﻿---
title: Torq connector and action
description: The Torq connector uses a Torq webhook to trigger workflows with Kibana actions. You can create connectors in Stack Management > Connectors or as needed...
url: https://www.elastic.co/docs/reference/kibana/connectors-kibana/torq-action-type
products:
  - Kibana
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Torq connector and action
The Torq connector uses a Torq webhook to trigger workflows with Kibana actions.

## Create connectors in Kibana

You can create connectors in **Stack Management > Connectors** or as needed when you're creating a rule. For example:
![Configure a Torq connector](https://www.elastic.co/docs/reference/kibana/images/torq-configured-connector.png)


### Connector configuration

Torq connectors have the following configuration properties:
<definitions>
  <definition term="Name">
    The name of the connector. The name is used to identify a connector in the Stack Management UI connector listing, and in the connector list when configuring an action.
  </definition>
  <definition term="Torq endpoint URL">
    Endpoint URL (webhook) of the Elastic Security integration you created in Torq.
  </definition>
  <definition term="Torq authentication header secret">
    Secret of the webhook authentication header.
  </definition>
</definitions>


## Test connectors

You can test connectors as you're creating or editing the connector in Kibana. For example:
![Torq connector test](https://www.elastic.co/docs/reference/kibana/images/torq-connector-test.png)

Torq actions have the following configuration properties.
<definitions>
  <definition term="Body">
    JSON payload to send to Torq.
  </definition>
</definitions>