﻿---
title: TheHive connector and action
description: TheHive connector uses the TheHive (v1) REST API to create cases and alerts. [8.16.0] You can create connectors in Stack Management > Connectors or as...
url: https://www.elastic.co/docs/reference/kibana/connectors-kibana/thehive-action-type
products:
  - Kibana
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# TheHive connector and action
TheHive connector uses the [TheHive (v1) REST API](https://docs.strangebee.com/thehive/api-docs/) to create cases and alerts. [8.16.0]
<note>
  If you use this connector with [cases](https://www.elastic.co/docs/explore-analyze/alerts-cases/cases), the status values differ in Kibana and TheHive. The status values are not synchronized when you update a case.
</note>


## Create connectors in Kibana

You can create connectors in **Stack Management > Connectors** or as needed when you're creating a rule. For example:
![TheHive connector](https://www.elastic.co/docs/reference/kibana/images/thehive-connector.png)


### Connector configuration

TheHive connectors have the following configuration properties:
<definitions>
  <definition term="Name">
    The name of the connector.
  </definition>
  <definition term="Organisation">
    The organisation in TheHive that will contain the cases or alerts.
  </definition>
  <definition term="URL">
    The instance URL in TheHive.
  </definition>
  <definition term="API key">
    The API key for authentication in TheHive.
  </definition>
</definitions>


## Test connectors

You can test connectors for creating a case or an alert with the [run connector API](https://www.elastic.co/docs/api/doc/kibana/v8/group/endpoint-connectors) or as you're creating or editing the connector in Kibana. For example:
![TheHive case params test](https://www.elastic.co/docs/reference/kibana/images/thehive-params-case-test.png)

![TheHive alert params test](https://www.elastic.co/docs/reference/kibana/images/thehive-params-alert-test.png)

TheHive actions have the following configuration properties.
<definitions>
  <definition term="Event action">
    The action that will be performed in TheHive: create a case or an alert.
  </definition>
  <definition term="Title">
    The title of the incident.
  </definition>
  <definition term="Description">
    The details about the incident.
  </definition>
  <definition term="Severity">
    The severity of the incident: `LOW`, `MEDIUM`, `HIGH` or `CRITICAL`.
    <note>
      <applies-to>Elastic Stack: Generally available since 9.1</applies-to> While creating an alert, use the **Keep severity from rule** toggle to create an alert with the rule's severity. If the rule does not have a defined severity, the alert will have the default MEDIUM severity.
    </note>
  </definition>
  <definition term="TLP">
    The traffic light protocol designation for the incident: `CLEAR`, `GREEN`, `AMBER`, `AMBER+STRICT` or `RED`.
  </definition>
  <definition term="Tags">
    The keywords or tags for the incident.
  </definition>
  <definition term="Additional comments">
    Additional information about the incident.
  </definition>
  <definition term="Type">
    The type of alert.
  </definition>
  <definition term="Source">
    The source of the alert.
  </definition>
  <definition term="Source reference">
    A source reference for the alert.
  </definition>
  <definition term="Body Elastic Stack: Generally available since 9.1">
    A Json payload specifying additional parameter, such as observables and procedures. For example:
    ```json
    {
      "observables": [
        {
          "dataType": "url",
          "data": "<EXAMPLE_URL>"
        }
      ],
      "procedures": [
        {
          "patternId": "TA0001",
          "occurDate": 1640000000000,
          "tactic": "tactic-name"
        }
      ]
    }
    ```
  </definition>
</definitions>


## Connector networking configuration

Use the [Action configuration settings](/docs/reference/kibana/configuration-reference/alerting-settings#action-settings) to customize connector networking configurations, such as proxies, certificates, or TLS settings. You can set configurations that apply to all your connectors or use `xpack.actions.customHostSettings` to set per-host configurations.

## Configure TheHive

To generate an API key in TheHive:
1. Log in to your TheHive instance.
2. Open profile tab and select the settings.
3. Go to **API Key**.
4. Click **Create** if no API key has been created previously; otherwise, you can view the API key by clicking on **Reveal**.
5. Copy the **API key** value to configure the connector in Kibana.