﻿---
title: Swimlane connector and action
description: The Swimlane connector uses the Swimlane REST API to create Swimlane records. You can create connectors in Stack Management > Connectors or as needed...
url: https://www.elastic.co/docs/reference/kibana/connectors-kibana/swimlane-action-type
products:
  - Kibana
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Swimlane connector and action
The Swimlane connector uses the [Swimlane REST API](https://swimlane.com/knowledge-center/docs/developer-guide/rest-api/) to create Swimlane records.

## Create connectors in Kibana

You can create connectors in **Stack Management > Connectors** or as needed when you're creating a rule. For example:
![Swimlane connector](https://www.elastic.co/docs/reference/kibana/images/swimlane-connector.png)


### Connector configuration

Swimlane connectors have the following configuration properties:
<definitions>
  <definition term="Name">
    The name of the connector.
  </definition>
  <definition term="URL">
    Swimlane instance URL.
  </definition>
  <definition term="Application ID">
    Swimlane application ID.
  </definition>
  <definition term="API token">
    Swimlane API authentication token for HTTP basic authentication.
  </definition>
</definitions>


## Test connectors

You can test connectors as you're creating or editing the connector in Kibana. For example:
![Swimlane params test](https://www.elastic.co/docs/reference/kibana/images/swimlane-params-test.png)

Swimlane actions have the following configuration properties.
<definitions>
  <definition term="Comments">
    Additional information for the client, such as how to troubleshoot the issue.
  </definition>
  <definition term="Severity">
    The severity of the incident.
  </definition>
</definitions>

<note>
  Alert ID and Rule Name are filled automatically. Specifically, Alert ID is set to `{{alert.id}}` and Rule Name to `{{rule.name}}`.
</note>