﻿---
title: Shodan connector
description: The Shodan connector communicates with the Shodan API for Internet-wide asset discovery and vulnerability scanning. You can create connectors in Stack...
url: https://www.elastic.co/docs/reference/kibana/connectors-kibana/shodan-action-type
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.3
---

# Shodan connector
The Shodan connector communicates with the Shodan API for Internet-wide asset discovery and vulnerability scanning.

## Create connectors in Kibana

You can create connectors in **Stack Management > Connectors**. For example:

### Connector configuration

Shodan connectors have the following configuration properties:
<definitions>
  <definition term="API Key">
    The Shodan API key for authentication.
  </definition>
</definitions>


## Test connectors

You can test connectors as you're creating or editing the connector in Kibana.
The Shodan connector has the following actions:
<definitions>
  <definition term="Search Hosts">
    Search for hosts and services using Shodan's search engine.
    - **Query** (required): Search query string.
    - **Page** (optional): Page number (default 1).
  </definition>
  <definition term="Get Host Info">
    Retrieve detailed information about a specific IP address.
    - **IP** (required): The IPv4 address to look up.
  </definition>
  <definition term="Count Results">
    Get the count of results for a search query without retrieving the actual results.
    - **Query** (required): Search query string.
    - **Facets** (optional): Facets to include in the results.
  </definition>
  <definition term="Get Services">
    Retrieve the list of services that Shodan crawls.
  </definition>
</definitions>


## Connector networking configuration

Use the [Action configuration settings](/docs/reference/kibana/configuration-reference/alerting-settings#action-settings) to customize connector networking configurations, such as proxies, certificates, or TLS settings. You can set configurations that apply to all your connectors or use `xpack.actions.customHostSettings` to set per-host configurations.

## Get API credentials

To use the Shodan connector, you need an API key:
1. Go to [Shodan](https://www.shodan.io/).
2. Sign up for an account or log in.
3. Navigate to your [Account page](https://account.shodan.io/).
4. Find your API Key in the account overview.
5. Copy the API key to configure the connector.

Note: Some features require a paid Shodan membership for full access.