﻿---
title: SentinelOne connector
description: The SentinelOne connector communicates with SentinelOne Management Console via REST API. To use this connector, you must have authority to run Endpoint...
url: https://www.elastic.co/docs/reference/kibana/connectors-kibana/sentinelone-action-type
products:
  - Kibana
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# SentinelOne connector
The SentinelOne connector communicates with SentinelOne Management Console via REST API.
To use this connector, you must have authority to run Endpoint Security connectors, which is an **Actions and Connectors** sub-feature privilege. Refer to [Kibana privileges](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges).

## Create connectors in Kibana

You can create connectors in **Stack Management > Connectors**. For example:
![SentinelOne connector](https://www.elastic.co/docs/reference/kibana/images/sentinelone-connector.png)


### Connector configuration

SentinelOne connectors have the following configuration properties:
<definitions>
  <definition term="API token">
    A SentinelOne API token created by the user.
  </definition>
  <definition term="URL">
    The SentinelOne tenant URL. If you are using the [`xpack.actions.allowedHosts`](/docs/reference/kibana/configuration-reference/alerting-settings#action-settings) setting, make sure the hostname is added to the allowed hosts.
  </definition>
</definitions>


## Test connectors

You can test connectors as you're creating or editing the connector in Kibana.
For example:
![SentinelOne connector test](https://www.elastic.co/docs/reference/kibana/images/sentinelone-connector-test.png)