﻿---
title: IBM Resilient connector and action
description: The IBM Resilient connector uses the RESILIENT REST v2 to create IBM Resilient incidents. You can create connectors in Stack Management > Connectors or...
url: https://www.elastic.co/docs/reference/kibana/connectors-kibana/resilient-action-type
products:
  - Kibana
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# IBM Resilient connector and action
The IBM Resilient connector uses the [RESILIENT REST v2](https://developer.ibm.com/security/resilient/rest/) to create IBM Resilient incidents.

## Create connectors in Kibana

You can create connectors in **Stack Management > Connectors** or as needed when you're creating a rule. For example:
![IBM Resilient connector](https://www.elastic.co/docs/reference/kibana/images/resilient-connector.png)


### Connector configuration

IBM Resilient connectors have the following configuration properties:
<definitions>
  <definition term="API key ID">
    The authentication key ID for HTTP Basic authentication.
  </definition>
  <definition term="API key secret">
    The authentication key secret for HTTP Basic authentication.
  </definition>
  <definition term="Organization ID">
    The IBM Resilient organization ID.
  </definition>
  <definition term="URL">
    The IBM Resilient instance URL.
  </definition>
</definitions>


## Test connectors

You can test connectors as you're creating or editing the connector in Kibana. For example:
![IBM Resilient connector test options](https://www.elastic.co/docs/reference/kibana/images/resilient-params-test.png)

IBM Resilient actions have the following configuration properties.
<definitions>
  <definition term="Incident type">
    The type of the incident.
  </definition>
  <definition term="Severity">
    The severity of the incident.
  </definition>
  <definition term="Name">
    A name for the issue, used for searching the contents of the knowledge base.
  </definition>
  <definition term="Description">
    The details about the incident.
  </definition>
  <definition term="Additional comments">
    Extra information for the client, such as how to troubleshoot the issue.
  </definition>
  <definition term="Additional fields Elastic Stack: Generally available since 9.2">
    An object that contains custom field identifiers and their values. These fields must exist in the IBM Resilient application and must be specified in JSON format.
  </definition>
</definitions>


## Connector networking configuration

Use the [action configuration settings](/docs/reference/kibana/configuration-reference/alerting-settings#action-settings) to customize connector networking configurations, such as proxies, certificates, or TLS settings. You can set configurations that apply to all your connectors or use `xpack.actions.customHostSettings` to set per-host configurations.