﻿---
title: Preconfigured connectors
description: If you are running Kibana on-prem, you can preconfigure a connector to have all the information it needs prior to startup by adding it to the kibana.yml...
url: https://www.elastic.co/docs/reference/kibana/connectors-kibana/pre-configured-connectors
products:
  - Kibana
---

# Preconfigured connectors
If you are running Kibana on-prem, you can preconfigure a connector to have all the information it needs prior to startup by adding it to the `kibana.yml` file.
<note>
  Elastic Cloud Hosted provides a preconfigured email connector but you cannot create additional preconfigured connectors.
</note>

Preconfigured connectors offer the following benefits:
- Require no setup. Configuration and credentials needed to run an action are predefined, including the connector name and ID.
- Appear in all spaces because they are not saved objects.
- Cannot be edited or deleted.


## Create preconfigured connectors

Add `xpack.actions.preconfigured` settings to your `kibana.yml` file. The settings vary depending on which type of connector you’re adding. Refer to [Preconfigured connector settings](/docs/reference/kibana/configuration-reference/alerting-settings#preconfigured-connector-settings).
This example shows a valid configuration for a Slack connector and a Webhook connector:
```js
  xpack.actions.preconfigured:
    my-slack1:                  
      actionTypeId: .slack      
      name: 'Slack #xyz'        
      secrets:
        webhookUrl: 'https://hooks.slack.com/services/abcd/efgh/ijklmnopqrstuvwxyz'
    webhook-service:
      actionTypeId: .webhook
      name: 'Email service'
      config:                   
        url: 'https://email-alert-service.elastic.co'
        method: post
        headers:
          header1: value1
          header2: value2
      secrets:                  
        user: elastic
        password: changeme
      exposeConfig: true        
```

<note>
  Sensitive properties, such as passwords, can also be stored in the [Kibana keystore](https://www.elastic.co/docs/deploy-manage/security/secure-settings#creating-keystore).
</note>


## View preconfigured connectors

go to the **Connectors** page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects). Preconfigured connectors appear regardless of which space you are in. They are tagged as “preconfigured”, and you cannot delete them.
![Connectors managing tab with pre-configured](https://www.elastic.co/docs/reference/kibana/images/preconfigured-connectors-managing.png)
Clicking a preconfigured connector shows the description, but not the configuration.

## Built-in preconfigured connectors

Kibana provides the following built-in preconfigured connectors:
- [Preconfigured alert history Elasticsearch index connector](#preconfigured-connector-alert-history)
- [`Elastic-Cloud-SMTP` preconfigured email connector](/docs/reference/kibana/connectors-kibana/email-action-type#elasticcloud)


### Preconfigured alert history Elasticsearch index connector

<warning>
  This functionality is in technical preview and may be changed or removed in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.
</warning>

Kibana offers a preconfigured index connector to facilitate indexing active alert data into Elasticsearch. To use this connector, set [`xpack.actions.preconfiguredAlertHistoryEsIndex`](/docs/reference/kibana/configuration-reference/alerting-settings#action-settings) to `true`.
When you subsequently create rules, you can use the `Alert history Elasticsearch index (preconfigured)` connector.
![Creating a rule action that uses the pre-configured alert history connector](https://www.elastic.co/docs/reference/kibana/images/pre-configured-alert-history-connector.png)
Documents are indexed using a preconfigured schema that captures the [action variables](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/create-manage-rules#defining-rules-actions-variables) available for the rule. By default, these documents are indexed into the `kibana-alert-history-default` index, but you can specify a different index. Index names must start with `kibana-alert-history-` to take advantage of the preconfigured alert history index template.
<important>
  - To write documents to the preconfigured index, you must have `all` or `write` privileges to the `kibana-alert-history-*` indices.
  - The `kibana-alert-history-*` indices are not configured to use ILM so they must be maintained manually. If the index size grows large, consider using the [delete by query](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-delete-by-query) API to clean up older documents in the index.
</important>


## Examples

- [Amazon Bedrock connectors](#preconfigured-bedrock-configuration)
- [D3 Security connectors](#preconfigured-d3security-configuration)
- [Email connectors](#preconfigured-email-configuration)
- [OpenAI connectors](#preconfigured-gen-ai-configuration)
- [IBM Resilient connectors](#preconfigured-resilient-configuration)
- [Index connectors](#preconfigured-index-configuration)
- [Jira connectors](#preconfigured-jira-configuration)
- [Microsoft Teams connectors](#preconfigured-teams-configuration)
- [Opsgenie connectors](#preconfigured-opsgenie-configuration)
- [PagerDuty connectors](#preconfigured-pagerduty-configuration)
- [Server log connectors](#preconfigured-server-log-configuration)
- [ServiceNow ITOM connectors](#preconfigured-servicenow-itom-configuration)
- [ServiceNow ITSM connectors](#preconfigured-servicenow-configuration)
- [ServiceNow SecOps connectors](#preconfigured-servicenow-sir-configuration)
- [Slack connectors](#preconfigured-slack-configuration)
- [Swimlane connectors](#preconfigured-swimlane-configuration)
- [Torq connectors](#preconfigured-torq-configuration)
- [Tines connectors](#preconfigured-tines-configuration)
- [Webhook connectors](#preconfigured-webhook-configuration)
- [Webhook - Case Management connectors](#preconfigured-cases-webhook-configuration)
- [xMatters connectors](#preconfigured-xmatters-configuration)


### Amazon Bedrock connectors

The following example creates an [Amazon Bedrock connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/bedrock-action-type):
```text
xpack.actions.preconfigured:
  my-bedrock:
    name: preconfigured-bedrock-connector-type
    actionTypeId: .bedrock
    config:
      apiUrl: https://bedrock-runtime.us-east-1.amazonaws.com 
      defaultModel: us.anthropic.claude-sonnet-4-5-20250929-v1:0 
    secrets:
      accessKey: key-value 
      secret: secret-value 
```


### D3 Security connectors

The following example creates a [D3 Security connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/d3security-action-type):
```text
xpack.actions.preconfigured:
  my-d3security:
    name: preconfigured-d3security-connector-type
    actionTypeId: .d3security
    config:
      url: <example-url>/elasticsearch/VSOC/api/Data/Kibana/Security%20Operations/CreateEvents 
    secrets:
      token: superlongtoken 
```


### Email connectors

The following example creates an [email connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/email-action-type):
```text
xpack.actions.preconfigured:
  my-email:
    name: preconfigured-email-connector-type
    actionTypeId: .email
    config:
      service: other 
      from: testsender@test.com 
      host: validhostname 
      port: 8080 
      secure: false 
      hasAuth: true 
    secrets:
      user: testuser 
      password: passwordkeystorevalue 
```


#### Amazon SES (Simple Email Service)

Use the following email connector configuration to send email from the [Amazon Simple Email Service](http://aws.amazon.com/ses) (SES) SMTP service:
```text
config:
    service: ses
    // `host`, `port` and `secure` have the following default values and do not need to set:
   
    // port: 465
    // secure: true
secrets:
    user: <username>
    password: <password>
```


#### Gmail

Use the following email connector configuration to send email from the [Gmail](https://mail.google.com) SMTP service:
```text
  config:
    service: gmail
    // `host`, `port` and `secure` have the following default values and do not need to set:
    // host: smtp.gmail.com
    // port: 465
    // secure: true
  secrets:
    user: <username>
    password: <password>
```


#### Microsoft Exchange with basic authentication

<admonition title="Deprecated in 7.16.0">
  Microsoft Exchange with basic authentication was deprecated in 7.16.0.
</admonition>

```text
config:
    service: other
    host: <your exchange server>
    port: 465
    secure: true
    from: <email address of service account> 
secrets:
    user: <email address of service account> 
    password: <password>
```


#### Microsoft Exchange with OAuth 2.0

Use the following email connector configuration to send email from Microsoft Exchange:
```text
config:
    service: exchange_server
    clientId: <The Application (client) ID> 
    tenantId: <The directory tenant ID, in GUID format.>
    from: <email address of service account> 
secrets:
    clientSecret: <URL-encoded string>
```


#### Outlook.com

Use the following email connector configuration to send email from the [Outlook.com](https://www.outlook.com/) SMTP service:
```text
config:
    service: outlook365
    // `host`, `port` and `secure` have the following default values and do not need to set:
    // host: smtp.office365.com
    // port: 587
    // secure: false
secrets:
    user: <email.address>
    password: <password>
```


### OpenAI connectors

The following example creates a [OpenAI connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/openai-action-type):
```text
xpack.actions.preconfigured:
  my-open-ai:
    name: preconfigured-openai-connector-type
    actionTypeId: .gen-ai
    config:
      apiUrl: https://api.openai.com/v1/chat/completions 
      apiProvider: 'OpenAI' 
      defaultModel: gpt-4.1 
    secrets:
      apiKey: superlongapikey 
```


### IBM Resilient connectors

The following example creates a [IBM Resilient connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/resilient-action-type):
```text
xpack.actions.preconfigured:
 my-resilient:
    name: preconfigured-resilient-connector-type
    actionTypeId: .resilient
    config:
      apiUrl: https://elastic.resilient.net 
      orgId: ES 
    secrets:
      apiKeyId: testuser 
      apiKeySecret: tokenkeystorevalue 
```


### Index connectors

The following example creates a [index connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/index-action-type):
```text
xpack.actions.preconfigured:
  my-index:
    name: preconfigured-index-connector-type
    actionTypeId: .index
    config:
      index: .kibana 
      executionTimeField: my-field 
```


### Jira connectors

The following example creates a [Jira connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/jira-action-type):
```text
xpack.actions.preconfigured:
  my-jira:
    name: preconfigured-jira-connector-type
    actionTypeId: .jira
    config:
      apiUrl: https://elastic.atlassian.net 
      projectKey: ES 
    secrets:
      email: testuser 
      apiToken: tokenkeystorevalue 
```


### Microsoft Teams connectors

The following example creates a [Microsoft Teams connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/teams-action-type):
```text
xpack.actions.preconfigured:
  my-teams:
    name: preconfigured-teams-connector-type
    actionTypeId: .teams
    secrets:
      webhookUrl: 'https://outlook.office.com/webhook/abcd@0123456/IncomingWebhook/abcdefgh/ijklmnopqrstuvwxyz' 
```


### Opsgenie connectors

The following example creates an [Opsgenie connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/opsgenie-action-type):
```text
xpack.actions.preconfigured:
  my-opsgenie:
    name: preconfigured-opsgenie-connector-type
    actionTypeId: .opsgenie
    config:
      apiUrl: https://api.opsgenie.com 
    secrets:
      apiKey: apikey 
```


### PagerDuty connectors

The following example creates a [PagerDuty connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/pagerduty-action-type):
```text
xpack.actions.preconfigured:
  my-pagerduty:
    name: preconfigured-pagerduty-connector-type
    actionTypeId: .pagerduty
    config:
      apiUrl: <EXAMPLE_URL> 
    secrets:
      routingKey: testroutingkey 
```


### Server log connectors

The following example creates a [server log connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/server-log-action-type):
```text
xpack.actions.preconfigured:
  my-server-log:
    name: preconfigured-server-log-connector-type
    actionTypeId: .server-log
```


### ServiceNow ITOM connectors

The following example creates a [ServiceNow ITOM connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-itom-action-type) with basic authentication:
```text
xpack.actions.preconfigured:
  my-servicenow-itom:
    name: preconfigured-servicenow-connector-type
    actionTypeId: .servicenow-itom
    config:
      apiUrl: <SERVICENOW_INSTANCE_URL> 
    secrets:
      username: testuser 
      password: passwordkeystorevalue 
```

The following example creates a ServiceNow ITOM connector with OAuth authentication:
```text
xpack.actions.preconfigured:
  my-servicenow:
    name: preconfigured-oauth-servicenow-connector-type
    actionTypeId: .servicenow-itom
    config:
      apiUrl: <SERVICENOW_INSTANCE_URL>
      isOAuth: true 
      userIdentifierValue: testuser@email.com 
      clientId: abcdefghijklmnopqrstuvwxyzabcdef 
      jwtKeyId: fedcbazyxwvutsrqponmlkjihgfedcba 
    secrets:
      clientSecret: secretsecret 
      privateKey: |  
        -----BEGIN RSA PRIVATE KEY-----
        MIIE...
        KAgD...
        ... multiple lines of key data ...
        -----END RSA PRIVATE KEY-----
```


### ServiceNow ITSM connectors

The following example creates a [ServiceNow ITSM connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-action-type) with basic authentication:
```text
xpack.actions.preconfigured:
  my-servicenow:
    name: preconfigured-servicenow-connector-type
    actionTypeId: .servicenow
    config:
      apiUrl: <SERVICENOW_INSTANCE_URL> 
      usesTableApi: false 
    secrets:
      username: testuser 
      password: passwordkeystorevalue 
```

The following example creates a ServiceNow ITSM connector with OAuth authentication:
```text
xpack.actions.preconfigured:
  my-servicenow:
    name: preconfigured-oauth-servicenow-connector-type
    actionTypeId: .servicenow
    config:
      apiUrl: <SERVICENOW_INSTANCE_URL>
      usesTableApi: false
      isOAuth: true 
      userIdentifierValue: testuser@email.com 
      clientId: abcdefghijklmnopqrstuvwxyzabcdef 
      jwtKeyId: fedcbazyxwvutsrqponmlkjihgfedcba 
    secrets:
      clientSecret: secretsecret 
      privateKey: | 
        -----BEGIN RSA PRIVATE KEY-----
        MIIE...
        KAgD...
        ... multiple lines of key data ...
        -----END RSA PRIVATE KEY-----
```


### ServiceNow SecOps connectors

The following example creates a [ServiceNow SecOps connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-sir-action-type) with basic authentication:
```text
xpack.actions.preconfigured:
  my-servicenow-sir:
    name: preconfigured-servicenow-connector-type
    actionTypeId: .servicenow-sir
    config:
      apiUrl: <SERVICENOW_INSTANCE_URL> 
      usesTableApi: false 
    secrets:
      username: testuser 
      password: passwordkeystorevalue 
```

The following example creates a ServiceNow SecOps connector with OAuth authentication:
```text
xpack.actions.preconfigured:
  my-servicenow:
    name: preconfigured-oauth-servicenow-connector-type
    actionTypeId: .servicenow-sir
    config:
      apiUrl: <SERVICENOW_INSTANCE_URL>
      usesTableApi: false
      isOAuth: true 
      userIdentifierValue: testuser@email.com 
      clientId: abcdefghijklmnopqrstuvwxyzabcdef 
      jwtKeyId: fedcbazyxwvutsrqponmlkjihgfedcba 
    secrets:
      clientSecret: secretsecret 
      privateKey: | 
        -----BEGIN RSA PRIVATE KEY-----
        MIIE...
        KAgD...
        ... multiple lines of key data ...
        -----END RSA PRIVATE KEY-----
```


### Slack connectors

The following example creates a [Slack connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/slack-action-type) with webhook:
```text
xpack.actions.preconfigured:
  my-slack:
    name: preconfigured-slack-webhook-connector-type
    actionTypeId: .slack
    secrets:
      webhookUrl: 'https://hooks.slack.com/services/xxxx/xxxx/xxxx' 
```

The following example creates a Slack connector with web API:
```text
xpack.actions.preconfigured:
  my-slack:
    name: preconfigured-slack-api-connector-type
    actionTypeId: .slack_api
    secrets:
      token: 'xoxb-xxxx-xxxx-xxxx' 
```


### Swimlane connectors

The following example creates a [Swimlane connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/swimlane-action-type):
```text
xpack.actions.preconfigured:
  my-swimlane:
    name: preconfigured-swimlane-connector-type
    actionTypeId: .swimlane
    config:
      apiUrl: <SWIMLANE_INSTANCE_URL> 
      appId: app-id 
      mappings: 
        alertIdConfig:
          fieldType: text
          id: agp4s
          key: alert-id
          name: Alert ID
        caseIdConfig:
          fieldType: text
          id: ae1mi
          key: case-id
          name: Case ID
        caseNameConfig:
          fieldType: text
          id: anxnr
          key: case-name
          name: Case Name
        commentsConfig:
          fieldType: comments
          id: au18d
          key: comments
          name: Comments
        descriptionConfig:
          fieldType: text
          id: ae1gd
          key: description
          name: Description
        ruleNameConfig:
          fieldType: text
          id: avfsl
          key: rule-name
          name: Rule Name
        severityConfig:
          fieldType: text
          id: a71ik
          key: severity
          name: severity
    secrets:
      apiToken: tokenkeystorevalue 
```


### Tines connectors

The following example creates a [Tines connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/tines-action-type):
```text
xpack.actions.preconfigured:
my-tines:
    name: preconfigured-tines-connector-type
    actionTypeId: .tines
    config:
      url: <TINES_TENANT_URL> 
    secrets:
      email: some.address@test.com 
      token: ausergeneratedapitoken 
```


### Torq connectors

The following example creates a [Torq connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/torq-action-type):
```yaml
xpack.actions.preconfigured:
  my-torq:
    name: preconfigured-torq-connector-type
    actionTypeId: .torq
    config:
      webhookIntegrationUrl: <TORQ_ENDPOINT_URL>/v1/somehook 
    secrets:
      token: mytorqtoken 
```


### Webhook connectors

The following example creates a [webhook connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/webhook-action-type) with basic authentication:
```text
xpack.actions.preconfigured:
  my-webhook:
    name: preconfigured-webhook-connector-type
    actionTypeId: .webhook
    config:
      url: <EXAMPLE_URL> 
      method: post 
      headers: 
        testheader: testvalue
      hasAuth: true 
    secrets:
      user: testuser 
      password: passwordkeystorevalue 
```

<note>
  SSL authentication is not supported in preconfigured webhook connectors.
</note>


### Webhook - Case Management connectors

The following example creates a [Webhook - Case Management connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/cases-webhook-action-type):
```text
xpack.actions.preconfigured:
  my-case-management-webhook:
    name: Case Management Webhook Connector
    actionTypeId: .cases-webhook
    config:
      hasAuth: true 
      headers: 
        'content-type': 'application/json'
      createIncidentUrl: '<EXAMPLE_URL>/rest/api/2/issue' 
      createIncidentMethod: 'post' 
      createIncidentJson: '{"fields":{"summary":{{{case.title}}},"description":{{{case.description}}},"labels":{{{case.tags}}}' 
      getIncidentUrl: '<EXAMPLE_URL>/rest/api/2/issue/{{{external.system.id}}}' 
      getIncidentResponseExternalTitleKey: 'key' 
      viewIncidentUrl: '<EXAMPLE_URL>/browse/{{{external.system.title}}}' 
      updateIncidentUrl: '<EXAMPLE_URL>/rest/api/2/issue/{{{external.system.id}}}' 
      updateIncidentMethod: 'put' 
      updateIncidentJson: '{"fields":{"summary":{{{case.title}}},"description":{{{case.description}}},"labels":{{{case.tags}}}' 
      createCommentMethod: 'post', 
      createCommentUrl: '<EXAMPLE_URL>/rest/api/2/issue/{{{external.system.id}}}/comment', 
      createCommentJson: '{"body": {{{case.comment}}}}', 
    secrets:
      user: testuser 
      password: passwordvalue 
```


### xMatters connectors

The following example creates an [xMatters connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/xmatters-action-type) with basic authentication:
```text
xpack.actions.preconfigured:
  my-xmatters:
    name: preconfigured-xmatters-connector-type
    actionTypeId: .xmatters
    config:
      configUrl: <EXAMPLE_REQUEST_URL> 
      usesBasic: true 
    secrets:
      user: testuser 
      password: passwordkeystorevalue 
```

The following example creates an xMatters connector with URL authentication:
```text
xpack.actions.preconfigured:
  my-xmatters:
    name: preconfigured-xmatters-connector-type
    actionTypeId: .xmatters
    config:
      usesBasic: false 
    secrets:
      secretsUrl: <EXAMPLE_HOST_URL>?apiKey=1234-abcd 
```