﻿---
title: Opsgenie connector and action
description: An Opsgenie connector enables you to create and close alerts in Opsgenie. In particular, it uses the Opsgenie alert API. To create this connector, you...
url: https://www.elastic.co/docs/reference/kibana/connectors-kibana/opsgenie-action-type
products:
  - Kibana
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Opsgenie connector and action
An Opsgenie connector enables you to create and close alerts in Opsgenie. In particular, it uses the [Opsgenie alert API](https://docs.opsgenie.com/docs/alert-api).
To create this connector, you must have a valid Opsgenie URL and API key. For configuration tips, refer to [Configure an Opsgenie account](#configuring-opsgenie).

## Create connectors in Kibana

You can create connectors in **Stack Management > Connectors** or as needed when you're creating a rule. For example:
![Opsgenie connector](https://www.elastic.co/docs/reference/kibana/images/opsgenie-connector.png)


### Connector configuration

Opsgenie connectors have the following configuration properties:
<definitions>
  <definition term="Name">
    The name of the connector. The name is used to identify a connector in the management UI connector listing, or in the connector list when configuring an action.
  </definition>
  <definition term="URL">
    The Opsgenie URL. For example, [[https://api.opsgenie.com](https://api.opsgenie.com)](https://api.opsgenie.com) or [[https://api.eu.opsgenie.com](https://api.eu.opsgenie.com)](https://api.eu.opsgenie.com).
    <note>
      If you are using the [`xpack.actions.allowedHosts`](/docs/reference/kibana/configuration-reference/alerting-settings#action-settings) setting, make sure the hostname is added to the allowed hosts.
    </note>
  </definition>
  <definition term="API Key">
    The Opsgenie API authentication key for HTTP basic authentication. For more details about generating Opsgenie API keys, refer to [Opsgenie documentation](https://support.atlassian.com/opsgenie/docs/create-a-default-api-integration/).
  </definition>
</definitions>


## Test connectors

After you create a connector, use the **Test** tab to test its actions:
- [Create alert](#opsgenie-action-create-alert-configuration)
- [Close alert](#opsgenie-action-close-alert-configuration)


### Create alert action

When you create a rule that uses an Opsgenie connector, its actions (with the exception of recovery actions) create Opsgenie alerts. You can test this type of action when you create or edit your connector:
![Opsgenie create alert action test](https://www.elastic.co/docs/reference/kibana/images/opsgenie-create-alert-test.png)

You can configure the create alert action through the form view or using a JSON editor.

#### Form view

The create alert action form has the following configuration properties.
<definitions>
  <definition term="Message">
    The message for the alert (required).
  </definition>
  <definition term="Opsgenie tags">
    The tags for the alert (optional).
  </definition>
  <definition term="Priority">
    The priority level for the alert.
  </definition>
  <definition term="Description">
    A description that provides detailed information about the alert (optional).
  </definition>
  <definition term="Alias">
    The alert identifier, which is used for alert deduplication in Opsgenie. For more information, refer to the [Opsgenie documentation](https://support.atlassian.com/opsgenie/docs/what-is-alert-de-duplication/) (optional).
  </definition>
  <definition term="Entity">
    The domain of the alert (optional).
  </definition>
  <definition term="Source">
    The source of the alert (optional).
  </definition>
  <definition term="User">
    The display name of the owner (optional).
  </definition>
  <definition term="Note">
    Additional information for the alert (optional).
  </definition>
</definitions>


#### JSON editor

A JSON editor is provided as an alternative to the form view and supports additional fields not shown in the form view. The JSON editor supports all of the forms configuration properties but as lowercase keys as [described in the Opsgenie API documentation](https://docs.opsgenie.com/docs/alert-api#create-alert). The JSON editor supports the following additional properties:
<definitions>
  <definition term="responders">
    The entities to receive notifications about the alert (optional).
  </definition>
  <definition term="visibleTo">
    The teams and users that the alert will be visible to without sending a notification to them (optional).
  </definition>
  <definition term="actions">
    The custom actions available to the alert (optional).
  </definition>
  <definition term="details">
    The custom properties of the alert (optional).
  </definition>
</definitions>


Example JSON editor contents
```json
{
  "message": "An example alert message",
  "alias": "Life is too short for no alias",
  "description":"Every alert needs a description",
  "responders":[
      {"id":"4513b7ea-3b91-438f-b7e4-e3e54af9147c", "type":"team"},
      {"name":"NOC", "type":"team"},
      {"id":"bb4d9938-c3c2-455d-aaab-727aa701c0d8", "type":"user"},
      {"username":"trinity@opsgenie.com", "type":"user"},
      {"id":"aee8a0de-c80f-4515-a232-501c0bc9d715", "type":"escalation"},
      {"name":"Nightwatch Escalation", "type":"escalation"},
      {"id":"80564037-1984-4f38-b98e-8a1f662df552", "type":"schedule"},
      {"name":"First Responders Schedule", "type":"schedule"}
  ],
  "visibleTo":[
      {"id":"4513b7ea-3b91-438f-b7e4-e3e54af9147c","type":"team"},
      {"name":"rocket_team","type":"team"},
      {"id":"bb4d9938-c3c2-455d-aaab-727aa701c0d8","type":"user"},
      {"username":"trinity@opsgenie.com","type":"user"}
  ],
  "actions": ["Restart", "AnExampleAction"],
  "tags": ["OverwriteQuietHours","Critical"],
  "details":{"key1":"value1","key2":"value2"},
  "entity":"An example entity",
  "priority":"P1"
}
```


### Close alert action

When you create a rule that uses an Opsgenie connector, its recovery actions close Opsgenie alerts. You can test this type of action when you create or edit your connector:
![Opsgenie close alert action test](https://www.elastic.co/docs/reference/kibana/images/opsgenie-close-alert-test.png)

The close alert action has the following configuration properties.
<definitions>
  <definition term="Alias">
    The alert identifier, which is used for alert deduplication in Opsgenie (required). The alias must match the value used when creating the alert. For more information, refer to the [Opsgenie documentation](https://support.atlassian.com/opsgenie/docs/what-is-alert-de-duplication/).
  </definition>
  <definition term="Note">
    Additional information for the alert (optional).
  </definition>
  <definition term="Source">
    The display name of the source (optional).
  </definition>
  <definition term="User">
    The display name of the owner (optional).
  </definition>
</definitions>


## Connector networking configuration

Use the [Action configuration settings](/docs/reference/kibana/configuration-reference/alerting-settings#action-settings) to customize connector networking configurations, such as proxies, certificates, or TLS settings. You can set configurations that apply to all your connectors or use `xpack.actions.customHostSettings` to set per-host configurations.

## Configure an Opsgenie account

After obtaining an Opsgenie instance, configure the API integration. For details, refer to the [Opsgenie documentation](https://support.atlassian.com/opsgenie/docs/create-a-default-api-integration/).
If you're using a free trial, go to the `Teams` dashboard and select the appropriate team.
![Opsgenie teams dashboard](https://www.elastic.co/docs/reference/kibana/images/opsgenie-teams.png)

Select the `Integrations` menu item, then select `Add integration`.
![Opsgenie teams integrations](https://www.elastic.co/docs/reference/kibana/images/opsgenie-integrations.png)

Search for `API` and select the `API` integration.
![Opsgenie API integration](https://www.elastic.co/docs/reference/kibana/images/opsgenie-add-api-integration.png)

Configure the integration and ensure you record the `API Key`. This key will be used to populate the `API Key` field when creating the Kibana Opsgenie connector. Click `Save Integration` after you finish configuring the integration.
![Opsgenie save integration](https://www.elastic.co/docs/reference/kibana/images/opsgenie-save-integration.png)