﻿---
title: Notion connector
description: The Notion connector communicates with the Notion API to explore content and databases in your Notion workspace. You can create connectors in Stack Management...
url: https://www.elastic.co/docs/reference/kibana/connectors-kibana/notion-action-type
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.3
---

# Notion connector
The Notion connector communicates with the Notion API to explore content and databases in your Notion workspace.

## Create connectors in Kibana

You can create connectors in **Stack Management > Connectors**. For example:

### Connector configuration

Notion connectors have the following configuration properties:
<definitions>
  <definition term="API Token">
    The Notion API token (bearer token) for authentication. You can obtain this by creating an [internal integration](https://www.notion.com/help/create-integrations-with-the-notion-api#create-an-internal-integration).
  </definition>
</definitions>


## Test connectors

You can test connectors as you're creating or editing the connector in Kibana.
The Notion connector has the following actions:
<definitions>
  <definition term="Search Page or Data Source by Title">
    Search for pages or databases by title.
    - **Query** (required): The search query string.
    - **Query Object Type** (required): Type of object to search for (`page` or `data_source`).
    - **Start Cursor** (optional): Cursor for pagination.
    - **Page Size** (optional): Number of results per page.
  </definition>
  <definition term="Get Page">
    Retrieve a page by its ID.
    - **Page ID** (required): The unique identifier of the page.
  </definition>
  <definition term="Get Data Source">
    Retrieve a database by its ID. Retrieve a database by its ID. This only returns information about the database properties and columns, _not_ about its rows.
    - **Data Source ID** (required): The unique identifier of the database. Check [Notion's documentation](https://developers.notion.com/reference/retrieve-a-data-source#finding-a-data-source-id) for instructions on how to find this ID.
  </definition>
  <definition term="Query Data Source">
    Query a database with optional filters.
    - **Data Source ID** (required): The unique identifier of the database to query.
    - **Filter** (optional): JSON string representing the filter object.
    - **Start Cursor** (optional): Cursor for pagination.
    - **Page Size** (optional): Number of results per page.
  </definition>
</definitions>


## Connector networking configuration

Use the [Action configuration settings](/docs/reference/kibana/configuration-reference/alerting-settings#action-settings) to customize connector networking configurations, such as proxies, certificates, or TLS settings. You can set configurations that apply to all your connectors or use `xpack.actions.customHostSettings` to set per-host configurations.

## Get API credentials

To use the Notion connector, you need to create an internal integration:
1. Go to [Notion](https://www.notion.so/).
2. Navigate to [My integrations](https://www.notion.so/my-integrations).
3. Click **+ New integration**.
4. Configure your integration:
   - Set a name for your integration.
- Select the workspace where you want to use the integration.
- Configure the capabilities (content, comment, and user capabilities as needed).
5. Click **Submit** to create the integration.
6. Copy the **Internal Integration Token** (this is your bearer token).
7. Share the pages and databases you want to access with your integration by clicking **Share** on the page or database and inviting your integration.