﻿---
title: MCP connector and action
description: The Model Context Protocol (MCP) connector communicates with remote MCP servers to retrieve and call their tools. This connector is required to use external...
url: https://www.elastic.co/docs/reference/kibana/connectors-kibana/mcp-action-type
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.3
---

# MCP connector and action
The Model Context Protocol (MCP) connector communicates with remote [MCP](https://modelcontextprotocol.io/docs/getting-started/intro) servers to retrieve and call their tools. This connector is required to use external MCP tools in [Elastic Agent Builder](https://www.elastic.co/docs/explore-analyze/ai-features/elastic-agent-builder).

## Create connectors in Kibana

You can create an MCP connector in **Stack Management > Connectors**. For example:
![MCP connector](https://www.elastic.co/docs/reference/kibana/images/mcp-connector.png)


### Connector configuration

MCP connectors have the following configuration properties:
<definitions>
  <definition term="Name">
    The name of the connector.
  </definition>
  <definition term="Server URL">
    The URL of the MCP server.
  </definition>
  <definition term="HTTP headers (under Additional settings)">
    A custom set of HTTP headers that you can use to connect to an MCP server.
    <definitions>
      <definition term="Config">
        If you choose the config type, values in headers will be sent as plain text in requests.
      </definition>
      <definition term="Secret">
        If you choose the secret type, values in your headers will be encrypted in requests.
      </definition>
    </definitions>
  </definition>
</definitions>


## Test connectors

You can test connectors as you’re creating or editing the connector in Kibana. For example:
![MCP test connector](https://www.elastic.co/docs/reference/kibana/images/mcp-test-connector.png)

MCP connectors offer three actions:
<definitions>
  <definition term="test">
    Test the connection to the remote MCP server with any auth that was provided.
  </definition>
  <definition term="listTools">
    Call the MCP server's `listTools` endpoint. Returns a list of tools and their input and output schemas.
  </definition>
  <definition term="callTool">
    Call a specific MCP server tool.
  </definition>
</definitions>

<tip>
  Call `listTools` first to understand how to correctly call an MCP server's tools, before using the `callTool` action.
</tip>