﻿---
title: Jira Service Management connector and action
description: An Jira Service Management connector enables you to create and close alerts in Jira Service Management. In particular, it uses the Jira Service Management...
url: https://www.elastic.co/docs/reference/kibana/connectors-kibana/jsm-action-type
products:
  - Kibana
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.2
---

# Jira Service Management connector and action
An Jira Service Management connector enables you to create and close alerts in Jira Service Management. In particular, it uses the [Jira Service Management Integration Events API](https://developer.atlassian.com/cloud/jira/service-desk-ops/rest/v1/api-group-integration-events/#api-group-integration-events).
To create this connector, you must have a valid Jira Service Management URL and API key. For configuration tips, refer to [Configure a Jira Service Management account](#configuring-jsm).

## Create connectors in Kibana

You can create connectors in **Stack Management > Connectors** or as needed when you're creating a rule. For example:
![Jira Service Management connector](https://www.elastic.co/docs/reference/kibana/images/jsm-connector.png)


### Connector configuration

Jira Service Management connectors have the following configuration properties:
<definitions>
  <definition term="Name">
    The name of the connector. The name is used to identify a connector in the management UI connector listing, or in the connector list when configuring an action.
  </definition>
  <definition term="URL">
    The Jira Service Management URL. For example, [[https://api.atlassian.com](https://api.atlassian.com)](https://api.atlassian.com).
    <note>
      If you are using the [`xpack.actions.allowedHosts`](/docs/reference/kibana/configuration-reference/alerting-settings#action-settings) setting, make sure the hostname is added to the allowed hosts.
    </note>
  </definition>
  <definition term="API Key">
    The Jira Service Management API authentication key for HTTP basic authentication. For more details about generating Jira Service Management API keys, refer to [Jira Service Management documentation](https://support.atlassian.com/jira-service-management-cloud/docs/set-up-an-api-integration/#Set-up-the-integration).
  </definition>
</definitions>


## Test connectors

After you create a connector, use the **Test** tab to test its actions:
- [Create alert](#jsm-action-create-alert-configuration)
- [Close alert](#jsm-action-close-alert-configuration)


### Create alert action

When you create a rule that uses an Jira Service Management connector, its actions (with the exception of recovery actions) create Jira Service Management alerts. You can test this type of action when you create or edit your connector:
![Jira Service Management create alert action test](https://www.elastic.co/docs/reference/kibana/images/jsm-create-alert-test.png)

You can configure the create alert action through the form view or using a JSON editor.

#### Form view

The create alert action form has the following configuration properties.
<definitions>
  <definition term="Message">
    The message for the alert (required).
  </definition>
  <definition term="Jira Service Management tags">
    The tags for the alert (optional).
  </definition>
  <definition term="Priority">
    The priority level for the alert (optional).
  </definition>
  <definition term="Description">
    A description that provides detailed information about the alert (optional).
  </definition>
  <definition term="Alias">
    The alert identifier, which is used for alert deduplication in Jira Service Management. For more information, refer to the [Jira Service Management documentation](https://support.atlassian.com/jira-service-management-cloud/docs/what-is-alert-deduplication/) (optional).
  </definition>
  <definition term="Entity">
    The domain of the alert (optional).
  </definition>
  <definition term="Source">
    The source of the alert (optional).
  </definition>
  <definition term="User">
    The display name of the owner (optional).
  </definition>
  <definition term="Note">
    Additional information for the alert (optional).
  </definition>
</definitions>


#### JSON editor

A JSON editor is provided as an alternative to the form view and supports additional fields not shown in the form view. The JSON editor supports all of the forms configuration properties but as lowercase keys as [described in the Jira Service Management API documentation](https://developer.atlassian.com/cloud/jira/service-desk-ops/rest/v1/api-group-integration-events/#api-jsm-ops-integration-v2-alerts-post). The JSON editor supports the following additional properties:
<definitions>
  <definition term="responders">
    The entities to receive notifications about the alert (optional).
  </definition>
  <definition term="visibleTo">
    The teams and users that the alert will be visible to without sending a notification to them (optional).
  </definition>
  <definition term="actions">
    The custom actions available to the alert (optional).
  </definition>
  <definition term="details">
    The custom properties of the alert (optional).
  </definition>
</definitions>


Example JSON editor contents
```json
{
  "message": "An example alert message",
  "alias": "Life is too short for no alias",
  "description":"Every alert needs a description",
  "responders":[
      {"id":"4513b7ea-3b91-438f-b7e4-e3e54af9147c", "type":"team"},
      {"id":"bb4d9938-c3c2-455d-aaab-727aa701c0d8", "type":"user"},
      {"id":"aee8a0de-c80f-4515-a232-501c0bc9d715", "type":"escalation"},
      {"id":"80564037-1984-4f38-b98e-8a1f662df552", "type":"schedule"}
  ],
  "visibleTo":[
      {"id":"4513b7ea-3b91-438f-b7e4-e3e54af9147c","type":"team"},
      {"id":"bb4d9938-c3c2-455d-aaab-727aa701c0d8","type":"user"}
  ],
  "actions": ["Restart", "AnExampleAction"],
  "tags": ["OverwriteQuietHours","Critical"],
  "details":{"key1":"value1","key2":"value2"},
  "entity":"An example entity",
  "priority":"P1"
}
```


### Close alert action

When you create a rule that uses an Jira Service Management connector, its recovery actions close Jira Service Management alerts. You can test this type of action when you create or edit your connector:
![Jira Service Management close alert action test](https://www.elastic.co/docs/reference/kibana/images/jsm-close-alert-test.png)

The close alert action has the following configuration properties.
<definitions>
  <definition term="Alias">
    The alert identifier, which is used for alert deduplication in Jira Service Management (required). The alias must match the value used when creating the alert. For more information, refer to the [Jira Service Management documentation](https://support.atlassian.com/jira-service-management-cloud/docs/what-is-alert-deduplication/).
  </definition>
  <definition term="Note">
    Additional information for the alert (optional).
  </definition>
  <definition term="Source">
    The display name of the source (optional).
  </definition>
  <definition term="User">
    The display name of the owner (optional).
  </definition>
</definitions>


## Connector networking configuration

Use the [Action configuration settings](/docs/reference/kibana/configuration-reference/alerting-settings#action-settings) to customize connector networking configurations, such as proxies, certificates, or TLS settings. You can set configurations that apply to all your connectors or use `xpack.actions.customHostSettings` to set per-host configurations.

## Configure a Jira Service Management account

After obtaining an Jira Service Management instance, configure the API integration. For details, refer to the [Jira Service Management documentation](https://support.atlassian.com/jira-service-management-cloud/docs/set-up-an-api-integration/#Set-up-the-integration).
1. Go to the **Operations** > **Overview** dashboard, then select the appropriate team.
   ![Jira Service Management Operations overview](https://www.elastic.co/docs/reference/kibana/images/jsm-operations-overview.png)
2. Select the **Integrations** menu item, then select **Add integration**.
   ![Jira Service Management integrations](https://www.elastic.co/docs/reference/kibana/images/jsm-integrations.png)
3. Search for `API` and select the **API** integration.
   ![Jira Service Management API integration](https://www.elastic.co/docs/reference/kibana/images/jsm-add-api-integration.png)
4. Configure the integration. Ensure you record the **API Key**. You will later use this key to populate the **API Key** field when creating the Kibana Jira Service Management connector.
5. Select **Turn on integration** after you finish configuring the integration.
   ![Jira Service Management turn on integration](https://www.elastic.co/docs/reference/kibana/images/jsm-turn-on-integration.png)