﻿---
title: Jira connector and action
description: The Jira connector uses the REST API v2 to create Atlassian Jira issues. Jira Cloud and Jira Data Center are supported. Jira on-premise deployments are...
url: https://www.elastic.co/docs/reference/kibana/connectors-kibana/jira-action-type
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Jira connector and action
The Jira connector uses the [REST API v2](https://developer.atlassian.com/cloud/jira/platform/rest/v2/) to create Atlassian Jira issues.

## Compatibility

Jira Cloud and Jira Data Center are supported. Jira on-premise deployments are not supported.

## Create connectors in Kibana

You can create connectors in **Stack Management > Connectors** or as needed when you're creating a rule. For example:
![Jira connector](https://www.elastic.co/docs/reference/kibana/images/jira-connector.png)


### Connector configuration

Jira connectors have the following configuration properties:
<definitions>
  <definition term="Name">
    The name of the connector.
  </definition>
  <definition term="URL">
    Jira instance URL.
  </definition>
  <definition term="Project key">
    Jira project key.
  </definition>
  <definition term="Email">
    The account email for HTTP Basic authentication.
  </definition>
  <definition term="API token">
    Jira API authentication token for HTTP Basic authentication. For Jira Data Center, this value should be the password associated with the email owner.
  </definition>
</definitions>


## Test connectors

You can test connectors as you're creating or editing the connector in Kibana. For example:
![Jira params test](https://www.elastic.co/docs/reference/kibana/images/jira-params-test.png)

Jira actions have the following configuration properties.
<definitions>
  <definition term="Issue type">
    The type of the issue.
  </definition>
  <definition term="Priority">
    The priority of the incident.
  </definition>
  <definition term="Labels">
    The labels for the incident.
  </definition>
  <definition term="Title">
    A title for the issue, used for searching the contents of the knowledge base.
  </definition>
  <definition term="Description">
    The details about the incident.
  </definition>
  <definition term="Parent">
    The ID or key of the parent issue. Only for `Subtask` issue types.
  </definition>
  <definition term="Additional comments">
    Additional information for the client, such as how to troubleshoot the issue.
  </definition>
  <definition term="Additional fields">
    An object that contains custom field identifiers and their values. These custom fields must comply with your Jira policies; they are not validated by the connector. For example, if a rule action does not include custom fields that are mandatory, the action might fail.
  </definition>
</definitions>


## Connector networking configuration

Use the [Action configuration settings](/docs/reference/kibana/configuration-reference/alerting-settings#action-settings) to customize connector networking configurations, such as proxies, certificates, or TLS settings. You can set configurations that apply to all your connectors or use `xpack.actions.customHostSettings` to set per-host configurations.