﻿---
title: GreyNoise connector
description: The GreyNoise connector communicates with the GreyNoise API to detect and classify Internet scanning noise. You can create connectors in Stack Management...
url: https://www.elastic.co/docs/reference/kibana/connectors-kibana/greynoise-action-type
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.3
---

# GreyNoise connector
The GreyNoise connector communicates with the GreyNoise API to detect and classify Internet scanning noise.

## Create connectors in Kibana

You can create connectors in **Stack Management > Connectors**. For example:

### Connector configuration

GreyNoise connectors have the following configuration properties:
<definitions>
  <definition term="API Key">
    The GreyNoise API key for authentication.
  </definition>
</definitions>


## Test connectors

You can test connectors as you're creating or editing the connector in Kibana.
The GreyNoise connector has the following actions:
<definitions>
  <definition term="Get IP Context">
    Get detailed context and classification information about an IP address.
    - **IP** (required): The IPv4 address to look up.
  </definition>
  <definition term="Quick Lookup">
    Quickly check if an IP is classified as noise.
    - **IP** (required): The IPv4 address to check.
  </definition>
  <definition term="Get Metadata">
    Retrieve metadata about an IP address including geolocation and ASN.
    - **IP** (required): The IPv4 address.
  </definition>
  <definition term="RIOT Lookup">
    Check if an IP belongs to a known benign service (Rule It Out).
    - **IP** (required): The IPv4 address.
  </definition>
</definitions>


## Connector networking configuration

Use the [Action configuration settings](/docs/reference/kibana/configuration-reference/alerting-settings#action-settings) to customize connector networking configurations, such as proxies, certificates, or TLS settings. You can set configurations that apply to all your connectors or use `xpack.actions.customHostSettings` to set per-host configurations.

## Get API credentials

To use the GreyNoise connector, you need an API key:
1. Go to [GreyNoise](https://www.greynoise.io/).
2. Sign up for an account or log in.
3. Navigate to your [Account Settings](https://viz.greynoise.io/account).
4. Find your API Key in the API section.
5. Copy the API key to configure the connector.