﻿---
title: Google Gemini connector and action
description: The Google Gemini connector uses axios to send a POST request to Google Gemini. You can create connectors in Stack Management > Connectors.  For example:...
url: https://www.elastic.co/docs/reference/kibana/connectors-kibana/gemini-action-type
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Google Gemini connector and action
The Google Gemini connector uses [axios](https://github.com/axios/axios) to send a POST request to Google Gemini.

## Create connectors in Kibana

You can create connectors in **Stack Management > Connectors**.  For example:
![Google Gemini connector](https://www.elastic.co/docs/reference/kibana/images/gemini-connector.png)


### Connector configuration

Google Gemini connectors have the following configuration properties:
<definitions>
  <definition term="Name">
    The name of the connector.
  </definition>
  <definition term="API URL">
    The Google Gemini request URL.
  </definition>
  <definition term="Project ID">
    The project which has Vertex AI endpoint enabled.
  </definition>
  <definition term="Region">
    The GCP region where the Vertex AI endpoint enabled.
  </definition>
  <definition term="Default model">
    The GAI model for Google Gemini to use. Current support is for the Google Gemini models.
    - <applies-to>Elastic Cloud Serverless: Generally available</applies-to> Defaults to `gemini-2.5-pro`.
    - <applies-to>Elastic Stack: Generally available since 9.1</applies-to> Defaults to `gemini-2.5-pro`.
    - <applies-to>Elastic Stack: Generally available since 9.0</applies-to> Defaults to `gemini-1.5-pro-002`.
      The model can be set on a per request basis by including a "model" parameter alongside the request body.
  </definition>
  <definition term="Credentials JSON">
    The GCP service account JSON file for authentication.
  </definition>
</definitions>


## Test connectors

You can test connectors as you're creating or editing the connector in Kibana. For example:
![Google Gemini params test](https://www.elastic.co/docs/reference/kibana/images/gemini-params.png)

The Google Gemini actions have the following configuration properties.
<definitions>
  <definition term="Body">
    A stringified JSON payload sent to the Google Gemini invoke model API. For example:
    ```text
    {
      body: JSON.stringify({
            contents: [{
                role: user,
                parts: [{ text: 'Hello world!' }]
            }],
            generation_config: {
                temperature: 0,
                maxOutputTokens: 8192
            }
      })
    }
    ```
  </definition>
  <definition term="Model">
    An optional string that overwrites the connector's default model.
  </definition>
</definitions>


## Connector networking configuration

Use the [Action configuration settings](/docs/reference/kibana/configuration-reference/alerting-settings#action-settings) to customize connector networking configurations, such as proxies, certificates, or TLS settings. You can set configurations that apply to all your connectors or use `xpack.actions.customHostSettings` to set per-host configurations.