﻿---
title: Email connector and action
description: The email connector uses the SMTP protocol to send mail messages. Email message text is sent as both plain text and html text. You can create connectors...
url: https://www.elastic.co/docs/reference/kibana/connectors-kibana/email-action-type
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Email connector and action
The email connector uses the SMTP protocol to send mail messages. Email message text is sent as both plain text and html text.
<note>
  - For emails to have a footer with a link back to Kibana, set the [`server.publicBaseUrl`](/docs/reference/kibana/configuration-reference/general-settings#server-publicBaseUrl) configuration setting.
  - When the [`xpack.actions.email.domain_allowlist`](/docs/reference/kibana/configuration-reference/alerting-settings#action-config-email-domain-allowlist) configuration setting is used, the email addresses used for all of the Sender (from), To, CC, and BCC properties must have email domains specified in the configuration setting.
</note>


## Create connectors in Kibana

You can create connectors in **Stack Management > Connectors** or as needed when you’re creating a rule. For example:
![Email connector](https://www.elastic.co/docs/reference/kibana/images/email-connector.png)


### Connector configuration

Email connectors have the following configuration properties:
<definitions>
  <definition term="Name">
    The name of the connector. The name is used to identify a  connector in the management UI connector listing, or in the connector list when configuring an action.
  </definition>
  <definition term="Sender">
    The from address for all emails sent with this connector. This must be specified in `user@host-name` format. See the [Nodemailer address documentation](https://nodemailer.com/message/addresses/) for more information.
  </definition>
  <definition term="Service">
    The name of the email service. If `service` is one of Nodemailer’s well-known email service providers, the `host`, `port`, and `secure` properties are defined with the default values and disabled for modification. If `service` is `MS Exchange Server`, the `host`, `port`, and `secure` properties are ignored and `tenantId`, `clientId`, `clientSecret` are required instead. If `service` is `other`, the `host` and `port` properties must be defined.
  </definition>
  <definition term="Host">
    Host name of the service provider. If you are using the [`xpack.actions.allowedHosts`](/docs/reference/kibana/configuration-reference/alerting-settings#action-settings) setting, make sure this hostname is added to the allowed hosts.
  </definition>
  <definition term="Port">
    The port to connect to on the service provider.
  </definition>
  <definition term="Secure">
    If true, the connection will use TLS when connecting to the service provider. Refer to the [Nodemailer TLS documentation](https://nodemailer.com/smtp/#tls-options) for more information. If not true, the connection will initially connect over TCP, then attempt to switch to TLS via the SMTP STARTTLS command.
  </definition>
  <definition term="Tenant ID">
    The directory tenant that the application plans to operate against, in GUID format.
  </definition>
  <definition term="Client ID">
    The application ID that is assigned to your app, in GUID format. You can find this information in the portal where you registered your app.
  </definition>
  <definition term="Client Secret">
    The client secret that you generated for your app in the app registration portal. The client secret must be URL-encoded before being sent. The Basic auth pattern of providing credentials in the Authorization header, per [RFC 6749](https://datatracker.ietf.org/doc/html/rfc6749#section-2.3.1), is also supported.
  </definition>
  <definition term="Require authentication">
    If true, a username and password for login type authentication must be provided.
  </definition>
  <definition term="Username">
    Username for login type authentication.
  </definition>
  <definition term="Password">
    Password for login type authentication.
  </definition>
</definitions>


## Test connectors

You can test connectors as you're creating or editing the connector in Kibana. For example:
![Email params test](https://www.elastic.co/docs/reference/kibana/images/email-params-test.png)

Email actions have the following configuration properties.
<definitions>
  <definition term="To, CC, BCC">
    Each item is a list of addresses. Addresses can be specified in `user@host-name` format, in `name <user@host-name>` format, or using [Mustache templates](https://www.elastic.co/docs/explore-analyze/alerts-cases/watcher/how-watcher-works#templates). One of To, CC, or BCC must contain an entry.
  </definition>
  <definition term="Subject">
    The subject line of the email.
  </definition>
  <definition term="Message">
    The message text of the email. Markdown format is supported.
  </definition>
</definitions>


## Connector networking configuration

Use the [Action configuration settings](/docs/reference/kibana/configuration-reference/alerting-settings#action-settings) to customize connector networking configurations, such as proxies, certificates, or TLS settings. You can set configurations that apply to all your connectors or use `xpack.actions.customHostSettings` to set per-host configurations.

## Configure email accounts for well-known services

The email connector uses an integration of [Nodemailer](https://nodemailer.com/) to send email from many popular SMTP email services. For Microsoft Exchange email, it uses the Microsoft Graph API.
For other email servers, you can check the list of well-known services that Nodemailer supports in the JSON file [well-known/services.json](https://github.com/nodemailer/nodemailer/blob/master/lib/well-known/services.json). The properties of the objects in those files — `host`, `port`, and `secure` — correspond to the same email connector configuration properties. A missing `secure` property in the "well-known/services.json" file is considered `false`.  Typically, `port: 465` uses `secure: true`, and `port: 25` and `port: 587` use `secure: false`.

### Elastic Cloud

Use the preconfigured email connector (`Elastic-Cloud-SMTP`) to send emails from Elastic Cloud.
<note>
  For more information on the preconfigured email connector, see [Elastic Cloud email service limits](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/tools-apis#email-service-limits).
</note>


### Gmail

To create a connector that sends email from the [Gmail](https://mail.google.com) SMTP service, set the **Service** to `Gmail`.
If you get an authentication error that indicates that you need to continue the sign-in process from a web browser when the action attempts to send email, you need to configure Gmail to [allow less secure apps to access your account](https://support.google.com/accounts/answer/6010255?hl=en).
If two-step verification is enabled for your account, you must generate and use a unique App Password to send email from Kibana. See [Sign in using App Passwords](https://support.google.com/accounts/answer/185833?hl=en) for more information.

### Outlook.com

To create a connector that sends email from the [Outlook.com](https://www.outlook.com/) SMTP service, set the **Service** to `Outlook`.
When sending emails, you must provide a `from` address, either as the default in your connector configuration or as part of the email action in the rule.
<note>
  You must use a unique App Password if two-step verification is enabled. See [App passwords and two-step verification](http://windows.microsoft.com/en-us/windows/app-passwords-two-step-verification) for more information.
</note>


### Amazon SES

To create a connector that sends email from the [Amazon Simple Email Service](http://aws.amazon.com/ses) (SES) SMTP service, set the **Service** to `Amazon SES`.
<note>
  You must use your Amazon SES SMTP credentials to send email through Amazon SES. For more information, see [Obtaining Your Amazon SES SMTP Credentials](http://docs.aws.amazon.com/ses/latest/DeveloperGuide/smtp-credentials.md). You might also need to verify [your email address](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-email-addresses.md) or [your whole domain](https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-domains.md) at AWS.
</note>


### Microsoft Exchange with basic authentication

To prepare for the removal of Basic Auth, you must update all existing Microsoft Exchange connectors with the new configuration based on the [OAuth 2.0 Client Credentials Authentication](https://docs.microsoft.com/en-us/azure/active-directory/develop/v2-oauth2-client-creds-grant-flow).

### Microsoft Exchange with OAuth 2.0

<note>
  The email connector uses Microsoft Graph REST API v1.0, in particular the [sendMail](https://docs.microsoft.com/en-us/graph/api/user-sendmail) endpoint. It supports only the [Microsoft Graph global service](https://learn.microsoft.com/en-us/graph/deployments#microsoft-graph-and-graph-explorer-service-root-endpoints) root endpoint (`https://graph.microsoft.com`).
</note>

Before you create an email connector for Microsoft Exchange, you must create and register the client integration application on the [Azure portal](https://go.microsoft.com/fwlink/?linkid=2083908):
![Register client application for MS Exchange](https://www.elastic.co/docs/reference/kibana/images/exchange-register-app.png)

Next, open **Manage > API permissions**, and then define the permissions for the registered application to send emails. Refer to the [documentation](https://docs.microsoft.com/en-us/graph/api/user-sendmail?view=graph-rest-1.0&tabs=http#permissions) for the Microsoft Graph API.
![MS Exchange API permissions](https://www.elastic.co/docs/reference/kibana/images/exchange-api-permissions.png)

Add the "Mail.Send" permission for Microsoft Graph. The permission appears in the list with the status "Not granted for `<your Azure active directory>`":
![MS Exchange "Mail.Send" not granted](https://www.elastic.co/docs/reference/kibana/images/exchange-not-granted.png)

Click **Grant admin consent for `<your Azure active directory>`**.
![MS Exchange grant confirmation](https://www.elastic.co/docs/reference/kibana/images/exchange-grant-confirm.png)

Confirm that the status for the "Mail.Send" permission is now granted.
![MS Exchange grant confirmation](https://www.elastic.co/docs/reference/kibana/images/exchange-granted.png)


#### Configure the Microsoft Exchange Client secret

To configure the Microsoft Exchange Client secret, open **Manage > Certificates & secrets**:
![MS Exchange secrets configuration](https://www.elastic.co/docs/reference/kibana/images/exchange-secrets.png)

Add a new client secret, then copy the value and put it to the proper field in the Microsoft Exchange email connector.

#### Configure the Microsoft Exchange client and tenant identifiers

To find the Microsoft Exchange client and tenant IDs, open the **Overview** page:
![MS Exchange Client ID and Tenant ID configuration](https://www.elastic.co/docs/reference/kibana/images/exchange-client-tenant.png)

Create a connector and set the **Service** to `MS Exchange Server`. Copy and paste the values into the proper fields.