﻿---
title: Microsoft Defender for Endpoint connector and action
description: The Microsoft Defender for Endpoint connector enables you to perform actions on Microsoft Defender-enrolled hosts. You can create connectors in Stack...
url: https://www.elastic.co/docs/reference/kibana/connectors-kibana/defender-action-type
products:
  - Kibana
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Microsoft Defender for Endpoint connector and action
The Microsoft Defender for Endpoint connector enables you to perform actions on Microsoft Defender-enrolled hosts.

## Create connectors in Kibana

You can create connectors in **Stack Management > Connectors** or as needed when you're creating a rule. For example:
![Microsoft Defender for Endpoint connector](https://www.elastic.co/docs/reference/kibana/images/defender-connector.png)


### Connector configuration

Microsoft Defender for Endpoint connectors have the following configuration properties:
<definitions>
  <definition term="API URL">
    The URL of the Microsoft Defender for Endpoint API. If you are using the [`xpack.actions.allowedHosts`](/docs/reference/kibana/configuration-reference/alerting-settings#action-settings) setting, make sure the hostname is added to the allowed hosts.
  </definition>
  <definition term="Application client ID">
    The application (client) identifier for your app in the Azure portal.
  </definition>
  <definition term="Client secret value">
    The client secret for your app in the Azure portal.
  </definition>
  <definition term="Name">
    The name of the connector.
  </definition>
  <definition term="OAuth Scope">
    The OAuth scopes or permission sets for the Microsoft Defender for Endpoint API.
  </definition>
  <definition term="OAuth Server URL">
    The OAuth server URL where authentication is sent and received for the Microsoft Defender for Endpoint API.
  </definition>
  <definition term="Tenant ID">
    The tenant identifier for your app in the Azure portal.
  </definition>
</definitions>


## Test connectors

You can test connectors as you're creating or editing the connector in Kibana.
For example:
![Microsoft Defender for Endpoint connector test](https://www.elastic.co/docs/reference/kibana/images/defender-connector-test.png)


## Configure Microsoft Defender for Endpoint

Before you create the connector, you must create a new application on your Azure domain.
The procedure to create an application is found in the [Microsoft Defender documentation](https://learn.microsoft.com/en-us/defender-endpoint/api/exposed-apis-create-app-webapp).
Make note of the client ID, client secret, and tenant ID, since you must provide this information when you create your connector.