﻿---
title: CrowdStrike connector
description: The CrowdStrike connector communicates with CrowdStrike Management Console via REST API. To use this connector, you must have authority to run Endpoint...
url: https://www.elastic.co/docs/reference/kibana/connectors-kibana/crowdstrike-action-type
products:
  - Kibana
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# CrowdStrike connector
The CrowdStrike connector communicates with CrowdStrike Management Console via REST API.
To use this connector, you must have authority to run Endpoint Security connectors, which is an **Actions and Connectors** sub-feature privilege. Refer to [Kibana privileges](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges).

## Create connectors in Kibana

You can create connectors in **Stack Management > Connectors**. For example:
![CrowdStrike connector](https://www.elastic.co/docs/reference/kibana/images/crowdstrike-connector.png)


### Connector configuration

CrowdStrike connectors have the following configuration properties:
<definitions>
  <definition term="CrowdStrike API URL">
    The CrowdStrike tenant URL. If you are using the [`xpack.actions.allowedHosts`](/docs/reference/kibana/configuration-reference/alerting-settings#action-settings) setting, make sure the hostname is added to the allowed hosts.
  </definition>
  <definition term="CrowdStrike client ID">
    The CrowdStrike API client identifier.
  </definition>
  <definition term="Client secret">
    The CrowdStrike API client secret to authenticate the client ID.
  </definition>
</definitions>


## Test connectors

You can test connectors as you’re creating or editing the connector in Kibana. For example:
![CrowdStrike connector test](https://www.elastic.co/docs/reference/kibana/images/crowdstrike-connector-test.png)

The CrowdStrike action has the following configuration properties:
<definitions>
  <definition term="Agent IDs">
    Get details about one or more CrowdStrike agent IDs.
  </definition>
</definitions>