﻿---
title: Webhook - Case Management connector and action
description: The Webhook - Case Management connector uses axios to send POST, PUT, and GET requests to a case management RESTful API web service. You can create connectors...
url: https://www.elastic.co/docs/reference/kibana/connectors-kibana/cases-webhook-action-type
products:
  - Kibana
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available
---

# Webhook - Case Management connector and action
The Webhook - Case Management connector uses [axios](https://github.com/axios/axios) to send POST, PUT, and GET requests to a case management RESTful API web service.

## Create connectors in Kibana

You can create connectors in **Stack Management > Connectors** or as needed when you’re creating a rule. In the first step, you must provide a name for the connector and its authentication details. For example:
![Set authentication details in the Webhook - Case Management connector](https://www.elastic.co/docs/reference/kibana/images/cases-webhook-connector.png)

In the second step, you must provide the information necessary to create cases in the external system. For example:
![Add case creation details in the Webhook - Case Management connector](https://www.elastic.co/docs/reference/kibana/images/cases-webhook-connector-create-case.png)

In the third step, you must provide information related to retrieving case details from the external system. For example:
![Add case retrieval details in the Webhook - Case Management connector](https://www.elastic.co/docs/reference/kibana/images/cases-webhook-connector-get-case.png)

In the fourth step, you must provide information necessary to update cases in the external system. You can also optionally provide information to add comments to cases. For example:
![Add case update and comment details in the Webhook - Case Management connector](https://www.elastic.co/docs/reference/kibana/images/cases-webhook-connector-comments.png)


### Connector configuration

Webhook - Case Management connectors have the following configuration properties:
<definitions>
  <definition term="Authentication">
    The authentication type: none, basic, or SSL. If you choose basic authentication, you must provide a user name and password. If you choose SSL authentication, you must provide SSL server certificate authentication data in a CRT and key file format or a PFX file format. You can also optionally provide a passphrase if the files are password-protected.
  </definition>
  <definition term="Certificate authority">
    A certificate authority (CA) that the connector can trust, for example to sign and validate server certificates. This option is available for all authentication types. You can choose from the following verification modes:
    - `Full`: Validate that the certificate has an issue date within the `not_before` and `not_after` dates, chains to a trusted certificate authority, and has a hostname or IP address that matches the names within the certificate.
    - `Certificate`: Validate that the certificate it is signed by a trusted authority. This option does not check the certificate hostname.
    - `None`: Skip certificate validation.
  </definition>
  <definition term="Create case method">
    The REST API HTTP request method to create a case in the third-party system: `post`(default), `put`, or `patch`.
  </definition>
  <definition term="Create case object">
    A JSON payload sent to the create case URL to create a case. Use the variable selector to add case data to the payload. Required variables are `case.title` and `case.description`. For example:
    ```json
    {
    	"fields": {
    	  "summary": {{{case.title}}},
    	  "description": {{{case.description}}},
    	  "labels": {{{case.tags}}}
    	}
    }
    ```
    <note>
      Due to Mustache template variables (the text enclosed in triple braces, for example, `{{{case.title}}}`), the JSON is not validated in this step. The JSON is validated after the Mustache variables have been placed when REST method runs. Manually ensure that the JSON is valid, disregarding the Mustache variables, so the later validation will pass.
    </note>
  </definition>
  <definition term="Create case response external key">
    The JSON key in the create external case response that contains the case ID.
  </definition>
  <definition term="Create case URL">
    The REST API URL to create a case in the third-party system. If you are using the [`xpack.actions.allowedHosts`](/docs/reference/kibana/configuration-reference/alerting-settings#action-settings) setting, make sure the hostname is added to the allowed hosts.
  </definition>
  <definition term="Create comment method">
    The optional REST API HTTP request method to create a case comment in the third-party system: `post`, `put`(default), or `patch`.
  </definition>
  <definition term="Create comment object">
    An optional JSON payload sent to the create comment URL to create a case comment. Use the variable selector to add Kibana cases data to the payload. The required variable is `case.comment`. For example:
    ```json
    {
      "body": {{{case.comment}}}
    }
    ```
    <note>
      Due to Mustache template variables (the text enclosed in triple braces, for example, `{{{case.title}}}`), the JSON is not validated in this step. The JSON is validated once the mustache variables have been placed and when REST method runs. We recommend manually ensuring that the JSON is valid, disregarding the Mustache variables, so the later validation will pass.
    </note>
  </definition>
  <definition term="Create comment URL">
    The optional REST API URL to create a case comment by ID in the third-party system. Use the variable selector to add the external system ID to the URL. If you are using the [`xpack.actions.allowedHosts`](/docs/reference/kibana/configuration-reference/alerting-settings#action-settings) setting, make sure the hostname is added to the allowed hosts. For example:
    ```text
    https://testing-jira.atlassian.net/rest/api/2/issue/{{{external.system.id}}}/comment
    ```
  </definition>
  <definition term="External case view URL">
    The URL to view the case in the external system. Use the variable selector to add the external system ID or external system title to the URL. For example:
    ```text
    https://testing-jira.atlassian.net/browse/{{{external.system.title}}}
    ```
  </definition>
  <definition term="Get case response external title key">
    The JSON key in the get external case response that contains the case title.
  </definition>
  <definition term="Get case URL">
    The REST API URL to GET case by ID from the third-party system. Use the variable selector to add the external system ID to the URL. If you are using the [`xpack.actions.allowedHosts`](/docs/reference/kibana/configuration-reference/alerting-settings#action-settings) setting, make sure the hostname is added to the allowed hosts. For example:
    ```text
    https://testing-jira.atlassian.net/rest/api/2/issue/{{{external.system.id}}}
    ```
    <note>
      Due to Mustache template variables (the text enclosed in triple braces, for example, `{{{case.title}}}`), the JSON is not validated in this step. The JSON is validated after the Mustache variables have been placed when REST method runs. Manually ensure that the JSON is valid, disregarding the Mustache variables, so the later validation will pass.
    </note>
  </definition>
  <definition term="HTTP headers">
    A set of key-value pairs sent as headers with the request URLs for the create case, update case, get case, and create comment methods. For example, set `Content-Type` to the appropriate media type for your requests.
  </definition>
  <definition term="Update case method">
    The REST API HTTP request method to update the case in the third-party system: `post`, `put`(default), or `patch`.
  </definition>
  <definition term="Update case object">
    A JSON payload sent to the update case URL to update the case. Use the variable selector to add Kibana cases data to the payload. Required variables are `case.title` and `case.description`. For example:
    ```json
    {
    	"fields": {
    	  "summary": {{{case.title}}},
    	  "description": {{{case.description}}},
    	  "labels": {{{case.tags}}}
    	}
    }
    ```
    <note>
      Due to Mustache template variables (which is the text enclosed in triple braces, for example, `{{{case.title}}}`), the JSON is not validated in this step. The JSON is validated after the Mustache variables have been placed when REST method runs. Manually ensure that the JSON is valid to avoid future validation errors; disregard Mustache variables during your review.
    </note>
  </definition>
  <definition term="Update case URL">
    The REST API URL to update the case by ID in the third-party system. Use the variable selector to add the external system ID to the URL. If you are using the [`xpack.actions.allowedHosts`](/docs/reference/kibana/configuration-reference/alerting-settings#action-settings) setting, make sure the hostname is added to the allowed hosts. For example:
    ```text
    https://testing-jira.atlassian.net/rest/api/2/issue/{{{external.system.ID}}}
    ```
  </definition>
</definitions>


## Test connectors

You can test connectors as you’re creating or editing the connector in Kibana. For example:
![Webhook - Case Management params test](https://www.elastic.co/docs/reference/kibana/images/cases-webhook-test.png)

Webhook - Case Management actions have the following configuration properties:
<definitions>
  <definition term="Additional comments">
    Additional information for the client, such as how to troubleshoot the issue.
  </definition>
  <definition term="Case ID">
    A unique case identifier.
  </definition>
  <definition term="Description">
    The details about the incident.
  </definition>
  <definition term="Labels">
    The labels for the incident.
  </definition>
  <definition term="Severity">
    The severity of the case can be `critical`, `high`, `low`, or `medium`.
  </definition>
  <definition term="Status">
    The status of the case can be `closed`, `in-progress` or `open`.
  </definition>
  <definition term="Summary">
    A brief case summary.
  </definition>
  <definition term="Tags">
    A list of tags that can be used to filter cases.
  </definition>
</definitions>


## Connector networking configuration

Use the [action configuration settings](/docs/reference/kibana/configuration-reference/alerting-settings#action-settings) to customize connector networking configurations, such as proxies, certificates, or TLS settings. You can set configurations that apply to all your connectors or use `xpack.actions.customHostSettings` to set per-host configurations.