﻿---
title: Brave Search connector
description: The Brave Search connector communicates with the Brave Search API to search the web for privacy-focused results. You can create connectors in Stack Management...
url: https://www.elastic.co/docs/reference/kibana/connectors-kibana/brave-search-action-type
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.3
---

# Brave Search connector
The Brave Search connector communicates with the Brave Search API to search the web for privacy-focused results.

## Create connectors in Kibana

You can create connectors in **Stack Management > Connectors**. For example:

### Connector configuration

Brave Search connectors have the following configuration properties:
<definitions>
  <definition term="API Key">
    The Brave Search API key for authentication. This key should be provided in the `X-Subscription-Token` header.
  </definition>
</definitions>


## Test connectors

You can test connectors as you're creating or editing the connector in Kibana.
The Brave Search connector has the following action:
<definitions>
  <definition term="Web Search">
    Search the web using Brave Search API.
    - **Query** (required): The search query string.
    - **Count** (optional): Number of results to return (1-20, default: 10).
    - **Offset** (optional): Result offset for pagination (default: 0).
  </definition>
</definitions>


## Connector networking configuration

Use the [Action configuration settings](/docs/reference/kibana/configuration-reference/alerting-settings#action-settings) to customize connector networking configurations, such as proxies, certificates, or TLS settings.
You can set configurations that apply to all your connectors or use `xpack.actions.customHostSettings` to set per-host configurations.

## Get API credentials

To use the Brave Search connector, you need an API key:
1. Go to [Brave Search API](https://brave.com/search/api/).
2. Sign up for an account or log in.
3. Navigate to your API dashboard.
4. Generate or copy your API key.
5. Use the API key to configure the connector in Kibana.