﻿---
title: Amazon Bedrock connector and action
description: The Amazon Bedrock connector uses axios to send a POST request to Amazon Bedrock. You can create connectors in Stack Management > Connectors.  For example:...
url: https://www.elastic.co/docs/reference/kibana/connectors-kibana/bedrock-action-type
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Amazon Bedrock connector and action
The Amazon Bedrock connector uses [axios](https://github.com/axios/axios) to send a POST request to Amazon Bedrock.

## Create connectors in Kibana

You can create connectors in **Stack Management > Connectors**.  For example:
![Amazon Bedrock connector](https://www.elastic.co/docs/reference/kibana/images/bedrock-connector.png)


### Connector configuration

Amazon Bedrock connectors have the following configuration properties:
<definitions>
  <definition term="Name">
    The name of the connector.
  </definition>
  <definition term="API URL">
    The Amazon Bedrock request URL.
  </definition>
  <definition term="Default model">
    The GAI model for Amazon Bedrock to use. Current support is for the Anthropic Claude models, defaulting to Claude 2. The model can be set on a per request basis by including a "model" parameter alongside the request body.
  </definition>
  <definition term="Access Key">
    The AWS access key for authentication.
  </definition>
  <definition term="Secret">
    The secret for authentication.
  </definition>
</definitions>


## Test connectors

You can test connectors as you’re creating or editing the connector in Kibana. For example:
![Amazon Bedrock params test](https://www.elastic.co/docs/reference/kibana/images/bedrock-params.png)

The Amazon Bedrock actions have the following configuration properties.
<definitions>
  <definition term="Body">
    A stringified JSON payload sent to the Amazon Bedrock Invoke Model API URL. For example:
    ```text
    {
      body: JSON.stringify({
            prompt: `${combinedMessages} \n\nAssistant:`,
            max_tokens_to_sample: 300,
            stop_sequences: ['\n\nHuman:']
      })
    }
    ```
  </definition>
  <definition term="Model">
    An optional string that will overwrite the connector’s default model. For
  </definition>
</definitions>


## Connector networking configuration

Use the [Action configuration settings](/docs/reference/kibana/configuration-reference/alerting-settings#action-settings) to customize connector networking configurations, such as proxies, certificates, or TLS settings. You can set configurations that apply to all your connectors or use `xpack.actions.customHostSettings` to set per-host configurations.