﻿---
title: AlienVault OTX connector
description: The AlienVault OTX (Open Threat Exchange) connector communicates with the AlienVault OTX API to retrieve community-driven threat intelligence. You can...
url: https://www.elastic.co/docs/reference/kibana/connectors-kibana/alienvault-otx-action-type
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.3
---

# AlienVault OTX connector
The AlienVault OTX (Open Threat Exchange) connector communicates with the AlienVault OTX API to retrieve community-driven threat intelligence.

## Create connectors in Kibana

You can create connectors in **Stack Management > Connectors**. For example:

### Connector configuration

AlienVault OTX connectors have the following configuration properties:
<definitions>
  <definition term="API Key">
    The AlienVault OTX API key for authentication.
  </definition>
</definitions>


## Test connectors

You can test connectors as you're creating or editing the connector in Kibana.
The AlienVault OTX connector has the following actions:
<definitions>
  <definition term="Get Indicator">
    Retrieve information about a specific indicator (IP, domain, hash, URL).
    - **Indicator Type** (required): Type of indicator (IPv4, IPv6, domain, hostname, url, FileHash-MD5, FileHash-SHA1, FileHash-SHA256).
    - **Indicator** (required): The indicator value to look up.
    - **Section** (optional): Specific section to retrieve.
  </definition>
  <definition term="Search Pulses">
    Search for threat pulses (threat intelligence reports).
    - **Query** (optional): Search query string.
    - **Page** (optional): Page number (default 1).
    - **Limit** (optional): Results per page (1-100, default 20).
  </definition>
  <definition term="Get Pulse">
    Retrieve detailed information about a specific pulse by ID.
    - **Pulse ID** (required): The pulse identifier.
  </definition>
  <definition term="Get Related Pulses">
    Find pulses related to a specific indicator.
    - **Indicator Type** (required): Type of indicator (IPv4, IPv6, domain, hostname, url, FileHash-MD5, FileHash-SHA1, FileHash-SHA256).
    - **Indicator** (required): The indicator value.
  </definition>
</definitions>


## Connector networking configuration

Use the [Action configuration settings](/docs/reference/kibana/configuration-reference/alerting-settings#action-settings) to customize connector networking configurations, such as proxies, certificates, or TLS settings. You can set configurations that apply to all your connectors or use `xpack.actions.customHostSettings` to set per-host configurations.

## Get API credentials

To use the AlienVault OTX connector, you need an API key:
1. Go to [AlienVault OTX](https://otx.alienvault.com/).
2. Sign up for an account or log in.
3. Navigate to your account settings.
4. Find your OTX API Key in the API Integration section.
5. Copy the API key to configure the connector.