﻿---
title: Alerting and case management connectors
description: Use these connectors to integrate with third-party services for alerting, incident management, and case management. 
url: https://www.elastic.co/docs/reference/kibana/connectors-kibana/alerting-cases-connectors
products:
  - Kibana
---

# Alerting and case management connectors
Use these connectors to integrate with third-party services for alerting, incident management, and case management.

## Available connectors

- [XSOAR](https://www.elastic.co/docs/reference/kibana/connectors-kibana/xsoar-action-type): Create an incident in Cortex XSOAR.
- [CrowdStrike](https://www.elastic.co/docs/reference/kibana/connectors-kibana/crowdstrike-action-type): Send a request to CrowdStrike.
- [D3 Security](https://www.elastic.co/docs/reference/kibana/connectors-kibana/d3security-action-type): Send a request to D3 Security.
- [Email](https://www.elastic.co/docs/reference/kibana/connectors-kibana/email-action-type): Send email from your server.
- [IBM Resilient](https://www.elastic.co/docs/reference/kibana/connectors-kibana/resilient-action-type): Create an incident in IBM Resilient.
- [Jira](https://www.elastic.co/docs/reference/kibana/connectors-kibana/jira-action-type): Create an incident in Jira.
- [Jira Service Management](https://www.elastic.co/docs/reference/kibana/connectors-kibana/jsm-action-type): Create or close an alert in Jira Service Management.
- [Microsoft Defender for Endpoint](https://www.elastic.co/docs/reference/kibana/connectors-kibana/defender-action-type): Send requests to Microsoft Defender-enrolled hosts.
- [Microsoft Teams](https://www.elastic.co/docs/reference/kibana/connectors-kibana/teams-action-type): Send a message to a Microsoft Teams channel.
- [Opsgenie](https://www.elastic.co/docs/reference/kibana/connectors-kibana/opsgenie-action-type): Create or close an alert in Opsgenie.
- [PagerDuty](https://www.elastic.co/docs/reference/kibana/connectors-kibana/pagerduty-action-type): Send an event in PagerDuty.
- [SentinelOne](https://www.elastic.co/docs/reference/kibana/connectors-kibana/sentinelone-action-type): Send a request to SentinelOne.
- [ServiceNow ITSM](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-action-type): Create an incident in ServiceNow.
- [ServiceNow ITOM](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-itom-action-type): Create an event in ServiceNow.
- [ServiceNow SecOps](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-sir-action-type): Create a security incident in ServiceNow.
- [Slack](https://www.elastic.co/docs/reference/kibana/connectors-kibana/slack-action-type): Send a message to a Slack channel or user.
- [Swimlane](https://www.elastic.co/docs/reference/kibana/connectors-kibana/swimlane-action-type): Create an incident in Swimlane.
- [TheHive](https://www.elastic.co/docs/reference/kibana/connectors-kibana/thehive-action-type): Create cases and alerts in TheHive.
- [Tines](https://www.elastic.co/docs/reference/kibana/connectors-kibana/tines-action-type): Send events to a Tines Story.
- [Torq](https://www.elastic.co/docs/reference/kibana/connectors-kibana/torq-action-type): Trigger a Torq workflow.
- [Webhook](https://www.elastic.co/docs/reference/kibana/connectors-kibana/webhook-action-type): Send a request to a web service.
- [Webhook - Case Management](https://www.elastic.co/docs/reference/kibana/connectors-kibana/cases-webhook-action-type): Send a request to a Case Management web service.
- [xMatters](https://www.elastic.co/docs/reference/kibana/connectors-kibana/xmatters-action-type): Send actionable alerts to on-call xMatters resources.