﻿---
title: AbuseIPDB connector
description: The AbuseIPDB connector communicates with the AbuseIPDB API to check IP reputation and report abusive IPs. You can create connectors in Stack Management...
url: https://www.elastic.co/docs/reference/kibana/connectors-kibana/abuseipdb-action-type
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Preview
  - Elastic Stack: Preview since 9.3
---

# AbuseIPDB connector
The AbuseIPDB connector communicates with the AbuseIPDB API to check IP reputation and report abusive IPs.

## Create connectors in Kibana

You can create connectors in **Stack Management > Connectors**. For example:

### Connector configuration

AbuseIPDB connectors have the following configuration properties:
<definitions>
  <definition term="API Key">
    The AbuseIPDB API key for authentication.
  </definition>
</definitions>


## Test connectors

You can test connectors as you're creating or editing the connector in Kibana.
The AbuseIPDB connector has the following actions:
<definitions>
  <definition term="Check IP">
    Get details about an IP address including abuse confidence score, usage type, ISP, and country code.
    - **IP Address** (required): The IPv4 address to check.
    - **Max Age in Days** (optional): Maximum age of reports in days (1-365, default 90).
  </definition>
  <definition term="Report IP">
    Report an abusive IP address to AbuseIPDB.
    - **IP** (required): The IPv4 address to report.
    - **Categories** (required): Array of abuse category IDs.
    - **Comment** (optional): Additional details about the abuse.
  </definition>
  <definition term="Get IP Info">
    Get detailed information about an IP address including geolocation and domain.
    - **IP Address** (required): The IPv4 address to lookup.
  </definition>
  <definition term="Bulk Check">
    Check multiple IPs in a network range using CIDR notation.
    - **Network** (required): Network in CIDR notation.
    - **Max Age in Days** (optional): Maximum age of reports in days (1-365, default 30).
  </definition>
</definitions>


## Connector networking configuration

Use the [Action configuration settings](/docs/reference/kibana/configuration-reference/alerting-settings#action-settings) to customize connector networking configurations, such as proxies, certificates, or TLS settings. You can set configurations that apply to all your connectors or use `xpack.actions.customHostSettings` to set per-host configurations.

## Get API credentials

To use the AbuseIPDB connector, you need an API key:
1. Go to [AbuseIPDB](https://www.abuseipdb.com/).
2. Sign up for an account or log in.
3. Navigate to your [API page](https://www.abuseipdb.com/api) in your account settings.
4. Generate an API key with appropriate permissions.
5. Copy the API key to configure the connector.