﻿---
title: Kibana connectors
description: Connectors provide a central place to store connection information for services and integrations with Elastic or third-party systems. If you're using...
url: https://www.elastic.co/docs/reference/kibana/connectors-kibana
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Kibana connectors
<important>
  These Kibana connectors are used to connect to external services for GenAI, alerting, and case management use cases.To learn about connectors for syncing data to Elasticsearch for search use cases, refer to [content connectors](https://www.elastic.co/docs/reference/search-connectors).
</important>

Connectors provide a central place to store connection information for services and integrations with Elastic or third-party systems.
If you're using connectors for alerting or case management, you can [create rules](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/create-manage-rules) and [add actions](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/create-manage-rules#defining-rules-actions-details) that use connectors to send notifications when conditions are met.
Kibana provides connectors for LLM providers, Elastic Stack features, and third-party alerting and case management platforms.

## Required permissions

Access to connectors is granted based on your privileges to alerting-enabled features. For more information, go to [Security](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/alerting-setup#alerting-security).

## Available connectors

Kibana provides the following connectors, grouped by category.
<dropdown title="Generative AI">
  - [AI Connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/ai-connector): Connect to third-party LLM services including Amazon Bedrock, Azure, Google Gemini, OpenAI, and Elastic Inference Service.
  - [Amazon Bedrock](https://www.elastic.co/docs/reference/kibana/connectors-kibana/bedrock-action-type): Send a request to Amazon Bedrock.
  - [Elastic Managed LLMs](https://www.elastic.co/docs/reference/kibana/connectors-kibana/elastic-managed-llm): Send a request to Elastic Managed LLMs.
  - [Google Gemini](https://www.elastic.co/docs/reference/kibana/connectors-kibana/gemini-action-type): Send a request to Google Gemini.
  - [OpenAI](https://www.elastic.co/docs/reference/kibana/connectors-kibana/openai-action-type): Send a request to OpenAI.

  **External MCP Server**
  - [MCP](https://www.elastic.co/docs/reference/kibana/connectors-kibana/mcp-action-type): Connect to MCP servers and call their tools. <applies-to>Elastic Stack: Preview in 9.3</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to>
</dropdown>

<dropdown title="Elastic Stack">
  - [Cases](https://www.elastic.co/docs/reference/kibana/connectors-kibana/cases-action-type): Add alerts to [Cases](https://www.elastic.co/docs/explore-analyze/alerts-cases/cases).
  - [Index](https://www.elastic.co/docs/reference/kibana/connectors-kibana/index-action-type): Index data into Elasticsearch.
  - [Observability AI Assistant](https://www.elastic.co/docs/reference/kibana/connectors-kibana/obs-ai-assistant-action-type): Send alerts to the AI Assistant.
  - [ServerLog](https://www.elastic.co/docs/reference/kibana/connectors-kibana/server-log-action-type): Add a message to a Kibana log.
</dropdown>

<dropdown title="Alerting and case management">
  - [XSOAR](https://www.elastic.co/docs/reference/kibana/connectors-kibana/xsoar-action-type): Create an incident in Cortex XSOAR.
  - [CrowdStrike](https://www.elastic.co/docs/reference/kibana/connectors-kibana/crowdstrike-action-type): Send a request to CrowdStrike.
  - [D3 Security](https://www.elastic.co/docs/reference/kibana/connectors-kibana/d3security-action-type): Send a request to D3 Security.
  - [Email](https://www.elastic.co/docs/reference/kibana/connectors-kibana/email-action-type): Send email from your server.
  - [IBM Resilient](https://www.elastic.co/docs/reference/kibana/connectors-kibana/resilient-action-type): Create an incident in IBM Resilient.
  - [Jira](https://www.elastic.co/docs/reference/kibana/connectors-kibana/jira-action-type): Create an incident in Jira.
  - [Jira Service Management](https://www.elastic.co/docs/reference/kibana/connectors-kibana/jsm-action-type): Create or close an alert in Jira Service Management.
  - [Microsoft Defender for Endpoint](https://www.elastic.co/docs/reference/kibana/connectors-kibana/defender-action-type): Send requests to Microsoft Defender-enrolled hosts.
  - [Microsoft Teams](https://www.elastic.co/docs/reference/kibana/connectors-kibana/teams-action-type): Send a message to a Microsoft Teams channel.
  - [Opsgenie](https://www.elastic.co/docs/reference/kibana/connectors-kibana/opsgenie-action-type): Create or close an alert in Opsgenie.
  - [PagerDuty](https://www.elastic.co/docs/reference/kibana/connectors-kibana/pagerduty-action-type): Send an event in PagerDuty.
  - [SentinelOne](https://www.elastic.co/docs/reference/kibana/connectors-kibana/sentinelone-action-type): Send a request to SentinelOne.
  - [ServiceNow ITSM](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-action-type): Create an incident in ServiceNow.
  - [ServiceNow ITOM](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-itom-action-type): Create an event in ServiceNow.
  - [ServiceNow SecOps](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-sir-action-type): Create a security incident in ServiceNow.
  - [Slack](https://www.elastic.co/docs/reference/kibana/connectors-kibana/slack-action-type): Send a message to a Slack channel or user.
  - [Swimlane](https://www.elastic.co/docs/reference/kibana/connectors-kibana/swimlane-action-type): Create an incident in Swimlane.
  - [TheHive](https://www.elastic.co/docs/reference/kibana/connectors-kibana/thehive-action-type): Create cases and alerts in TheHive.
  - [Tines](https://www.elastic.co/docs/reference/kibana/connectors-kibana/tines-action-type): Send events to a Tines Story.
  - [Torq](https://www.elastic.co/docs/reference/kibana/connectors-kibana/torq-action-type): Trigger a Torq workflow.
  - [Webhook](https://www.elastic.co/docs/reference/kibana/connectors-kibana/webhook-action-type): Send a request to a web service.
  - [Webhook - Case Management](https://www.elastic.co/docs/reference/kibana/connectors-kibana/cases-webhook-action-type): Send a request to a Case Management web service.
  - [xMatters](https://www.elastic.co/docs/reference/kibana/connectors-kibana/xmatters-action-type): Send actionable alerts to on-call xMatters resources.
</dropdown>

<note>
  Some connector types are paid commercial features, while others are free. For a comparison of the Elastic subscription levels, go to [the subscription page](https://www.elastic.co/subscriptions).
</note>


## Find available connectors

In **Stack Management > Connectors**, you can find a list of the connectors in the current space. You can use the search bar to find specific connectors by name and type. The **Type** dropdown also enables you to filter to a subset of connector types.
![Filtering the connector list by types of connectors](https://www.elastic.co/docs/reference/kibana/images/connector-filter-by-type.png)

You can delete individual connectors using the trash icon. Alternatively, select multiple connectors and delete them in bulk using the **Delete** button.
![Deleting connectors individually or in bulk](https://www.elastic.co/docs/reference/kibana/images/connector-delete.png)

<note>
  You can delete a connector even if there are still actions referencing it. When this happens the action will fail to run and errors appear in the Kibana logs.
</note>


## Creating a new connector

New connectors can be created with the **Create connector** button, which guides you to select the type of connector and configure its properties.
![Connector select type](https://www.elastic.co/docs/reference/kibana/images/connector-select-type.png)

After you create a connector, it is available for use any time you set up an action in the current space.
For out-of-the-box and standardized connectors, refer to [preconfigured connectors](https://www.elastic.co/docs/reference/kibana/connectors-kibana/pre-configured-connectors).
<tip>
  You can also manage connectors as resources with the [Elasticstack provider](https://registry.terraform.io/providers/elastic/elasticstack/latest) for Terraform. For more details, refer to the [elasticstack_kibana_action_connector](https://registry.terraform.io/providers/elastic/elasticstack/latest/docs/resources/kibana_action_connector) resource.
</tip>


## Managing connectors

Rules use connectors to route actions to different destinations like log files, ticketing systems, and messaging tools. While each Kibana app can offer their own types of rules, they typically share connectors. **Stack Management > Connectors** offers a central place to view and manage all the connectors in the current space.
![Example connector listing in the Rules UI](https://www.elastic.co/docs/reference/kibana/images/connector-listing.png)


## Preconfigured connectors

If you are running Kibana on-prem, you can preconfigure a connector to have all the information it needs prior to startup by adding it to the kibana.yml file. Refer to [preconfigured connectors](https://www.elastic.co/docs/reference/kibana/connectors-kibana/pre-configured-connectors) for more information.

## Connector networking configuration

Use the [action configuration settings](/docs/reference/kibana/configuration-reference/alerting-settings#action-settings) to customize connector networking configurations, such as proxies, certificates, or TLS settings. You can set configurations that apply to all your connectors or use `xpack.actions.customHostSettings` to set per-host configurations.

## Importing and exporting connectors

To import and export connectors, use the [Saved Objects Management UI](https://www.elastic.co/docs/explore-analyze/find-and-organize/saved-objects).
![Connectors import banner](https://www.elastic.co/docs/reference/kibana/images/connectors-import-banner.png)

If a connector is missing sensitive information after the import, a **Fix** button appears in **Connectors**.
![Connectors with missing secrets](https://www.elastic.co/docs/reference/kibana/images/connectors-with-missing-secrets.png)


## Monitoring connectors

The [Task Manager health API](https://www.elastic.co/docs/deploy-manage/monitor/kibana-task-manager-health-monitoring) helps you understand the performance of all tasks in your environment. However, if connectors fail to run, they will report as successful to Task Manager. The failure stats will not accurately depict the performance of connectors.
For more information on connector successes and failures, refer to the [Event log index](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/event-log-index).