﻿---
title: URL drilldown settings in Kibana
description: Configure the URL drilldown settings in your kibana.yml configuration file. 
url: https://www.elastic.co/docs/reference/kibana/configuration-reference/url-drilldown-settings
products:
  - Kibana
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# URL drilldown settings in Kibana
Configure the URL drilldown settings in your `kibana.yml` configuration file.
<definitions>
  <definition term="externalUrl.policy">
    Configures the external URL policies. URL drilldowns respect the global **External URL** service, which you can use to deny or allow external URLs. By default all external URLs are allowed.
    For example, to allow only external URLs to the `example.com` domain with the `https` scheme, except for the `danger.example.com` sub-domain, which is denied even when `https` scheme is used:
    ```yaml
    externalUrl.policy:
      - allow: false
        host: danger.example.com
      - allow: true
        host: example.com
        protocol: https
    ```
  </definition>
</definitions>