﻿---
title: Telemetry settings in Kibana
description: Usage Collection (also known as Telemetry) is enabled by default. This allows us to learn what our users are most interested in, so we can improve our...
url: https://www.elastic.co/docs/reference/kibana/configuration-reference/telemetry-settings
products:
  - Kibana
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Telemetry settings in Kibana
Usage Collection (also known as Telemetry) is enabled by default. This allows us to learn what our users are most interested in, so we can improve our products and services.
Refer to our [Privacy Statement](https://www.elastic.co/legal/product-privacy-statement) to learn more.
You can control whether this data is sent from the Kibana servers, or if it should be sent from the user’s browser, in case a firewall is blocking the connections from the server. Additionally, you can disable this feature either in **Stack Management > Kibana > Advanced Settings > Global Settings > Usage collection** or the config file with the following settings.

## General telemetry settings

<definitions>
  <definition term="telemetry.optIn">
    Set to `false` to stop sending any telemetry data to Elastic. Reporting your cluster statistics helps us improve your user experience. **Default: `true`.**
    This setting can be changed at any time in [Advanced Settings](https://www.elastic.co/docs/reference/kibana/advanced-settings). To prevent users from changing it, set [`telemetry.allowChangingOptInStatus`](/docs/reference/kibana/configuration-reference/general-settings#telemetry-allowChangingOptInStatus) to `false`.
  </definition>
  <definition term="telemetry.allowChangingOptInStatus">
    Set to `false` to disallow overwriting the [`telemetry.optIn`](#telemetry-optIn) setting via the [Advanced Settings](https://www.elastic.co/docs/reference/kibana/advanced-settings) in Kibana. **Default: `true`.**
  </definition>
  <definition term="telemetry.sendUsageFrom">
    Set to `'server'` to report the cluster statistics from the Kibana server. If the server fails to connect to our endpoint at [[https://telemetry.elastic.co/](https://telemetry.elastic.co/)](https://telemetry.elastic.co/), it assumes it is behind a firewall and falls back to `'browser'` to send it from users' browsers when they are navigating through Kibana. **Default: `'server'`.**
  </definition>
  <definition term="xpack.apm.telemetryCollectionEnabled">
    Collects information about APM data and API performance. Set this to `false` to specifically disable APM’s collector. **Default: `'true'`.**
  </definition>
</definitions>