﻿---
title: Spaces settings in Kibana
description: By default, spaces is enabled in Kibana. To secure spaces, enable security. 
url: https://www.elastic.co/docs/reference/kibana/configuration-reference/spaces-settings
products:
  - Kibana
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Spaces settings in Kibana
By default, spaces is enabled in Kibana. To secure spaces, [enable security](https://www.elastic.co/docs/reference/kibana/configuration-reference/security-settings).
<definitions>
  <definition term="xpack.spaces.maxSpaces">
    The maximum number of spaces that you can use with the Kibana instance. Some Kibana operations return all spaces using a single `_search` from Elasticsearch, so you must configure this setting lower than the `index.max_result_window` in Elasticsearch. The default is `1000`.
  </definition>
  <definition term="xpack.spaces.defaultSolution Elastic Stack: Generally available since 9.1">
    Sets the solution view for your default space.
  </definition>
</definitions>