﻿---
title: Security settings in Kibana
description: You do not need to configure any additional settings to use the security features in Kibana. They are enabled by default. You configure authentication...
url: https://www.elastic.co/docs/reference/kibana/configuration-reference/security-settings
products:
  - Kibana
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Security settings in Kibana
You do not need to configure any additional settings to use the security features in Kibana. They are enabled by default.
<important>
  In high-availability deployments, make sure you use the same security settings for all instances of Kibana. Also consider storing sensitive security settings, such as encryption and decryption keys, securely in the Kibana keystore, instead of keeping them in clear text in the `kibana.yml` file.
</important>

<note>
  If a setting is applicable to Elastic Cloud Hosted environments, its name is followed by this icon: ![logo cloud](https://doc-icons.s3.us-east-2.amazonaws.com/logo_cloud.svg "Supported on Elastic Cloud Hosted")
</note>


### Authentication security settings

You configure authentication settings in the `xpack.security.authc` namespace.
For example:
```yaml
xpack.security.authc:
    providers:
      basic.basic1: 
          order: 0 
          ...

      saml.saml1: 
          order: 1
          ...

      saml.saml2: 
          order: 2
          ...

      pki.realm3:
          order: 3
          ...
    ...
```


### Valid settings for all authentication providers

The valid settings in the `xpack.security.authc.providers` namespace vary depending on the authentication provider type. For more information, refer to [Authentication](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/user-authentication).
<definitions>
  <definition term="xpack.security.authc.providers...enabled logo cloud">
    Determines if the authentication provider should be enabled. By default, Kibana enables the provider as soon as you configure any of its properties.
  </definition>
  <definition term="xpack.security.authc.providers...order logo cloud">
    Order of the provider in the authentication chain and on the Login Selector UI.
  </definition>
  <definition term="xpack.security.authc.providers...description logo cloud">
    Custom description of the provider entry displayed on the Login Selector UI.
  </definition>
  <definition term="xpack.security.authc.providers...hint logo cloud">
    Custom hint for the provider entry displayed on the Login Selector UI.
  </definition>
  <definition term="xpack.security.authc.providers...icon logo cloud">
    Custom icon for the provider entry displayed on the Login Selector UI.
  </definition>
  <definition term="xpack.security.authc.providers...origin Elastic Stack: Generally available since 9.3 logo cloud">
    Specifies the origin(s) where the provider will appear to users in the Login Selector UI. Each origin must be a valid URI only containing an origin. By default, providers are not restricted to specific origins.
    For example:
    ```yaml
    xpack.security.authc:
      providers:
        basic.basic1:
          origin: [http://localhost:5601, http://127.0.0.1:5601]
          ...
        saml.saml1:
          origin: https://elastic.co
          ...
    ```
  </definition>
  <definition term="xpack.security.authc.providers...showInSelector logo cloud">
    Flag that indicates if the provider should have an entry on the Login Selector UI. Setting this to `false` doesn’t remove the provider from the authentication chain.
    <note>
      You are unable to set this setting to `false` for `basic` and `token` authentication providers.
    </note>
  </definition>
  <definition term="xpack.security.authc.providers...accessAgreement.message logo cloud">
    Access agreement text in Markdown format. For more information, refer to [Access agreement](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/access-agreement).
  </definition>
  <definition term="xpack.security.authc.providers...session.idleTimeout logo cloud">
    Ensures that user sessions will expire after a period of inactivity. Setting this to `0` will prevent sessions from expiring because of inactivity. By default, this setting is equal to [`xpack.security.session.idleTimeout`](#xpack-session-idleTimeout).
    <note>
      Use a string of `<count>[ms\|s\|m\|h\|d\|w\|M\|Y]` (e.g. *20m*, *24h*, *7d*, *1w*).
    </note>
  </definition>
  <definition term="xpack.security.authc.providers.<provider-type>.<provider-name>.session.lifespan logo cloud">
    Ensures that user sessions will expire after the defined time period. This behavior is also known as an "absolute timeout". If this is set to `0`, user sessions could stay active indefinitely. By default, this setting is equal to [`xpack.security.session.lifespan`](#xpack-session-lifespan).
    <note>
      Use a string of `<count>[ms\|s\|m\|h\|d\|w\|M\|Y]` (e.g. *20m*, *24h*, *7d*, *1w*).
    </note>
  </definition>
</definitions>


### SAML authentication provider settings

In addition to [the settings that are valid for all providers](#authentication-provider-settings), you can specify the following settings:
<definitions>
  <definition term="xpack.security.authc.providers.saml.<provider-name>.realm logo cloud">
    SAML realm in Elasticsearch that provider should use.
  </definition>
  <definition term="xpack.security.authc.providers.saml.<provider-name>.maxRedirectURLSize logo cloud">
    Specifies the maximum size of the URL that Kibana is allowed to store during the SAML handshake.
  </definition>
  <definition term="xpack.security.authc.providers.saml..useRelayStateDeepLink logo cloud">
    Determines if the provider should treat the `RelayState` parameter as a deep link in Kibana during Identity Provider initiated log in. By default, this setting is set to `false`. The link specified in `RelayState` should be a relative, URL-encoded Kibana URL. For example, the `/app/dashboards#/list` link in `RelayState` parameter would look like this: `RelayState=%2Fapp%2Fdashboards%23%2Flist`.
  </definition>
  <definition term="xpack.security.authc.saml.maxRedirectURLSize logo cloud">
    Specifies the maximum size of the URL that Kibana is allowed to store during the SAML handshake.
  </definition>
</definitions>


#### Discontinued SAML settings

<applies-to>
  - Elastic Cloud Hosted: Removed in 8.0
</applies-to>

The following settings are available in Elastic Cloud for all supported versions before 8.0:
<definitions>
  <definition term="xpack.security.authProviders logo cloud">
    Set to `saml` to instruct Kibana to use SAML SSO as the authentication method.
  </definition>
  <definition term="xpack.security.public.protocol logo cloud">
    Set to HTTP or HTTPS. To access Kibana, HTTPS protocol is recommended.
  </definition>
  <definition term="xpack.security.public.hostname logo cloud">
    Set to a fully qualified hostname to connect your users to the proxy server.
  </definition>
  <definition term="xpack.security.public.port logo cloud">
    The port number that connects your users to the proxy server (for example, 80 for HTTP or 443 for HTTPS).
  </definition>
  <definition term="xpack.security.authc.saml.useRelayStateDeepLink logo cloud">
    Specifies if Kibana should treat the `RelayState` parameter as a deep link when Identity Provider Initiated login flow is used.
  </definition>
  <definition term="server.xsrf.whitelist logo cloud">
    Explicitly allows the SAML authentication URL within Kibana, so that the Kibana server doesn't reject external authentication messages that originate from your Identity Provider. This setting is renamed to `server.xsrf.allowlist` in version 8.0.0.
  </definition>
</definitions>


### OpenID Connect authentication provider settings

In addition to [the settings that are valid for all providers](#authentication-provider-settings), you can specify the following settings:
<definitions>
  <definition term="xpack.security.authc.providers.oidc..realm logo cloud">
    OpenID Connect realm in Elasticsearch that the provider should use.
  </definition>
</definitions>


### Anonymous authentication provider settings

In addition to [the settings that are valid for all providers](#authentication-provider-settings), you can specify the following settings:
<note>
  You can configure only one anonymous provider per Kibana instance.
</note>

<definitions>
  <definition term="xpack.security.authc.providers.anonymous..credentials logo cloud">
    Credentials that Kibana should use internally to authenticate anonymous requests to Elasticsearch.
    For example:
    ```yaml
    xpack.security.authc.providers.anonymous.anonymous1:
      credentials:
        username: "anonymous_service_account"
        password: "anonymous_service_account_password"
    ```
  </definition>
</definitions>

For more information, refer to [Anonymous authentication](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-authentication#anonymous-authentication).

### HTTP authentication settings

There is a very limited set of cases when you’d want to change these settings. For more information, refer to [HTTP authentication](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-authentication#http-authentication).
<definitions>
  <definition term="xpack.security.authc.http.enabled">
    Determines if HTTP authentication should be enabled. By default, this setting is set to `true`.
  </definition>
  <definition term="xpack.security.authc.http.autoSchemesEnabled">
    Determines if HTTP authentication schemes used by the enabled authentication providers should be automatically supported during HTTP authentication. By default, this setting is set to `true`.
  </definition>
  <definition term="xpack.security.authc.http.schemes[]">
    List of HTTP authentication schemes that Kibana HTTP authentication should support. By default, this setting is set to `['apikey', 'bearer']` to support HTTP authentication with the [`ApiKey`](https://www.elastic.co/docs/deploy-manage/api-keys/elasticsearch-api-keys) and [`Bearer`](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-authentication#http-authentication) schemes.
  </definition>
</definitions>


### Login user interface settings

<definitions>
  <definition term="xpack.security.loginAssistanceMessage logo cloud">
    Adds a message to the login UI. Useful for displaying information about maintenance windows, links to corporate sign up pages, and so on.
  </definition>
  <definition term="xpack.security.loginHelp logo cloud">
    Adds a message accessible at the login UI with additional help information for the login process.
  </definition>
  <definition term="xpack.security.authc.selector.enabled logo cloud">
    Determines if the login selector UI should be enabled. By default, this setting is set to `true` if more than one authentication provider is configured.
  </definition>
</definitions>


### Configure a default access agreement

<definitions>
  <definition term="xpack.security.accessAgreement.message logo cloud">
    This setting specifies the access agreement text in Markdown format that will be used as the default access agreement for all providers that do not specify a value for `xpack.security.authc.providers.<provider-type>.<provider-name>.accessAgreement.message`. For more information, refer to [Access agreement](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/access-agreement).
  </definition>
</definitions>


### Session and cookie security settings

<definitions>
  <definition term="xpack.security.cookieName">
    Sets the name of the cookie used for the session. The default value is `"sid"`.
  </definition>
  <definition term="xpack.security.encryptionKey">
    An arbitrary string of 32 characters or more that is used to encrypt session information. Do **not** expose this key to users of Kibana. By default, a value is automatically generated in memory. If you use that default behavior, all sessions are invalidated when Kibana restarts. In addition, high-availability deployments of Kibana will behave unexpectedly if this setting isn’t the same for all instances of Kibana.
  </definition>
  <definition term="xpack.security.secureCookies">
    Sets the `secure` flag of the session cookie. The default value is `false`. It is automatically set to `true` if [`server.ssl.enabled`](/docs/reference/kibana/configuration-reference/general-settings#server-ssl-enabled) is set to `true`. Set this to `true` if SSL is configured outside of Kibana (for example, you are routing requests through a load balancer or proxy).
  </definition>
  <definition term="xpack.security.sameSiteCookies logo cloud">
    Sets the `SameSite` attribute of the session cookie. This allows you to declare whether your cookie should be restricted to a first-party or same-site context. Valid values are `Strict`, `Lax`, `None`. This is **not set** by default, which modern browsers will treat as `Lax`. If you use Kibana embedded in an iframe in modern browsers, you might need to set it to `None`. Setting this value to `None` requires cookies to be sent over a secure connection by setting [`xpack.security.secureCookies`](#xpack-security-secureCookies): `true`.
  </definition>
  <definition term="xpack.security.session.idleTimeout logo cloud">
    Ensures that user sessions will expire after a period of inactivity. This and [`xpack.security.session.lifespan`](#xpack-session-lifespan) are both highly recommended. You can also specify this setting for [every provider separately](#xpack-security-provider-session-idleTimeout). If this is set to `0`, then sessions will never expire due to inactivity. By default, this value is 3 days.
    <note>
      Use a string of `<count>[ms\|s\|m\|h\|d\|w\|M\|Y]` (e.g. *20m*, *24h*, *7d*, *1w*).
    </note>
  </definition>
  <definition term="xpack.security.session.lifespan logo cloud">
    Ensures that user sessions will expire after the defined time period. This behavior is also known as an "absolute timeout". If this is set to `0`, user sessions could stay active indefinitely. This and [`xpack.security.session.idleTimeout`](#xpack-session-idleTimeout) are both highly recommended. You can also specify this setting for [every provider separately](#xpack-security-provider-session-lifespan). By default, this value is 30 days for on-prem installations, and 24 hours for Elastic Cloud installations.
    <tip>
      Use a string of `<count>[ms\|s\|m\|h\|d\|w\|M\|Y]` (e.g. *20m*, *24h*, *7d*, *1w*).
    </tip>
  </definition>
  <definition term="xpack.security.session.cleanupInterval logo cloud">
    Sets the interval at which Kibana tries to remove expired and invalid sessions from the session index. By default, this value is 1 hour. The minimum value is 10 seconds.
    <tip>
      Use a string of `<count>[ms\|s\|m\|h\|d\|w\|M\|Y]` (e.g. *20m*, *24h*, *7d*, *1w*).
    </tip>
  </definition>
  <definition term="xpack.security.session.concurrentSessions.maxSessions logo cloud">
    Set the maximum number of sessions each user is allowed to have active at any given time. By default, no limit is applied. If set, the value of this option should be an integer between `1` and `1000`. When the limit is exceeded, the oldest session is automatically invalidated.
    It is available in Elastic Cloud 8.7.0 and later versions.
  </definition>
</definitions>


## Encrypted saved objects settings

These settings control the encryption of saved objects with sensitive data. For more details, refer to [Secure saved objects](https://www.elastic.co/docs/deploy-manage/security/secure-saved-objects).
<definitions>
  <definition term="xpack.encryptedSavedObjects.encryptionKey">
    An arbitrary string of at least 32 characters that is used to encrypt sensitive properties of saved objects before they’re stored in Elasticsearch. If not set, Kibana will generate a random key on startup, but certain features won’t be available until you set the encryption key explicitly.
  </definition>
  <definition term="xpack.encryptedSavedObjects.keyRotation.decryptionOnlyKeys">
    An optional list of previously used encryption keys. Like [`xpack.encryptedSavedObjects.encryptionKey`](#xpack-encryptedSavedObjects-encryptionKey), these must be at least 32 characters in length. Kibana doesn’t use these keys for encryption, but may still require them to decrypt some existing saved objects. Use this setting if you wish to change your encryption key, but don’t want to lose access to saved objects that were previously encrypted with a different key.
  </definition>
</definitions>


### Audit logging settings

You can enable audit logging to support compliance, accountability, and security. When enabled, Kibana will capture:
- Who performed an action
- What action was performed
- When the action occurred

For more details and a reference of audit events, refer to [Audit logs](https://www.elastic.co/docs/reference/kibana/kibana-audit-events).
<definitions>
  <definition term="xpack.security.audit.enabled logo cloud">
    Set to `true` to enable audit logging. **Default:** `false`
    For example:
    ```yaml
    xpack.security.audit.enabled: true
    xpack.security.audit.appender: 
      type: rolling-file
      fileName: ./logs/audit.log
      policy:
        type: time-interval
        interval: 24h 
      strategy:
        type: numeric
        max: 10 
      layout:
        type: json
    ```
  </definition>
  <definition term="xpack.security.audit.appender">
    Optional. Specifies where audit logs should be written to and how they should be formatted. If no appender is specified, a default appender will be used (see above).
  </definition>
  <definition term="xpack.security.audit.appender.type">
    Required. Specifies where audit logs should be written to. Allowed values are `console`, `file`, or `rolling-file`.
    Refer to [file appender](#audit-logging-file-appender) and [rolling file appender](#audit-logging-rolling-file-appender) for appender specific settings.
  </definition>
  <definition term="xpack.security.audit.appender.layout.type">
    Required. Specifies how audit logs should be formatted. Allowed values are `json` or `pattern`.
    Refer to [pattern layout](#audit-logging-pattern-layout) for layout specific settings.
    <tip>
      We recommend using `json` format to allow ingesting Kibana audit logs into Elasticsearch using Filebeat.
    </tip>
  </definition>
</definitions>


### File appender

The `file` appender writes to a file and can be configured using the following settings:
<definitions>
  <definition term="xpack.security.audit.appender.fileName">
    Required. Full file path the log file should be written to.
  </definition>
</definitions>


### Rolling file appender

The `rolling-file` appender writes to a file and rotates it using a rolling strategy, when a particular policy is triggered:
<definitions>
  <definition term="xpack.security.audit.appender.fileName">
    Required. Full file path the log file should be written to.
  </definition>
  <definition term="xpack.security.audit.appender.policy.type">
    Specifies when a rollover should occur. Allowed values are `size-limit` and `time-interval`. **Default:** `time-interval`.
    Refer to [size limit policy](#audit-logging-size-limit-policy) and [time interval policy](#audit-logging-time-interval-policy) for policy specific settings.
  </definition>
  <definition term="xpack.security.audit.appender.strategy.type">
    Specifies how the rollover should occur. Only allowed value is currently `numeric`. **Default:** `numeric`
    Refer to [numeric strategy](#audit-logging-numeric-strategy) for strategy specific settings.
  </definition>
</definitions>


### Size limit triggering policy

The `size-limit` triggering policy will rotate the file when it reaches a certain size:
<definitions>
  <definition term="xpack.security.audit.appender.policy.size">
    Maximum size the log file should reach before a rollover should be performed. **Default:** `100mb`
  </definition>
</definitions>


### Time interval triggering policy

The `time-interval` triggering policy will rotate the file every given interval of time:
<definitions>
  <definition term="xpack.security.audit.appender.policy.interval">
    How often a rollover should occur. **Default:** `24h`
  </definition>
  <definition term="xpack.security.audit.appender.policy.modulate">
    Whether the interval should be adjusted to cause the next rollover to occur on the interval boundary. **Default:** `true`
  </definition>
</definitions>


### Numeric rolling strategy

The `numeric` rolling strategy will suffix the log file with a given pattern when rolling over, and will retain a fixed number of rolled files:
<definitions>
  <definition term="xpack.security.audit.appender.strategy.pattern">
    Suffix to append to the file name when rolling over. Must include `%i`. **Default:** `-%i`
  </definition>
  <definition term="xpack.security.audit.appender.strategy.max">
    Maximum number of files to keep. Once this number is reached, oldest files will be deleted. **Default:** `7`
  </definition>
</definitions>


### Pattern layout

The `pattern` layout outputs a string, formatted using a pattern with special placeholders, which will be replaced with data from the actual log message:
<definitions>
  <definition term="xpack.security.audit.appender.layout.pattern">
    Optional. Specifies how the log line should be formatted. **Default:** `[%date][%level][%logger]%meta %message`
  </definition>
  <definition term="xpack.security.audit.appender.layout.highlight">
    Optional. Set to `true` to enable highlighting log messages with colors.
  </definition>
</definitions>


### Ignore filters

<definitions>
  <definition term="xpack.security.audit.ignore_filters[] logo cloud">
    List of filters that determine which events should be excluded from the audit log. An event will get filtered out if at least one of the provided filters matches.
    For example:
    ```yaml
    xpack.security.audit.ignore_filters:
    - actions: [http_request] 
    - categories: [database]
      types: [creation, change, deletion] 
    - spaces: [default] 
    - users: [elastic, kibana_system] 
    ```
  </definition>
  <definition term="xpack.security.audit.ignore_filters[].actions[] logo cloud">
    List of values matched against the `event.action` field of an audit event. Refer to [Audit logs](https://www.elastic.co/docs/reference/kibana/kibana-audit-events) for a list of available events.
  </definition>
  <definition term="xpack.security.audit.ignore_filters[].categories[] logo cloud">
    List of values matched against the `event.category` field of an audit event. Refer to [ECS categorization field](https://www.elastic.co/docs/reference/ecs/ecs-allowed-values-event-category) for allowed values.
  </definition>
  <definition term="xpack.security.audit.ignore_filters[].outcomes[] logo cloud">
    List of values matched against the `event.outcome` field of an audit event. Refer to [ECS outcome field](https://www.elastic.co/docs/reference/ecs/ecs-allowed-values-event-outcome) for allowed values.
  </definition>
  <definition term="xpack.security.audit.ignore_filters[].spaces[] logo cloud">
    List of values matched against the `kibana.space_id` field of an audit event. This represents the space id in which the event took place.
  </definition>
  <definition term="xpack.security.audit.ignore_filters[].types[] logo cloud">
    List of values matched against the `event.type` field of an audit event. Refer to [ECS type field](https://www.elastic.co/docs/reference/ecs/ecs-allowed-values-event-type) for allowed values.
  </definition>
  <definition term="xpack.security.audit.ignore_filters[].users[] logo cloud">
    List of values matched against the `user.name` field of an audit event. This represents the `username` associated with the audit event.
  </definition>
</definitions>