﻿---
title: Background search and search sessions settings in Kibana
description: 
url: https://www.elastic.co/docs/reference/kibana/configuration-reference/search-sessions-settings
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Stack: Preview since 9.2
---

# Background search and search sessions settings in Kibana
<important>
  [Background search](https://www.elastic.co/docs/explore-analyze/discover/background-search) is a feature introduced in version 9.2. It replaces the **Search sessions** feature, deprecated in version 8.15.
</important>

<note>
  If a setting is applicable to Elastic Cloud Hosted environments, its name is followed by this icon: ![logo cloud](https://doc-icons.s3.us-east-2.amazonaws.com/logo_cloud.svg "Supported on Elastic Cloud Hosted")
</note>

<applies-switch>
  <applies-item title="stack: ga 9.2+" applies-to="Elastic Stack: Generally available since 9.2">
    <definitions>
      <definition term="data.search.sessions.enabled logo cloud">
        `false` by default. Set to `true` to enable background searches.
      </definition>
      <definition term="data.search.sessions.maxUpdateRetries logo cloud">
        How many retries Kibana can perform while attempting to send a search to the background. The default is `10`.
      </definition>
      <definition term="data.search.sessions.defaultExpiration logo cloud">
        How long background search results are stored before they expire and are deleted. When users extend the validity period of the background search, this setting also determines by how long. The default is `7d`.
      </definition>
    </definitions>
  </applies-item>

  <applies-item title="stack: ga 9.0-9.1" applies-to="Elastic Stack: Generally available from 9.0 to 9.1">
    <definitions>
      <definition term="data.search.sessions.enabled logo cloud">
        Deprecated in 8.15.0. `false` by default. Set to `true` to enable search sessions.
      </definition>
      <definition term="data.search.sessions.notTouchedTimeout logo cloud">
        Deprecated in 8.15.0. How long Kibana stores search results from unsaved sessions, after the last search in the session completes. The default is `5m`.
      </definition>
      <definition term="data.search.sessions.maxUpdateRetries logo cloud">
        Deprecated in 8.15.0. How many retries Kibana can perform while attempting to save a search session. The default is `10`.
      </definition>
      <definition term="data.search.sessions.defaultExpiration logo cloud">
        Deprecated in 8.15.0. How long search session results are stored before they are deleted. Extending a search session resets the expiration by the same value. The default is `7d`.
      </definition>
    </definitions>
  </applies-item>
</applies-switch>