﻿---
title: Monitoring settings in Kibana
description: By default, Stack Monitoring is enabled, but data collection is disabled. When you first start Kibana monitoring, you are prompted to enable data collection...
url: https://www.elastic.co/docs/reference/kibana/configuration-reference/monitoring-settings
products:
  - Kibana
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Monitoring settings in Kibana
By default, **Stack Monitoring** is enabled, but data collection is disabled. When you first start Kibana monitoring, you are prompted to enable data collection. If you are using Elastic Stack security features, you must be signed in as a user with the `cluster:manage` privilege to enable data collection. The built-in `superuser` role has this privilege and the built-in `elastic` user has this role.
You can adjust how monitoring data is collected from Kibana and displayed in Kibana by configuring settings in the `kibana.yml` file. There are also `monitoring.ui.elasticsearch.*` settings, which support the same values as [Kibana configuration settings](https://www.elastic.co/docs/reference/kibana/configuration-reference/general-settings).
To control how data is collected from your Elasticsearch nodes, you configure [`xpack.monitoring.collection` settings](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/monitoring-settings) in `elasticsearch.yml`. To control how monitoring data is collected from Logstash, configure monitoring settings in `logstash.yml`.
For more information, check out [Monitor a cluster](https://www.elastic.co/docs/deploy-manage/monitor).
<note>
  If a setting is applicable to Elastic Cloud Hosted environments, its name is followed by this icon: ![logo cloud](https://doc-icons.s3.us-east-2.amazonaws.com/logo_cloud.svg "Supported on Elastic Cloud Hosted")
</note>


## General monitoring settings

<definitions>
  <definition term="monitoring.cluster_alerts.email_notifications.enabled">
    Deprecated in 7.11. When enabled, sends email notifications for Watcher alerts to the specified email address. The default is `true`.
  </definition>
  <definition term="monitoring.cluster_alerts.email_notifications.email_address logo cloud">
    Deprecated in 7.11. When enabled, specifies the email address where you want to receive cluster alert notifications.
  </definition>
  <definition term="monitoring.ui.ccs.enabled">
    Set to `true` (default) to enable [cross-cluster search](https://www.elastic.co/docs/solutions/explore-analyze/cross-cluster-search) of your monitoring data. The [`remote_cluster_client`](https://www.elastic.co/docs/reference/elasticsearch/configuration-reference/remote-clusters) role must exist on each node.
  </definition>
  <definition term="monitoring.ui.elasticsearch.hosts">
    Specifies the location of the Elasticsearch cluster where your monitoring data is stored.
    By default, this is the same as [`elasticsearch.hosts`](/docs/reference/kibana/configuration-reference/general-settings#elasticsearch-hosts). This setting enables you to use a single Kibana instance to search and visualize data in your production cluster as well as monitor data sent to a dedicated monitoring cluster.
  </definition>
  <definition term="monitoring.ui.elasticsearch.username">
    Specifies the username used by Kibana monitoring to establish a persistent connection in Kibana to the Elasticsearch monitoring cluster and to verify licensing status on the Elasticsearch monitoring cluster when using `monitoring.ui.elasticsearch.hosts`.
    All other requests performed by **Stack Monitoring** to the monitoring Elasticsearch cluster uses the authenticated user’s credentials, which must be the same on both the Elasticsearch monitoring cluster and the Elasticsearch production cluster.
    If not set, Kibana uses the value of the [`elasticsearch.username`](/docs/reference/kibana/configuration-reference/general-settings#elasticsearch-user-passwd) setting.
  </definition>
  <definition term="monitoring.ui.elasticsearch.password">
    Specifies the password used by Kibana monitoring to establish a persistent connection in Kibana  to the Elasticsearch monitoring cluster and to verify licensing status on the Elasticsearch monitoring cluster when using `monitoring.ui.elasticsearch.hosts`.
    All other requests performed by **Stack Monitoring** to the monitoring Elasticsearch cluster use the authenticated user’s credentials, which must be the same on both the Elasticsearch monitoring cluster and the Elasticsearch production cluster.
    If not set, Kibana uses the value of the [`elasticsearch.password`](/docs/reference/kibana/configuration-reference/general-settings#elasticsearch-user-passwd) setting.
  </definition>
  <definition term="monitoring.ui.elasticsearch.serviceAccountToken">
    Specifies a [service account token](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-create-service-token) for the Elasticsearch cluster where your monitoring data is stored when using `monitoring.ui.elasticsearch.hosts`.  This setting is an alternative to using `monitoring.ui.elasticsearch.username` and `monitoring.ui.elasticsearch.password`.
  </definition>
  <definition term="monitoring.ui.elasticsearch.pingTimeout">
    Specifies the time in milliseconds to wait for Elasticsearch to respond to internal health checks. By default, it matches the [`elasticsearch.pingTimeout`](/docs/reference/kibana/configuration-reference/general-settings#elasticsearch-pingTimeout) setting, which has a default value of `30000`.
  </definition>
  <definition term="monitoring.ui.elasticsearch.ssl">
    Shares the same configuration as [`elasticsearch.ssl`](/docs/reference/kibana/configuration-reference/general-settings#elasticsearch-ssl-cert-key). These settings configure encrypted communication between Kibana and the monitoring cluster.
  </definition>
</definitions>


## Monitoring collection settings

These settings control how data is collected from Kibana.
<definitions>
  <definition term="monitoring.kibana.collection.enabled">
    Set to `true` (default) to enable data collection from the Kibana NodeJS server for Kibana dashboards to be featured in **Stack Monitoring**.
  </definition>
  <definition term="monitoring.kibana.collection.interval logo cloud">
    Specifies the number of milliseconds to wait in between data sampling on the Kibana NodeJS server for the metrics that are displayed in the Kibana dashboards. Defaults to `10000` (10 seconds).
  </definition>
</definitions>


## Monitoring UI settings

These settings adjust how **Stack Monitoring** displays monitoring data. However, the defaults work best in most circumstances. For more information about configuring Kibana, see [Setting Kibana server properties](https://www.elastic.co/docs/reference/kibana/configuration-reference/general-settings).
<definitions>
  <definition term="monitoring.ui.elasticsearch.logFetchCount">
    Specifies the number of log entries to display in **Stack Monitoring**. Defaults to `10`. The maximum value is `50`.
  </definition>
  <definition term="monitoring.ui.enabled">
    Set to `false` to hide **Stack Monitoring**. The monitoring back-end continues to run as an agent for sending Kibana stats to the monitoring cluster. Defaults to `true`.
  </definition>
  <definition term="monitoring.ui.logs.index">
    Specifies the name of the indices that are shown on the [**Logs**](https://www.elastic.co/docs/deploy-manage/monitor/monitoring-data/elasticsearch-metrics#logs-monitor-page) page in **Stack Monitoring**. The default value is `filebeat-*`.
  </definition>
  <definition term="monitoring.ui.metricbeat.index">
    <admonition title="Deprecated in 8.15.0">
      This setting was deprecated in 8.15.0.
    </admonition>
    Used as a workaround to avoid querying `metricbeat-*` indices which are now no longer queried. The default value is `metricbeat-*`.
  </definition>
  <definition term="monitoring.ui.max_bucket_size">
    Specifies the number of term buckets to return out of the overall terms list when performing terms aggregations to retrieve index and node metrics. For more information about the `size` parameter, see [Terms Aggregation](https://www.elastic.co/docs/reference/aggregations/search-aggregations-bucket-terms-aggregation#search-aggregations-bucket-terms-aggregation-size). Defaults to `10000`.
  </definition>
  <definition term="monitoring.ui.min_interval_seconds logo cloud">
    Specifies the minimum number of seconds that a time bucket in a chart can represent. Defaults to 10. If you modify the `monitoring.ui.collection.interval` in `elasticsearch.yml`, use the same value in this setting.
  </definition>
  <definition term="monitoring.ui.kibana.reporting.stale_status_threshold_seconds">
    Specifies how many seconds can pass before the Kibana status reports are considered stale. Defaults to `120`.
  </definition>
</definitions>


### Monitoring UI container settings

**Stack Monitoring** exposes the Cgroup statistics that we collect for you to make better decisions about your container performance, rather than guessing based on the overall machine performance. If you are not running your applications in a container, then Cgroup statistics are not useful.
<definitions>
  <definition term="monitoring.ui.container.elasticsearch.enabled logo cloud">
    For Elasticsearch clusters that are running in containers, this setting changes the **Node Listing** to display the CPU utilization based on the reported Cgroup statistics. It also adds the calculated Cgroup CPU utilization to the **Node Overview** page instead of the overall operating system’s CPU utilization. Defaults to `false`.
  </definition>
  <definition term="monitoring.ui.container.logstash.enabled">
    For Logstash nodes that are running in containers, this setting changes the Logstash **Node Listing** to display the CPU utilization based on the reported Cgroup statistics. It also adds the calculated Cgroup CPU utilization to the Logstash node detail pages instead of the overall operating system’s CPU utilization. Defaults to `false`.
  </definition>
</definitions>