﻿---
title: Map settings in Kibana
description: 
url: https://www.elastic.co/docs/reference/kibana/configuration-reference/map-settings
products:
  - Elastic Cloud Hosted
  - Kibana
applies_to:
  - Elastic Cloud Hosted: Generally available
---

# Map settings in Kibana
<definitions>
  <definition term="map.regionmap logo cloud">
    Specifies additional vector layers for use in [Region Map](https://www.elastic.co/docs/explore-analyze/visualize/maps/maps-getting-started) visualizations. Each layer object points to an external vector file that contains a geojson FeatureCollection. The file must use the [WGS84 coordinate reference system](https://en.wikipedia.org/wiki/World_Geodetic_System) and only include polygons. If the file is hosted on a separate domain from Kibana, the server needs to be CORS-enabled so Kibana can download the file. The following example shows a valid regionmap configuration.
    ```yaml
    map.regionmap:
      includeElasticMapsService: false
      layers:
        - name: "Departments of France"
          url: "<MY_CORS_ENABLED_SERVER_URL>/france_departements.geojson"
          attribution:   "INRAP"
          fields:
            - name: "department"
              description: "Full department name"
            - name: "INSEE"
              description: "INSEE numeric identifier"
    ```
  </definition>
  <definition term="map.regionmap.includeElasticMapsService logo cloud">
    Turns on or off whether layers from the Elastic Maps Service should be included in the vector layer option list. Supported on Elastic Cloud Enterprise. By turning this off, only the layers that are configured here will be included. The default is `true`.
  </definition>
  <definition term="map.regionmap.layers[].attribution logo cloud">
    Optional. References the originating source of the geojson file.
  </definition>
  <definition term="map.regionmap.layers[].fields[] logo cloud">
    Mandatory. Each layer can contain multiple fields to indicate what properties from the geojson features you wish to expose. The previous example shows how to define multiple properties.
  </definition>
  <definition term="map.regionmap.layers[].fields[].description logo cloud">
    Mandatory. The human readable text that is shown under the Options tab when building the Region Map visualization.
  </definition>
  <definition term="map.regionmap.layers[].fields[].name logo cloud">
    Mandatory. This value is used to do an inner-join between the document stored in Elasticsearch and the geojson file. For example, if the field in the geojson is called `Location` and has city names, there must be a field in Elasticsearch that holds the same values that Kibana can then use to lookup for the geoshape data.
  </definition>
  <definition term="map.regionmap.layers[].name logo cloud">
    Mandatory. A description of the map being provided.
  </definition>
  <definition term="map.regionmap.layers[].url logo cloud">
    Mandatory. The location of the geojson file as provided by a webserver.
  </definition>
  <definition term="tilemap.options.attribution logo cloud">
    Adds the map attribution string.
  </definition>
  <definition term="tilemap.options.maxZoom logo cloud">
    Sets the maximum zoom level.
  </definition>
  <definition term="tilemap.options.minZoom logo cloud">
    Sets the minimum zoom level.
  </definition>
  <definition term="tilemap.options.subdomains logo cloud">
    Provides an array of subdomains used by the tile service. Specify the position of the subdomain the URL with the token `{{s}}`.
  </definition>
  <definition term="tilemap.url logo cloud">
    Lists the URL to the tileservice that Kibana uses to display map tiles in tilemap visualizations.
  </definition>
</definitions>