﻿---
title: Fleet settings in Kibana
description: By default, Fleet is enabled. To use Fleet, you also need to configure Kibana and Elasticsearch hosts. Many Fleet settings can also be configured directly...
url: https://www.elastic.co/docs/reference/kibana/configuration-reference/fleet-settings
products:
  - Kibana
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Fleet settings in Kibana
<note>
  In Elastic Cloud, Fleet flags are already configured.
  If a setting is applicable to Elastic Cloud Hosted environments, its name is followed by this icon: ![logo cloud](https://doc-icons.s3.us-east-2.amazonaws.com/logo_cloud.svg "Supported on Elastic Cloud Hosted")
</note>

By default, Fleet is enabled. To use Fleet, you also need to configure Kibana and Elasticsearch hosts.
Many Fleet settings can also be configured directly through the Fleet UI. See [Fleet UI settings](https://www.elastic.co/docs/reference/fleet/fleet-settings) for details.
Go to the [Fleet](https://www.elastic.co/docs/reference/fleet) docs for more information about Fleet.

## General Fleet settings

<definitions>
  <definition term="xpack.fleet.agents.enabled logo cloud">
    Set to `true` (default) to enable Fleet.
  </definition>
  <definition term="xpack.fleet.isAirGapped">
    Set to `true` to indicate Fleet is running in an air-gapped environment. Refer to [Air-gapped environments](https://www.elastic.co/docs/reference/fleet/air-gapped) for details. Enabling this flag helps Fleet skip needless requests and improve the user experience for air-gapped environments.
  </definition>
  <definition term="xpack.fleet.createArtifactsBulkBatchSize logo cloud">
    Allow to configure batch size for creating and updating Fleet user artifacts.  Examples include creation of Trusted Applications and Endpoint Exceptions in Security. It is available in Elastic Cloud 8.9.0 and later versions.
  </definition>
</definitions>


## Elastic Package Manager settings

<definitions>
  <definition term="xpack.fleet.registryUrl">
    The address to use to reach the Elastic Package Manager registry.
  </definition>
  <definition term="xpack.fleet.registryProxyUrl">
    The proxy address to use to reach the Elastic Package Manager registry if an internet connection is not directly available. Refer to [Air-gapped environments](https://www.elastic.co/docs/reference/fleet/air-gapped) for details.
  </definition>
  <definition term="xpack.fleet.packageVerification.gpgKeyPath">
    The path on disk to the GPG key used to verify Elastic Package Manager packages. If the Elastic public key is ever reissued as a security precaution, you can use this setting to specify the new key.
  </definition>
</definitions>


## Fleet settings

<definitions>
  <definition term="xpack.fleet.agents.fleet_server.hosts">
    Hostnames used by Elastic Agent for accessing Fleet Server.
    If configured in your `kibana.yml`, this setting is grayed out and unavailable in the Fleet UI. To make this setting editable in the UI, do not configure it in the configuration file.
  </definition>
  <definition term="xpack.fleet.agents.elasticsearch.hosts">
    Hostnames used by Elastic Agent for accessing Elasticsearch.
  </definition>
  <definition term="xpack.fleet.agents.elasticsearch.ca_sha256">
    Hash pin used for certificate verification. The pin is a base64-encoded string of the SHA-256 fingerprint.
  </definition>
</definitions>


## Preconfiguration settings (for advanced use cases)

Use these settings to pre-define integrations, agent policies, and Fleet Server hosts or proxies that you want Fleet to load up by default.
<note>
  These settings are not supported to pre-configure the Endpoint and Cloud Security integration.
</note>

<definitions>
  <definition term="xpack.fleet.packages">
    List of integrations that are installed when the Fleet app starts up for the first time.
    **Required properties of `xpack.fleet.packages`**:
    <definitions>
      <definition term="name">
        Name of the integration from the package registry.
      </definition>
      <definition term="version">
        Either an exact semantic version, or the keyword `latest` to fetch the latest integration version.
      </definition>
    </definitions>
  </definition>
  <definition term="xpack.fleet.agentPolicies">
    List of agent policies that are configured when the Fleet app starts.
    **Required properties of `xpack.fleet.agentPolicies`**:
    <definitions>
      <definition term="id">
        Unique ID for this policy. The ID may be a number or string.
      </definition>
      <definition term="name">
        Policy name.
      </definition>
    </definitions>
    **Optional properties of `xpack.fleet.agentPolicies`**:
    <definitions>
      <definition term="description">
        Text description of this policy.
      </definition>
      <definition term="namespace">
        String identifying this policy’s namespace.
      </definition>
      <definition term="monitoring_enabled">
        List of keywords that specify the monitoring data to collect. Valid values include `['logs']`, `['metrics']`, and `['logs', 'metrics']`.
      </definition>
      <definition term="keep_monitoring_alive">
        If `true`, monitoring will be enabled, but logs/metrics collection will be disabled. Use this if you want to keep agent’s monitoring server alive even when logs/metrics aren’t being collected.
      </definition>
      <definition term="is_managed">
        If `true`, this policy is not editable by the user and can only be changed by updating the Kibana config.
      </definition>
      <definition term="is_default Elastic Stack: Deprecated since 8.1">
        If `true`, this policy is the default agent policy.
      </definition>
      <definition term="is_default_fleet_server Elastic Stack: Deprecated since 8.1">
        If `true`, this policy is the default Fleet Server agent policy.
      </definition>
      <definition term="data_output_id">
        ID of the output to send data. (Need to be identical to `monitoring_output_id`)
      </definition>
      <definition term="monitoring_output_id">
        ID of the output to send monitoring data. (Need to be identical to `data_output_id`)
      </definition>
      <definition term="fleet_server_host_id">
        ID of the fleet server.
      </definition>
      <definition term="package_policies">
        List of integration policies to add to this policy.
      </definition>
    </definitions>
    **Properties of `package_policies`**:
    `id`
    :   Unique ID of the integration policy. The ID may be a number or string.
    `name`
    :   (required) Name of the integration policy.
    `package`
    :   (required) Integration that this policy configures.
    **Properties of `package`**:
    `name`
    :   Name of the integration associated with this policy.
    `description`
    :   Text string describing this integration policy.
    `namespace`
    :   String identifying this policy’s namespace.
    `inputs`
    :   Map of input for the integration. Follows the same schema as the package policy API inputs, with the exception that any object in `vars` can be passed `frozen: true` in order to prevent that specific `var` from being edited by the user.
    Example configuration:
    ```yaml
    xpack.fleet.packages:
      - name: apache
        version: 0.5.0
    xpack.fleet.agentPolicies:
      - name: Preconfigured Policy
        id: preconfigured-policy
        namespace: test
        package_policies:
          - package:
              name: system
            name: System Integration
            namespace: test
            id: preconfigured-system
            inputs:
              system-system/metrics:
                enabled: true
                vars:
                  '[system.hostfs]': home/test
                streams:
                  '[system.core]':
                    enabled: true
                    vars:
                      period: 20s
              system-winlog:
                enabled: false
    ```
  </definition>
  <definition term="xpack.fleet.outputs">
    List of outputs that are configured when the Fleet app starts.
    Certain types of outputs have additional required and optional settings. Refer to [Output settings](https://www.elastic.co/docs/reference/fleet/fleet-settings#output-settings) in the Fleet and Elastic Agent Guide for the full list of settings for each output type.
    If configured in your `kibana.yml`, output settings are grayed out and unavailable in the Fleet UI. To make these settings editable in the UI, do not configure them in the configuration file.
    <note>
      The `xpack.fleet.outputs` settings are intended for advanced configurations such as having multiple outputs. We recommend not enabling the `xpack.fleet.agents.elasticsearch.host` settings when using `xpack.fleet.outputs`.
    </note>
    **Required properties of `xpack.fleet.outputs`**:
    <definitions>
      <definition term="id">
        Unique ID for this output. The ID should be a string.
      </definition>
      <definition term="name">
        Output name.
      </definition>
      <definition term="type">
        Type of Output. Currently we support "elasticsearch", "logstash", "kafka", and "remote_elasticsearch".
      </definition>
      <definition term="hosts">
        Array that contains the list of host for that output.
      </definition>
    </definitions>
    **Optional properties of `xpack.fleet.outputs`**:
    <definitions>
      <definition term="is_default">
        If `true`, the output specified in `xpack.fleet.outputs` will be the one used to send agent data unless there is another one configured specifically for the agent policy.
      </definition>
      <definition term="is_default_monitoring">
        If `true`, the output specified in `xpack.fleet.outputs` will be the one used to send agent monitoring data unless there is another one configured specifically for the agent policy.
      </definition>
      <definition term="is_internal">
        If `true`, the output specified in `xpack.fleet.outputs` will not appear in the UI, and can only be managed via `kibana.yml` or the Fleet API.
      </definition>
      <definition term="config">
        Extra config for that output.
      </definition>
      <definition term="proxy_id">
        Unique ID of a proxy to access the output.
      </definition>
      <definition term="ssl">
        Set to enable authentication using the Secure Sockets Layer (SSL) protocol.
      </definition>
    </definitions>
    **Properties of `ssl`**:
    `certificate`
    :   The SSL certificate that Elastic Agents use to authenticate with the output. Include the full contents of the certificate here.
    <definitions>
      <definition term="secrets">
        Include here any values for preconfigured outputs that should be stored as secrets. A secret value is replaced in the `kibana.yml` settings file with a reference, with the original value stored externally as a secure hash. Note that this type of secret storage requires all configured Fleet Servers to be on version 8.12.0 or later.
      </definition>
    </definitions>
    **Properties of `secrets`**
    `key`:
    :   The private certificate key that Elastic Agents use to authenticate with the output.
    Example `xpack.fleet.outputs` configuration:
    ```yaml
    xpack.fleet.outputs:
      - id: my-logstash-output-with-a-secret
        name: preconfigured logstash output with a secret
        type:  logstash
        hosts: ["localhost:9999"]
        ssl:
          certificate: xxxxxxxxxx
        secrets:
          ssl:
            key: securekey
    ```
  </definition>
  <definition term="xpack.fleet.fleetServerHosts">
    List of Fleet Server hosts that are configured when the Fleet app starts.
    **Required properties of `xpack.fleet.fleetServerHosts`**
    <definitions>
      <definition term="id">
        Unique ID for the host server.
      </definition>
      <definition term="name">
        Name of the host server.
      </definition>
      <definition term="host_urls">
        Array of one or more host URLs that Elastic Agents will use to connect to Fleet Server.
      </definition>
    </definitions>
    **Optional properties of `xpack.fleet.fleetServerHosts`**:
    <definitions>
      <definition term="is_default">
        Whether or not this host should be the default to use for Fleet Server.
      </definition>
      <definition term="is_internal">
        If `true` the host will not appear in the UI, and can only be managed through `kibana.yml` or the Fleet API.
      </definition>
      <definition term="proxy_id">
        Unique ID of the proxy to access the Fleet Server host.
      </definition>
    </definitions>
  </definition>
  <definition term="xpack.fleet.proxy">
    List of proxies to access Fleet Server that are configured when the Fleet app starts.
    **Required properties of `xpack.fleet.proxy`**:
    <definitions>
      <definition term="id">
        Unique ID of the proxy to access the Fleet Server host.
      </definition>
      <definition term="name">
        Name of the proxy to access the Fleet Server host.
      </definition>
      <definition term="url">
        URL that Elastic Agents use to connect to the proxy to access Fleet Server.
      </definition>
    </definitions>
    **Optional properties of `xpack.fleet.proxy`**:
    <definitions>
      <definition term="proxy_headers">
        Map of headers to use with the proxy. .Properties of `proxy_headers`
      </definition>
    </definitions>
    `key`
    :   Key to use for the proxy header.
    `value`
    :   Value to use for the proxy header.
    <definitions>
      <definition term="certificate_authorities">
        Certificate authority (CA) used to issue the certificate.
      </definition>
      <definition term="certificate">
        The name of the certificate used to authenticate the proxy.
      </definition>
      <definition term="certificate_key">
        The certificate key used to authenticate the proxy.
      </definition>
    </definitions>
  </definition>
  <definition term="xpack.fleet.enableExperimental logo cloud Elastic Stack: Deprecated since 9.3">
    List of experimental feature flag to enable in Fleet.
    It is available in Elastic Cloud 8.6.0 and later versions.
    From 9.3.0 onwards, use `xpack.fleet.experimentalFeatures` to explicitly enable or disable experimental features.
  </definition>
  <definition term="xpack.fleet.experimentalFeatures logo cloud Elastic Stack: Generally available since 9.3">
    Set experimental feature flags to `true` or `false` to enable or disable them, respectively.
    Example configuration:
    ```yaml
    xpack.fleet.experimentalFeatures:
      useSpaceAwareness: false
      enableAgentPrivilegeLevelChange: true
    ```
    <note>
      Experimental features should not be enabled in production environments. The features in this section are experimental and may be changed or removed completely in future releases. Elastic will make a best effort to fix any issues, but experimental features are not supported to the same level as generally available (GA) features.
    </note>
  </definition>
  <definition term="xpack.fleet.enableManagedLogsAndMetricsDataviews logo cloud">
    Set to `true` (default), to enable the automatic creation of global `logs-*` and `metrics-*` data views.
  </definition>
  <definition term="xpack.fleet.autoUpgrades.taskInterval logo cloud Elastic Stack: Generally available since 9.1">
    Configure the interval of the automatic upgrade task for Fleet-managed Elastic Agents. Defaults to `30m`.
  </definition>
  <definition term="xpack.fleet.autoUpgrades.retryDelays logo cloud Elastic Stack: Generally available since 9.1">
    Configure the retry delays of the automatic upgrade task for Fleet-managed Elastic Agents. The array's length indicates the maximum number of retries. Defaults to `['30m', '1h', '2h', '4h', '8h', '16h', '24h']`.
  </definition>
  <definition term="xpack.fleet.integrationRollbackTTL logo cloud Elastic Stack: Generally available since 9.3">
    Configure the time-to-live (TTL) for integration rollback availability. This setting controls how long the rollback option remains available after an integration is upgraded. The value must be specified in a duration format (for example, `7d`, `14d`, `168h`, or `1w`). Defaults to `7d` (7 days). For more information, refer to [Roll back an integration](https://www.elastic.co/docs/reference/fleet/roll-back-integration).
  </definition>
</definitions>

`xpack.fleet.fleetPolicyRevisionsCleanup.max_revisions` ![logo cloud](https://doc-icons.s3.us-east-2.amazonaws.com/logo_cloud.svg "Supported on Elastic Cloud Hosted") <applies-to>Elastic Stack: Generally available since 9.1</applies-to>
: The maximum number of revisions to maintain for a Fleet agent policy. Defaults to `10`.
`xpack.fleet.fleetPolicyRevisionsCleanup.interval` ![logo cloud](https://doc-icons.s3.us-east-2.amazonaws.com/logo_cloud.svg "Supported on Elastic Cloud Hosted") <applies-to>Elastic Stack: Generally available since 9.1</applies-to>
: The time interval for performing cleanups of Fleet agent policy revisions. The value must be specified in a duration format (for example, `30m`, `1h`, `1d`). Defaults to `1h` (1 hour).
`xpack.fleet.fleetPolicyRevisionsCleanup.max_policies_per_run` ![logo cloud](https://doc-icons.s3.us-east-2.amazonaws.com/logo_cloud.svg "Supported on Elastic Cloud Hosted") <applies-to>Elastic Stack: Generally available since 9.1</applies-to>
: The maximum number of Fleet agent policies to clean up revisions from per interval. Defaults to `100`.