﻿---
title: Banner settings in Kibana
description: Banners are disabled by default. You need to manually configure them in order to use the feature. You can configure the xpack.banners settings in your...
url: https://www.elastic.co/docs/reference/kibana/configuration-reference/banner-settings
products:
  - Kibana
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Banner settings in Kibana
Banners are disabled by default. You need to manually configure them in order to use the feature.
You can configure the `xpack.banners` settings in your `kibana.yml` file.
<note>
  Banners are a [subscription feature](https://www.elastic.co/subscriptions).
</note>

<definitions>
  <definition term="xpack.banners.placement">
    Set to `top` to display a banner above the Elastic header. Defaults to `disabled`.
  </definition>
  <definition term="xpack.banners.textContent">
    The text to display inside the banner, either plain text or Markdown.
  </definition>
  <definition term="xpack.banners.textColor">
    The color for the banner text. Defaults to `#8A6A0A`.
  </definition>
  <definition term="xpack.banners.linkColor Elastic Stack: Generally available since 9.1">
    The color for the banner link text. Defaults to `#0B64DD`.
  </definition>
  <definition term="xpack.banners.backgroundColor">
    The color of the banner background. Defaults to `#FFF9E8`.
  </definition>
  <definition term="xpack.banners.disableSpaceBanners">
    If true, per-space banner overrides will be disabled. Defaults to `false`.
  </definition>
</definitions>