﻿---
title: APM settings in Kibana
description: These settings allow the APM app to function, and specify the data that it surfaces. Unless you’ve customized your setup, you do not need to configure...
url: https://www.elastic.co/docs/reference/kibana/configuration-reference/apm-settings
products:
  - Kibana
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Self-managed Elastic deployments: Generally available
---

# APM settings in Kibana
These settings allow the APM app to function, and specify the data that it surfaces. Unless you’ve customized your setup, you do not need to configure any settings to use the APM app. It is enabled by default.
<note>
  If a setting is applicable to Elastic Cloud Hosted environments, its name is followed by this icon: ![logo cloud](https://doc-icons.s3.us-east-2.amazonaws.com/logo_cloud.svg "Supported on Elastic Cloud Hosted")
</note>


## APM indices

The APM app uses data views to query APM indices. To change the default APM indices that the APM app queries, open the APM app and select **Settings** > **Indices**. Index settings in the APM app take precedence over those set in `kibana.yml`.
APM indices are Kibana space-aware; changes to APM index settings will only apply to the currently enabled space.

## General APM settings

If you’d like to change any of the default values, copy and paste the relevant settings into your `kibana.yml` configuration file. Changing these settings may disable features of the APM App.
<tip>
  More settings are available in the [Observability advanced settings](/docs/reference/kibana/advanced-settings#observability-advanced-settings).
</tip>

<definitions>
  <definition term="xpack.apm.maxSuggestions logo cloud">
    Maximum number of suggestions fetched in autocomplete selection boxes. Defaults to `100`.
  </definition>
  <definition term="xpack.apm.serviceMapFingerprintBucketSize logo cloud">
    Maximum number of unique transaction combinations sampled for generating service map focused on a specific service. Defaults to `100`.
  </definition>
  <definition term="xpack.apm.serviceMapFingerprintGlobalBucketSize logo cloud">
    Maximum number of unique transaction combinations sampled for generating the global service map. Defaults to `100`.
  </definition>
  <definition term="xpack.apm.serviceMapEnabled logo cloud">
    Set to `false` to disable service maps. Defaults to `true`.
  </definition>
  <definition term="xpack.apm.serviceMapTraceIdBucketSize logo cloud">
    Maximum number of trace IDs sampled for generating service map focused on a specific service. Defaults to `65`.
  </definition>
  <definition term="xpack.apm.serviceMapTraceIdGlobalBucketSize logo cloud">
    Maximum number of trace IDs sampled for generating the global service map. Defaults to `6`.
  </definition>
  <definition term="xpack.apm.serviceMapMaxTracesPerRequest logo cloud">
    Maximum number of traces per request for generating the global service map. Defaults to `50`.
  </definition>
  <definition term="xpack.apm.ui.enabled logo cloud">
    Set to `false` to hide the APM app from the main menu. Defaults to `true`.
  </definition>
  <definition term="xpack.apm.ui.maxTraceItems logo cloud">
    Maximum number of child items displayed when viewing trace details. Defaults to `5000`.
  </definition>
  <definition term="xpack.observability.annotations.index logo cloud">
    Index name where Observability annotations are stored. Defaults to `observability-annotations`.
  </definition>
  <definition term="xpack.apm.metricsInterval logo cloud">
    Sets a `fixed_interval` for date histograms in metrics aggregations. Defaults to `30`.
  </definition>
  <definition term="xpack.apm.agent.migrations.enabled logo cloud">
    Set to `false` to disable cloud APM migrations. Defaults to `true`.
  </definition>
  <definition term="xpack.apm.indices.error logo cloud">
    Matcher for all error indices. Defaults to `logs-apm*,apm-*,traces-*.otel-*`.
  </definition>
  <definition term="xpack.apm.indices.onboarding logo cloud">
    Matcher for all onboarding indices. Defaults to `apm-*`.
  </definition>
  <definition term="xpack.apm.indices.span logo cloud">
    Matcher for all span indices. Defaults to `traces-apm*,apm-*,traces-*.otel-*`.
  </definition>
  <definition term="xpack.apm.indices.transaction logo cloud">
    Matcher for all transaction indices. Defaults to `traces-apm*,apm-*,traces-*.otel-*`.
  </definition>
  <definition term="xpack.apm.indices.metric logo cloud">
    Matcher for all metrics indices. Defaults to `metrics-apm*,apm-*,metrics-*.otel-*`.
  </definition>
  <definition term="xpack.apm.indices.sourcemap logo cloud">
    Matcher for all source map indices. Defaults to `apm-*`.
  </definition>
  <definition term="xpack.apm.autoCreateApmDataView logo cloud">
    Set to `false` to disable the automatic creation of the APM data view when the APM app is opened. Defaults to `true`.
  </definition>
  <definition term="xpack.apm.latestAgentVersionsUrl logo cloud">
    Specifies the URL of a self hosted file that contains latest agent versions. Defaults to `https://apm-agent-versions.elastic.co/versions.json`. Set to `''` to disable requesting latest agent versions.
  </definition>
</definitions>