﻿---
title: Alerting and action settings in Kibana
description: Alerting and actions are enabled by default in Kibana, but require you to configure the following: Set up Kibana to work with Elastic Stack security features.Set...
url: https://www.elastic.co/docs/reference/kibana/configuration-reference/alerting-settings
products:
  - Kibana
applies_to:
  - Elastic Cloud Hosted: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Alerting and action settings in Kibana
Alerting and actions are enabled by default in Kibana, but require you to configure the following:
1. [Set up Kibana to work with Elastic Stack security features](https://www.elastic.co/docs/deploy-manage/security/secure-your-cluster-deployment).
2. [Set up TLS encryption between Kibana and Elasticsearch](https://www.elastic.co/docs/deploy-manage/security/set-up-basic-security-plus-https#encrypt-kibana-http).
3. If you are using an **on-premises** Elastic Stack deployment, [specify a value for `xpack.encryptedSavedObjects.encryptionKey`](#general-alert-action-settings).

<note>
  If a setting is applicable to Elastic Cloud Hosted environments, its name is followed by this icon: ![logo cloud](https://doc-icons.s3.us-east-2.amazonaws.com/logo_cloud.svg "Supported on Elastic Cloud Hosted")
</note>


## General settings

<definitions>
  <definition term="xpack.encryptedSavedObjects.encryptionKey">
    A string of 32 or more characters used to encrypt sensitive properties on alerting rules and actions before they’re stored in Elasticsearch. Third party credentials — such as the username and password used to connect to an SMTP service — are an example of encrypted properties.
    Kibana offers a [CLI tool](https://www.elastic.co/docs/reference/kibana/commands/kibana-encryption-keys) to help generate this encryption key.
    If not set, Kibana will generate a random key on startup, but all alerting and action functions will be blocked. Generated keys are not allowed for alerting and actions because when a new key is generated on restart, existing encrypted data becomes inaccessible. For the same reason, alerting and actions in high-availability deployments of Kibana will behave unexpectedly if the key isn’t the same on all instances of Kibana.
    Although the key can be specified in clear text in `kibana.yml`, it’s recommended to store this key securely in the [Kibana Keystore](https://www.elastic.co/docs/deploy-manage/security/secure-settings). Be sure to back up the encryption key value somewhere safe, as your alerting rules and actions will cease to function due to decryption failures should you lose it.  If you want to rotate the encryption key, be sure to follow the instructions on [encryption key rotation](https://www.elastic.co/docs/deploy-manage/security/secure-saved-objects#encryption-key-rotation).
    Data type: `string`
  </definition>
</definitions>


## Action settings

<definitions>
  <definition term="xpack.actions.allowedHosts logo cloud">
    A list of hostnames that Kibana is allowed to connect to when built-in actions are triggered. It defaults to `["*"]`, allowing any host, but keep in mind the potential for SSRF attacks when hosts are not explicitly added to the allowed hosts. An empty list `[]` can be used to block built-in actions from making any external connections.
    Note that hosts associated with built-in actions, such as Slack and PagerDuty, are not automatically added to allowed hosts. If you are not using the default `["*"]` setting, you must ensure that the corresponding endpoints are added to the allowed hosts as well.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.customHostSettings logo cloud">
    A list of custom host settings to override existing global settings.
    Each entry in the list must have a `url` property, to associate a connection type (mail or https), hostname and port with the remaining options in the entry.
    The settings in `xpack.actions.customHostSettings` can be used to override the global option `xpack.actions.ssl.verificationMode` and provide customized TLS settings on a per-server basis. Set `xpack.actions.ssl.verificationMode` to the value to be used by default for all servers, then add an entry in `xpack.actions.customHostSettings` for every server that requires customized settings.
    Data type: `string`
    Default: `an empty list`
    In the following example, two custom host settings are defined.  The first provides a custom host setting for mail server `mail.example.com` using port 465 that supplies server certificate authentication data from both a file and inline, and requires TLS for the connection.  The second provides a custom host setting for https server `webhook.example.com` which turns off server certificate authentication, that will allow Kibana to connect to the server if it’s using a self-signed certificate.  The individual properties that can be used in the settings are documented below.
    ```yaml
    xpack.actions.customHostSettings:
      - url: smtp://mail.example.com:465
        ssl:
          verificationMode: 'full'
          certificateAuthoritiesFiles: [ 'one.crt' ]
          certificateAuthoritiesData: |
              -----BEGIN CERTIFICATE-----
              MIIDTD...
              CwUAMD...
              ... multiple lines of certificate data ...
              -----END CERTIFICATE-----
        smtp:
          requireTLS: true
      - url: <EXAMPLE_WEBHOOK_URL>
        ssl:
          verificationMode: 'none'
    ```
  </definition>
  <definition term="xpack.actions.customHostSettings[n].url logo cloud">
    A URL associated with this custom host setting.  Should be in the form of `protocol://hostname:port`, where `protocol` is `https` or `smtp`.  If the port is not provided, 443 is used for `https` and 25 is used for `smtp`.  The `smtp` URLs are used for the Email actions that use this server, and the `https` URLs are used for actions which use `https` to connect to services.
    Entries with `https` URLs can use the `ssl` options, and entries with `smtp` URLs can use both the `ssl` and `smtp` options.
    No other URL values should be part of this URL, including paths, query strings, and authentication information.  When an http or smtp request is made as part of running an action, only the protocol, hostname, and port of the URL for that request are used to look up these configuration values.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.customHostSettings[n].smtp.ignoreTLS logo cloud">
    A boolean value indicating that TLS must not be used for this connection. The options `smtp.ignoreTLS` and `smtp.requireTLS` can not both be set to true.
    Data type: `bool`
    Default: `false`
  </definition>
  <definition term="xpack.actions.customHostSettings[n].smtp.requireTLS logo cloud">
    A boolean value indicating that TLS must be used for this connection. The options `smtp.ignoreTLS` and `smtp.requireTLS` can not both be set to true.
    Data type: `bool`
    Default: `false`
  </definition>
</definitions>


<definitions>
  <definition term="xpack.actions.customHostSettings[n].ssl.verificationMode logo cloud">
    Controls the verification of the server certificate that Kibana receives when making an outbound SSL/TLS connection to the host server. Valid values are `full`, `certificate`, and `none`. Use `full` to perform hostname verification, `certificate` to skip hostname verification, and `none` to skip verification. Default: `full`. [Equivalent Kibana setting](/docs/reference/kibana/configuration-reference/general-settings#elasticsearch-ssl-verificationMode). Overrides the general `xpack.actions.ssl.verificationMode` configuration for requests made for this hostname/port.
    Data type: `enum`
    Options:
    - `full`
    - `certificate`
    - `none`
    Default: `full`
  </definition>
  <definition term="xpack.actions.customHostSettings[n].ssl.certificateAuthoritiesFiles">
    A file name or list of file names of PEM-encoded certificate files to use to validate the server.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.customHostSettings[n].ssl.certificateAuthoritiesData logo cloud">
    The contents of one or more PEM-encoded certificate files in multiline format. This configuration can be used for environments where the files cannot be made available.
    Data type: `string`
  </definition>
</definitions>


<definitions>
  <definition term="xpack.actions.email.domain_allowlist logo cloud">
    A list of allowed email domains which can be used with the email connector. When this setting is not used, all email domains are allowed. When this setting is used, if any email is attempted to be sent that (a) includes an addressee with an email domain that is not in the allowlist, or (b) includes a from address domain that is not in the allowlist, it will fail with a message indicating the email is not allowed.
    <warning>
      This feature is available in Kibana 7.17.4 and 8.3.0 onwards but is not supported in Kibana 8.0, 8.1 or 8.2. As such, this setting should be removed before upgrading from 7.17 to 8.0, 8.1 or 8.2. It is possible to configure the settings in 7.17.4 and then upgrade to 8.3.0 directly.
    </warning>
    Data type: `string`
  </definition>
  <definition term="xpack.actions.email.recipient_allowlist logo cloud Elastic Stack: Generally available since 9.2">
    A list of allowed email recipient patterns (`to`, `cc`, or `bcc`) that can be used with email connectors. If you attempt to send an email to a recipient that does not match the allowed patterns, the action will fail. The failure message indicates that the email is not allowed.
    <warning>
      This setting cannot be used with `xpack.actions.email.domain_allowlist`.
    </warning>
    Data type: `string`
    For example:
    ```yaml
    xpack.actions.email.recipient_allowlist: ["admin-*@company.org", "sales-*@example.com"]
    ```
    Only "to", "cc", or "bcc" email addresses that match the listed patterns will be accepted. For example, "admin-network@company.org" or "sales-north@example.com".
  </definition>
  <definition term="xpack.actions.email.maximum_body_length logo cloud Elastic Stack: Generally available since 9.3">
    The maximum length of an email body in bytes.  Values longer than this length will be truncated.  The default is 25MB, the maximum is 25MB.
  </definition>
  <definition term="xpack.actions.email.services.ses.host logo cloud Elastic Stack: Generally available since 9.1">
    The SMTP endpoint for an Amazon Simple Email Service (SES) service provider that can be used by email connectors.
    <warning>
      This setting alone is insufficient for overriding system defaults for the SES SMTP endpoint. You must also configure the `xpack.actions.email.services.ses.port` setting
    </warning>
    Data type: `string`
    Default: `email-smtp.us-east-1.amazonaws.com`
  </definition>
  <definition term="xpack.actions.email.services.ses.port logo cloud Elastic Stack: Generally available since 9.1">
    The port number for an Amazon Simple Email Service (SES) service provider that can be used by email connectors.
    Data type: `int`
    Default: `465`
  </definition>
  <definition term="xpack.actions.email.services.enabled logo cloud Elastic Stack: Generally available since 9.1">
    An array of strings indicating all email services that are enabled. Available options are `elastic-cloud`, `google-mail`, `microsoft-outlook`, `amazon-ses`, `microsoft-exchange`, and `other`. If the array is empty, no email services are enabled. The default value is `["*"]`, which enables all email services.
    Data type: `string`
    Default: `["*"]`
  </definition>
  <definition term="xpack.actions.enableFooterInEmail logo cloud">
    A boolean value indicating that a footer with a relevant link should be added to emails sent as alerting actions.
    Data type: `bool`
    Default: `true`
  </definition>
  <definition term="xpack.actions.enabledActionTypes logo cloud">
    A list of action types that are enabled. It defaults to `["*"]`, enabling all types. The names for built-in Kibana action types are prefixed with a `.` and include: `.email`, `.index`, `.jira`, `.opsgenie`, `.pagerduty`, `.resilient`, `.server-log`, `.servicenow`, .`servicenow-itom`, `.servicenow-sir`, `.slack`, `.swimlane`, `.teams`, `.tines`, `.torq`, `.xmatters`,  `.gen-ai`,  `.bedrock`, `.gemini`,  `.d3security`, and `.webhook`. An empty list `[]` will disable all action types.
    Disabled action types will not appear as an option when creating new connectors, but existing connectors and actions of that type will remain in Kibana and will not function.
    <important>
      [Preconfigured connectors](https://www.elastic.co/docs/reference/kibana/connectors-kibana/pre-configured-connectors) are not affected by this setting.
    </important>
    Data type: `string`
    Default: `["*"]`
  </definition>
  <definition term="xpack.actions.microsoftExchangeUrl">
    The URL for the Microsoft Azure Active Directory endpoint to use for MS Exchange email authentication.
    Data type: `string`
    Default: `https://login.microsoftonline.com`
  </definition>
  <definition term="xpack.actions.microsoftGraphApiUrl">
    The URL for the Microsoft Graph API endpoint to use for MS Exchange email authentication.
    Data type: `string`
    Default: `https://graph.microsoft.com/v1.0`
  </definition>
  <definition term="xpack.actions.microsoftGraphApiScope">
    The URL for the Microsoft Graph API scope endpoint to use for MS Exchange email authentication.
    Data type: `string`
    Default: `https://graph.microsoft.com/.default`
  </definition>
  <definition term="xpack.actions.proxyUrl logo cloud">
    Specifies the proxy URL to use, if using a proxy for actions. By default, no proxy is used.
    Proxies may be used to proxy http or https requests through a proxy using the http or https protocol.  Kibana only uses proxies in "CONNECT" mode (sometimes referred to as "tunneling" TCP mode, compared to HTTP mode).  That is, Kibana will always make requests through a proxy using the HTTP `CONNECT` method.
    If your proxy is using the https protocol (vs the http protocol), the setting `xpack.actions.ssl.proxyVerificationMode: none` will likely be needed, unless your proxy’s certificates are signed using a publicly available certificate authority.
    There is currently no support for using basic authentication with a proxy (authentication for the proxy itself, not the URL being requested through the proxy).
    Data type: `string`
    To help diagnose problems using a proxy, you can use the `curl` command with options to use your proxy, and log debug information, with the following command, replacing the proxy and target URLs as appropriate.  This will force the request to be made to the proxy in tunneling mode, and display some of the interaction between the client and the proxy.
    ```sh
    curl --verbose --proxytunnel --proxy http://localhost:8080 <EXAMPLE_URL>
    ```
  </definition>
  <definition term="xpack.actions.proxyBypassHosts logo cloud">
    Specifies hostnames which should not use the proxy, if using a proxy for actions. The value is an array of hostnames as strings.
    By default, all hosts will use the proxy, but if an action’s hostname is in this list, the proxy will not be used.  The settings `xpack.actions.proxyBypassHosts` and `xpack.actions.proxyOnlyHosts` cannot be used at the same time.
    Data type: `string`
    For example:
    ```yaml
    xpack.actions.proxyBypassHosts: [ "events.pagerduty.com" ]
    ```
    If applicable, include the subdomain in the hostname
  </definition>
  <definition term="xpack.actions.proxyOnlyHosts logo cloud">
    Specifies hostnames which should only use the proxy, if using a proxy for actions. The value is an array of hostnames as strings.
    By default, no hosts will use the proxy, but if an action’s hostname is in this list, the proxy will be used.  The settings `xpack.actions.proxyBypassHosts` and `xpack.actions.proxyOnlyHosts` cannot be used at the same time.
    Data type: `string`
    For example:
    ```yaml
    xpack.actions.proxyOnlyHosts: [ "events.pagerduty.com" ]
    ```
    If applicable, include the subdomain in the hostname
  </definition>
  <definition term="xpack.actions.proxyHeaders logo cloud">
    Specifies HTTP headers for the proxy, if using a proxy for actions.
    Data type: `string`
    Default: `{}`
  </definition>
</definitions>


<definitions>
  <definition term="xpack.actions.ssl.proxyVerificationMode logo cloud">
    Controls the verification for the proxy server certificate that Kibana receives when making an outbound SSL/TLS connection to the proxy server.
    Use `full` to perform hostname verification, `certificate` to skip hostname verification, and `none` to skip verification.
    [Equivalent Kibana setting](/docs/reference/kibana/configuration-reference/general-settings#elasticsearch-ssl-verificationMode)
    Data type: `enum`
    Options:
    - `full`
    - `certificate`
    - `none`
    Default: `full`
  </definition>
</definitions>


<definitions>
  <definition term="xpack.actions.ssl.verificationMode logo cloud">
    Controls the verification for the server certificate that Elastic Maps Server receives when making an outbound SSL/TLS connection for actions. Valid values are `full`, `certificate`, and `none`. Use `full` to perform hostname verification, `certificate` to skip hostname verification, and `none` to skip verification.
    [Equivalent Kibana setting](/docs/reference/kibana/configuration-reference/general-settings#elasticsearch-ssl-verificationMode)
    This setting can be overridden for specific URLs by using the setting `xpack.actions.customHostSettings[n].ssl.verificationMode` (described above) to a different value.
    Data type: `enum`
    Options:
    - `full`
    - `certificate`
    - `none`
    Default: `full`
  </definition>
  <definition term="xpack.actions.maxResponseContentLength logo cloud">
    Specifies the max number of bytes of the http response for requests to external resources.
    Data type: `int`
    Default: `1000000 (1MB)`
  </definition>
  <definition term="xpack.actions.responseTimeout logo cloud">
    Specifies the time allowed for requests to external resources. Requests that take longer are canceled. The time is formatted as a number and a time unit (`ms`, `s`, `m`, `h`, `d`, `w`, `M`, or `Y`). For example, `20m`, `24h`, `7d`, `1w`. Default: `60s`.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.run.maxAttempts logo cloud">
    Specifies the maximum number of times an action can be attempted to run.
    Data type: `int`
    Options:
    - `minimum 1 and maximum 10`
  </definition>
  <definition term="xpack.actions.run.connectorTypeOverrides logo cloud">
    Overrides the configs under `xpack.actions.run` for the connector type with the given ID. List the connector type identifier and its settings in an array of objects.
    Data type: `string`
    For example:
    ```yaml
    xpack.actions.run:
        maxAttempts: 1
        connectorTypeOverrides:
            - id: '.server-log'
              maxAttempts: 5
    ```
  </definition>
  <definition term="xpack.actions.queued.max logo cloud">
    Specifies the maximum number of actions that can be queued.
    It is available in Elastic Cloud 8.11.0 and later versions.
    Data type: `int`
    Default: `1000000`
  </definition>
</definitions>


## Preconfigured connector settings

These settings vary depending on which type of preconfigured connector you’re adding.
For example:
```yaml
xpack.actions.preconfigured:
  my-server-log:
    name: preconfigured-server-log-connector-type
    actionTypeId: .server-log
```

For more examples, go to [Preconfigured connectors](https://www.elastic.co/docs/reference/kibana/connectors-kibana/pre-configured-connectors).
<definitions>
  <definition term="xpack.actions.preconfiguredAlertHistoryEsIndex logo cloud">
    Enables a preconfigured alert history Elasticsearch [Index](https://www.elastic.co/docs/reference/kibana/connectors-kibana/index-action-type) connector.
    Data type: `bool`
    Default: `false`
  </definition>
  <definition term="xpack.actions.preconfigured">
    Specifies configuration details that are specific to the type of preconfigured connector.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.actionTypeId">
    The type of preconfigured connector.
    Options:
    - `.email`
    - `.index`
    - `.opsgenie`
    - `.server-log`
    - `.resilient`
    - `.slack`
    - `.webhook`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config">
    The configuration details, which are specific to the type of preconfigured connector.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.apiProvider">
    For a [OpenAI connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/openai-action-type), specifies the OpenAI API provider.
    Data type: `enum`
    Options:
    - `OpenAI`
    - `Azure OpenAI`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.apiUrl">
    A configuration URL that varies by connector:
    - For an [Amazon Bedrock connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/bedrock-action-type), specifies the Amazon Bedrock request URL.
    - For an [Google Gemini connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/gemini-action-type), specifies the Google Gemini request URL.
    - For a [OpenAI connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/openai-action-type), specifies the OpenAI request URL.
    - For a [IBM Resilient connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/resilient-action-type), specifies the IBM Resilient instance URL.
    - For a [Jira connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/jira-action-type), specifies the Jira instance URL.
    - For an [Opsgenie connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/opsgenie-action-type), specifies the Opsgenie URL. For example, `https://api.opsgenie.com` or `https://api.eu.opsgenie.com`.
    - For a [PagerDuty connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/pagerduty-action-type), specifies the PagerDuty event URL. Defaults to `https://events.pagerduty.com/v2/enqueue`.
    - For a [ServiceNow ITSM](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-action-type), [ServiceNow SecOps](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-sir-action-type), or [ServiceNow ITOM connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-itom-action-type) specifies the ServiceNow instance URL.
    - For a [Swimlane connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/swimlane-action-type), specifies the Swimlane instance URL.
    <note>
      If you are using the `xpack.actions.allowedHosts` setting, make sure the hostname in the URL is added to the allowed hosts.
    </note>
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.appId">
    An application ID that varies by connector:
    - For a [Swimlane connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/swimlane-action-type), specifies a Swimlane application identifier.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.clientId">
    A client identifier that varies by connector:
    - For an [email connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/email-action-type), specifies a GUID format value that corresponds to the client ID, which is a part of OAuth 2.0 client credentials authentication.
    - For a [ServiceNow ITOM](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-itom-action-type), [ServiceNow ITSM](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-action-type), or [ServiceNow SecOps connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-sir-action-type) specifies the client identifier assigned to the OAuth application.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.configUrl">
    For an [xMatters connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/xmatters-action-type) with basic authentication, specifies the request URL for the Elastic Alerts trigger in xMatters.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.createCommentJson">
    For a [Webhook - Case Management connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/cases-webhook-action-type), specifies a stringified JSON payload with Mustache variables that is sent to the create comment URL to create a case comment. The required variable is `case.description`.
    <note>
      The JSON is validated after the Mustache variables have been placed when the REST method runs. You should manually ensure that the JSON is valid, disregarding the Mustache variables, so the later validation will pass.
    </note>
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.createCommentMethod">
    For a [Webhook - Case Management connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/cases-webhook-action-type), specifies the REST API HTTP request method to create a case comment in the third-party system.
    Data type: `string`
    Options:
    - `post`
    - `put`
    - `patch`
    Default: `put`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.createCommentUrl">
    For a [Webhook - Case Management connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/cases-webhook-action-type), specifies a REST API URL string to create a case comment by ID in the third-party system.
    <note>
      If you are using the `xpack.actions.allowedHosts` setting, make sure the hostname in the URL is added to the allowed hosts.
    </note>
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.createIncidentJson">
    For a [Webhook - Case Management connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/cases-webhook-action-type), specifies a stringified JSON payload with Mustache variables that is sent to the create case URL to create a case. Required variables are `case.title` and `case.description`.
    <note>
      The JSON is validated after the Mustache variables have been placed when the REST method runs. You should manually ensure that the JSON is valid, disregarding the Mustache variables, so the later validation will pass.
    </note>
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.createIncidentMethod">
    For a [Webhook - Case Management connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/cases-webhook-action-type), specifies the REST API HTTP request method to create a case in the third-party system
    Data type: `string`
    Options:
    - `post`
    - `put`
    - `patch`
    Default: `post`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.createIncidentUrl">
    For a [Webhook - Case Management connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/cases-webhook-action-type), specifies a REST API URL string to create a case in the third-party system.
    <note>
      If you are using the `xpack.actions.allowedHosts` setting, make sure the hostname in the URL is added to the allowed hosts.
    </note>
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.createIncidentResponseKey">
    For a [Webhook - Case Management connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/cases-webhook-action-type), specifies a string from the response body of the create case method that corresponds to the external service identifier.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.defaultModel">
    The default model to use for requests, which varies by connector:
    - For an [Amazon Bedrock connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/bedrock-action-type), current support is for the Anthropic Claude models.
      - <applies-to>Elastic Cloud Serverless: Generally available</applies-to> Defaults to `us.anthropic.claude-sonnet-4-5-20250929-v1:0`.
    - <applies-to>Elastic Stack: Generally available since 9.2</applies-to> Defaults to `us.anthropic.claude-sonnet-4-5-20250929-v1:0`.
    - <applies-to>Elastic Stack: Generally available in 9.1</applies-to> Defaults to `us.anthropic.claude-3-7-sonnet-20250219-v1:0`.
    - <applies-to>Elastic Stack: Generally available in 9.0</applies-to> Defaults to `anthropic.claude-3-5-sonnet-20240620-v1:0`.
    - For a [Google Gemini connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/gemini-action-type), current support is for the Gemini models.
      - <applies-to>Elastic Cloud Serverless: Generally available</applies-to> Defaults to `gemini-2.5-pro`.
    - <applies-to>Elastic Stack: Generally available since 9.1</applies-to> Defaults to `gemini-2.5-pro`.
    - <applies-to>Elastic Stack: Generally available in 9.0</applies-to> Defaults to `gemini-1.5-pro-002`.
    - For a [OpenAI connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/openai-action-type), it is optional and applicable only when `xpack.actions.preconfigured.<connector-id>.config.apiProvider` is `OpenAI`.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.executionTimeField">
    For an [index connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/index-action-type), a field that indicates when the document was indexed.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.from">
    For an [email connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/email-action-type), specifies the from address for all emails sent by the connector. It must be specified in `user@host-name` format.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.getIncidentResponseExternalTitleKey">
    For a [Webhook - Case Management connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/cases-webhook-action-type), specifies a string from the response body of the get case method that corresponds to the external service title.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.getIncidentUrl">
    For a [Webhook - Case Management connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/cases-webhook-action-type), specifies a REST API URL string with an external service ID Mustache variable to get the case from the third-party system.
    <note>
      If you are using the `xpack.actions.allowedHosts` setting, make sure the hostname in the URL is added to the allowed hosts.
    </note>
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.hasAuth">
    For an [email](https://www.elastic.co/docs/reference/kibana/connectors-kibana/email-action-type), [webhook](https://www.elastic.co/docs/reference/kibana/connectors-kibana/webhook-action-type), or [Webhook - Case Management connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/cases-webhook-action-type), specifies whether a user and password are required inside the secrets configuration.
    Data type: `bool`
    Default: `true`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.headers">
    For a [webhook](https://www.elastic.co/docs/reference/kibana/connectors-kibana/webhook-action-type) or [Webhook - Case Management connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/cases-webhook-action-type), specifies a set of key-value pairs sent as headers with the request.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.host">
    For an [email connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/email-action-type), specifies the host name of the service provider.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.index">
    For an [index connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/index-action-type), specifies the Elasticsearch index.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.isOAuth">
    For a [ServiceNow ITSM](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-action-type), [ServiceNow SecOps](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-sir-action-type), or [ServiceNow ITOM connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-itom-action-type), specifies whether to use basic or OAuth authentication.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.jwtKeyId">
    For a [ServiceNow ITSM](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-action-type), [ServiceNow SecOps](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-sir-action-type), or [ServiceNow ITOM connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-itom-action-type), specifies the key ID assigned to the JWT verifier map of your OAuth application. It is required when `xpack.actions.preconfigured.<connector-id>.config.isOAuth` is `true`.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.mappings">
    For a [Swimlane connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/swimlane-action-type), specifies field mappings.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.mappings.alertIdConfig">
    For a [Swimlane connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/swimlane-action-type), field mapping for the alert identifier. You must provide `fieldtype`, `id`, `key`, and `name` values.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.mappings.caseIdConfig">
    For a [Swimlane connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/swimlane-action-type), field mapping for the case identifier. You must provide `fieldtype`, `id`, `key`, and `name` values.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.mappings.caseNameConfig">
    For a [Swimlane connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/swimlane-action-type), field mapping for the case name. You must provide `fieldtype`, `id`, `key`, and `name` values.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.mappings.commentsConfig">
    For a [Swimlane connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/swimlane-action-type), field mapping for the case comments. You must provide `fieldtype`, `id`, `key`, and `name` values.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.mappings.descriptionConfig">
    For a [Swimlane connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/swimlane-action-type), field mapping for the case description. You must provide `fieldtype`, `id`, `key`, and `name` values.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.mappings.ruleNameConfig">
    For a [Swimlane connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/swimlane-action-type), field mapping for the rule name. You must provide `fieldtype`, `id`, `key`, and `name` values.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.mappings.severityConfig">
    For a [Swimlane connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/swimlane-action-type), specifies a field mapping for the severity. You must provide `fieldtype`, `id`, `key`, and `name` values.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.method">
    For a [webhook connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/webhook-action-type), specifies the HTTP request method, either `post` or `put`. Defaults to `post`.
    Data type: `enum`
    Options:
    - `post`
    - `put`
    Default: `post`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.orgId">
    For an [IBM Resilient connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/resilient-action-type), specifies the IBM Resilient organization identifier.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.port">
    For an [email connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/email-action-type), specifies the port to connect to on the service provider.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.projectKey">
    For a [Jira connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/jira-action-type), specifies the Jira project key.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.secure">
    For an [email connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/email-action-type), specifies whether the connection will use TLS when connecting to the service provider. If not true, the connection will initially connect over TCP then attempt to switch to TLS via the SMTP STARTTLS command.
    Data type: `bool`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.service">
    For an [email connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/email-action-type), specifies the name of the email service. For example, `elastic_cloud`, `exchange_server`, `gmail`, `other`, `outlook365`, or `ses`.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.tenantId">
    For an [email connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/email-action-type), specifies a GUID format value that corresponds to a tenant ID, which is a part of OAuth 2.0 client credentials authentication.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.updateIncidentJson">
    For a [Webhook - Case Management connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/cases-webhook-action-type), specifies a stringified JSON payload with Mustache variables that is sent to the update case URL to update a case. Required variables are `case.title` and `case.description`.
    <note>
      The JSON is validated after the Mustache variables have been placed when the REST method runs. You should manually ensure that the JSON is valid, disregarding the Mustache variables, so the later validation will pass.
    </note>
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.updateIncidentMethod">
    For a [Webhook - Case Management connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/cases-webhook-action-type), specifies the REST API HTTP request method to update the case in the third-party system.
    Data type: `enum`
    Options:
    - `post`
    - `put`
    - `patch`
    Default: `put`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.updateIncidentUrl">
    For a [Webhook - Case Management connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/cases-webhook-action-type), specifies the REST API URL to update the case by ID in the third-party system.
    <note>
      If you are using the `xpack.actions.allowedHosts` setting, make sure the hostname in the URL is added to the allowed hosts.
    </note>
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.url">
    A configuration URL that varies by connector:
    - For a [D3 Security connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/d3security-action-type), specifies the D3 Security API request URL.
    - For a [Tines connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/tines-action-type), specifies the Tines tenant URL.
    - For a [webhook connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/webhook-action-type), specifies the web service request URL.
    <note>
      If you are using the `xpack.actions.allowedHosts` setting, make sure this hostname is added to the allowed hosts.
    </note>
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.userIdentifierValue">
    For a [ServiceNow ITSM](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-action-type), [ServiceNow SecOps](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-sir-action-type), or [ServiceNow ITOM connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-itom-action-type), specifies the user identifier. It is required when required when `xpack.actions.preconfigured.<connector-id>.config.isOAuth` is `true`.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.usesBasic">
    For an [xMatters connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/xmatters-action-type), specifies whether it uses HTTP basic authentication.
    Data type: `bool`
    Default: `true`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.usesTableApi">
    For a [ServiceNow ITSM](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-action-type) or [ServiceNow SecOps connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-sir-action-type), specifies whether the connector uses the Table API or the Import Set API. If set to `false`, the Elastic application should be installed in ServiceNow.
    Data type: `bool`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.viewIncidentUrl">
    For a [Webhook - Case Management connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/cases-webhook-action-type), specifies a URL string with either the external service ID or external service title Mustache variable to view a case in the external system.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.config.webhookIntegrationUrl">
    For a [Torq connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/torq-action-type), specifies the endpoint URL of the Elastic Security integration in Torq.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.name">
    The name of the preconfigured connector.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.secrets">
    Sensitive configuration details, such as username, password, and keys, which are specific to the connector type.
    <tip>
      Sensitive properties, such as passwords, should be stored in the [Kibana keystore](https://www.elastic.co/docs/deploy-manage/security/secure-settings#creating-keystore).
    </tip>
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.secrets.accessKey">
    For an [Amazon Bedrock connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/bedrock-action-type), specifies the AWS access key for authentication.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.secrets.apikey">
    An API key secret that varies by connector.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.secrets.credentialsJson">
    For an [Google Gemini connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/gemini-action-type), specifies the GCP service account credentials JSON file for authentication.
    - For a [OpenAI connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/openai-action-type), specifies the OpenAI or Azure OpenAI API key for authentication.
    - For an [Opsgenie connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/opsgenie-action-type), specifies the Opsgenie API authentication key for HTTP basic authentication.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.secrets.apiKeyId">
    For an [IBM Resilient connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/resilient-action-type), specifies the authentication key ID for HTTP basic authentication.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.secrets.apiKeySecret">
    For an [IBM Resilient connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/resilient-action-type), specifies the authentication key secret for HTTP basic authentication.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.secrets.apiToken">
    For a [Jira](https://www.elastic.co/docs/reference/kibana/connectors-kibana/jira-action-type) or [Swimlane connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/swimlane-action-type), specifies the API authentication token for HTTP basic authentication.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.secrets.clientSecret">
    A client secret that varies by connector:
    - For an [email connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/email-action-type), specifies the client secret that you generated for your app in the app registration portal. It is required when the email service is `exchange_server`, which uses OAuth 2.0 client credentials authentication.
    - For a [ServiceNow ITSM](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-action-type), [ServiceNow SecOps](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-sir-action-type), or [ServiceNow ITOM connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-itom-action-type), specifies the client secret assigned to the OAuth application. It is required when `xpack.actions.preconfigured.<connector-id>.config.isOAuth` is `true`.
    <note>
      The client secret must be URL-encoded.
    </note>
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.secrets.email">
    An email address that varies by connector:
    - For a [Jira connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/jira-action-type), specifies the account email for HTTP basic authentication.
    - For a [Tines connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/tines-action-type), specifies the email used to sign in to Tines.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.secrets.password">
    A password secret that varies by connector:
    - For an [email](https://www.elastic.co/docs/reference/kibana/connectors-kibana/email-action-type), [webhook](https://www.elastic.co/docs/reference/kibana/connectors-kibana/webhook-action-type), or [Webhook - Case Management connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/cases-webhook-action-type), specifies a password that is required when `xpack.actions.preconfigured.<connector-id>.config.hasAuth` is `true`.
    - For a [ServiceNow ITSM](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-action-type), [ServiceNow SecOps](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-sir-action-type), or [ServiceNow ITOM connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-itom-action-type), specifies a password that is required when `xpack.actions.preconfigured.<connector-id>.config.isOAuth` is `false`.
    - For an [xMatters connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/xmatters-action-type), specifies a password that is required when `xpack.actions.preconfigured.<connector-id>.config.usesBasic` is `true`.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.secrets.privateKey">
    For a [ServiceNow ITSM](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-action-type), [ServiceNow SecOps](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-sir-action-type), or [ServiceNow ITOM connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-itom-action-type), specifies the RSA private key. It is required when `xpack.actions.preconfigured.<connector-id>.config.isOAuth` is `true`.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.secrets.privateKeyPassword">
    For a [ServiceNow ITSM](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-action-type), [ServiceNow SecOps](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-sir-action-type), or [ServiceNow ITOM connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-itom-action-type), specifies the password for the RSA private key.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.secrets.routingKey">
    For a [PagerDuty connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/pagerduty-action-type), specifies the 32 character PagerDuty Integration Key for an integration on a service, also referred to as the routing key.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.secrets.secret">
    For an [Amazon Bedrock connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/bedrock-action-type), specifies the AWS secret for authentication.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.secrets.secretsUrl">
    For an [xMatters connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/xmatters-action-type) with URL authentication, specifies the request URL for the Elastic Alerts trigger in xMatters with the API key included in the URL. It is used only when `xpack.actions.preconfigured.<connector-id>.config.usesBasic` is `false`.
    <note>
      If you are using the `xpack.actions.allowedHosts` setting, make sure this hostname is added to the allowed hosts.
    </note>
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.secrets.token">
    A token secret that varies by connector:
    - For a [D3 Security conector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/d3security-action-type), specifies the D3 Security token.
    - For a [Slack connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/slack-action-type), specifies the Slack bot user OAuth token.
    - For a [Tines connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/tines-action-type), specifies the Tines API token.
    - For a [Torq connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/torq-action-type), specifies the secret of the webhook authentication header.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.secrets.user">
    A user name secret that varies by connector:
    - For an [email](https://www.elastic.co/docs/reference/kibana/connectors-kibana/email-action-type), [webhook](https://www.elastic.co/docs/reference/kibana/connectors-kibana/webhook-action-type), or [Webhook - Case Management connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/cases-webhook-action-type), specifies a user name that is required when `xpack.actions.preconfigured.<connector-id>.config.hasAuth` is `true`.
    - For an [xMatters connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/xmatters-action-type), specifies a user name that is required when `xpack.actions.preconfigured.<connector-id>.config.usesBasic` is `true`.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.secrets.webhookUrl">
    A URL that varies by connector:
    - For a [Microsoft Teams](https://www.elastic.co/docs/reference/kibana/connectors-kibana/teams-action-type), specifies the URL of the incoming webhook.
    - For a [Slack connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/slack-action-type), specifies the Slack webhook URL.
    <note>
      If you are using the `xpack.actions.allowedHosts` setting, make sure the hostname is added to the allowed hosts.
    </note>
    Data type: `string`
  </definition>
  <definition term="xpack.actions.preconfigured.<connector-id>.secrets.username">
    For a [ServiceNow ITSM](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-action-type), [ServiceNow SecOps](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-sir-action-type), or [ServiceNow ITOM connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/servicenow-itom-action-type), specifies a user name that is required when `xpack.actions.preconfigured.<connector-id>.config.isOAuth` is `false`.
    Data type: `string`
  </definition>
  <definition term="xpack.actions.webhook.ssl.pfx.enabled Elastic Stack: Generally available since 9.1">
    Disable PFX file support for SSL client authentication. When set to `false`, the application will not accept PFX certificate files and will require separate certificate and private key files instead. Only applies to the [Webhook connector](https://www.elastic.co/docs/reference/kibana/connectors-kibana/webhook-action-type).
    Data type: `bool`
    Default: `true`
  </definition>
</definitions>


## Alerting settings

<definitions>
  <definition term="xpack.alerting.cancelAlertsOnRuleTimeout logo cloud">
    Specifies whether to skip writing alerts and scheduling actions if rule processing was cancelled due to a timeout. This setting can be overridden by individual rule types.
    Data type: `bool`
    Default: `true`
  </definition>
  <definition term="xpack.alerting.rules.maxScheduledPerMinute">
    Specifies the maximum number of rules to run per minute.
    Data type: `int`
    Default: `32000`
    <note applies-to="Elastic Cloud Serverless: Generally available">
      In Serverless, the maximum number of rules to run per minute is set to `400` and can't be configured.
    </note>
  </definition>
  <definition term="xpack.alerting.rules.minimumScheduleInterval.value logo cloud">
    Specifies the minimum schedule interval for rules. This minimum is applied to all rules created or updated after you set this value. The time is formatted as a number and a time unit (`s`, `m`, `h`, or `d`). For example, `20m`, `24h`, `7d`. This duration cannot exceed `1d`.
    Data type: `string`
    Default: `1m`
  </definition>
  <definition term="xpack.alerting.rules.minimumScheduleInterval.enforce logo cloud">
    Specifies the behavior when a new or changed rule has a schedule interval less than the value defined in `xpack.alerting.rules.minimumScheduleInterval.value`. If `false`, rules with schedules less than the interval will be created but warnings will be logged. If `true`, rules with schedules less than the interval cannot be created.
    Data type: `bool`
    Default: `false`
  </definition>
  <definition term="xpack.alerting.rules.run.actions.max logo cloud">
    Specifies the maximum number of actions that a rule can generate each time detection checks run.
    Data type: `int`
  </definition>
  <definition term="xpack.alerting.rules.run.alerts.max logo cloud">
    Specifies the maximum number of alerts that a rule can generate each time detection checks run.
    <warning>
      The exact number of alerts your cluster can safely handle depends on your cluster configuration and workload, however setting a value higher than the default (`1000`) is not recommended or supported. Doing so could strain system resources and lead to performance issues, delays in alert processing, and potential disruptions during high alert activity periods.
    </warning>
    Data type: `int`
    Default: `1000`
  </definition>
  <definition term="xpack.alerting.rules.run.timeout logo cloud">
    Specifies the default timeout for tasks associated with all types of rules. The time is formatted as a number and a time unit (`ms`, `s`, `m`, `h`, `d`, `w`, `M`, or `Y`). For example, `20m`, `24h`, `7d`, `1w`. Default: `5m`.
    Data type: `string`
  </definition>
  <definition term="xpack.alerting.rules.run.ruleTypeOverrides logo cloud">
    Overrides the configs under `xpack.alerting.rules.run` for the rule type with the given ID. List the rule identifier and its settings in an array of objects.
    Data type: `string`
    For example:
    ```yaml
    xpack.alerting.rules.run:
        timeout: '5m'
        ruleTypeOverrides:
            - id: '.index-threshold'
              timeout: '15m'
    ```
  </definition>
  <definition term="xpack.alerting.rules.run.actions.connectorTypeOverrides logo cloud">
    Overrides the configs under `xpack.alerting.rules.run.actions` for the connector type with the given ID. List the connector type identifier and its settings in an array of objects.
    Data type: `string`
    For example:
    ```yaml
    xpack.alerting.rules.run:
        actions:
            max: 10
            connectorTypeOverrides:
                - id: '.server-log'
                  max: 5
    ```
  </definition>
  <definition term="xpack.alerting.rules.apiKeyType Elastic Cloud Serverless: Generally available Elastic Stack: Unavailable">
    The API key type to use for executing alerting rules. The default value, corresponding to the existing behavior, is `es`, which uses an Elasticsearch API key. Set this to `uiam` to use UIAM API keys instead.
    <note applies-to="Elastic Cloud Serverless: Generally available">
      In Serverless, you can't edit this setting.
    </note>
    Data type: `string`
    For example:
    ```yaml
    xpack.alerting.rules.apiKeyType: uiam
    ```
  </definition>
</definitions>