﻿---
title: Kibana configuration reference
description: Configuration settings enable you to customize the behavior of Kibana apps and features. This reference provides details about each setting, such as its...
url: https://www.elastic.co/docs/reference/kibana/configuration-reference
products:
  - Kibana
---

# Kibana configuration reference
Configuration settings enable you to customize the behavior of Kibana apps and features.
This reference provides details about each setting, such as its purpose, default behavior, and availability in Elastic Cloud environments.
For information about how to update these settings, refer to the appropriate instructions for your environment. For example, [Elastic Cloud Hosted](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/edit-stack-settings), [Elastic Cloud Enterprise](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/edit-stack-settings-kibana), or [self-managed clusters](https://www.elastic.co/docs/deploy-manage/deploy/self-managed/configure-kibana).
The settings are grouped by feature or purpose, for example:
- [AI Assistant](https://www.elastic.co/docs/reference/kibana/configuration-reference/ai-assistant-settings)
- [Alerting](https://www.elastic.co/docs/reference/kibana/configuration-reference/alerting-settings)
- [APM](https://www.elastic.co/docs/reference/kibana/configuration-reference/apm-settings)
- [Banners](https://www.elastic.co/docs/reference/kibana/configuration-reference/banner-settings)
- [Cases](https://www.elastic.co/docs/reference/kibana/configuration-reference/cases-settings)
- [Fleet](https://www.elastic.co/docs/reference/kibana/configuration-reference/fleet-settings)
- [General](https://www.elastic.co/docs/reference/kibana/configuration-reference/general-settings)
- [Internationalization](https://www.elastic.co/docs/reference/kibana/configuration-reference/internationalization-settings)
- [Logging](https://www.elastic.co/docs/reference/kibana/configuration-reference/logging-settings)
- [Logs](https://www.elastic.co/docs/reference/kibana/configuration-reference/logs-settings)
- [Maps](https://www.elastic.co/docs/reference/kibana/configuration-reference/map-settings)
- [Metrics](https://www.elastic.co/docs/reference/kibana/configuration-reference/metrics-settings)
- [Monitoring](https://www.elastic.co/docs/reference/kibana/configuration-reference/monitoring-settings)
- [Product intercept](https://www.elastic.co/docs/reference/kibana/configuration-reference/product-intercept-settings)
- [Reporting](https://www.elastic.co/docs/reference/kibana/configuration-reference/reporting-settings)
- [Search sessions](https://www.elastic.co/docs/reference/kibana/configuration-reference/search-sessions-settings)
- [Security](https://www.elastic.co/docs/reference/kibana/configuration-reference/security-settings)
- [Share](https://www.elastic.co/docs/reference/kibana/configuration-reference/share-settings)
- [Spaces](https://www.elastic.co/docs/reference/kibana/configuration-reference/spaces-settings)
- [Task Manager](https://www.elastic.co/docs/reference/kibana/configuration-reference/task-manager-settings)
- [Telemetry](https://www.elastic.co/docs/reference/kibana/configuration-reference/telemetry-settings)
- [URL drilldown](https://www.elastic.co/docs/reference/kibana/configuration-reference/url-drilldown-settings)