﻿---
title: kibana-setup
description: The kibana-setup tool walks you through all required steps to securely connect Kibana with Elasticsearch. Use this command to configure a secure connection...
url: https://www.elastic.co/docs/reference/kibana/commands/kibana-setup
products:
  - Kibana
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# kibana-setup
The `kibana-setup` tool walks you through all required steps to securely connect Kibana with Elasticsearch.

## Synopsis

```shell
bin/kibana-setup
[-t, --enrollment-token <token>] [-s, --silent]
[-V, --version] [-h, --help]
```


## Description

Use this command to configure a secure connection between Kibana and Elasticsearch. The tool guides you through the process of enrolling Kibana with a secured Elasticsearch cluster using an enrollment token. This is particularly useful for initial setup and configuration of Kibana in secured environments.
<important>
  You must have an enrollment token generated from your Elasticsearch cluster before running this command.
</important>


## Parameters

<definitions>
  <definition term="-t, --enrollment-token <token>">
    Elasticsearch enrollment token to use for configuring the connection.
  </definition>
  <definition term="-s, --silent">
    Prevent all logging output during the setup process.
  </definition>
  <definition term="-h, --help">
    Returns all of the command parameters.
  </definition>
  <definition term="-V, --version">
    Displays the Kibana version number.
  </definition>
</definitions>


## Examples

The following command runs the interactive setup process:
```shell
bin/kibana-setup
```

The following command configures Kibana with a specific enrollment token:
```shell
bin/kibana-setup --enrollment-token <your-enrollment-token>
```

The following command runs setup silently with an enrollment token:
```shell
bin/kibana-setup --enrollment-token <your-enrollment-token> --silent
```