﻿---
title: kibana-encryption-keys
description: The kibana-encryption-keys command helps you generate encryption keys that Kibana uses to protect sensitive information. Kibana uses encryption keys in...
url: https://www.elastic.co/docs/reference/kibana/commands/kibana-encryption-keys
products:
  - Kibana
---

# kibana-encryption-keys
The `kibana-encryption-keys` command helps you generate encryption keys that Kibana uses to protect sensitive information.
Kibana uses encryption keys in several areas, ranging from encrypting data in Kibana associated indices to storing session information. By defining these encryption keys in your configuration, you’ll ensure consistent operations across restarts.

## Usage

```shell
bin/kibana-encryption-keys [command] [options]
```


## Commands

<definitions>
  <definition term="generate">
    Generate encryption keys.
    Unless interactive mode (`-i`) is used, the generated encryption keys will be output to your console only. From here, you should manually copy the keys into either `kibana.yml` or where else you’re configurating Kibana.
    <definitions>
      <definition term="-i, --interactive">
        Prompts you for which encryption keys to set and optionally where to save a sample configuration file.
      </definition>
      <definition term="-q, --quiet">
        Outputs the config options/encryption keys only (without helper information).
      </definition>
      <definition term="-f, --force">
        Generates new keys for all settings. By default, only un-configured encryption keys will be generated.
      </definition>
      <definition term="-h, --help">
        Shows help information.
      </definition>
    </definitions>
  </definition>
</definitions>


## Examples

```shell
bin/kibana-encryption-keys generate
```