﻿---
title: Kibana advanced settings
description: List of Kibana advanced settings.
url: https://www.elastic.co/docs/reference/kibana/advanced-settings
products:
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Kibana advanced settings
**Advanced Settings** control the behavior of Kibana. You can change the settings that apply to a specific space only, or to all of Kibana. For example, you can change the format used to display dates, specify the default data view, and apply your own branding.
<warning>
  Changing a setting can affect Kibana performance and cause problems that are difficult to diagnose. Setting a property value to a blank field reverts to the default behavior, which might not be compatible with other configuration settings. Deleting a custom setting permanently removes it from Kibana.
</warning>

Settings on this page are ordered as they appear in Kibana.

## Required permissions

You must have the `Advanced Settings` Kibana privilege to access the **Advanced Settings** page.
When you have insufficient privileges to edit advanced settings, the edit options are not visible, and the following indicator shows:
![Example of Advanced Settings Management's read only access indicator in Kibana's header](https://www.elastic.co/docs/reference/kibana/images/settings-read-only-badge.png)
To add the privilege, go to the **Roles** management page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
For more information on granting access to Kibana, refer to [Granting access to Kibana](https://www.elastic.co/docs/reference/elasticsearch/roles).

## Change the space-specific setting

Change the settings that apply only to a specific Kibana space.
1. Go to the **Advanced settings** page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Click **Space Settings**.
3. Scroll or search for the setting.
4. Make your change, then click **Save changes**.


### General

<definitions>
  <definition term="hideAnnouncements Elastic Stack: Planned for deprecation, Elastic Stack: Generally available from 9.0 to 9.3 Elastic Cloud Serverless: Unavailable">
    Stops showing messages and tours that highlight new features. `false` by default.
    <note applies-to="Elastic Stack: Planned">
      If this setting is set to `false` but the `hideAnnouncements` setting located in the **Global Settings** tab is set to `true`, then messages and tours that highlight new features won't show for the current space.
    </note>
  </definition>
  <definition term="dateFormat Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    The format to use for displaying [pretty formatted dates](https://momentjs.com/docs/#/displaying/format/).
  </definition>
  <definition term="dateFormat:tz Elastic Stack: Generally available Elastic Cloud Serverless: Generally available">
    The timezone that Kibana uses. `Browser` by default, which uses the timezone detected by the browser.
  </definition>
  <definition term="dateFormat:scaled Elastic Stack: Generally available Elastic Cloud Serverless: Generally available">
    The values that define the format to use to render ordered time-based data. Formatted timestamps must adapt to the interval between measurements. Keys are [ISO8601 intervals](http://en.wikipedia.org/wiki/ISO_8601#Time_intervals).
  </definition>
  <definition term="dateFormat:dow Elastic Stack: Generally available Elastic Cloud Serverless: Generally available">
    The day that a week should start on.
  </definition>
  <definition term="dateNanosFormat Elastic Stack: Generally available Elastic Cloud Serverless: Generally available">
    The format to use for displaying [pretty formatted dates](https://momentjs.com/docs/#/displaying/format/) of [Elasticsearch date_nanos type](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/date_nanos).
  </definition>
  <definition term="theme:darkMode Elastic Stack: Deprecated since 9.0 Elastic Cloud Serverless: Unavailable">
    The UI theme that the Kibana UI should use. Set to `enabled` or `disabled` to enable or disable the dark theme. Set to `system` to have the Kibana UI theme follow the system theme. You must refresh the page to apply the setting.
  </definition>
  <definition term="state:storeInSessionStorage Elastic Stack: Planned for deprecation, Elastic Stack: Preview from 9.0 to 9.3 Elastic Cloud Serverless: Unavailable">
    Kibana tracks UI state in the URL, which can lead to problems when there is a lot of state information, and the URL gets long. Enabling this setting stores part of the URL in your browser session to keep the URL short.
  </definition>
  <definition term="savedObjects:perPage Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    The number of objects to show on each page of the list of saved objects. `20` by default.
  </definition>
  <definition term="savedObjects:listingLimit Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    The number of objects to fetch for lists of saved objects. `1000` by default. Do not set above `10000`.
  </definition>
  <definition term="csv:separator Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    The separator for exported values. `,` by default.
  </definition>
  <definition term="csv:quoteValues Elastic Stack: Generally available Elastic Cloud Serverless: Generally available">
    Quotes exported values in CSV exports when activated. `true` by default.
  </definition>
  <definition term="shortDots:enable Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    Shortens long field names in visualizations. For example, shows `f.b.baz` instead of `foo.bar.baz`. `false` by default.
  </definition>
  <definition term="format:defaultTypeMap Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    A map of the default format name for each field type. Field types that are not explicitly mentioned use "_default_".
  </definition>
  <definition term="format:number:defaultPattern Elastic Stack: Generally available Elastic Cloud Serverless: Generally available">
    The [numeral pattern](https://www.elastic.co/docs/explore-analyze/numeral-formatting) for the "number" format. `0,0.[000]` by default.
  </definition>
  <definition term="format:percent:defaultPattern Elastic Stack: Generally available Elastic Cloud Serverless: Generally available">
    The [numeral pattern](https://www.elastic.co/docs/explore-analyze/numeral-formatting) for the "percent" format. `0,0.[000]%` by default.
  </definition>
  <definition term="format:bytes:defaultPattern Elastic Stack: Generally available Elastic Cloud Serverless: Generally available">
    The default [numeral pattern](https://www.elastic.co/docs/explore-analyze/numeral-formatting) format for the "bytes" format. `0,0.[0]b` by default.
  </definition>
  <definition term="format:currency:defaultPattern Elastic Stack: Generally available Elastic Cloud Serverless: Generally available">
    The default [numeral pattern](https://www.elastic.co/docs/explore-analyze/numeral-formatting) format for the "currency" format. `($0,0.[00])` by default.
  </definition>
  <definition term="format:number:defaultLocale Elastic Stack: Generally available Elastic Cloud Serverless: Generally available">
    The [numeral pattern](https://www.elastic.co/docs/explore-analyze/numeral-formatting) locale. `en` by default.
  </definition>
  <definition term="data_views:fields_excluded_data_tiers Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    Allows the exclusion of listed data tiers when getting a field list for faster performance.
  </definition>
  <definition term="data_views:cache_max_age Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    Sets how long data view fields API requests are cached in seconds. A value of 0 turns off caching. Modifying this value might not take immediate effect, users need to clear browser cache or wait until the current cache expires. To get immediate changes, try a hard reload of Kibana. `5` by default.
  </definition>
  <definition term="metaFields Elastic Stack: Generally available Elastic Cloud Serverless: Generally available">
    Fields that exist outside of `_source`. Kibana merges these fields into the document when displaying it. `_source, _id, _index, _score, _ignored` by default.
  </definition>
  <definition term="query:queryString:options Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    Options for the Lucene query string parser. Only used when `search:queryLanguage` is set to **Lucene**.
  </definition>
  <definition term="query:allowLeadingWildcards Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    Allows a wildcard (*) as the first character in a query clause. To disallow leading wildcards in Lucene queries, use `query:queryString:options`. `True` by default.
  </definition>
  <definition term="search:queryLanguage Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    The query language to use in the query bar. Choices are [KQL](https://www.elastic.co/docs/reference/query-languages/kql)(default), a language built specifically for Kibana, and the [Lucene query syntax](https://www.elastic.co/docs/explore-analyze/query-filter/languages/lucene-query-syntax).
  </definition>
  <definition term="sort:options Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    Options for the Elasticsearch [sort](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/sort-search-results) parameter.
  </definition>
  <definition term="defaultIndex Elastic Stack: Generally available Elastic Cloud Serverless: Generally available">
    The default data view to access if none is set in Discover and Dashboards. `null` by default.
  </definition>
  <definition term="histogram:barTarget Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    When date histograms use the `auto` interval, Kibana attempts to generate this number of bars. `50` by default.
  </definition>
  <definition term="histogram:maxBars Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    Limits the density of date and number histograms across Kibana using a test query to improve performance. When the test query contains too many buckets, the interval between buckets increases. Applies separately to each histogram aggregation, and does not apply to other types of aggregations. To find the maximum value, divide the Elasticsearch `search.max_buckets` value by the maximum number of aggregations in each visualization. `1000` by default.
  </definition>
  <definition term="history:limit Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    In fields that have history, such as query inputs, shows this many recent values. `10` by default.
  </definition>
  <definition term="timepicker:refreshIntervalDefaults Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    The default refresh interval for the time filter. Specify the `value` parameter in milliseconds. `{"pause": true, "value": 60000}` by default.
  </definition>
  <definition term="timepicker:timeDefaults Elastic Stack: Generally available Elastic Cloud Serverless: Generally available">
    The default selection in the time filter. Must be an object containing "from" and "to" (refer to [accepted formats](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/common-options#date-math)). `{"from": "now-15m", "to": "now"}` by default.
  </definition>
  <definition term="timepicker:quickRanges Elastic Stack: Generally available Elastic Cloud Serverless: Generally available">
    The list of ranges to show in the Quick section of the time filter. This must be an array of objects, with each object containing `from`, `to` (refer to [accepted formats](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/common-options#date-math)), and `display` (the title to be displayed).
  </definition>
  <definition term="filters:pinnedByDefault Elastic Stack: Generally available Elastic Cloud Serverless: Generally available">
    Makes filters have a global state and be pinned by default when activated. `false` by default.
  </definition>
  <definition term="filterEditor:suggestValues Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    Enables the filter editor and KQL autocomplete to suggest values for fields. `true` by default.
  </definition>
  <definition term="defaultRoute Elastic Stack: Generally available Serverless Observability projects: Generally available">
    The default route when opening Kibana. Use this setting to route users to a specific dashboard, application, or saved object as they enter each space.
  </definition>
  <definition term="fileUpload:maxFileSize Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    Sets the file size limit when importing files. `100MB` by default. The highest supported value for this setting is `1GB`.
  </definition>
  <definition term="enableESQL Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    Enables ES|QL in Kibana. `true` by default.
    When deactivated, hides the ES|QL user interface from various applications. However, users can still access existing ES|QL-based Discover sessions, visualizations, and other objects.
  </definition>
  <definition term="metrics:max_buckets Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    Affects the **TSVB** histogram density. Must be set higher than `histogram:maxBars`. `2000` by default.
  </definition>
  <definition term="metrics:allowStringIndices Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    Enables you to use Elasticsearch indices in **TSVB** visualizations. `false` by default.
  </definition>
  <definition term="workflows:ui:enabled Elastic Stack: Preview since 9.3 Elastic Cloud Serverless: Preview">
    Enables Elastic Workflows and related experiences. `false` by default.
  </definition>
  <definition term="fields:popularLimit Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    The top N most popular fields to show. `10` by default.
  </definition>
  <definition term="aiAssistant:preferredAIAssistantType Elastic Stack: Generally available since 9.1 Elastic Cloud Serverless: Unavailable">
    This setting allows you to choose which AI Assistants are available to use and where. You can choose to only show the AI Assistants in their solutions, in other Kibana applications (for example, Discover, Dashboards, and Stack Management pages), or nowhere.
    <note applies-to="Elastic Stack: Generally available since 9.2">
      Configure the `aiAssistant:preferredAIAssistantType` setting from the **GenAI Settings** page, which you can find using the Classic navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects). Note that this setting is unavailable from the **GenAI Settings** page when using a [solution view](https://www.elastic.co/docs/deploy-manage/manage-spaces).
    </note>
  </definition>
</definitions>


### Presentation Labs

<definitions>
  <definition term="labs:dashboard:deferBelowFold Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    Enables deferred loading of dashboard panels below the fold. *Below the fold* refers to panels that are not immediately visible when you open a dashboard, but become visible as you scroll. `false` by default.
  </definition>
  <definition term="labs:canvas:byValueEmbeddable Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    Enables support for by-value embeddables in Canvas. `true` by default.
  </definition>
  <definition term="labs:dashboard:enable_ui Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    Provides access to the experimental **Labs** features for **Dashboard** when activated. `false` by default.
  </definition>
  <definition term="labs:canvas:enable_ui Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    Provides access to the experimental **Labs** features for **Canvas** when activated. `false` by default.
  </definition>
</definitions>


### Accessibility

<definitions>
  <definition term="accessibility:disableAnimations Elastic Stack: Generally available Elastic Cloud Serverless: Generally available">
    Turns off all optional animations in the Kibana UI. Refresh the page to apply the changes. `false` by default.
  </definition>
</definitions>


### Autocomplete

<definitions>
  <definition term="autocomplete:valueSuggestionMethod Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    The method to retrieve values for KQL autocomplete suggestions. `terms_enum` by default.
    - When set to `terms_enum`, autocomplete uses the terms enum API for value suggestions. Kibana returns results faster, but suggestions are approximate, sorted alphabetically, and can be outside the selected time range. (Note that this API is incompatible with [Document-Level-Security](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/controlling-access-at-document-field-level).)
    - When set to `terms_agg`, Kibana uses a terms aggregation for value suggestions, which is slower, but suggestions include all values that optionally match your time range and are sorted by popularity.
  </definition>
  <definition term="autocomplete:useTimeRange Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    When off, autocomplete suggestions come from your data set instead of the time range. `true` by default.
  </definition>
</definitions>


### Banners

<note>
  Banners are a [subscription feature](https://www.elastic.co/subscriptions).
</note>

<definitions>
  <definition term="banners:placement Elastic Stack: Generally available Elastic Cloud Serverless: Generally available">
    The placement of the banner for this space. Set to `Top` to display a banner above the Elastic header. Uses the value of the `xpack.banners.placement` configuration property by default.
  </definition>
  <definition term="banners:textContent Elastic Stack: Generally available Elastic Cloud Serverless: Generally available">
    The text to display inside the banner for this space, either plain text or Markdown. Uses the value of the `xpack.banners.textContent` configuration property by default.
  </definition>
  <definition term="banners:textColor Elastic Stack: Generally available Elastic Cloud Serverless: Generally available">
    The color for the banner text for this space. Uses the value of the `xpack.banners.textColor` configuration property by default.
  </definition>
  <definition term="banners:linkColor Elastic Stack: Generally available since 9.1 Elastic Cloud Serverless: Unavailable">
    The color for the banner link text for this space. Uses the value of the `xpack.banners.linkColor` configuration property by default.
  </definition>
  <definition term="banners:backgroundColor Elastic Stack: Generally available Elastic Cloud Serverless: Generally available">
    The color of the banner background for this space. Uses the value of the `xpack.banners.backgroundColor` configuration property by default.
  </definition>
</definitions>


### Discover

<definitions>
  <definition term="doc_table:highlight Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    Highlights search results in **Discover** and Discover session panels on dashboards. Highlighting slows requests when working on large documents. `true` by default.
  </definition>
  <definition term="defaultColumns Elastic Stack: Generally available Elastic Cloud Serverless: Generally available">
    The columns that appear by default on the **Discover** page. When empty, displays a summary of the document. Empty by default.
  </definition>
  <definition term="discover:maxDocFieldsDisplayed Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    Specifies the maximum number of fields to show in the document column of the **Discover** table. `200` by default.
  </definition>
  <definition term="discover:sampleSize Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    Sets the maximum number of rows for the entire document table. This is the maximum number of documents fetched from Elasticsearch. `500` by default.
  </definition>
  <definition term="discover:sampleRowsPerPage Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    Limits the number of rows per page in the document table. `100` by default.
  </definition>
  <definition term="discover:sort:defaultOrder Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    The default sort direction for time-based data views. `Descending` by default.
  </definition>
  <definition term="discover:searchOnPageLoad Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    Controls whether a search runs when **Discover** first loads. This setting does not have an effect when loading a saved Discover session. `true` by default.
  </definition>
  <definition term="doc_table:hideTimeColumn Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    Hides the "Time" column in **Discover** and in all Discover session panels on dashboards. `false` by default.
  </definition>
  <definition term="context:defaultSize Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    The number of surrounding entries to display in the context view. `5` by default.
  </definition>
  <definition term="context:step Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    The number by which to increment or decrement the context size. `5` by default.
  </definition>
  <definition term="context:tieBreakerFields Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    A comma-separated list of fields to use for breaking a tie between documents that have the same timestamp value. The first field that is present and sortable in the current data view is used. `_doc` by default.
  </definition>
  <definition term="discover:modifyColumnsOnSwitch Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    Removes columns that are not in the newly selected data view when changing data views. `true` by default.
  </definition>
  <definition term="discover:showFieldStatistics Elastic Stack: Beta">
    Enables the Field statistics view. Examine details such as the minimum and maximum values of a numeric field or a map of a geo field. `true` by default.
  </definition>
  <definition term="discover:showMultiFields Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    Controls the display of multi-fields in the expanded document view. This option is only available when `searchFieldsFromSource` is off. `false` by default.
  </definition>
  <definition term="discover:rowHeightOption Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    The number of lines to allow in a row. A value of -1 automatically adjusts the row height to fit the contents. A value of 0 displays the content in a single line. `3` by default.
  </definition>
</definitions>


### Machine Learning

<definitions>
  <definition term="ml:anomalyDetection:results:enableTimeDefaults Elastic Stack: Generally available Serverless Observability projects: Generally available Serverless Security projects: Generally available">
    Uses the default time filter in the **Single Metric Viewer** and **Anomaly Explorer** when activated. When deactivated, shows results for the full time range. `false` by default.
  </definition>
  <definition term="ml:anomalyDetection:results:timeDefaults Elastic Stack: Generally available Serverless Observability projects: Generally available Serverless Security projects: Generally available">
    The default time filter for viewing anomaly detection job results. Must contain from and to values (refer to [accepted formats](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/common-options#date-math)). Ignored unless the `ml:anomalyDetection:results:enableTimeDefaults` setting is activated. `{"from": "now-15m", "to": "now"}` by default.
  </definition>
</definitions>


### Notifications

<definitions>
  <definition term="notifications:banner Elastic Stack: Generally available Elastic Cloud Serverless: Generally available">
    A custom banner intended for temporary notices to all users. Supports [Markdown syntax](https://docs.github.com/en/get-started/writing-on-github/getting-started-with-writing-and-formatting-on-github/basic-writing-and-formatting-syntax).
  </definition>
  <definition term="notifications:lifetime:banner Elastic Stack: Generally available Elastic Cloud Serverless: Generally available">
    The duration, in milliseconds, for banner notification displays. `3000000` by default.
  </definition>
  <definition term="notifications:lifetime:error Elastic Stack: Generally available Elastic Cloud Serverless: Generally available">
    The duration, in milliseconds, for error notification displays. `300000` by default.
  </definition>
  <definition term="notifications:lifetime:warning Elastic Stack: Generally available Elastic Cloud Serverless: Generally available">
    The duration, in milliseconds, for warning notification displays. `10000` by default.
  </definition>
  <definition term="notifications:lifetime:info Elastic Stack: Generally available Elastic Cloud Serverless: Generally available">
    The duration, in milliseconds, for information notification displays. `5000` by default.
  </definition>
</definitions>


### Observability

<definitions>
  <definition term="ai:anonymizationSettings Elastic Stack: Preview Serverless Observability projects: Preview Serverless Elasticsearch projects: Preview">
    List of anonymization rules for AI Assistant. Includes rules for Named Entity Recognition (NER) models and regular expression patterns to identify and anonymize sensitive data.
    <dropdown title="Default configuration">
      ```json
      {
        "rules": [
          {
            "entityClass": "EMAIL",
            "type": "RegExp",
            "pattern": "([a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,})",
            "enabled": false
          },
          {
            "type": "NER",
            "modelId": "elastic__distilbert-base-uncased-finetuned-conll03-english",
            "enabled": false,
            "allowedEntityClasses": [
              "PER",
              "ORG",
              "LOC"
            ],
            "timeoutSeconds": 30
          }
        ]
      }
      ```
    </dropdown>
  </definition>
  <definition term="observability:logSources Elastic Stack: Generally available Serverless Observability projects: Generally available">
    Sources to use for logs data. If the data of these indices is not logs data, you can experience degraded functionality. Changes to this setting can potentially impact the sources queried in Log Threshold rules. `logs-*-*, logs-*, filebeat-*` by default.
  </definition>
  <definition term="observability:streamsEnableContentPacks Elastic Stack: Preview Serverless Observability projects: Preview">
    Enable Streams content packs. `false` by default.
  </definition>
  <definition term="observability:aiAssistantSimulatedFunctionCalling Elastic Stack: Preview Serverless Observability projects: Preview Serverless Elasticsearch projects: Preview">
    Simulated function calling does not need API support for functions or tools, but it can decrease performance. Currently always activated for connectors that do not have API support for Native function calling. `false` by default.
  </definition>
  <definition term="observability:aiAssistantSearchConnectorIndexPattern Elastic Stack: Preview Serverless Observability projects: Generally available Serverless Elasticsearch projects: Generally available">
    Index pattern used by the AI Assistant when querying search connectors indices (part of the knowledge base). Empty by default: the index for every search connector is queried.
  </definition>
  <definition term="observability:newLogsOverview Elastic Stack: Preview Serverless Observability projects: Preview">
    Enable the new logs overview experience. `true` by default.
  </definition>
  <definition term="observability:enableInspectEsQueries Elastic Stack: Generally available Serverless Observability projects: Generally available">
    When activated, allows you to inspect Elasticsearch queries in API responses. `false` by default.
  </definition>
  <definition term="observability:maxSuggestions Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    Maximum number of suggestions fetched in autocomplete selection boxes. `100` by default.
  </definition>
  <definition term="observability:enableComparisonByDefault Elastic Stack: Generally available Serverless Observability projects: Generally available">
    Enables the comparison feature by default in the APM app. `true` by default.
  </definition>
  <definition term="observability:apmDefaultServiceEnvironment Elastic Stack: Generally available Serverless Observability projects: Generally available">
    The default environment for the APM app. When left empty, displays data from all environments by default. Empty by default.
  </definition>
  <definition term="observability:apmProgressiveLoading Elastic Stack: Generally available since 9.1, Elastic Stack: Preview in 9.0 Serverless Observability projects: Generally available">
    Enables progressive loading of some APM views. Data can be requested with a lower sampling rate first, with lower accuracy but faster response times, while the unsampled data loads in the background. `Off` by default.
  </definition>
  <definition term="observability:apmServiceInventoryOptimizedSorting Elastic Stack: Removed in 9.1, Elastic Stack: Preview in 9.0">
    Sort services without anomaly detection rules on the APM Service inventory page by service name. `false` by default.
  </definition>
  <definition term="observability:apmServiceGroupMaxNumberOfServices Elastic Stack: Generally available Serverless Observability projects: Generally available">
    Limit the number of services in a given service group. `500` by default.
  </definition>
  <definition term="observability:apmTraceExplorerTab Elastic Stack: Removed in 9.1, Elastic Stack: Preview in 9.0">
    Enable the APM Trace Explorer feature, that allows you to search and inspect traces with KQL or EQL. `true` by default.
  </definition>
  <definition term="observability:apmLabsButton Elastic Stack: Removed in 9.1 Elastic Cloud Serverless: Unavailable">
    Activates the APM Labs button, a quick way to enable and disable technical preview features in APM. `false` by default.
  </definition>
  <definition term="observability:enableInfrastructureProfilingIntegration Elastic Stack: Removed in 9.1, Elastic Stack: Preview in 9.0">
    Enables the Profiling view in Host details within Infrastructure. `true` by default.
  </definition>
  <definition term="observability:enableInfrastructureAssetCustomDashboards Elastic Stack: Preview since 9.0">
    Enables the option to link custom dashboards in the Asset Details view. `false` by default.
  </definition>
  <definition term="observability:enableAwsLambdaMetrics Elastic Stack: Removed in 9.1, Elastic Stack: Preview in 9.0">
    Display Amazon Lambda metrics in the service metrics tab. `true` by default.
  </definition>
  <definition term="observability:apmAgentExplorerView Elastic Stack: Removed in 9.1, Elastic Stack: Beta in 9.0 Elastic Cloud Serverless: Unavailable">
    Enable the Agent explorer view. `true` by default.
  </definition>
  <definition term="observability:apmEnableTableSearchBar Elastic Stack: Preview Serverless Observability projects: Preview">
    Enables faster searching in APM tables by adding a handy search bar with live filtering. Available for the following tables: Services, Transactions, and Errors. `true` by default.
  </definition>
  <definition term="observability:apmEnableServiceInventoryTableSearchBar Elastic Stack: Preview Serverless Observability projects: Preview">
    Enables faster searching in the APM Service inventory table by adding a handy search bar with live filtering. `true` by default.
  </definition>
  <definition term="observability:apmAWSLambdaPriceFactor Elastic Stack: Generally available Serverless Observability projects: Generally available">
    Set the price per Gb-second for your AWS Lambda functions. `{"x86_64": 0.0000166667,"arm": 0.0000133334}` by default.
  </definition>
  <definition term="observability:apmAWSLambdaRequestCostPerMillion Elastic Stack: Generally available Serverless Observability projects: Generally available">
    Set the AWS Lambda cost per million requests. `0.2` by default.
  </definition>
  <definition term="observability:apmEnableServiceMetrics Elastic Stack: Removed in 9.1, Elastic Stack: Beta in 9.0 Elastic Cloud Serverless: Unavailable">
    Enable the usage of service transaction metrics, which are low cardinality metrics that can be used by certain views like the service inventory for faster loading times. `true` by default.
  </definition>
  <definition term="observability:apmEnableContinuousRollups Elastic Stack: Removed in 9.1, Elastic Stack: Beta in 9.0 Elastic Cloud Serverless: Unavailable">
    When continuous rollups is activated, the UI selects metrics with the appropriate resolution. On larger time ranges, lower resolution metrics are used, which improves loading times. `true` by default.
  </definition>
  <definition term="observability:apmEnableCriticalPath Elastic Stack: Removed in 9.1 Elastic Cloud Serverless: Unavailable">
    When activated, displays the critical path of a trace. `false` by default.
  </definition>
  <definition term="observability:syntheticsThrottlingEnabled Elastic Stack: Preview Elastic Cloud Serverless: Unavailable">
    Enable the throttling setting in Synthetics monitor configurations. Throttling might still not be available for your monitors even if the setting is active. `false` by default.
    <warning>
      This setting is intended for Elastic-internal use only. [Learn more](https://github.com/elastic/synthetics/blob/main/docs/throttling.md)
    </warning>
  </definition>
  <definition term="observability:enableLegacyUptimeApp Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    By default, the legacy Uptime app is hidden from the interface when it doesn't have any data for more than a week. Enabling this option always shows it. `false` by default.
  </definition>
  <definition term="observability:apmEnableProfilingIntegration Elastic Stack: Removed in 9.1 Elastic Cloud Serverless: Unavailable">
    Enable the Universal Profiling integration in APM. `true` by default.
  </definition>
  <definition term="observability:profilingShowErrorFrames Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    Show error frames in the Universal Profiling views to indicate stack unwinding failures. `false` by default.
  </definition>
  <definition term="observability:profilingPervCPUWattX86 Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    The average amortized per-core power consumption (based on 100% CPU utilization) for x86 architecture. `7` by default.
  </definition>
  <definition term="observability:profilingPervCPUWattArm64 Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    The average amortized per-core power consumption (based on 100% CPU utilization) for arm64 architecture. `2,8` by default.
  </definition>
  <definition term="observability:profilingDatacenterPUE Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    Data center power usage effectiveness (PUE) measures how efficiently a data center uses energy. `1.7` by default, the average on-premise data center PUE according to the [Uptime Institute](https://ela.st/uptimeinstitute) survey.
  </definition>
  <definition term="observability:profilingCo2PerKWH Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    Carbon intensity measures how clean your data center electricity is. Specifically, it measures the average amount of CO2 emitted per kilowatt-hour (kWh) of electricity consumed in a particular region. Use the [cloud carbon footprint data sheet](https://ela.st/grid-datasheet) to update this value according to your region. Defaults to US East (N. Virginia).
  </definition>
  <definition term="observability:profilingAWSCostDiscountRate Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    If you're enrolled in the AWS Enterprise Discount Program (EDP), enter your discount rate to update the profiling cost calculation. Empty by default.
  </definition>
  <definition term="observability:profilingAzureCostDiscountRate Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    If you have an Azure Enterprise Agreement with Microsoft, enter your discount rate to update the profiling cost calculation. Empty by default.
  </definition>
  <definition term="observability:profilingCostPervCPUPerHour Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    Default Hourly Cost per CPU Core for machines not on AWS or Azure. `0,0425` by default.
  </definition>
  <definition term="observability:apmEnableTransactionProfiling Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    Enables Universal Profiling on Transaction view. `true` by default.
  </definition>
  <definition term="observability:profilingFetchTopNFunctionsFromStacktraces Elastic Stack: Removed in 9.1 Elastic Cloud Serverless: Unavailable">
    Switch to fetch the TopN Functions from the Stacktraces API. `false` by default.
  </definition>
  <definition term="observability:searchExcludedDataTiers Elastic Stack: Preview Elastic Cloud Serverless: Unavailable">
    Specify the data tiers to exclude from search, such as data_cold or data_frozen. When configured, indices allocated in the selected tiers are ignored from search requests. Affected apps: APM, Infrastructure. Empty by default.
  </definition>
  <definition term="observability:enableDiagnosticMode Elastic Stack: Preview Serverless Observability projects: Preview">
    Enable diagnostic mode for debugging and troubleshooting capabilities. Currently available only in the Service map view. `false` by default.
  </definition>
  <definition term="observability:streamsEnableSignificantEvents Elastic Stack: Preview Serverless Observability projects: Preview">
    Enable streams significant events. `false` by default.
  </definition>
</definitions>


### Reporting

<definitions>
  <definition term="xpackReporting:customPdfLogo Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    A custom image to use in the footer of the PDF. None by default.
  </definition>
</definitions>


### Rollup

<warning>
  Rollups are deprecated and will be removed in a future version. Use [downsampling](https://www.elastic.co/docs/manage-data/data-store/data-streams/downsampling-time-series-data-stream) instead.
</warning>

<definitions>
  <definition term="rollups:enableIndexPatterns Elastic Stack: Deprecated since 8.15 Elastic Cloud Serverless: Unavailable">
    Enables the creation of data views that capture rollup indices, which in turn enables visualizations based on rollup data. Refresh the page to apply the changes.
  </definition>
</definitions>


### Elasticsearch

<definitions>
  <definition term="courier:ignoreFilterIfFieldNotInIndex Elastic Stack: Generally available Serverless Elasticsearch projects: Generally available">
    Enhances support for dashboards containing visualizations accessing several dissimilar data views. When activated, filters are ignored for a visualization when the visualization's data view does not contain the filtering field. When deactivated, all filters are applied to all visualizations. `false` by default.
  </definition>
  <definition term="courier:setRequestPreference Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    Sets which shards handle your search requests.
    - **Session ID** (default): Restricts operations to execute all search requests on the same shards. This has the benefit of reusing shard caches across requests.
    - **Custom**: Allows you to define your own preference. Use `courier:customRequestPreference` to customize your preference value.
    - **None**: Do not set a preference. This might provide better performance because requests can be spread across all shard copies. However, results might be inconsistent because different shards might be in different refresh states.
  </definition>
  <definition term="courier:customRequestPreference Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    [Request preference](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-search#operation-search-preference) to use when `courier:setRequestPreference` uses `custom`. `_local` by default.
  </definition>
  <definition term="courier:maxConcurrentShardRequests Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    Controls the [max_concurrent_shard_requests](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-msearch) setting used for `_msearch` requests sent by Kibana. Set to 0 to disable this config and use the Elasticsearch default. `0` by default.
  </definition>
  <definition term="search:includeFrozen Elastic Stack: Deprecated since 7.16 Elastic Cloud Serverless: Unavailable">
    Includes [frozen indices](https://www.elastic.co/docs/manage-data/lifecycle/data-tiers#frozen-tier) in results. Searching through frozen indices might increase the search time. `false` by default.
  </definition>
  <definition term="search:timeout Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    The maximum timeout, in milliseconds, for search requests. To deactivate the timeout and allow queries to run to completion, set to `0`. `600000` (10 minutes) by default.
  </definition>
</definitions>


### Security solution

<definitions>
  <definition term="securitySolution:refreshIntervalDefaults Elastic Stack: Generally available Serverless Security projects: Generally available">
    The default refresh interval for the Security time filter, in milliseconds. `300000` by default.
  </definition>
  <definition term="securitySolution:timeDefaults Elastic Stack: Generally available Serverless Security projects: Generally available">
    The default period of time of the Security solution time filter. `{"from": "now/d","to": "now/d"}` by default.
  </definition>
  <definition term="securitySolution:defaultIndex Elastic Stack: Generally available Serverless Security projects: Generally available">
    A comma-delimited list of Elasticsearch indices from which the Elastic Security app collects events. `apm-*-transaction*, auditbeat-*, endgame-*, filebeat-*, logs-*, packetbeat-*, traces-apm*, winlogbeat-*, -*elastic-cloud-logs-*` by default.
  </definition>
  <definition term="securitySolution:defaultThreatIndex Elastic Stack: Generally available Serverless Security projects: Generally available">
    A comma-delimited list of Threat Intelligence indices from which the Elastic Security app collects indicators. `logs-ti_*` by default.
  </definition>
  <definition term="securitySolution:defaultAnomalyScore Elastic Stack: Generally available Serverless Security projects: Generally available">
    The threshold above which machine learning job anomalies are displayed in the Elastic Security app. The value must be between `0` and `100`. `50` by default.
  </definition>
  <definition term="securitySolution:enableNewsFeed Elastic Stack: Generally available Serverless Security projects: Generally available">
    Enables the security news feed on the Security **Overview** page. `true` by default.
  </definition>
  <definition term="securitySolution:excludeColdAndFrozenTiersInAnalyzer Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    Skips cold and frozen tiers in Analyzer's queries when activated. `false` by default.
  </definition>
  <definition term="securitySolution:enableGraphVisualization Elastic Stack: Preview Serverless Security projects: Preview">
    Enables the Graph Visualization feature within the Security solution. `false` by default.
  </definition>
  <definition term="securitySolution:enableAssetInventory Elastic Stack: Preview Serverless Security projects: Preview">
    Enables the Asset Inventory experience within the Security solution. When activated, you can access the Inventory feature through the Security solution navigation. `false` by default.
    <note>
      Disabling this setting will not disable the Entity Store or clear persistent Entity metadata. To manage or disable the Entity Store, visit the **Entity Store Management** page.
    </note>
  </definition>
  <definition term="securitySolution:enableCloudConnector Elastic Stack: Preview Serverless Security projects: Preview">
    Enables the Cloud Connector experience within the Security solution. `true` by default.
  </definition>
  <definition term="securitySolution:rulesTableRefresh Elastic Stack: Generally available Serverless Security projects: Generally available">
    Enables auto refresh on the rules and monitoring tables, in milliseconds. `{"on": true,"value": 60000}` by default.
  </definition>
  <definition term="securitySolution:newsFeedUrl Elastic Stack: Generally available Serverless Security projects: Generally available">
    The URL to retrieve the security news feed content from. `https://feeds.elastic.co/security-solution` by default.
  </definition>
  <definition term="securitySolution:ipReputationLinks Elastic Stack: Generally available Serverless Security projects: Generally available">
    A JSON array containing links for verifying the reputation of an IP address. The links are displayed on [IP detail](https://www.elastic.co/docs/solutions/security/explore/network-page) pages.
    <dropdown title="Default array">
      ```json
      [
        { "name": "virustotal.com", "url_template": "https://www.virustotal.com/gui/search/{{ip}}" },
        { "name": "talosIntelligence.com", "url_template": "https://talosintelligence.com/reputation_center/lookup?search={{ip}}" }
      ]
      ```
    </dropdown>
  </definition>
  <definition term="securitySolution:enableCcsWarning Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    Enables privilege check warnings in rules for CCS indices. `true` by default.
  </definition>
  <definition term="securitySolution:suppressionBehaviorOnAlertClosure Elastic Stack: Generally available Serverless Security projects: Generally available">
    If an alert is closed while suppression is active, you can choose whether suppression continues or resets. `Restart suppression` by default.
  </definition>
  <definition term="securitySolution:showRelatedIntegrations Elastic Stack: Generally available Serverless Security projects: Generally available">
    Shows related integrations on the rules and monitoring tables. `true` by default.
  </definition>
  <definition term="securitySolution:alertTags Elastic Stack: Generally available Serverless Security projects: Generally available">
    List of tag options for use with alerts generated by Security Solution rules. `Duplicate, False Positive, Further investigation required` by default.
  </definition>
  <definition term="securitySolution:excludedDataTiersForRuleExecution Elastic Stack: Generally available Serverless Security projects: Generally available">
    Specifies data tiers to exclude from searching during rule execution. Excludes events from the specified data tiers, which might help improve rule performance or reduce execution time. For example: `data_frozen,data_cold`. Empty by default.
  </definition>
  <definition term="securitySolution:enablePrivilegedUserMonitoring Elastic Stack: Removed in 9.3, Elastic Stack: Preview from 9.1 to 9.2 Elastic Cloud Serverless: Unavailable">
    Enables the privileged user monitoring dashboard and onboarding experience, which are in technical preview. `true` by default.
  </definition>
  <definition term="securitySolution:enableEsqlRiskScoring Elastic Stack: Removed in 9.3, Elastic Stack: Preview from 9.0 to 9.2 Elastic Cloud Serverless: Unavailable">
    Enables risk scoring based on ES|QL queries. Disabling this reverts to using scripted metrics. `true` by default.
  </definition>
  <definition term="securitySolution:defaultAIConnector Elastic Stack: Unavailable Serverless Security projects: Generally available">
    Default AI connector for serverless AI features (Elastic AI SOC Engine). `Elastic Managed LLM` by default.
  </definition>
  <definition term="securitySolution:defaultValueReportMinutes Elastic Stack: Unavailable Serverless Security projects: Generally available">
    The average review time in minutes for an analyst to review an alert. Used for calculations in the Value report. `8` by default.
  </definition>
  <definition term="securitySolution:defaultValueReportRate Elastic Stack: Unavailable Serverless Security projects: Generally available">
    The average hourly rate for a security analyst. Used for calculations in the Value report. `75` by default.
  </definition>
  <definition term="securitySolution:defaultValueReportTitle Elastic Stack: Unavailable Serverless Security projects: Generally available">
    The title of the Value report. `Elastic AI value report` by default.
  </definition>
</definitions>


### Timelion

<definitions>
  <definition term="timelion:es.timefield Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    The default field containing a timestamp when using the `.es()` query. `@timestamp` by default.
  </definition>
  <definition term="timelion:es.default_index Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    The default index when using the `.es()` query. `_all` by default.
  </definition>
  <definition term="timelion:target_buckets Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    Used for calculating automatic intervals in visualizations, this is the number of buckets to try to represent. `200` by default.
  </definition>
  <definition term="timelion:max_buckets Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    The maximum number of buckets a single data source can return. This value is used for calculating automatic intervals in visualizations. `2000` by default.
  </definition>
  <definition term="timelion:min_interval Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    The smallest interval to calculate when using "auto". `1ms` by default.
  </definition>
</definitions>


### Visualization

<definitions>
  <definition term="visualization:heatmap:maxBuckets Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    The maximum number of buckets a datasource can return. High numbers can have a negative impact on your browser rendering performance. `50` by default.
  </definition>
  <definition term="visualization:visualize:legacyHeatmapChartsLibrary Elastic Stack: Deprecated Elastic Cloud Serverless: Unavailable">
    Enables legacy charts library for heatmap charts in visualize. `false` by default.
  </definition>
  <definition term="visualization:useLegacyTimeAxis Elastic Stack: Removed in 9.1, Elastic Stack: Deprecated from 8.10 to 9.0 Elastic Cloud Serverless: Unavailable">
    Enables the legacy time axis for charts in Lens, Discover, Visualize, and TSVB. `true` by default.
  </definition>
</definitions>


### Developer tools

<definitions>
  <definition term="devTools:enablePersistentConsole Elastic Stack: Generally available Serverless Elasticsearch projects: Generally available">
    Enables a persistent console in the Kibana UI. This setting does not affect the standard Console in Dev Tools. `true` by default.
  </definition>
</definitions>


## Change the global settings

<applies-to>
  - Elastic Cloud Serverless: Unavailable
  - Elastic Stack: Generally available
</applies-to>

Change the settings that apply to all of Kibana.
1. Go to the **Advanced settings** page using the navigation menu or the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Click **Global Settings**.
3. Scroll or search for the setting.
4. Make your change, then click **Save changes**.


### General

<definitions>
  <definition term="hideAnnouncements Elastic Stack: Planned Elastic Cloud Serverless: Unavailable">
    Stops showing messages and tours that highlight new features. `false` by default.
  </definition>
</definitions>


### Custom branding

<note>
  Custom branding is a [subscription feature](https://www.elastic.co/subscriptions).
</note>

<definitions>
  <definition term="xpackCustomBranding:logo Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    A custom image that appears in the header of all Kibana pages. Images must have a transparent background, and 128x128 pixels or smaller.
  </definition>
  <definition term="xpackCustomBranding:customizedLogo Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    The custom text that appears in the header of all Kibana pages. Images must have a transparent background, and 200x84 pixels or smaller.
  </definition>
  <definition term="xpackCustomBranding:pageTitle Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    The custom text that appears on Kibana browser tabs.
  </definition>
  <definition term="xpackCustomBranding:faviconSVG Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    The URL of a custom SVG image that appears on Kibana browser tabs. Images must be 16x16 pixels.
  </definition>
  <definition term="xpackCustomBranding:faviconPNG Elastic Stack: Generally available Elastic Cloud Serverless: Unavailable">
    The URL of a custom PNG image that appears on Kibana browser tabs.
  </definition>
</definitions>