﻿---
title: Zscaler ZPA
description: This integration is for Zscaler Private Access logs. It can be used to receive logs sent by LSS Log Receiver on respective TCP ports. The log message...
url: https://www.elastic.co/docs/reference/integrations/zscaler_zpa
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Zscaler ZPA
|                                                                                                 |                                 |
|-------------------------------------------------------------------------------------------------|---------------------------------|
| **Version**                                                                                     | 1.23.3 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                           |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                         |
| **Ingestion method(s)**                                                                         | Network Protocol                |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.13.0                     |

This integration is for Zscaler Private Access logs. It can be used
to receive logs sent by LSS Log Receiver on respective TCP ports.
The log message is expected to be in JSON format. The data is mapped to
ECS fields where applicable and the remaining fields are written under
`zscaler_zpa.<data-stream-name>.*`.

## Setup steps

1. Enable the integration with the TCP input.
2. Configure the Zscaler LSS Log Receiver to send logs to the Elastic Agent
   that is running this integration. See [*Setup Log Receiver*](https://help.zscaler.com/zpa/configuring-log-receiver). Use the IP address/hostname of the Elastic Agent as the 'Log Receiver Domain or IP Address', and use the listening port of the Elastic Agent as the 'TCP Port' on the *Add Log Receiver* configuration screen.
3. *Please make sure to use the latest version of given response formats.*


## ZPA Log Receiver Setup

For detailed docs on setting up the ZPA log receiver, refer to the Zscaler documentation at
- [About the Log Streaming Service](https://help.zscaler.com/zpa/about-log-streaming-service)
- [Configuring a Log Receiver](https://help.zscaler.com/zpa/configuring-log-receiver)

**Domain or IP**: Use the IP address/hostname of the Elastic Agent

**TCP port**: Use the listening port of the Elastic Agent

## Compatibility

This package has been tested against `Zscaler Private Access Client Connector version 3.7.1.44`

## Documentation and configuration


### App Connector Status Logs

Default port: *9015*
Vendor documentation: 
Zscaler App Connector Status response format (v2):
```
{"LogTimestamp": %j{LogTimestamp:time},"Customer": %j{Customer},"SessionID": %j{SessionID},"SessionType": %j{SessionType},"SessionStatus": %j{SessionStatus},"Version": %j{Version},"Platform": %j{Platform},"ZEN": %j{ZEN},"Connector": %j{Connector},"ConnectorGroup": %j{ConnectorGroup},"PrivateIP": %j{PrivateIP},"PublicIP": %j{PublicIP},"Latitude": %f{Latitude},"Longitude": %f{Longitude},"CountryCode": %j{CountryCode},"TimestampAuthentication": %j{TimestampAuthentication:iso8601},"TimestampUnAuthentication": %j{TimestampUnAuthentication:iso8601},"CPUUtilization": %d{CPUUtilization},"MemUtilization": %d{MemUtilization},"ServiceCount": %d{ServiceCount},"InterfaceDefRoute": %j{InterfaceDefRoute},"DefRouteGW": %j{DefRouteGW},"PrimaryDNSResolver": %j{PrimaryDNSResolver},"HostStartTime": %j{HostStartTime},"ConnectorStartTime": %j{ConnectorStartTime},"NumOfInterfaces": %d{NumOfInterfaces},"BytesRxInterface": %d{BytesRxInterface},"PacketsRxInterface": %d{PacketsRxInterface},"ErrorsRxInterface": %d{ErrorsRxInterface},"DiscardsRxInterface": %d{DiscardsRxInterface},"BytesTxInterface": %d{BytesTxInterface},"PacketsTxInterface": %d{PacketsTxInterface},"ErrorsTxInterface": %d{ErrorsTxInterface},"DiscardsTxInterface": %d{DiscardsTxInterface},"TotalBytesRx": %d{TotalBytesRx},"TotalBytesTx": %d{TotalBytesTx}}\n
```

Sample Response:
```json
{"LogTimestamp":"Wed Jul 3 05:17:22 2019","Customer":"Safe March","SessionID":"8A64Qwj9zCkfYDGJVoUZ","SessionType":"ZPN_ASSISTANT_BROKER_CONTROL","SessionStatus":"ZPN_STATUS_AUTHENTICATED","Version":"19.20.3","Platform":"el7","ZEN":"US-NY-8179","Connector":"Seattle App Connector 1","ConnectorGroup":"Azure App Connectors","PrivateIP":"10.0.0.4","PublicIP":"0.0.0.0","Latitude":47,"Longitude":-122,"CountryCode":"","TimestampAuthentication":"2019-06-27T05:05:23.348Z","TimestampUnAuthentication":"","CPUUtilization":1,"MemUtilization":20,"ServiceCount":2,"InterfaceDefRoute":"eth0","DefRouteGW":"10.0.0.1","PrimaryDNSResolver":"168.63.129.16","HostStartTime":"1513229995","ConnectorStartTime":"1555920005","NumOfInterfaces":2,"BytesRxInterface":319831966346,"PacketsRxInterface":1617569938,"ErrorsRxInterface":0,"DiscardsRxInterface":0,"BytesTxInterface":192958782635,"PacketsTxInterface":1797471190,"ErrorsTxInterface":0,"DiscardsTxInterface":0,"TotalBytesRx":10902554,"TotalBytesTx":48931771}
```


### Audit Logs

Default port: *9016*
Vendor documentation: 
Zscaler Audit response format (v1):
```
{"ModifiedTime":%j{modifiedTime:iso8601},"CreationTime":%j{creationTime:iso8601},"ModifiedBy":%d{modifiedBy},"RequestID":%j{requestId},"SessionID":%j{sessionId},"AuditOldValue":%j{auditOldValue},"AuditNewValue":%j{auditNewValue},"AuditOperationType":%j{auditOperationType},"ObjectType":%j{objectType},"ObjectName":%j{objectName},"ObjectID":%d{objectId},"CustomerID":%d{customerId},"User":%j{modifiedByUser},"ClientAuditUpdate":%d{isClientAudit}}\n
```

Sample Response:
```json
{"ModifiedTime":"2021-11-17T04:29:38.000Z","CreationTime":"2021-11-17T04:29:38.000Z","ModifiedBy":12345678901234567,"RequestID":"11111111-1111-1111-1111-111111111111","SessionID":"1idn23nlfm2q1txa5h3r4mep6","AuditOldValue":"","AuditNewValue":"{\"id\":\"72058340288495701\",\"name\":\"Some-Name\",\"domainOrIpAddress\":\"1.0.0.1\",\"description\":\"This is a description field\",\"enabled\":\"true\"}","AuditOperationType":"Create","ObjectType":"Server","ObjectName":"Some-Name","ObjectID":12345678901234567,"CustomerID":98765432109876543,"User":"zpaadmin@xxxxxxxxxxxxxxxxx.zpa-customer.com","ClientAuditUpdate":0}
```


### Browser Access Logs

Default port: *9017*
Vendor documentation: 
Zscaler Browser Access response format (v1):
```
{"LogTimestamp":%j{LogTimestamp:time},"ConnectionID":%j{ConnectionID},"Exporter":%j{Exporter},"TimestampRequestReceiveStart":%j{TimestampRequestReceiveStart:iso8601},"TimestampRequestReceiveHeaderFinish":%j{TimestampRequestReceiveHeaderFinish:iso8601},"TimestampRequestReceiveFinish":%j{TimestampRequestReceiveFinish:iso8601},"TimestampRequestTransmitStart":%j{TimestampRequestTransmitStart:iso8601},"TimestampRequestTransmitFinish":%j{TimestampRequestTransmitFinish:iso8601},"TimestampResponseReceiveStart":%j{TimestampResponseReceiveStart:iso8601},"TimestampResponseReceiveFinish":%j{TimestampResponseReceiveFinish:iso8601},"TimestampResponseTransmitStart":%j{TimestampResponseTransmitStart:iso8601},"TimestampResponseTransmitFinish":%j{TimestampResponseTransmitFinish:iso8601},"TotalTimeRequestReceive":%d{TotalTimeRequestReceive},"TotalTimeRequestTransmit":%d{TotalTimeRequestTransmit},"TotalTimeResponseReceive":%d{TotalTimeResponseReceive},"TotalTimeResponseTransmit":%d{TotalTimeResponseTransmit},"TotalTimeConnectionSetup":%d{TotalTimeConnectionSetup},"TotalTimeServerResponse":%d{TotalTimeServerResponse},"Method":%j{Method},"Protocol":%j{Protocol},"Host":%j{Host},"URL":%j{URL},"UserAgent":%j{UserAgent},"XFF":%j{XFF},"NameID":%j{NameID},"StatusCode":%d{StatusCode},"RequestSize":%d{RequestSize},"ResponseSize":%d{ResponseSize},"ApplicationPort":%d{ApplicationPort},"ClientPublicIp":%j{ClientPublicIp},"ClientPublicPort":%d{ClientPublicPort},"ClientPrivateIp":%j{ClientPrivateIp},"Customer":%j{Customer},"ConnectionStatus":%j{ConnectionStatus},"ConnectionReason":%j{ConnectionReason},"Origin":%j{Origin},"CorsToken":%j{CorsToken}}\n
```

Sample Response:
```json
{"LogTimestamp":"Wed Jul 3 05:12:25 2019","ConnectionID":"","Exporter":"unset","TimestampRequestReceiveStart":"2019-07-03T05:12:25.723Z","TimestampRequestReceiveHeaderFinish":"2019-07-03T05:12:25.723Z","TimestampRequestReceiveFinish":"2019-07-03T05:12:25.723Z","TimestampRequestTransmitStart":"2019-07-03T05:12:25.790Z","TimestampRequestTransmitFinish":"2019-07-03T05:12:25.790Z","TimestampResponseReceiveStart":"2019-07-03T05:12:25.791Z","TimestampResponseReceiveFinish":"2019-07-03T05:12:25.791Z","TimestampResponseTransmitStart":"2019-07-03T05:12:25.791Z","TimestampResponseTransmitFinish":"2019-07-03T05:12:25.791Z","TotalTimeRequestReceive":127,"TotalTimeRequestTransmit":21,"TotalTimeResponseReceive":73,"TotalTimeResponseTransmit":13,"TotalTimeConnectionSetup":66995,"TotalTimeServerResponse":1349,"Method":"GET","Protocol":"HTTPS","Host":"portal.beta.zdemo.net","URL":"/media/Regular.woff","UserAgent":"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1.1 Safari/605.1.15","XFF":"","NameID":"admin@zdemo.net","StatusCode":304,"RequestSize":615,"ResponseSize":331,"ApplicationPort":443,"ClientPublicIp":"175.16.199.1","ClientPublicPort":60006,"ClientPrivateIp":"","Customer":"ANZ Team/zdemo in beta","ConnectionStatus":"","ConnectionReason":""}
```


### User Activity Logs

Default port: *9018*
Vendor documentation: 
Zscaler User Activity response format (v1):
```
{"LogTimestamp": %j{LogTimestamp:time},"Customer": %j{Customer},"SessionID": %j{SessionID},"ConnectionID": %j{ConnectionID},"InternalReason": %j{InternalReason},"ConnectionStatus": %j{ConnectionStatus},"IPProtocol": %d{IPProtocol},"DoubleEncryption": %d{DoubleEncryption},"Username": %j{Username},"ServicePort": %d{ServicePort},"ClientPublicIP": %j{ClientPublicIP},"ClientPrivateIP": %j{ClientPrivateIP},"ClientLatitude": %f{ClientLatitude},"ClientLongitude": %f{ClientLongitude},"ClientCountryCode": %j{ClientCountryCode},"ClientZEN": %j{ClientZEN},"Policy": %j{Policy},"Connector": %j{Connector},"ConnectorZEN": %j{ConnectorZEN},"ConnectorIP": %j{ConnectorIP},"ConnectorPort": %d{ConnectorPort},"Host": %j{Host},"Application": %j{Application},"AppGroup": %j{AppGroup},"Server": %j{Server},"ServerIP": %j{ServerIP},"ServerPort": %d{ServerPort},"PolicyProcessingTime": %d{PolicyProcessingTime},"ServerSetupTime": %d{ServerSetupTime},"TimestampConnectionStart": %j{TimestampConnectionStart:iso8601},"TimestampConnectionEnd": %j{TimestampConnectionEnd:iso8601},"TimestampCATx": %j{TimestampCATx:iso8601},"TimestampCARx": %j{TimestampCARx:iso8601},"TimestampAppLearnStart": %j{TimestampAppLearnStart:iso8601},"TimestampZENFirstRxClient": %j{TimestampZENFirstRxClient:iso8601},"TimestampZENFirstTxClient": %j{TimestampZENFirstTxClient:iso8601},"TimestampZENLastRxClient": %j{TimestampZENLastRxClient:iso8601},"TimestampZENLastTxClient": %j{TimestampZENLastTxClient:iso8601},"TimestampConnectorZENSetupComplete": %j{TimestampConnectorZENSetupComplete:iso8601},"TimestampZENFirstRxConnector": %j{TimestampZENFirstRxConnector:iso8601},"TimestampZENFirstTxConnector": %j{TimestampZENFirstTxConnector:iso8601},"TimestampZENLastRxConnector": %j{TimestampZENLastRxConnector:iso8601},"TimestampZENLastTxConnector": %j{TimestampZENLastTxConnector:iso8601},"ZENTotalBytesRxClient": %d{ZENTotalBytesRxClient},"ZENBytesRxClient": %d{ZENBytesRxClient},"ZENTotalBytesTxClient": %d{ZENTotalBytesTxClient},"ZENBytesTxClient": %d{ZENBytesTxClient},"ZENTotalBytesRxConnector": %d{ZENTotalBytesRxConnector},"ZENBytesRxConnector": %d{ZENBytesRxConnector},"ZENTotalBytesTxConnector": %d{ZENTotalBytesTxConnector},"ZENBytesTxConnector": %d{ZENBytesTxConnector},"Idp": %j{Idp},"ClientToClient": %j{c2c},"ConnectorZENSetupTime":%d{ConnectorZENSetupTime},"ConnectionSetupTime":%d{ConnectionSetupTime}}\n
```

Sample Response:
```json
{"LogTimestamp": "Fri May 31 17:35:42 2019","Customer": "Customer XYZ","SessionID": "LHJdkjmNDf12nclBsvwA","ConnectionID": "SqyZIMkg0JTj7EABsvwA,Q+EjXGdrvbF2lPiBbedm","InternalReason": "","ConnectionStatus": "active","IPProtocol": 6,"DoubleEncryption": 0,"Username": "ZPA LSS Client","ServicePort": 10011,"ClientPublicIP": "81.2.69.193","ClientPrivateIP": "","ClientLatitude": 45.000000,"ClientLongitude": -119.000000,"ClientCountryCode": "US","ClientZEN": "broker2b.pdx","Policy": "ANZ Lab Apps","Connector": "ZDEMO ANZ","ConnectorZEN": "broker2b.pdx","ConnectorIP": "67.43.156.12","ConnectorPort": 60266,"Host": "175.16.199.1","Application": "ANZ Lab Apps","AppGroup": "ANZ Lab Apps","Server": "0","ServerIP": "175.16.199.1","ServerPort": 10011,"PolicyProcessingTime": 28,"CAProcessingTime": 1330,"ServerSetupTime": 465,"AppLearnTime": 0,"TimestampConnectionStart": "2019-05-30T08:20:42.230Z","TimestampConnectionEnd": "","TimestampCATx": "2019-05-30T08:20:42.230Z","TimestampCARx": "2019-05-30T08:20:42.231Z","TimestampAppLearnStart": "","TimestampZENFirstRxClient": "2019-05-30T08:20:42.424Z","TimestampZENFirstTxClient": "","TimestampZENLastRxClient": "2019-05-31T17:34:27.348Z","TimestampZENLastTxClient": "","TimestampConnectorZENSetupComplete": "2019-05-30T08:20:42.422Z","TimestampZENFirstRxConnector": "","TimestampZENFirstTxConnector": "2019-05-30T08:20:42.424Z","TimestampZENLastRxConnector": "","TimestampZENLastTxConnector": "2019-05-31T17:34:27.348Z","ZENTotalBytesRxClient": 2406926,"ZENBytesRxClient": 7115,"ZENTotalBytesTxClient": 0,"ZENBytesTxClient": 0,"ZENTotalBytesRxConnector": 0,"ZENBytesRxConnector": 0,"ZENTotalBytesTxConnector": 2406926,"ZENBytesTxConnector": 7115,"Idp": "Example IDP Config","ConnectorZENSetupTime":1640674274,"ConnectionSetupTime":1640675274}
```

<note>
  In order to populate *Slowest Applications* (visualization); *"ConnectorZENSetupTime"* and *"ConnectionSetupTime"* fields are added into the default response format of Zscaler User Activity Log above.
</note>


### User Status Logs

Default port: *9019*
Vendor documentation: 
Zscaler User Status response format (v2):
```
{"LogTimestamp": %j{LogTimestamp:time},"Customer": %j{Customer},"Username": %j{Username},"SessionID": %j{SessionID},"SessionStatus": %j{SessionStatus},"Version": %j{Version},"ZEN": %j{ZEN},"CertificateCN": %j{CertificateCN},"PrivateIP": %j{PrivateIP},"PublicIP": %j{PublicIP},"Latitude": %f{Latitude},"Longitude": %f{Longitude},"CountryCode": %j{CountryCode},"TimestampAuthentication": %j{TimestampAuthentication:iso8601},"TimestampUnAuthentication": %j{TimestampUnAuthentication:iso8601},"TotalBytesRx": %d{TotalBytesRx},"TotalBytesTx": %d{TotalBytesTx},"Idp": %j{Idp},"Hostname": %j{Hostname},"Platform": %j{Platform},"ClientType": %j{ClientType},"TrustedNetworks": [%j(,){TrustedNetworks}],"TrustedNetworksNames": [%j(,){TrustedNetworksNames}],"SAMLAttributes": %j{SAMLAttributes},"PosturesHit": [%j(,){PosturesHit}],"PosturesMiss": [%j(,){PosturesMiss}],"ZENLatitude": %f{ZENLatitude},"ZENLongitude": %f{ZENLongitude},"ZENCountryCode": %j{ZENCountryCode},"FQDNRegistered": %j{FQDNRegistered},"FQDNRegisteredError": %j{FQDNRegisteredError}}\n
```

Sample Response:
```json
{"LogTimestamp":"Fri May 31 17:34:48 2019","Customer":"Customer XYZ","Username":"ZPA LSS Client","SessionID":"vkczUERSLl88Y+ytH8v5","SessionStatus":"ZPN_STATUS_AUTHENTICATED","Version":"19.12.0-36-g87dad18","ZEN":"broker2b.pdx","CertificateCN":"loggerz2x.pde.zpabeta.net","PrivateIP":"","PublicIP":"81.2.69.144","Latitude":45,"Longitude":-119,"CountryCode":"US","TimestampAuthentication":"2019-05-29T21:18:38.000Z","TimestampUnAuthentication":"","TotalBytesRx":31274866,"TotalBytesTx":25424152,"Idp":"IDP Config","Hostname":"DESKTOP-99HCSJ1","Platform":"windows","ClientType":"zpn_client_type_zapp","TrustedNetworks":"TN1_stc1","TrustedNetworksNames":"145248739466696953","SAMLAttributes":"myname:user,myemail:user@zscaler.com","PosturesHit":"sm-posture1,sm-posture2","PosturesMiss":"sm-posture11,sm-posture12","ZENLatitude":47,"ZENLongitude":-122,"ZENCountryCode":""}
```


## Fields and Sample Event


### App Connector Status Logs

<dropdown title="Exported fields">
  | Field                                                           | Description                                                                                                           | Type             |
  |-----------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                      | Event timestamp.                                                                                                      | date             |
  | data_stream.dataset                                             | Data stream dataset.                                                                                                  | constant_keyword |
  | data_stream.namespace                                           | Data stream namespace.                                                                                                | constant_keyword |
  | data_stream.type                                                | Data stream type.                                                                                                     | constant_keyword |
  | event.dataset                                                   | Event dataset                                                                                                         | constant_keyword |
  | event.module                                                    | Event module                                                                                                          | constant_keyword |
  | input.type                                                      | Type of filebeat input.                                                                                               | keyword          |
  | log.offset                                                      | Log offset.                                                                                                           | long             |
  | log.source.address                                              | Source address from which the log event was read / sent from.                                                         | keyword          |
  | zscaler_zpa.app_connector_status.connector.group                | The App Connector group name.                                                                                         | keyword          |
  | zscaler_zpa.app_connector_status.connector.name                 | The App Connector name.                                                                                               | keyword          |
  | zscaler_zpa.app_connector_status.connector_start_time           | Time in seconds at which App Connector was started.                                                                   | date             |
  | zscaler_zpa.app_connector_status.host_start_time                | Time in seconds at which host was started.                                                                            | date             |
  | zscaler_zpa.app_connector_status.interface.name                 | The name of the interface to default route.                                                                           | keyword          |
  | zscaler_zpa.app_connector_status.interface.received.bytes       | The bytes received on the interface.                                                                                  | double           |
  | zscaler_zpa.app_connector_status.interface.received.discards    | The discards received on the interface.                                                                               | double           |
  | zscaler_zpa.app_connector_status.interface.received.errors      | The errors received on the interface.                                                                                 | double           |
  | zscaler_zpa.app_connector_status.interface.received.packets     | The packets received on the interface.                                                                                | double           |
  | zscaler_zpa.app_connector_status.interface.transmitted.bytes    | The bytes transmitted on the interface.                                                                               | double           |
  | zscaler_zpa.app_connector_status.interface.transmitted.discards | The discards transmitted on the interface.                                                                            | double           |
  | zscaler_zpa.app_connector_status.interface.transmitted.errors   | The errors transmitted on the interface.                                                                              | double           |
  | zscaler_zpa.app_connector_status.interface.transmitted.packets  | The packets transmitted on the interface.                                                                             | double           |
  | zscaler_zpa.app_connector_status.memory.utilization             | The memory utilization in %.                                                                                          | double           |
  | zscaler_zpa.app_connector_status.num_of_interfaces              | The number of interfaces on the App Connector host.                                                                   | double           |
  | zscaler_zpa.app_connector_status.primary_dns_resolver           | The IP address of the primary DNS resolver.                                                                           | ip               |
  | zscaler_zpa.app_connector_status.private_ip                     | The private IP address of the App Connector.                                                                          | ip               |
  | zscaler_zpa.app_connector_status.service.count                  | The number of services (combinations of domains/IP addresses and TCP/UDP ports) being monitored by the App Connector. | double           |
  | zscaler_zpa.app_connector_status.session.id                     | The TLS session ID.                                                                                                   | keyword          |
  | zscaler_zpa.app_connector_status.session.status                 | The status of the session.                                                                                            | keyword          |
  | zscaler_zpa.app_connector_status.session.type                   | The type of session.                                                                                                  | keyword          |
  | zscaler_zpa.app_connector_status.timestamp.authentication       | Timestamp in microseconds when the App Connector was authenticated.                                                   | date             |
  | zscaler_zpa.app_connector_status.timestamp.unauthentication     | Timestamp in microseconds when the App Connector was unauthenticated.                                                 | date             |
  | zscaler_zpa.app_connector_status.zen                            | The TLS session ID.                                                                                                   | keyword          |
</dropdown>

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2019-07-03T05:17:22.000Z",
      "agent": {
          "ephemeral_id": "a668f81e-2848-4d79-95ef-1ecd5a6d332c",
          "id": "85fbad05-ff47-41ab-b16e-b299c3b10b39",
          "name": "elastic-agent-11095",
          "type": "filebeat",
          "version": "8.13.0"
      },
      "client": {
          "nat": {
              "ip": "10.0.0.1"
          }
      },
      "data_stream": {
          "dataset": "zscaler_zpa.app_connector_status",
          "namespace": "67128",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "85fbad05-ff47-41ab-b16e-b299c3b10b39",
          "snapshot": false,
          "version": "8.13.0"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "package"
          ],
          "dataset": "zscaler_zpa.app_connector_status",
          "ingested": "2025-09-16T07:32:52Z",
          "kind": "event",
          "original": "{\"LogTimestamp\":\"Wed Jul 3 05:17:22 2019\",\"Customer\":\"Customer Name\",\"SessionID\":\"8A64Qwj9zCkfYDGJVoUZ\",\"SessionType\":\"ZPN_ASSISTANT_BROKER_CONTROL\",\"SessionStatus\":\"ZPN_STATUS_AUTHENTICATED\",\"Version\":\"19.20.3\",\"Platform\":\"el7\",\"ZEN\":\"US-NY-8179\",\"Connector\":\"Some App Connector\",\"ConnectorGroup\":\"Some App Connector Group\",\"PrivateIP\":\"10.0.0.4\",\"PublicIP\":\"0.0.0.0\",\"Latitude\":47,\"Longitude\":-122,\"CountryCode\":\"\",\"TimestampAuthentication\":\"2019-06-27T05:05:23.348Z\",\"TimestampUnAuthentication\":\"\",\"CPUUtilization\":1,\"MemUtilization\":20,\"ServiceCount\":2,\"InterfaceDefRoute\":\"eth0\",\"DefRouteGW\":\"10.0.0.1\",\"PrimaryDNSResolver\":\"168.63.129.16\",\"HostStartTime\":\"1513229995\",\"ConnectorStartTime\":\"1555920005\",\"NumOfInterfaces\":2,\"BytesRxInterface\":319831966346,\"PacketsRxInterface\":1617569938,\"ErrorsRxInterface\":0,\"DiscardsRxInterface\":0,\"BytesTxInterface\":192958782635,\"PacketsTxInterface\":1797471190,\"ErrorsTxInterface\":0,\"DiscardsTxInterface\":0,\"TotalBytesRx\":10902554,\"TotalBytesTx\":48931771}",
          "type": [
              "info"
          ]
      },
      "host": {
          "cpu": {
              "usage": 1
          },
          "network": {
              "egress": {
                  "bytes": 48931771
              },
              "ingress": {
                  "bytes": 10902554
              }
          }
      },
      "input": {
          "type": "tcp"
      },
      "log": {
          "source": {
              "address": "172.21.0.3:43448"
          }
      },
      "observer": {
          "geo": {
              "location": {
                  "lat": 47,
                  "lon": -122
              }
          },
          "ip": [
              "0.0.0.0"
          ],
          "os": {
              "platform": "el7"
          },
          "type": "forwarder",
          "version": "19.20.3"
      },
      "organization": {
          "name": "Customer Name"
      },
      "related": {
          "ip": [
              "10.0.0.1",
              "0.0.0.0",
              "10.0.0.4",
              "168.63.129.16"
          ]
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "zscaler_zpa-app_connectors_status"
      ],
      "zscaler_zpa": {
          "app_connector_status": {
              "connector": {
                  "group": "Some App Connector Group",
                  "name": "Some App Connector"
              },
              "connector_start_time": "2019-04-22T08:00:05.000Z",
              "host_start_time": "2017-12-14T05:39:55.000Z",
              "interface": {
                  "name": "eth0",
                  "received": {
                      "bytes": 319831966346,
                      "discards": 0,
                      "errors": 0,
                      "packets": 1617569938
                  },
                  "transmitted": {
                      "bytes": 192958782635,
                      "discards": 0,
                      "errors": 0,
                      "packets": 1797471190
                  }
              },
              "memory": {
                  "utilization": 20
              },
              "num_of_interfaces": 2,
              "primary_dns_resolver": "168.63.129.16",
              "private_ip": "10.0.0.4",
              "service": {
                  "count": 2
              },
              "session": {
                  "id": "8A64Qwj9zCkfYDGJVoUZ",
                  "status": "ZPN_STATUS_AUTHENTICATED",
                  "type": "ZPN_ASSISTANT_BROKER_CONTROL"
              },
              "timestamp": {
                  "authentication": "2019-06-27T05:05:23.348Z"
              },
              "zen": "US-NY-8179"
          }
      }
  }
  ```
</dropdown>


## Audit Logs

<dropdown title="Exported fields">
  | Field                                 | Description                                                                                                                | Type             |
  |---------------------------------------|----------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                            | Event timestamp.                                                                                                           | date             |
  | data_stream.dataset                   | Data stream dataset.                                                                                                       | constant_keyword |
  | data_stream.namespace                 | Data stream namespace.                                                                                                     | constant_keyword |
  | data_stream.type                      | Data stream type.                                                                                                          | constant_keyword |
  | event.dataset                         | Event dataset                                                                                                              | constant_keyword |
  | event.module                          | Event module                                                                                                               | constant_keyword |
  | input.type                            | Type of filebeat input.                                                                                                    | keyword          |
  | log.offset                            | Log offset.                                                                                                                | long             |
  | log.source.address                    | Source address from which the log event was read / sent from.                                                              | keyword          |
  | zscaler_zpa.audit.client_audit_update | The flag to represent if the event is a client Audit log.                                                                  | long             |
  | zscaler_zpa.audit.object.id           | The ID associated with the object name.                                                                                    | keyword          |
  | zscaler_zpa.audit.object.name         | The name of the object. This corresponds to the Resource Name in the Audit Log page.                                       | keyword          |
  | zscaler_zpa.audit.object.type         | The location within the ZPA Admin Portal where the Action was performed.                                                   | keyword          |
  | zscaler_zpa.audit.operation_type      | The type of action performed.                                                                                              | keyword          |
  | zscaler_zpa.audit.session.id          | The ID for the administrator's session in the ZPA Admin Portal. This corresponds to a successful sign in action occurring. | keyword          |
  | zscaler_zpa.audit.value.new           | The new value that was changed if the action type is create, sign in, or update.                                           | flattened        |
  | zscaler_zpa.audit.value.old           | The previous value that was changed if the action type is delete, sign out, or update.                                     | flattened        |
</dropdown>

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2021-11-17T04:29:38.000Z",
      "agent": {
          "ephemeral_id": "44b51929-01cc-40e0-9f61-1cd201dfb5f1",
          "id": "2a639f99-de36-4f57-92a5-c693d32d599d",
          "name": "elastic-agent-52871",
          "type": "filebeat",
          "version": "8.13.0"
      },
      "data_stream": {
          "dataset": "zscaler_zpa.audit",
          "namespace": "69804",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "2a639f99-de36-4f57-92a5-c693d32d599d",
          "snapshot": false,
          "version": "8.13.0"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "iam"
          ],
          "created": "2021-11-17T04:29:38.000Z",
          "dataset": "zscaler_zpa.audit",
          "id": "11111111-1111-1111-1111-111111111111",
          "ingested": "2025-09-16T07:33:42Z",
          "kind": "event",
          "original": "{\"ModifiedTime\":\"2021-11-17T04:29:38.000Z\",\"CreationTime\":\"2021-11-17T04:29:38.000Z\",\"ModifiedBy\":12345678901234567,\"RequestID\":\"11111111-1111-1111-1111-111111111111\",\"SessionID\":\"1idn23nlfm2q1txa5h3r4mep6\",\"AuditOldValue\":\"\",\"AuditNewValue\":\"{\\\"id\\\":\\\"72058340288495701\\\",\\\"name\\\":\\\"Some-Name\\\",\\\"domainOrIpAddress\\\":\\\"1.0.0.1\\\",\\\"description\\\":\\\"This is a description field\\\",\\\"enabled\\\":\\\"true\\\"}\",\"AuditOperationType\":\"Create\",\"ObjectType\":\"Server\",\"ObjectName\":\"Some-Name\",\"ObjectID\":12345678901234567,\"CustomerID\":98765432109876543,\"User\":\"zpaadmin@xxxxxxxxxxxxxxxxx.zpa-customer.com\",\"ClientAuditUpdate\":0}",
          "outcome": "success",
          "type": [
              "creation"
          ]
      },
      "input": {
          "type": "tcp"
      },
      "log": {
          "source": {
              "address": "172.21.0.3:49510"
          }
      },
      "organization": {
          "id": "98765432109876543"
      },
      "related": {
          "ip": [
              "1.0.0.1"
          ],
          "user": [
              "12345678901234567",
              "zpaadmin",
              "zpaadmin@xxxxxxxxxxxxxxxxx.zpa-customer.com"
          ]
      },
      "server": {
          "address": "1.0.0.1",
          "ip": "1.0.0.1"
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "zscaler_zpa-audit"
      ],
      "user": {
          "domain": "xxxxxxxxxxxxxxxxx.zpa-customer.com",
          "email": "zpaadmin@xxxxxxxxxxxxxxxxx.zpa-customer.com",
          "id": "12345678901234567",
          "name": "zpaadmin"
      },
      "zscaler_zpa": {
          "audit": {
              "client_audit_update": 0,
              "object": {
                  "id": "12345678901234567",
                  "name": "Some-Name",
                  "type": "Server"
              },
              "operation_type": "Create",
              "session": {
                  "id": "1idn23nlfm2q1txa5h3r4mep6"
              },
              "value": {
                  "new": {
                      "description": "This is a description field",
                      "domainOrIpAddress": "1.0.0.1",
                      "enabled": "true",
                      "id": "72058340288495701",
                      "name": "Some-Name"
                  }
              }
          }
      }
  }
  ```
</dropdown>


## Browser Access Logs

<dropdown title="Exported fields">
  | Field                                                              | Description                                                                                                                                                                                                   | Type             |
  |--------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                         | Event timestamp.                                                                                                                                                                                              | date             |
  | data_stream.dataset                                                | Data stream dataset.                                                                                                                                                                                          | constant_keyword |
  | data_stream.namespace                                              | Data stream namespace.                                                                                                                                                                                        | constant_keyword |
  | data_stream.type                                                   | Data stream type.                                                                                                                                                                                             | constant_keyword |
  | event.dataset                                                      | Event dataset                                                                                                                                                                                                 | constant_keyword |
  | event.module                                                       | Event module                                                                                                                                                                                                  | constant_keyword |
  | input.type                                                         | Type of filebeat input.                                                                                                                                                                                       | keyword          |
  | log.offset                                                         | Log offset.                                                                                                                                                                                                   | long             |
  | log.source.address                                                 | Source address from which the log event was read / sent from.                                                                                                                                                 | keyword          |
  | zscaler_zpa.browser_access.client_private_ip                       | The private IP address of the user's device.                                                                                                                                                                  | ip               |
  | zscaler_zpa.browser_access.connection.id                           | The application connection ID.                                                                                                                                                                                | keyword          |
  | zscaler_zpa.browser_access.connection.status                       | The status of the connection.                                                                                                                                                                                 | keyword          |
  | zscaler_zpa.browser_access.cors_token                              | The token from the CORS request.                                                                                                                                                                              | keyword          |
  | zscaler_zpa.browser_access.exporter                                | The Browser Access Service instance to ZPA Public Service Edge or ZPA Private Service Edge instance.                                                                                                          | keyword          |
  | zscaler_zpa.browser_access.origin                                  | The Browser Access domain that led to the origination of the CORS request.                                                                                                                                    | keyword          |
  | zscaler_zpa.browser_access.timestamp.request.receive.finish        | Timestamp in microseconds when Browser Access Service received the last byte of the HTTP request from web browser.                                                                                            | date             |
  | zscaler_zpa.browser_access.timestamp.request.receive.header_finish | Timestamp in microseconds when Browser Access Service received the last byte of the HTTP header corresponding to the request from web browser.                                                                | date             |
  | zscaler_zpa.browser_access.timestamp.request.receive.start         | Timestamp in microseconds when Browser Access Service received the first byte of the HTTP request from web browser.                                                                                           | date             |
  | zscaler_zpa.browser_access.timestamp.request.transmit.finish       | Timestamp in microseconds when Browser Access Service sent the last byte of the HTTP request to the web server.                                                                                               | date             |
  | zscaler_zpa.browser_access.timestamp.request.transmit.start        | Timestamp in microseconds when Browser Access Service sent the first byte of the HTTP request to the web server.                                                                                              | date             |
  | zscaler_zpa.browser_access.timestamp.response.receive.finish       | Timestamp in microseconds when Browser Access Service received the last byte of the HTTP response from the web server.                                                                                        | date             |
  | zscaler_zpa.browser_access.timestamp.response.receive.start        | Timestamp in microseconds when Browser Access Service received the first byte of the HTTP response from the web server.                                                                                       | date             |
  | zscaler_zpa.browser_access.timestamp.response.transmit.finish      | Timestamp in microseconds when Browser Access Service sent the last byte of the HTTP response to the web browser.                                                                                             | date             |
  | zscaler_zpa.browser_access.timestamp.response.transmit.start       | Timestamp in microseconds when Browser Access Service sent the first byte of the HTTP response to the web browser.                                                                                            | date             |
  | zscaler_zpa.browser_access.total_time.connection.setup             | Time difference between reception of the first byte of the HTTP request from web browser and transmission of the first byte towards the web server, as seen by the Browser Access Service.                    | long             |
  | zscaler_zpa.browser_access.total_time.request.receive              | Time difference between reception of the first and last byte of the HTTP request from the web browser as seen by the Browser Access Service.                                                                  | long             |
  | zscaler_zpa.browser_access.total_time.request.transmit             | Time difference between transmission of the first and last byte of the HTTP request towards the web server as seen by the Browser Access Service.                                                             | long             |
  | zscaler_zpa.browser_access.total_time.response.receive             | Time difference between reception of the first and last byte of the HTTP response from the web server as seen by the Browser Access Service.                                                                  | long             |
  | zscaler_zpa.browser_access.total_time.response.transmit            | Time difference between transmission of the first and last byte of the HTTP request towards the web server as seen by the Browser Access Service.                                                             | long             |
  | zscaler_zpa.browser_access.total_time.server.response              | Time difference between transmission of the last byte of the HTTP request towards the web server and reception of the first byte of the HTTP response from web server, as seen by the Browser Access Service. | long             |
  | zscaler_zpa.browser_access.xff                                     | The X-Forwarded-For (XFF) HTTP header.                                                                                                                                                                        | keyword          |
</dropdown>

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2019-07-03T05:12:25.000Z",
      "agent": {
          "ephemeral_id": "4f05f964-ac22-415a-b61a-751c5dd904dc",
          "id": "da5dbc19-3716-438a-84f1-667080bf03f1",
          "name": "elastic-agent-72091",
          "type": "filebeat",
          "version": "8.13.0"
      },
      "client": {
          "geo": {
              "city_name": "London",
              "continent_name": "Europe",
              "country_iso_code": "GB",
              "country_name": "United Kingdom",
              "location": {
                  "lat": 51.5142,
                  "lon": -0.0931
              },
              "region_iso_code": "GB-ENG",
              "region_name": "England"
          },
          "ip": "81.2.69.144",
          "port": 60006
      },
      "data_stream": {
          "dataset": "zscaler_zpa.browser_access",
          "namespace": "88779",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "da5dbc19-3716-438a-84f1-667080bf03f1",
          "snapshot": false,
          "version": "8.13.0"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "network",
              "session"
          ],
          "dataset": "zscaler_zpa.browser_access",
          "ingested": "2025-09-16T07:34:33Z",
          "kind": "event",
          "original": "{\"LogTimestamp\":\"Wed Jul 3 05:12:25 2019\",\"ConnectionID\":\"\",\"Exporter\":\"unset\",\"TimestampRequestReceiveStart\":\"2019-07-03T05:12:25.723Z\",\"TimestampRequestReceiveHeaderFinish\":\"2019-07-03T05:12:25.723Z\",\"TimestampRequestReceiveFinish\":\"2019-07-03T05:12:25.723Z\",\"TimestampRequestTransmitStart\":\"2019-07-03T05:12:25.790Z\",\"TimestampRequestTransmitFinish\":\"2019-07-03T05:12:25.790Z\",\"TimestampResponseReceiveStart\":\"2019-07-03T05:12:25.791Z\",\"TimestampResponseReceiveFinish\":\"2019-07-03T05:12:25.791Z\",\"TimestampResponseTransmitStart\":\"2019-07-03T05:12:25.791Z\",\"TimestampResponseTransmitFinish\":\"2019-07-03T05:12:25.791Z\",\"TotalTimeRequestReceive\":127,\"TotalTimeRequestTransmit\":21,\"TotalTimeResponseReceive\":73,\"TotalTimeResponseTransmit\":13,\"TotalTimeConnectionSetup\":66995,\"TotalTimeServerResponse\":1349,\"Method\":\"GET\",\"Protocol\":\"HTTPS\",\"Host\":\"portal.beta.zdemo.net\",\"URL\":\"/media/Regular.woff\",\"UserAgent\":\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1.1 Safari/605.1.15\",\"XFF\":\"\",\"NameID\":\"admin@zdemo.net\",\"StatusCode\":304,\"RequestSize\":615,\"ResponseSize\":331,\"ApplicationPort\":443,\"ClientPublicIp\":\"81.2.69.144\",\"ClientPublicPort\":60006,\"ClientPrivateIp\":\"81.2.69.193\",\"Customer\":\"ANZ Team/zdemo in beta\",\"ConnectionStatus\":\"\",\"ConnectionReason\":\"\"}",
          "type": [
              "connection"
          ]
      },
      "http": {
          "request": {
              "body": {
                  "bytes": 615
              },
              "method": "GET"
          },
          "response": {
              "body": {
                  "bytes": 331
              },
              "status_code": 304
          }
      },
      "input": {
          "type": "tcp"
      },
      "log": {
          "source": {
              "address": "172.21.0.3:51684"
          }
      },
      "organization": {
          "name": "ANZ Team/zdemo in beta"
      },
      "related": {
          "ip": [
              "81.2.69.144",
              "81.2.69.193"
          ],
          "user": [
              "admin",
              "admin@zdemo.net"
          ]
      },
      "server": {
          "address": "portal.beta.zdemo.net",
          "port": 443
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "zscaler_zpa-browser_access"
      ],
      "url": {
          "domain": "portal.beta.zdemo.net",
          "extension": "woff",
          "original": "https://portal.beta.zdemo.net/media/regular.woff",
          "path": "/media/regular.woff",
          "scheme": "https"
      },
      "user": {
          "domain": "zdemo.net",
          "email": "admin@zdemo.net",
          "name": "admin"
      },
      "user_agent": {
          "device": {
              "name": "Mac"
          },
          "name": "Safari",
          "original": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1.1 Safari/605.1.15",
          "os": {
              "full": "Mac OS X 10.14.5",
              "name": "Mac OS X",
              "version": "10.14.5"
          },
          "version": "12.1.1"
      },
      "zscaler_zpa": {
          "browser_access": {
              "client_private_ip": "81.2.69.193",
              "exporter": "unset",
              "timestamp": {
                  "request": {
                      "receive": {
                          "finish": "2019-07-03T05:12:25.723Z",
                          "header_finish": "2019-07-03T05:12:25.723Z",
                          "start": "2019-07-03T05:12:25.723Z"
                      },
                      "transmit": {
                          "finish": "2019-07-03T05:12:25.790Z",
                          "start": "2019-07-03T05:12:25.790Z"
                      }
                  },
                  "response": {
                      "receive": {
                          "finish": "2019-07-03T05:12:25.791Z",
                          "start": "2019-07-03T05:12:25.791Z"
                      },
                      "transmit": {
                          "finish": "2019-07-03T05:12:25.791Z",
                          "start": "2019-07-03T05:12:25.791Z"
                      }
                  }
              },
              "total_time": {
                  "connection": {
                      "setup": 66995
                  },
                  "request": {
                      "receive": 127,
                      "transmit": 21
                  },
                  "response": {
                      "receive": 73,
                      "transmit": 13
                  },
                  "server": {
                      "response": 1349
                  }
              }
          }
      }
  }
  ```
</dropdown>


## User Activity Logs

<dropdown title="Exported fields">
  | Field                                                            | Description                                                                                                                                                                                                                                                                                | Type             |
  |------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                       | Event timestamp.                                                                                                                                                                                                                                                                           | date             |
  | data_stream.dataset                                              | Data stream dataset.                                                                                                                                                                                                                                                                       | constant_keyword |
  | data_stream.namespace                                            | Data stream namespace.                                                                                                                                                                                                                                                                     | constant_keyword |
  | data_stream.type                                                 | Data stream type.                                                                                                                                                                                                                                                                          | constant_keyword |
  | event.dataset                                                    | Event dataset                                                                                                                                                                                                                                                                              | constant_keyword |
  | event.module                                                     | Event module                                                                                                                                                                                                                                                                               | constant_keyword |
  | input.type                                                       | Type of filebeat input.                                                                                                                                                                                                                                                                    | keyword          |
  | log.offset                                                       | Log offset.                                                                                                                                                                                                                                                                                | long             |
  | log.source.address                                               | Source address from which the log event was read / sent from.                                                                                                                                                                                                                              | keyword          |
  | zscaler_zpa.user_activity.app_group                              | The application group name.                                                                                                                                                                                                                                                                | keyword          |
  | zscaler_zpa.user_activity.app_learn_time                         | Time in microseconds taken for App Connectors to learn about the requested application and report the learned information to the central authority.                                                                                                                                        | long             |
  | zscaler_zpa.user_activity.application                            | The application name.                                                                                                                                                                                                                                                                      | keyword          |
  | zscaler_zpa.user_activity.ca_processing_time                     | Time in microseconds taken for processing in the central authority.                                                                                                                                                                                                                        | long             |
  | zscaler_zpa.user_activity.client_private_ip                      | The private IP address of the Zscaler Client Connector.                                                                                                                                                                                                                                    | ip               |
  | zscaler_zpa.user_activity.client_to_client                       | The status of the client-to-client connection.                                                                                                                                                                                                                                             | keyword          |
  | zscaler_zpa.user_activity.connection.id                          | The application connection ID.                                                                                                                                                                                                                                                             | keyword          |
  | zscaler_zpa.user_activity.connection.setup_time                  | Time taken by the App Connector to process a notification from the App Connector selection microservice and set up the connection to the application server.                                                                                                                               | long             |
  | zscaler_zpa.user_activity.connection.status                      | The status of the connection. The expected values for this field are: [ Open, Close, Active ].                                                                                                                                                                                             | keyword          |
  | zscaler_zpa.user_activity.connector.ip                           | The source IP address of the App Connector.                                                                                                                                                                                                                                                | ip               |
  | zscaler_zpa.user_activity.connector.name                         | The App Connector name.                                                                                                                                                                                                                                                                    | keyword          |
  | zscaler_zpa.user_activity.connector.port                         | The source port of the App Connector.                                                                                                                                                                                                                                                      | integer          |
  | zscaler_zpa.user_activity.connector_zen_setup_time               | Time in microseconds taken for setting up connection between App Connector and ZPA Public Service Edge or ZPA Private Service Edge.                                                                                                                                                        | long             |
  | zscaler_zpa.user_activity.double_encryption                      | The double encryption status.                                                                                                                                                                                                                                                              | integer          |
  | zscaler_zpa.user_activity.idp                                    | The name of the identity provider (IdP) as configured in the ZPA Admin Portal.                                                                                                                                                                                                             | keyword          |
  | zscaler_zpa.user_activity.internal_reason                        | The internal reason for the status of the transaction.                                                                                                                                                                                                                                     | keyword          |
  | zscaler_zpa.user_activity.policy.name                            | The access policy or timeout policy rule name.                                                                                                                                                                                                                                             | keyword          |
  | zscaler_zpa.user_activity.policy.processing_time                 | Time in microseconds taken for processing the access policy associated with the application.                                                                                                                                                                                               | long             |
  | zscaler_zpa.user_activity.server                                 | The server ID name. The server ID must be set to zero if dynamic server discovery is enabled.                                                                                                                                                                                              | keyword          |
  | zscaler_zpa.user_activity.server_setup_time                      | Time in microseconds taken for setting up connection at server.                                                                                                                                                                                                                            | long             |
  | zscaler_zpa.user_activity.service_port                           | The destination port of the server.                                                                                                                                                                                                                                                        | integer          |
  | zscaler_zpa.user_activity.session_id                             | The TLS session ID.                                                                                                                                                                                                                                                                        | keyword          |
  | zscaler_zpa.user_activity.timestamp.app_learn_start              | Time in microseconds taken for App Connectors to learn about the requested application and report the learned information to the central authority.                                                                                                                                        | keyword          |
  | zscaler_zpa.user_activity.timestamp.ca.rx                        | Timestamp in microseconds when the central authority received request from ZPA Public Service Edge or ZPA Private Service Edge.                                                                                                                                                            | date             |
  | zscaler_zpa.user_activity.timestamp.ca.tx                        | Timestamp in microseconds when the central authority sent request to ZPA Public Service Edge or ZPA Private Service Edge.                                                                                                                                                                  | date             |
  | zscaler_zpa.user_activity.timestamp.connection.end               | Timestamp in microseconds when the ZPA Public Service Edge or ZPA Private Service Edge terminated the connection.                                                                                                                                                                          | date             |
  | zscaler_zpa.user_activity.timestamp.connection.start             | Timestamp in microseconds when the ZPA Public Service Edge or ZPA Private Service Edge received the initial request from Zscaler Client Connector to start the connection.                                                                                                                 | date             |
  | zscaler_zpa.user_activity.timestamp.connector_zen.setup_complete | Timestamp in microseconds when the ZPA Public Service Edge or ZPA Private Service Edge received request from App Connector to set up data connection. The request from the App Connector is triggered by the initial request for a specific application from the Zscaler Client Connector. | date             |
  | zscaler_zpa.user_activity.timestamp.zen.client.rx.first          | Timestamp in microseconds when the ZPA Public Service Edge or ZPA Private Service Edge received the first byte from the Zscaler Client Connector.                                                                                                                                          | date             |
  | zscaler_zpa.user_activity.timestamp.zen.client.rx.last           | Timestamp in microseconds when the ZPA Public Service Edge or ZPA Private Service Edge received the last byte from the Zscaler Client Connector.                                                                                                                                           | date             |
  | zscaler_zpa.user_activity.timestamp.zen.client.tx.first          | Timestamp in microseconds when the ZPA Public Service Edge or ZPA Private Service Edge sent the first byte to the Zscaler Client Connector.                                                                                                                                                | date             |
  | zscaler_zpa.user_activity.timestamp.zen.client.tx.last           | Timestamp in microseconds when the ZPA Public Service Edge or ZPA Private Service Edge sent the last byte to the Zscaler Client Connector.                                                                                                                                                 | date             |
  | zscaler_zpa.user_activity.timestamp.zen.connector.rx.first       | Timestamp in microseconds when the ZPA Public Service Edge or ZPA Private Service Edge received the first byte from the App Connector.                                                                                                                                                     | date             |
  | zscaler_zpa.user_activity.timestamp.zen.connector.rx.last        | Timestamp in microseconds when the ZPA Public Service Edge or ZPA Private Service Edge received the last byte from the App Connector.                                                                                                                                                      | date             |
  | zscaler_zpa.user_activity.timestamp.zen.connector.tx.first       | Timestamp in microseconds when the ZPA Public Service Edge or ZPA Private Service Edge sent the first byte to the App Connector.                                                                                                                                                           | date             |
  | zscaler_zpa.user_activity.timestamp.zen.connector.tx.last        | Timestamp in microseconds when the ZPA Public Service Edge or ZPA Private Service Edge sent the last byte to the App Connector.                                                                                                                                                            | date             |
  | zscaler_zpa.user_activity.zen.client.bytes_rx                    | The additional bytes received from the Zscaler Client Connector since the last transaction log.                                                                                                                                                                                            | long             |
  | zscaler_zpa.user_activity.zen.client.bytes_tx                    | The additional bytes transmitted to the Zscaler Client Connector since the last transaction log.                                                                                                                                                                                           | long             |
  | zscaler_zpa.user_activity.zen.client.domain                      | The ZPA Public Service Edge (formerly Zscaler Enforcement Node or ZEN) or ZPA Private Service Edge that received the request from the Zscaler Client Connector.                                                                                                                            | keyword          |
  | zscaler_zpa.user_activity.zen.client.total.bytes_rx              | The total bytes received from the Zscaler Client Connector by the ZPA Public Service Edge or ZPA Private Service Edge.                                                                                                                                                                     | long             |
  | zscaler_zpa.user_activity.zen.client.total.bytes_tx              | The total bytes transmitted to the Zscaler Client Connector from the ZPA Public Service Edge or ZPA Private Service Edge.                                                                                                                                                                  | long             |
  | zscaler_zpa.user_activity.zen.connector.bytes_rx                 | The additional bytes received from the App Connector since the last transaction log.                                                                                                                                                                                                       | long             |
  | zscaler_zpa.user_activity.zen.connector.bytes_tx                 | The additional bytes transmitted by the App Connector since the last transaction log.                                                                                                                                                                                                      | long             |
  | zscaler_zpa.user_activity.zen.connector.domain                   | The ZPA Public Service Edge or ZPA Private Service Edge that sent the request from the App Connector.                                                                                                                                                                                      | keyword          |
  | zscaler_zpa.user_activity.zen.connector.total.bytes_rx           | The total bytes received from the App Connector by the ZPA Public Service Edge or ZPA Private Service Edge.                                                                                                                                                                                | long             |
  | zscaler_zpa.user_activity.zen.connector.total.bytes_tx           | The total bytes transmitted to the App Connector from the ZPA Public Service Edge or ZPA Private Service Edge.                                                                                                                                                                             | long             |
</dropdown>

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2019-05-31T17:35:42.000Z",
      "agent": {
          "ephemeral_id": "6fb1a136-9af8-4d32-9dd8-c392ae6f2580",
          "id": "157c5fae-90f8-4fe0-8069-e93ccb609fe1",
          "name": "elastic-agent-97104",
          "type": "filebeat",
          "version": "8.13.0"
      },
      "client": {
          "geo": {
              "country_iso_code": "US",
              "location": {
                  "lat": 45,
                  "lon": -119
              }
          },
          "ip": "81.2.69.193"
      },
      "data_stream": {
          "dataset": "zscaler_zpa.user_activity",
          "namespace": "25160",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "157c5fae-90f8-4fe0-8069-e93ccb609fe1",
          "snapshot": false,
          "version": "8.13.0"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "iam"
          ],
          "dataset": "zscaler_zpa.user_activity",
          "ingested": "2025-09-16T07:35:23Z",
          "kind": "event",
          "original": "{\"LogTimestamp\": \"Fri May 31 17:35:42 2019\",\"Customer\": \"Customer XYZ\",\"SessionID\": \"LHJdkjmNDf12nclBsvwA\",\"ConnectionID\": \"SqyZIMkg0JTj7EABsvwA,Q+EjXGdrvbF2lPiBbedm\",\"InternalReason\": \"\",\"ConnectionStatus\": \"active\",\"IPProtocol\": 6,\"DoubleEncryption\": 0,\"Username\": \"ZPA LSS Client\",\"ServicePort\": 10011,\"ClientPublicIP\": \"81.2.69.193\",\"ClientLatitude\": 45.000000,\"ClientLongitude\": -119.000000,\"ClientCountryCode\": \"US\",\"ClientZEN\": \"broker2b.pdx\",\"Policy\": \"ABC Lab Apps\",\"Connector\": \"ZDEMO ABC\",\"ConnectorZEN\": \"broker2b.pdx\",\"ConnectorIP\": \"67.43.156.12\",\"ConnectorPort\": 60266,\"Host\": \"175.16.199.1\",\"Application\": \"ABC Lab Apps\",\"AppGroup\": \"ABC Lab Apps\",\"Server\": \"0\",\"ServerIP\": \"175.16.199.1\",\"ServerPort\": 10011,\"PolicyProcessingTime\": 28,\"CAProcessingTime\": 1330,\"ConnectorZENSetupTime\": 191017,\"ConnectionSetupTime\": 192397,\"ServerSetupTime\": 465,\"AppLearnTime\": 0,\"TimestampConnectionStart\": \"2019-05-30T08:20:42.230Z\",\"TimestampConnectionEnd\": \"\",\"TimestampCATx\": \"2019-05-30T08:20:42.230Z\",\"TimestampCARx\": \"2019-05-30T08:20:42.231Z\",\"TimestampAppLearnStart\": \"\",\"TimestampZENFirstRxClient\": \"2019-05-30T08:20:42.424Z\",\"TimestampZENFirstTxClient\": \"\",\"TimestampZENLastRxClient\": \"2019-05-31T17:34:27.348Z\",\"TimestampZENLastTxClient\": \"\",\"TimestampConnectorZENSetupComplete\": \"2019-05-30T08:20:42.422Z\",\"TimestampZENFirstRxConnector\": \"\",\"TimestampZENFirstTxConnector\": \"2019-05-30T08:20:42.424Z\",\"TimestampZENLastRxConnector\": \"\",\"TimestampZENLastTxConnector\": \"2019-05-31T17:34:27.348Z\",\"ZENTotalBytesRxClient\": 2406926,\"ZENBytesRxClient\": 7115,\"ZENTotalBytesTxClient\": 0,\"ZENBytesTxClient\": 0,\"ZENTotalBytesRxConnector\": 0,\"ZENBytesRxConnector\": 0,\"ZENTotalBytesTxConnector\": 2406926,\"ZENBytesTxConnector\": 7115,\"Idp\": \"Example IDP Config\",\"ClientToClient\": \"0\"}",
          "type": [
              "info",
              "user"
          ]
      },
      "host": {
          "ip": [
              "175.16.199.1"
          ]
      },
      "input": {
          "type": "tcp"
      },
      "log": {
          "source": {
              "address": "172.21.0.3:40418"
          }
      },
      "network": {
          "transport": "tcp"
      },
      "organization": {
          "name": "Customer XYZ"
      },
      "related": {
          "hosts": [
              "broker2b.pdx"
          ],
          "ip": [
              "81.2.69.193",
              "175.16.199.1",
              "67.43.156.12"
          ],
          "user": [
              "ZPA LSS Client"
          ]
      },
      "server": {
          "ip": "175.16.199.1",
          "port": 10011
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "zscaler_zpa-user_activity"
      ],
      "user": {
          "name": "ZPA LSS Client"
      },
      "zscaler_zpa": {
          "user_activity": {
              "app_group": "ABC Lab Apps",
              "app_learn_time": 0,
              "application": "ABC Lab Apps",
              "ca_processing_time": 1330,
              "client_to_client": "0",
              "connection": {
                  "id": "SqyZIMkg0JTj7EABsvwA,Q+EjXGdrvbF2lPiBbedm",
                  "setup_time": 192397,
                  "status": "active"
              },
              "connector": {
                  "ip": "67.43.156.12",
                  "name": "ZDEMO ABC",
                  "port": 60266
              },
              "connector_zen_setup_time": 191017,
              "double_encryption": 0,
              "idp": "Example IDP Config",
              "policy": {
                  "name": "ABC Lab Apps",
                  "processing_time": 28
              },
              "server": "0",
              "server_setup_time": 465,
              "service_port": 10011,
              "session_id": "LHJdkjmNDf12nclBsvwA",
              "timestamp": {
                  "ca": {
                      "rx": "2019-05-30T08:20:42.231Z",
                      "tx": "2019-05-30T08:20:42.230Z"
                  },
                  "connection": {
                      "start": "2019-05-30T08:20:42.230Z"
                  },
                  "connector_zen": {
                      "setup_complete": "2019-05-30T08:20:42.422Z"
                  },
                  "zen": {
                      "client": {
                          "rx": {
                              "first": "2019-05-30T08:20:42.424Z",
                              "last": "2019-05-31T17:34:27.348Z"
                          }
                      },
                      "connector": {
                          "tx": {
                              "first": "2019-05-30T08:20:42.424Z",
                              "last": "2019-05-31T17:34:27.348Z"
                          }
                      }
                  }
              },
              "zen": {
                  "client": {
                      "bytes_rx": 7115,
                      "bytes_tx": 0,
                      "domain": "broker2b.pdx",
                      "total": {
                          "bytes_rx": 2406926,
                          "bytes_tx": 0
                      }
                  },
                  "connector": {
                      "bytes_rx": 0,
                      "bytes_tx": 7115,
                      "domain": "broker2b.pdx",
                      "total": {
                          "bytes_rx": 0,
                          "bytes_tx": 2406926
                      }
                  }
              }
          }
      }
  }
  ```
</dropdown>


## User Status Logs

<dropdown title="Exported fields">
  | Field                                              | Description                                                                                                                         | Type             |
  |----------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                         | Event timestamp.                                                                                                                    | date             |
  | data_stream.dataset                                | Data stream dataset.                                                                                                                | constant_keyword |
  | data_stream.namespace                              | Data stream namespace.                                                                                                              | constant_keyword |
  | data_stream.type                                   | Data stream type.                                                                                                                   | constant_keyword |
  | event.dataset                                      | Event dataset                                                                                                                       | constant_keyword |
  | event.module                                       | Event module                                                                                                                        | constant_keyword |
  | input.type                                         | Type of filebeat input.                                                                                                             | keyword          |
  | log.offset                                         | Log offset.                                                                                                                         | long             |
  | log.source.address                                 | Source address from which the log event was read / sent from.                                                                       | keyword          |
  | zscaler_zpa.user_status.client.type                | The client type for the request (i.e., Zscaler Client Connector, ZPA LSS, or Web Browser).                                          | keyword          |
  | zscaler_zpa.user_status.fqdn.registered            | The status of the hostname for the client-to-client connection. The expected values for this field are true or false.               | boolean          |
  | zscaler_zpa.user_status.fqdn.registered_error      | The status of the registered hostname.                                                                                              | keyword          |
  | zscaler_zpa.user_status.idp                        | The name of the identity provider (IdP) as configured in the ZPA Admin Portal.                                                      | keyword          |
  | zscaler_zpa.user_status.postures.hit               | The posture profiles that the Zscaler Client Connector verified for this device.                                                    | keyword          |
  | zscaler_zpa.user_status.postures.miss              | The posture profiles that the Zscaler Client Connector failed to verified for this device.                                          | keyword          |
  | zscaler_zpa.user_status.private_ip                 | The private IP address of the Zscaler Client Connector.                                                                             | ip               |
  | zscaler_zpa.user_status.saml_attributes            | The list of SAML attributes reported by the IdP.                                                                                    | keyword          |
  | zscaler_zpa.user_status.session.id                 | The TLS session ID.                                                                                                                 | keyword          |
  | zscaler_zpa.user_status.session.status             | The status of the session.                                                                                                          | keyword          |
  | zscaler_zpa.user_status.timestamp.authentication   | Timestamp in microseconds when the Zscaler Client Connector was authenticated.                                                      | date             |
  | zscaler_zpa.user_status.timestamp.unauthentication | Timestamp in microseconds when the Zscaler Client Connector was unauthenticated.                                                    | date             |
  | zscaler_zpa.user_status.total.bytes_rx             | The total bytes received.                                                                                                           | long             |
  | zscaler_zpa.user_status.total.bytes_tx             | The total bytes transmitted.                                                                                                        | long             |
  | zscaler_zpa.user_status.trusted_networks           | The unique IDs for the trusted networks that the Zscaler Client Connector has determined for this device.                           | keyword          |
  | zscaler_zpa.user_status.trusted_networks_names     | The names for the trusted networks that the Zscaler Client Connector has determined for this device.                                | keyword          |
  | zscaler_zpa.user_status.version                    | The Zscaler Client Connector version.                                                                                               | keyword          |
  | zscaler_zpa.user_status.zen.domain                 | The Public Service Edge (formerly Zscaler Enforcement Node or ZEN) or ZPA Private Service Edge that was selected for the connection | keyword          |
</dropdown>

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2019-05-31T17:34:48.000Z",
      "agent": {
          "ephemeral_id": "1abe1ea0-4a67-4535-ac7c-c525e6248a65",
          "id": "080c4b8f-729b-46b0-b898-8c927e9d39a8",
          "name": "elastic-agent-82171",
          "type": "filebeat",
          "version": "8.13.0"
      },
      "client": {
          "geo": {
              "country_iso_code": "US",
              "location": {
                  "lat": 45,
                  "lon": -119
              }
          },
          "ip": "81.2.69.144"
      },
      "data_stream": {
          "dataset": "zscaler_zpa.user_status",
          "namespace": "13582",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "080c4b8f-729b-46b0-b898-8c927e9d39a8",
          "snapshot": false,
          "version": "8.13.0"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "iam"
          ],
          "dataset": "zscaler_zpa.user_status",
          "ingested": "2025-09-16T07:36:12Z",
          "kind": "state",
          "original": "{\"LogTimestamp\":\"Fri May 31 17:34:48 2019\",\"Customer\":\"Customer XYZ\",\"Username\":\"ZPA LSS Client\",\"SessionID\":\"vkczUERSLl88Y+ytH8v5\",\"SessionStatus\":\"ZPN_STATUS_AUTHENTICATED\",\"Version\":\"19.12.0-36-g87dad18\",\"ZEN\":\"broker2b.pdx\",\"CertificateCN\":\"loggerz2x.pde.zpabeta.net\",\"PublicIP\":\"81.2.69.144\",\"Latitude\":45,\"Longitude\":-119,\"CountryCode\":\"US\",\"TimestampAuthentication\":\"2019-05-29T21:18:38.000Z\",\"TimestampUnAuthentication\":\"\",\"TotalBytesRx\":31274866,\"TotalBytesTx\":25424152,\"Idp\":\"IDP Config\",\"Hostname\":\"DESKTOP-99HCSJ1\",\"Platform\":\"windows\",\"ClientType\":\"zpn_client_type_zapp\",\"TrustedNetworks\":\"TN1_stc1\",\"TrustedNetworksNames\":\"145248739466696953\",\"SAMLAttributes\":\"myname:user,myemail:user@zscaler.com\",\"PosturesHit\":\"sm-posture1,sm-posture2\",\"PosturesMiss\":\"sm-posture11,sm-posture12\",\"ZENLatitude\":47,\"ZENLongitude\":-122,\"ZENCountryCode\":\"\",\"FQDNRegistered\": \"0\",\"FQDNRegisteredError\": \"CUSTOMER_NOT_ENABLED\"}",
          "type": [
              "info",
              "user"
          ]
      },
      "host": {
          "hostname": "DESKTOP-99HCSJ1",
          "os": {
              "platform": "windows"
          }
      },
      "input": {
          "type": "tcp"
      },
      "log": {
          "source": {
              "address": "172.21.0.3:51342"
          }
      },
      "organization": {
          "name": "Customer XYZ"
      },
      "related": {
          "ip": [
              "81.2.69.144"
          ],
          "user": [
              "ZPA LSS Client"
          ]
      },
      "server": {
          "geo": {
              "location": {
                  "lat": 47,
                  "lon": -122
              }
          }
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "zscaler_zpa-user_status"
      ],
      "user": {
          "name": "ZPA LSS Client"
      },
      "x509": {
          "issuer": {
              "common_name": [
                  "loggerz2x.pde.zpabeta.net"
              ]
          }
      },
      "zscaler_zpa": {
          "user_status": {
              "client": {
                  "type": "zpn_client_type_zapp"
              },
              "fqdn": {
                  "registered": false,
                  "registered_error": "CUSTOMER_NOT_ENABLED"
              },
              "idp": "IDP Config",
              "postures": {
                  "hit": [
                      "sm-posture1",
                      "sm-posture2"
                  ],
                  "miss": [
                      "sm-posture11",
                      "sm-posture12"
                  ]
              },
              "saml_attributes": [
                  "myname:user",
                  "myemail:user@zscaler.com"
              ],
              "session": {
                  "id": "vkczUERSLl88Y+ytH8v5",
                  "status": "ZPN_STATUS_AUTHENTICATED"
              },
              "timestamp": {
                  "authentication": "2019-05-29T21:18:38.000Z"
              },
              "total": {
                  "bytes_rx": 31274866,
                  "bytes_tx": 25424152
              },
              "trusted_networks": "TN1_stc1",
              "trusted_networks_names": "145248739466696953",
              "version": "19.12.0-36-g87dad18",
              "zen": {
                  "domain": "broker2b.pdx"
              }
          }
      }
  }
  ```
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Zscaler ZPA app connector status dashboard screenshot](https://epr.elastic.co/package/zscaler_zpa/1.23.3/img/zscaler-zpa-screenshot.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                                                                                        | Minimum Kibana version |
  |------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.23.3** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15292))Unify the treatment of user email for all data streams.                                                                                                                                                                                   | 9.0.08.13.0            |
  | **1.23.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/15131))Add conditions to convert processors to prevent failure on empty strings.                                                                                                                                                                 | 9.0.08.13.0            |
  | **1.23.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14221))Fix `related.host` to be `related.hosts`.                                                                                                                                                                                                 | 9.0.08.13.0            |
  | **1.23.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14077))Standardize user fields processing across integrations.                                                                                                                                                                               | 9.0.08.13.0            |
  | **1.22.3** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13999))Fix handling of `IPProtocol` field mapping.                                                                                                                                                                                               | 9.0.08.13.0            |
  | **1.22.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13755))Fix handling of remote IP lists in audit data stream.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13755))Fix ECS event type, category and outcome mapping of audit events.                               | 9.0.08.13.0            |
  | **1.22.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13393))Do not set `error.message` for expected behavior related to Zscaler `Host` field.                                                                                                                                                         | 9.0.08.13.0            |
  | **1.22.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13436))Remove undocumented fields and update format versions.                                                                                                                                                                                | 9.0.08.13.0            |
  | **1.21.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                                                                                                            | 9.0.08.13.0            |
  | **1.20.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12781))Updated SSL description in package manifest.yml to be uniform and to include links to documentation.                                                                                                                                      | 8.13.0                 |
  | **1.20.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12076))Do not remove `event.original` in main ingest pipeline.                                                                                                                                                                               | 8.13.0                 |
  | **1.19.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                                                                                                             | 8.13.0                 |
  | **1.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Removed import_mappings. Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                                                          | 8.13.0                 |
  | **1.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9404))Update manifest format version to v3.0.3.                                                                                                                                                                                              | 8.7.1                  |
  | **1.16.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                                                                                         | 8.7.1                  |
  | **1.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8436))ECS version updated to 8.11.0.                                                                                                                                                                                                         | 8.7.1                  |
  | **1.15.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8341))Fix `client.as.*` field mapping.                                                                                                                                                                                                       | 8.7.1                  |
  | **1.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8269))Improve `event.original` check to avoid errors if set.                                                                                                                                                                                 | 8.7.1                  |
  | **1.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7920))ECS version updated to 8.10.0.                                                                                                                                                                                                         | 8.7.1                  |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7883))The format_version in the package manifest changed from 2.11.0 to 3.0.0. Removed dotted YAML keys from package manifest. Added 'owner.type: elastic' to package manifest.                                                              | 8.7.1                  |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.                                                                                   | 8.7.1                  |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7111))Update package to ECS 8.9.0.                                                                                                                                                                                                           | 8.7.1                  |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6924))Convert visualizations to lens.                                                                                                                                                                                                        | 8.7.1                  |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6651))Ensure event.kind is correctly set for pipeline errors.                                                                                                                                                                                | 8.0.07.16.2            |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6328))Update package to ECS 8.8.0.                                                                                                                                                                                                           | 8.0.07.16.2            |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6299))Update package-spec version to 2.7.0.                                                                                                                                                                                                  | 8.0.07.16.2            |
  | **1.6.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5565))Fix PosturesHit and PosturesMiss parsing                                                                                                                                                                                                   | 8.0.07.16.2            |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                                                                                                           | 8.0.07.16.2            |
  | **1.5.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                                                                                 | 8.0.07.16.2            |
  | **1.5.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5409))Add support for dynamic ECS mapping.**Bug fix** ([View pull request](https://github.com/elastic/integrations/issues/5346))Resolve the issue related to ECS fields.                                                                     | 8.0.07.16.2            |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                                                                                                           | 8.0.07.16.2            |
  | **1.4.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4610))Remove duplicate fields.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4610))Fix `x509.issuer.common_name` normalization.                                                                                   | 8.0.07.16.2            |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4648))Update Aggregation visualizations to Lens, Add an on_failure processor to the convert, geo_ip, uri_parts and date processors, remove unnecessary white spaces, mapped to related ecs field and convert double quotes to single quotes. | 8.0.07.16.2            |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                                                                                                           | 8.0.07.16.2            |
  | **1.2.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/issues/4227))Use ECS geo.location definition.                                                                                                                                                                                                     | 8.0.07.16.2            |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3872))Update package to ECS 8.4.0                                                                                                                                                                                                            | 8.0.07.16.2            |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3353))Update package to ECS 8.3.0.                                                                                                                                                                                                           | 8.0.07.16.2            |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3428))Make GA                                                                                                                                                                                                                                | 8.0.07.16.2            |
  | **0.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2781))Update ECS to 8.2                                                                                                                                                                                                                      |                        |
  | **0.1.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                                                                                                     |                        |
  | **0.1.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2769))Updated the README to describe the Zscaler ZPA setup process.                                                                                                                                                                          |                        |
  | **0.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2458))Initial draft of the package                                                                                                                                                                                                           |                        |
</dropdown>