﻿---
title: ZeroFox Cloud Platform Integration
description: The ZeroFox Platform integration collects and parses data from the the ZeroFox Alert APIs. This integration supports the ZeroFox API v1.0 Contains alert...
url: https://www.elastic.co/docs/reference/integrations/zerofox
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.1
---

# ZeroFox Cloud Platform Integration
|                                                                                                 |                                 |
|-------------------------------------------------------------------------------------------------|---------------------------------|
| **Version**                                                                                     | 1.29.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                           |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Partner                         |
| **Ingestion method(s)**                                                                         | API                             |
| **Minimum Kibana version(s)**                                                                   | 9.1.49.0.78.19.4                |

The ZeroFox Platform integration collects and parses data from the the [ZeroFox](https://www.zerofox.com/) Alert APIs.

## Compatibility

This integration supports the ZeroFox API v1.0

### ZeroFox

Contains alert data received from the ZeroFox Cloud Platform
<dropdown title="Exported fields">
  | Field                                          | Description                      | Type             |
  |------------------------------------------------|----------------------------------|------------------|
  | @timestamp                                     | Event timestamp.                 | date             |
  | cloud.image.id                                 | Image ID for the cloud instance. | keyword          |
  | data_stream.dataset                            | Data stream dataset name.        | constant_keyword |
  | data_stream.namespace                          | Data stream namespace.           | constant_keyword |
  | data_stream.type                               | Data stream type.                | constant_keyword |
  | dataset.name                                   | Dataset name.                    | constant_keyword |
  | dataset.namespace                              | Dataset namespace.               | constant_keyword |
  | dataset.type                                   | Dataset type.                    | constant_keyword |
  | event.dataset                                  | Event dataset                    | constant_keyword |
  | event.module                                   | Event module                     | constant_keyword |
  | host.containerized                             | If the host is a container.      | boolean          |
  | host.os.build                                  | OS build information.            | keyword          |
  | host.os.codename                               | OS codename, if any.             | keyword          |
  | input.type                                     | Type of Filebeat input.          | keyword          |
  | zerofox.content_actions                        |                                  | keyword          |
  | zerofox.darkweb_term                           |                                  | keyword          |
  | zerofox.entity.entity_group.id                 | The entity group identifier.     | integer          |
  | zerofox.entity.entity_group.name               | The entity group name.           | keyword          |
  | zerofox.entity.id                              | The entity identifier.           | keyword          |
  | zerofox.entity.image                           | The entity default image url.    | keyword          |
  | zerofox.entity.labels.id                       | The entity label identifier      | keyword          |
  | zerofox.entity.labels.name                     | The entity label text            | keyword          |
  | zerofox.entity.name                            | The entity name.                 | keyword          |
  | zerofox.entity_account                         |                                  | keyword          |
  | zerofox.entity_term.deleted                    |                                  | boolean          |
  | zerofox.entity_term.id                         |                                  | keyword          |
  | zerofox.entity_term.name                       |                                  | keyword          |
  | zerofox.escalated                              |                                  | boolean          |
  | zerofox.last_modified                          |                                  | date             |
  | zerofox.metadata                               |                                  | flattened        |
  | zerofox.notes                                  |                                  | text             |
  | zerofox.perpetrator.account_number             |                                  | keyword          |
  | zerofox.perpetrator.content                    |                                  | keyword          |
  | zerofox.perpetrator.destination_account_number |                                  | keyword          |
  | zerofox.perpetrator.display_name               |                                  | keyword          |
  | zerofox.perpetrator.id                         |                                  | keyword          |
  | zerofox.perpetrator.image                      |                                  | keyword          |
  | zerofox.perpetrator.name                       |                                  | keyword          |
  | zerofox.perpetrator.network                    |                                  | keyword          |
  | zerofox.perpetrator.parent_post_account_number |                                  | keyword          |
  | zerofox.perpetrator.parent_post_number         |                                  | keyword          |
  | zerofox.perpetrator.parent_post_url            |                                  | keyword          |
  | zerofox.perpetrator.post_number                |                                  | keyword          |
  | zerofox.perpetrator.post_type                  |                                  | keyword          |
  | zerofox.perpetrator.timestamp                  |                                  | keyword          |
  | zerofox.perpetrator.type                       |                                  | keyword          |
  | zerofox.perpetrator.url                        |                                  | keyword          |
  | zerofox.perpetrator.username                   |                                  | keyword          |
  | zerofox.protected_account                      |                                  | keyword          |
  | zerofox.protected_locations                    |                                  | keyword          |
  | zerofox.protected_social_object                |                                  | keyword          |
  | zerofox.reviewed                               |                                  | boolean          |
  | zerofox.reviews                                |                                  | keyword          |
  | zerofox.status                                 |                                  | keyword          |
  | zerofox.tags                                   |                                  | keyword          |
</dropdown>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                           | Minimum Kibana version |
  |------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.29.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15584))Prevent updating fleet health status to degraded.                                                                                                                        | 9.1.49.0.78.19.4       |
  | **1.28.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                                               | 9.0.08.13.0            |
  | **1.27.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12076))Do not remove `event.original` in main ingest pipeline.                                                                                                                  | 8.13.0                 |
  | **1.26.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                                                | 8.13.0                 |
  | **1.25.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                      | 8.13.0                 |
  | **1.24.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9974))Improve handling of empty responses.                                                                                                                                      | 8.12.0                 |
  | **1.23.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9129))Set sensitive values as secret.                                                                                                                                           | 8.12.0                 |
  | **1.22.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                            | 8.7.1                  |
  | **1.22.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8489))Limit request tracer log count to five.                                                                                                                                   | 8.7.1                  |
  | **1.21.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8436))ECS version updated to 8.11.0.                                                                                                                                            | 8.7.1                  |
  | **1.20.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8269))Improve 'event.original' check to avoid errors if set.                                                                                                                    | 8.7.1                  |
  | **1.19.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8035))Set 'partner' owner type.                                                                                                                                                 | 8.7.1                  |
  | **1.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7920))ECS version updated to 8.10.0.                                                                                                                                            | 8.7.1                  |
  | **1.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7883))The format_version in the package manifest changed from 2.11.0 to 3.0.0. Removed dotted YAML keys from package manifest. Added 'owner.type: elastic' to package manifest. | 8.7.1                  |
  | **1.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.                      | 8.7.1                  |
  | **1.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7111))Update package to ECS 8.9.0.                                                                                                                                              | 8.7.1                  |
  | **1.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6992))Document duration units.                                                                                                                                                  | 8.7.1                  |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6706))Document valid duration units.                                                                                                                                            | 8.7.1                  |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6654))Ensure event.kind is correctly set for pipeline errors.                                                                                                                   | 8.7.1                  |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6328))Update package to ECS 8.8.0.                                                                                                                                              | 8.7.1                  |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6299))Update package-spec version to 2.7.0.                                                                                                                                     | 8.7.1                  |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6115))Add a new flag to enable request tracing                                                                                                                                  | 8.7.1                  |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                                              | 8.0.07.14              |
  | **1.7.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                    | 8.0.07.14              |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                                              | 8.0.07.14              |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                                              | 8.0.07.14              |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3872))Update package to ECS 8.4.0                                                                                                                                               | 8.0.07.14              |
  | **1.4.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3478))Update package name and description to align with standard wording                                                                                                        | 8.0.07.14              |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3353))Update package to ECS 8.3.0.                                                                                                                                              | 8.0.07.14              |
  | **1.3.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3178))update readme added a ink to zerofox readme                                                                                                                               | 8.0.07.14              |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2781))Update to ECS 8.2                                                                                                                                                         | 8.0.07.14              |
  | **1.2.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                                        | 8.0.07.14              |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2453))Update to ECS 8.0                                                                                                                                                         | 8.0.07.14              |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2230))Add 8.0.0 version constraint                                                                                                                                              | 8.0.07.14              |
  | **1.0.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2077))Uniform with guidelines                                                                                                                                                   | 7.14                   |
  | **1.0.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1993))Update Title and Description.                                                                                                                                             |                        |
  | **1.0.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1862))Fix logic that checks for the 'forwarded' tag                                                                                                                                 |                        |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1757))GA package                                                                                                                                                                |                        |
  | **0.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1636))Update to ECS 1.12.0                                                                                                                                                      |                        |
  | **0.1.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1405))Escape special characters in docs                                                                                                                                         |                        |
  | **0.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/971))initial release                                                                                                                                                            |                        |
</dropdown>