﻿---
title: Zeek Integration
description: This is an integration for Zeek, which was formerly named Bro. Zeek is a passive, open-source network traffic analyzer. This integrations ingests the...
url: https://www.elastic.co/docs/reference/integrations/zeek
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Zeek Integration
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 4.0.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                        |
| **Ingestion method(s)**                                                                         | File                           |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.12.0                    |

This is an integration for [Zeek](https://www.zeek.org/), which was formerly
named Bro. Zeek is a passive, open-source network traffic analyzer. This
integrations ingests the logs Zeek produces about the network traffic that it
analyzes.
Zeek logs must be output in JSON format. This is normally done by appending the
[json-logs policy](https://docs.zeek.org/en/lts/scripts/policy/tuning/json-logs.zeek.html)
to your `local.zeek` file. Add this line to your `local.zeek`.
`@load policy/tuning/json-logs.zeek`

## Compatibility

This module has been developed against Zeek 2.6.1, but is expected to work with
other versions of Zeek.
Zeek requires a Unix-like platform, and it currently supports Linux,
FreeBSD, and Mac OS X.

## Logs


### capture_loss

The `capture_loss` dataset collects the Zeek capture_loss.log file,
which contains packet loss rate data.
<dropdown title="Exported fields">
  | Field                          | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |--------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                     | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                                                                                                                            | date             |
  | cloud.account.id               | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.availability_zone        | Availability zone in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | cloud.image.id                 | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.instance.id              | Instance ID of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.instance.name            | Instance name of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.machine.type             | Machine type of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | cloud.project.id               | The cloud project identifier. Examples: Google Cloud Project id, Azure Project id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.provider                 | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.region                   | Region in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | container.id                   | Unique container id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | container.image.name           | Name of the image the container was built on.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | container.labels               | Image labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | object           |
  | container.name                 | Container name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | data_stream.dataset            | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                                                                                 | constant_keyword |
  | data_stream.namespace          | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                                                                                                                | constant_keyword |
  | data_stream.type               | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | ecs.version                    | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | error.message                  | Error message.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |
  | event.created                  | `event.created` contains the date/time when the event was first read by an agent, or by your pipeline. This field is distinct from `@timestamp` in that `@timestamp` typically contain the time extracted from the original event. In most situations, these two timestamps will be slightly different. The difference can be used to calculate the delay between your source generating an event, and the time when your agent first processed it. This can be used to monitor your agent's or pipeline's ability to keep up with your event source. In case the two timestamps are identical, `@timestamp` should be used. | date             |
  | event.dataset                  | Event dataset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | constant_keyword |
  | event.ingested                 | Timestamp when an event arrived in the central data store. This is different from `@timestamp`, which is when the event originally occurred.  It's also different from `event.created`, which is meant to capture the first time an agent saw the event. In normal conditions, assuming no tampering, the timestamps should chronologically look like this: `@timestamp` < `event.created` < `event.ingested`.                                                                                                                                                                                                               | date             |
  | event.kind                     | This is one of four ECS Categorization Fields, and indicates the highest level in the ECS category hierarchy. `event.kind` gives high-level information about what type of information the event contains, without being specific to the contents of the event. For example, values of this field distinguish alert events from metric events. The value of this field can be used to inform how these kinds of events should be handled. They may warrant different retention, different access control, it may also help understand whether the data is coming in at a regular interval or not.                            | keyword          |
  | event.module                   | Event module                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | constant_keyword |
  | event.type                     | This is one of four ECS Categorization Fields, and indicates the third level in the ECS category hierarchy. `event.type` represents a categorization "sub-bucket" that, when used along with the `event.category` field values, enables filtering events down to a level appropriate for single visualization. This field is an array. This will allow proper categorization of some events that fall in multiple event types.                                                                                                                                                                                               | keyword          |
  | host.architecture              | Operating system architecture.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | host.containerized             | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |
  | host.domain                    | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | host.hostname                  | Hostname of the host. It normally contains what the `hostname` command returns on the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | host.id                        | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.ip                        | Host ip addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | host.mac                       | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | host.name                      | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host.                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.os.build                  | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.codename               | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | host.os.family                 | OS family (such as redhat, debian, freebsd, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.kernel                 | Operating system kernel version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.os.name                   | Operating system name, without the version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | host.os.name.text              | Multi-field of `host.os.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |
  | host.os.platform               | Operating system platform (such centos, ubuntu, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.os.version                | Operating system version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.type                      | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | input.type                     | Type of Filebeat input.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | log.file.path                  | Full path to the log file this event came from, including the file name. It should include the drive letter, when appropriate. If the event wasn't read from a log file, do not populate this field.                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | log.flags                      | Flags for the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | log.offset                     | Offset of the entry in the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | tags                           | List of keywords used to tag each event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | zeek.capture_loss.acks         | Total number of ACKs seen in the previous measurement interval.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | integer          |
  | zeek.capture_loss.gaps         | Number of missed ACKs from the previous measurement interval.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | integer          |
  | zeek.capture_loss.peer         | In the event that there are multiple Bro instances logging to the same host, this distinguishes each peer with its individual name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | zeek.capture_loss.percent_lost | Percentage of ACKs seen where the data being ACKed wasn't seen.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | double           |
  | zeek.capture_loss.ts_delta     | The time delay between this measurement and the last.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | integer          |
  | zeek.session_id                | A unique identifier of the session                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
</dropdown>


### connection

The `connection` dataset collects the Zeek conn.log file, which
contains TCP/UDP/ICMP connection data.
<dropdown title="Exported fields">
  | Field                                 | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | Type             |
  |---------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                            | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                                                                                                                                                                                                                                  | date             |
  | cloud.account.id                      | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | cloud.availability_zone               | Availability zone in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.image.id                        | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | cloud.instance.id                     | Instance ID of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | cloud.instance.name                   | Instance name of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | cloud.machine.type                    | Machine type of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | cloud.project.id                      | The cloud project identifier. Examples: Google Cloud Project id, Azure Project id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | cloud.provider                        | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | cloud.region                          | Region in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | container.id                          | Unique container id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | container.image.name                  | Name of the image the container was built on.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | container.labels                      | Image labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | object           |
  | container.name                        | Container name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | data_stream.dataset                   | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                                                                                                                                                                                       | constant_keyword |
  | data_stream.namespace                 | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                                                                                                                                                                                                                      | constant_keyword |
  | data_stream.type                      | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | constant_keyword |
  | destination.address                   | Some event destination addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | destination.as.number                 | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | long             |
  | destination.as.organization.name      | Organization name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | destination.as.organization.name.text | Multi-field of `destination.as.organization.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | match_only_text  |
  | destination.bytes                     | Bytes sent from the destination to the source.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | long             |
  | destination.geo.city_name             | City name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | destination.geo.continent_name        | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | destination.geo.country_iso_code      | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | destination.geo.country_name          | Country name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | destination.geo.location              | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | geo_point        |
  | destination.geo.name                  | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | destination.geo.region_iso_code       | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | destination.geo.region_name           | Region name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | destination.ip                        | IP address of the destination (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | ip               |
  | destination.mac                       | MAC address of the destination. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | destination.packets                   | Packets sent from the destination to the source.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | long             |
  | destination.port                      | Port of the destination.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | long             |
  | ecs.version                           | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | error.message                         | Error message.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | match_only_text  |
  | event.category                        | This is one of four ECS Categorization Fields, and indicates the second level in the ECS category hierarchy. `event.category` represents the "big buckets" of ECS categories. For example, filtering on `event.category:process` yields all events relating to process activity. This field is closely related to `event.type`, which is used as a subcategory. This field is an array. This will allow proper categorization of some events that fall in multiple categories.                                                                                                                                                                                                                                                     | keyword          |
  | event.created                         | `event.created` contains the date/time when the event was first read by an agent, or by your pipeline. This field is distinct from `@timestamp` in that `@timestamp` typically contain the time extracted from the original event. In most situations, these two timestamps will be slightly different. The difference can be used to calculate the delay between your source generating an event, and the time when your agent first processed it. This can be used to monitor your agent's or pipeline's ability to keep up with your event source. In case the two timestamps are identical, `@timestamp` should be used.                                                                                                       | date             |
  | event.dataset                         | Event dataset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | constant_keyword |
  | event.duration                        | Duration of the event in nanoseconds. If `event.start` and `event.end` are known this value should be the difference between the end and start time.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | long             |
  | event.id                              | Unique ID to describe the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | event.ingested                        | Timestamp when an event arrived in the central data store. This is different from `@timestamp`, which is when the event originally occurred.  It's also different from `event.created`, which is meant to capture the first time an agent saw the event. In normal conditions, assuming no tampering, the timestamps should chronologically look like this: `@timestamp` < `event.created` < `event.ingested`.                                                                                                                                                                                                                                                                                                                     | date             |
  | event.kind                            | This is one of four ECS Categorization Fields, and indicates the highest level in the ECS category hierarchy. `event.kind` gives high-level information about what type of information the event contains, without being specific to the contents of the event. For example, values of this field distinguish alert events from metric events. The value of this field can be used to inform how these kinds of events should be handled. They may warrant different retention, different access control, it may also help understand whether the data is coming in at a regular interval or not.                                                                                                                                  | keyword          |
  | event.module                          | Event module                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | constant_keyword |
  | event.type                            | This is one of four ECS Categorization Fields, and indicates the third level in the ECS category hierarchy. `event.type` represents a categorization "sub-bucket" that, when used along with the `event.category` field values, enables filtering events down to a level appropriate for single visualization. This field is an array. This will allow proper categorization of some events that fall in multiple event types.                                                                                                                                                                                                                                                                                                     | keyword          |
  | host.architecture                     | Operating system architecture.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | host.containerized                    | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | boolean          |
  | host.domain                           | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | host.hostname                         | Hostname of the host. It normally contains what the `hostname` command returns on the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | host.id                               | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | host.ip                               | Host ip addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | ip               |
  | host.mac                              | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | host.name                             | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | host.os.build                         | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | host.os.codename                      | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | host.os.family                        | OS family (such as redhat, debian, freebsd, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | host.os.kernel                        | Operating system kernel version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | host.os.name                          | Operating system name, without the version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.name.text                     | Multi-field of `host.os.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | match_only_text  |
  | host.os.platform                      | Operating system platform (such centos, ubuntu, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | host.os.version                       | Operating system version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | host.type                             | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | input.type                            | Type of Filebeat input.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | log.file.path                         | Full path to the log file this event came from, including the file name. It should include the drive letter, when appropriate. If the event wasn't read from a log file, do not populate this field.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | log.flags                             | Flags for the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | log.offset                            | Offset of the entry in the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | long             |
  | network.bytes                         | Total bytes transferred in both directions. If `source.bytes` and `destination.bytes` are known, `network.bytes` is their sum.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | long             |
  | network.community_id                  | A hash of source and destination IPs and ports, as well as the protocol used in a communication. This is a tool-agnostic standard to identify flows. Learn more at .                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | network.direction                     | Direction of the network traffic. When mapping events from a host-based monitoring context, populate this field from the host's point of view, using the values "ingress" or "egress". When mapping events from a network or perimeter-based monitoring context, populate this field from the point of view of the network perimeter, using the values "inbound", "outbound", "internal" or "external". Note that "internal" is not crossing perimeter boundaries, and is meant to describe communication between two hosts within the perimeter. Note also that "external" is meant to describe traffic between two hosts that are external to the perimeter. This could for example be useful for ISPs or VPN service providers. | keyword          |
  | network.packets                       | Total packets transferred in both directions. If `source.packets` and `destination.packets` are known, `network.packets` is their sum.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | long             |
  | network.protocol                      | In the OSI Model this would be the Application Layer protocol. For example, `http`, `dns`, or `ssh`. The field value must be normalized to lowercase for querying.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | network.transport                     | Same as network.iana_number, but instead using the Keyword name of the transport layer (udp, tcp, ipv6-icmp, etc.) The field value must be normalized to lowercase for querying.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | related.ip                            | All of the IPs seen on your event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | ip               |
  | source.address                        | Some event source addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | source.as.number                      | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | long             |
  | source.as.organization.name           | Organization name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | source.as.organization.name.text      | Multi-field of `source.as.organization.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | match_only_text  |
  | source.bytes                          | Bytes sent from the source to the destination.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | long             |
  | source.geo.city_name                  | City name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | source.geo.continent_name             | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | source.geo.country_iso_code           | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | source.geo.country_name               | Country name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | source.geo.location                   | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | geo_point        |
  | source.geo.name                       | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | source.geo.region_iso_code            | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | source.geo.region_name                | Region name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | source.ip                             | IP address of the source (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | source.mac                            | MAC address of the source. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | source.packets                        | Packets sent from the source to the destination.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | long             |
  | source.port                           | Port of the source.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | long             |
  | tags                                  | List of keywords used to tag each event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | zeek.connection.history               | Flags indicating the history of the session.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | zeek.connection.icmp.code             | ICMP message code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | integer          |
  | zeek.connection.icmp.type             | ICMP message type.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | integer          |
  | zeek.connection.inner_vlan            | VLAN identifier.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | integer          |
  | zeek.connection.local_orig            | Indicates whether the session is originated locally.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | boolean          |
  | zeek.connection.local_resp            | Indicates whether the session is responded locally.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | boolean          |
  | zeek.connection.missed_bytes          | Missed bytes for the session.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | long             |
  | zeek.connection.state                 | Code indicating the state of the session.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | zeek.connection.state_message         | The state of the session.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | zeek.connection.vlan                  | VLAN identifier.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | integer          |
  | zeek.session_id                       | A unique identifier of the session                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
</dropdown>


### dce_rpc

The `dce_rpc` dataset collects the Zeek dce_rpc.log file, which
contains Distributed Computing Environment/RPC data.
<dropdown title="Exported fields">
  | Field                                 | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |---------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                            | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                                                                                                                            | date             |
  | cloud.account.id                      | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.availability_zone               | Availability zone in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | cloud.image.id                        | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.instance.id                     | Instance ID of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.instance.name                   | Instance name of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.machine.type                    | Machine type of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | cloud.project.id                      | The cloud project identifier. Examples: Google Cloud Project id, Azure Project id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.provider                        | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.region                          | Region in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | container.id                          | Unique container id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | container.image.name                  | Name of the image the container was built on.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | container.labels                      | Image labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | object           |
  | container.name                        | Container name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | data_stream.dataset                   | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                                                                                 | constant_keyword |
  | data_stream.namespace                 | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                                                                                                                | constant_keyword |
  | data_stream.type                      | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | destination.address                   | Some event destination addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | destination.as.number                 | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | long             |
  | destination.as.organization.name      | Organization name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | destination.as.organization.name.text | Multi-field of `destination.as.organization.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | match_only_text  |
  | destination.bytes                     | Bytes sent from the destination to the source.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | long             |
  | destination.geo.city_name             | City name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | destination.geo.continent_name        | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | destination.geo.country_iso_code      | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | destination.geo.country_name          | Country name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | destination.geo.location              | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | geo_point        |
  | destination.geo.name                  | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | destination.geo.region_iso_code       | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | destination.geo.region_name           | Region name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | destination.ip                        | IP address of the destination (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | ip               |
  | destination.port                      | Port of the destination.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | long             |
  | ecs.version                           | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | error.message                         | Error message.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |
  | event.action                          | The action captured by the event. This describes the information in the event. It is more specific than `event.category`. Examples are `group-add`, `process-started`, `file-created`. The value is normally defined by the implementer.                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | event.category                        | This is one of four ECS Categorization Fields, and indicates the second level in the ECS category hierarchy. `event.category` represents the "big buckets" of ECS categories. For example, filtering on `event.category:process` yields all events relating to process activity. This field is closely related to `event.type`, which is used as a subcategory. This field is an array. This will allow proper categorization of some events that fall in multiple categories.                                                                                                                                               | keyword          |
  | event.created                         | `event.created` contains the date/time when the event was first read by an agent, or by your pipeline. This field is distinct from `@timestamp` in that `@timestamp` typically contain the time extracted from the original event. In most situations, these two timestamps will be slightly different. The difference can be used to calculate the delay between your source generating an event, and the time when your agent first processed it. This can be used to monitor your agent's or pipeline's ability to keep up with your event source. In case the two timestamps are identical, `@timestamp` should be used. | date             |
  | event.dataset                         | Event dataset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | constant_keyword |
  | event.id                              | Unique ID to describe the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | event.ingested                        | Timestamp when an event arrived in the central data store. This is different from `@timestamp`, which is when the event originally occurred.  It's also different from `event.created`, which is meant to capture the first time an agent saw the event. In normal conditions, assuming no tampering, the timestamps should chronologically look like this: `@timestamp` < `event.created` < `event.ingested`.                                                                                                                                                                                                               | date             |
  | event.kind                            | This is one of four ECS Categorization Fields, and indicates the highest level in the ECS category hierarchy. `event.kind` gives high-level information about what type of information the event contains, without being specific to the contents of the event. For example, values of this field distinguish alert events from metric events. The value of this field can be used to inform how these kinds of events should be handled. They may warrant different retention, different access control, it may also help understand whether the data is coming in at a regular interval or not.                            | keyword          |
  | event.module                          | Event module                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | constant_keyword |
  | event.type                            | This is one of four ECS Categorization Fields, and indicates the third level in the ECS category hierarchy. `event.type` represents a categorization "sub-bucket" that, when used along with the `event.category` field values, enables filtering events down to a level appropriate for single visualization. This field is an array. This will allow proper categorization of some events that fall in multiple event types.                                                                                                                                                                                               | keyword          |
  | host.architecture                     | Operating system architecture.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | host.containerized                    | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |
  | host.domain                           | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | host.hostname                         | Hostname of the host. It normally contains what the `hostname` command returns on the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | host.id                               | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.ip                               | Host ip addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | host.mac                              | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | host.name                             | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host.                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.os.build                         | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.codename                      | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | host.os.family                        | OS family (such as redhat, debian, freebsd, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.kernel                        | Operating system kernel version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.os.name                          | Operating system name, without the version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | host.os.name.text                     | Multi-field of `host.os.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |
  | host.os.platform                      | Operating system platform (such centos, ubuntu, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.os.version                       | Operating system version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.type                             | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | input.type                            | Type of Filebeat input.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | log.file.path                         | Full path to the log file this event came from, including the file name. It should include the drive letter, when appropriate. If the event wasn't read from a log file, do not populate this field.                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | log.flags                             | Flags for the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | log.offset                            | Offset of the entry in the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | network.community_id                  | A hash of source and destination IPs and ports, as well as the protocol used in a communication. This is a tool-agnostic standard to identify flows. Learn more at .                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | network.protocol                      | In the OSI Model this would be the Application Layer protocol. For example, `http`, `dns`, or `ssh`. The field value must be normalized to lowercase for querying.                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | network.transport                     | Same as network.iana_number, but instead using the Keyword name of the transport layer (udp, tcp, ipv6-icmp, etc.) The field value must be normalized to lowercase for querying.                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | related.ip                            | All of the IPs seen on your event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | source.address                        | Some event source addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | source.as.number                      | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | long             |
  | source.as.organization.name           | Organization name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | source.as.organization.name.text      | Multi-field of `source.as.organization.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | match_only_text  |
  | source.bytes                          | Bytes sent from the source to the destination.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | long             |
  | source.geo.city_name                  | City name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | source.geo.continent_name             | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | source.geo.country_iso_code           | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | source.geo.country_name               | Country name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | source.geo.location                   | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | geo_point        |
  | source.geo.name                       | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | source.geo.region_iso_code            | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | source.geo.region_name                | Region name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | source.ip                             | IP address of the source (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | ip               |
  | source.port                           | Port of the source.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | long             |
  | tags                                  | List of keywords used to tag each event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | zeek.dce_rpc.endpoint                 | Endpoint name looked up from the uuid.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | zeek.dce_rpc.named_pipe               | Remote pipe name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | zeek.dce_rpc.operation                | Operation seen in the call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | zeek.dce_rpc.rtt                      | Round trip time from the request to the response. If either the request or response wasn't seen, this will be null.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | integer          |
  | zeek.session_id                       | A unique identifier of the session                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
</dropdown>


### dhcp

The `dhcp` dataset collects the Zeek dhcp.log file, which contains
DHCP lease data.
<dropdown title="Exported fields">
  | Field                       | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |-----------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                  | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                                                                                                                            | date             |
  | client.address              | Some event client addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | cloud.account.id            | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.availability_zone     | Availability zone in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | cloud.image.id              | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.instance.id           | Instance ID of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.instance.name         | Instance name of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.machine.type          | Machine type of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | cloud.project.id            | The cloud project identifier. Examples: Google Cloud Project id, Azure Project id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.provider              | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.region                | Region in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | container.id                | Unique container id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | container.image.name        | Name of the image the container was built on.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | container.labels            | Image labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | object           |
  | container.name              | Container name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | data_stream.dataset         | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                                                                                 | constant_keyword |
  | data_stream.namespace       | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                                                                                                                | constant_keyword |
  | data_stream.type            | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | destination.address         | Some event destination addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | destination.ip              | IP address of the destination (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | ip               |
  | destination.port            | Port of the destination.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | long             |
  | ecs.version                 | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | error.message               | Error message.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |
  | event.category              | This is one of four ECS Categorization Fields, and indicates the second level in the ECS category hierarchy. `event.category` represents the "big buckets" of ECS categories. For example, filtering on `event.category:process` yields all events relating to process activity. This field is closely related to `event.type`, which is used as a subcategory. This field is an array. This will allow proper categorization of some events that fall in multiple categories.                                                                                                                                               | keyword          |
  | event.created               | `event.created` contains the date/time when the event was first read by an agent, or by your pipeline. This field is distinct from `@timestamp` in that `@timestamp` typically contain the time extracted from the original event. In most situations, these two timestamps will be slightly different. The difference can be used to calculate the delay between your source generating an event, and the time when your agent first processed it. This can be used to monitor your agent's or pipeline's ability to keep up with your event source. In case the two timestamps are identical, `@timestamp` should be used. | date             |
  | event.dataset               | Event dataset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | constant_keyword |
  | event.id                    | Unique ID to describe the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | event.ingested              | Timestamp when an event arrived in the central data store. This is different from `@timestamp`, which is when the event originally occurred.  It's also different from `event.created`, which is meant to capture the first time an agent saw the event. In normal conditions, assuming no tampering, the timestamps should chronologically look like this: `@timestamp` < `event.created` < `event.ingested`.                                                                                                                                                                                                               | date             |
  | event.kind                  | This is one of four ECS Categorization Fields, and indicates the highest level in the ECS category hierarchy. `event.kind` gives high-level information about what type of information the event contains, without being specific to the contents of the event. For example, values of this field distinguish alert events from metric events. The value of this field can be used to inform how these kinds of events should be handled. They may warrant different retention, different access control, it may also help understand whether the data is coming in at a regular interval or not.                            | keyword          |
  | event.module                | Event module                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | constant_keyword |
  | event.type                  | This is one of four ECS Categorization Fields, and indicates the third level in the ECS category hierarchy. `event.type` represents a categorization "sub-bucket" that, when used along with the `event.category` field values, enables filtering events down to a level appropriate for single visualization. This field is an array. This will allow proper categorization of some events that fall in multiple event types.                                                                                                                                                                                               | keyword          |
  | host.architecture           | Operating system architecture.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | host.containerized          | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |
  | host.domain                 | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | host.hostname               | Hostname of the host. It normally contains what the `hostname` command returns on the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | host.id                     | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.ip                     | Host ip addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | host.mac                    | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | host.name                   | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host.                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.os.build               | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.codename            | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | host.os.family              | OS family (such as redhat, debian, freebsd, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.kernel              | Operating system kernel version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.os.name                | Operating system name, without the version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | host.os.name.text           | Multi-field of `host.os.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |
  | host.os.platform            | Operating system platform (such centos, ubuntu, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.os.version             | Operating system version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.type                   | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | input.type                  | Type of Filebeat input.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | log.file.path               | Full path to the log file this event came from, including the file name. It should include the drive letter, when appropriate. If the event wasn't read from a log file, do not populate this field.                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | log.flags                   | Flags for the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | log.offset                  | Offset of the entry in the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | network.community_id        | A hash of source and destination IPs and ports, as well as the protocol used in a communication. This is a tool-agnostic standard to identify flows. Learn more at .                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | network.name                | Name given by operators to sections of their network.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | network.protocol            | In the OSI Model this would be the Application Layer protocol. For example, `http`, `dns`, or `ssh`. The field value must be normalized to lowercase for querying.                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | network.transport           | Same as network.iana_number, but instead using the Keyword name of the transport layer (udp, tcp, ipv6-icmp, etc.) The field value must be normalized to lowercase for querying.                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | related.ip                  | All of the IPs seen on your event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | server.address              | Some event server addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | source.address              | Some event source addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | source.ip                   | IP address of the source (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | ip               |
  | source.port                 | Port of the source.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | long             |
  | tags                        | List of keywords used to tag each event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | zeek.dhcp.address.assigned  | IP address assigned by the server.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | zeek.dhcp.address.client    | IP address of the client. If a transaction is only a client sending INFORM messages then there is no lease information exchanged so this is helpful to know who sent the messages. Getting an address in this field does require that the client sources at least one DHCP message using a non-broadcast address.                                                                                                                                                                                                                                                                                                            | ip               |
  | zeek.dhcp.address.mac       | Client's hardware address.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | zeek.dhcp.address.requested | IP address requested by the client.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | ip               |
  | zeek.dhcp.address.server    | IP address of the DHCP server.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | ip               |
  | zeek.dhcp.client_fqdn       | FQDN given by client in Client FQDN option 81.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | zeek.dhcp.domain            | Domain given by the server in option 15.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | zeek.dhcp.duration          | Duration of the DHCP session representing the time from the first message to the last, in seconds.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | double           |
  | zeek.dhcp.hostname          | Name given by client in Hostname option 12.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | zeek.dhcp.id.circuit        | (present if policy/protocols/dhcp/sub-opts.bro is loaded) Added by DHCP relay agents which terminate switched or permanent circuits. It encodes an agent-local identifier of the circuit from which a DHCP client-to-server packet was received. Typically it should represent a router or switch interface number.                                                                                                                                                                                                                                                                                                          | keyword          |
  | zeek.dhcp.id.remote_agent   | (present if policy/protocols/dhcp/sub-opts.bro is loaded) A globally unique identifier added by relay agents to identify the remote host end of the circuit.                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | zeek.dhcp.id.subscriber     | (present if policy/protocols/dhcp/sub-opts.bro is loaded) The subscriber ID is a value independent of the physical network configuration so that a customer's DHCP configuration can be given to them correctly no matter where they are physically connected.                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | zeek.dhcp.lease_time        | IP address lease interval in seconds.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | integer          |
  | zeek.dhcp.msg.client        | Message typically accompanied with a DHCP_DECLINE so the client can tell the server why it rejected an address.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | zeek.dhcp.msg.origin        | (present if policy/protocols/dhcp/msg-orig.bro is loaded) The address that originated each message from the msg.types field.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | ip               |
  | zeek.dhcp.msg.server        | Message typically accompanied with a DHCP_NAK to let the client know why it rejected the request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | zeek.dhcp.msg.types         | List of DHCP message types seen in this exchange.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | zeek.dhcp.software.client   | (present if policy/protocols/dhcp/software.bro is loaded) Software reported by the client in the vendor_class option.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | zeek.dhcp.software.server   | (present if policy/protocols/dhcp/software.bro is loaded) Software reported by the client in the vendor_class option.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | zeek.session_id             | A unique identifier of the session                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
</dropdown>


### dnp3

The `dnp3` dataset collects the Zeek dnp3.log file which contains DNP3
requests and replies.
<dropdown title="Exported fields">
  | Field                                 | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |---------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                            | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                                                                                                                            | date             |
  | cloud.account.id                      | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.availability_zone               | Availability zone in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | cloud.image.id                        | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.instance.id                     | Instance ID of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.instance.name                   | Instance name of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.machine.type                    | Machine type of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | cloud.project.id                      | The cloud project identifier. Examples: Google Cloud Project id, Azure Project id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.provider                        | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.region                          | Region in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | container.id                          | Unique container id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | container.image.name                  | Name of the image the container was built on.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | container.labels                      | Image labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | object           |
  | container.name                        | Container name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | data_stream.dataset                   | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                                                                                 | constant_keyword |
  | data_stream.namespace                 | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                                                                                                                | constant_keyword |
  | data_stream.type                      | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | destination.address                   | Some event destination addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | destination.as.number                 | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | long             |
  | destination.as.organization.name      | Organization name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | destination.as.organization.name.text | Multi-field of `destination.as.organization.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | match_only_text  |
  | destination.bytes                     | Bytes sent from the destination to the source.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | long             |
  | destination.geo.city_name             | City name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | destination.geo.continent_name        | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | destination.geo.country_iso_code      | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | destination.geo.country_name          | Country name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | destination.geo.location              | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | geo_point        |
  | destination.geo.name                  | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | destination.geo.region_iso_code       | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | destination.geo.region_name           | Region name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | destination.ip                        | IP address of the destination (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | ip               |
  | destination.port                      | Port of the destination.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | long             |
  | ecs.version                           | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | error.message                         | Error message.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |
  | event.action                          | The action captured by the event. This describes the information in the event. It is more specific than `event.category`. Examples are `group-add`, `process-started`, `file-created`. The value is normally defined by the implementer.                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | event.category                        | This is one of four ECS Categorization Fields, and indicates the second level in the ECS category hierarchy. `event.category` represents the "big buckets" of ECS categories. For example, filtering on `event.category:process` yields all events relating to process activity. This field is closely related to `event.type`, which is used as a subcategory. This field is an array. This will allow proper categorization of some events that fall in multiple categories.                                                                                                                                               | keyword          |
  | event.created                         | `event.created` contains the date/time when the event was first read by an agent, or by your pipeline. This field is distinct from `@timestamp` in that `@timestamp` typically contain the time extracted from the original event. In most situations, these two timestamps will be slightly different. The difference can be used to calculate the delay between your source generating an event, and the time when your agent first processed it. This can be used to monitor your agent's or pipeline's ability to keep up with your event source. In case the two timestamps are identical, `@timestamp` should be used. | date             |
  | event.dataset                         | Event dataset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | constant_keyword |
  | event.id                              | Unique ID to describe the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | event.ingested                        | Timestamp when an event arrived in the central data store. This is different from `@timestamp`, which is when the event originally occurred.  It's also different from `event.created`, which is meant to capture the first time an agent saw the event. In normal conditions, assuming no tampering, the timestamps should chronologically look like this: `@timestamp` < `event.created` < `event.ingested`.                                                                                                                                                                                                               | date             |
  | event.kind                            | This is one of four ECS Categorization Fields, and indicates the highest level in the ECS category hierarchy. `event.kind` gives high-level information about what type of information the event contains, without being specific to the contents of the event. For example, values of this field distinguish alert events from metric events. The value of this field can be used to inform how these kinds of events should be handled. They may warrant different retention, different access control, it may also help understand whether the data is coming in at a regular interval or not.                            | keyword          |
  | event.module                          | Event module                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | constant_keyword |
  | event.type                            | This is one of four ECS Categorization Fields, and indicates the third level in the ECS category hierarchy. `event.type` represents a categorization "sub-bucket" that, when used along with the `event.category` field values, enables filtering events down to a level appropriate for single visualization. This field is an array. This will allow proper categorization of some events that fall in multiple event types.                                                                                                                                                                                               | keyword          |
  | host.architecture                     | Operating system architecture.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | host.containerized                    | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |
  | host.domain                           | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | host.hostname                         | Hostname of the host. It normally contains what the `hostname` command returns on the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | host.id                               | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.ip                               | Host ip addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | host.mac                              | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | host.name                             | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host.                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.os.build                         | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.codename                      | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | host.os.family                        | OS family (such as redhat, debian, freebsd, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.kernel                        | Operating system kernel version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.os.name                          | Operating system name, without the version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | host.os.name.text                     | Multi-field of `host.os.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |
  | host.os.platform                      | Operating system platform (such centos, ubuntu, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.os.version                       | Operating system version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.type                             | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | input.type                            | Type of Filebeat input.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | log.file.path                         | Full path to the log file this event came from, including the file name. It should include the drive letter, when appropriate. If the event wasn't read from a log file, do not populate this field.                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | log.flags                             | Flags for the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | log.offset                            | Offset of the entry in the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | network.community_id                  | A hash of source and destination IPs and ports, as well as the protocol used in a communication. This is a tool-agnostic standard to identify flows. Learn more at .                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | network.protocol                      | In the OSI Model this would be the Application Layer protocol. For example, `http`, `dns`, or `ssh`. The field value must be normalized to lowercase for querying.                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | network.transport                     | Same as network.iana_number, but instead using the Keyword name of the transport layer (udp, tcp, ipv6-icmp, etc.) The field value must be normalized to lowercase for querying.                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | related.ip                            | All of the IPs seen on your event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | source.address                        | Some event source addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | source.as.number                      | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | long             |
  | source.as.organization.name           | Organization name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | source.as.organization.name.text      | Multi-field of `source.as.organization.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | match_only_text  |
  | source.bytes                          | Bytes sent from the source to the destination.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | long             |
  | source.geo.city_name                  | City name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | source.geo.continent_name             | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | source.geo.country_iso_code           | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | source.geo.country_name               | Country name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | source.geo.location                   | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | geo_point        |
  | source.geo.name                       | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | source.geo.region_iso_code            | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | source.geo.region_name                | Region name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | source.ip                             | IP address of the source (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | ip               |
  | source.port                           | Port of the source.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | long             |
  | tags                                  | List of keywords used to tag each event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | zeek.dnp3.function.reply              | The name of the function message in the reply.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | zeek.dnp3.function.request            | The name of the function message in the request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | zeek.dnp3.id                          | The response's internal indication number.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | integer          |
  | zeek.session_id                       | A unique identifier of the session                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
</dropdown>


### dns

The `dns` dataset collects the Zeek dns.log file which contains DNS
activity.
<dropdown title="Exported fields">
  | Field                                 | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | Type             |
  |---------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                            | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | date             |
  | cloud.account.id                      | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | cloud.availability_zone               | Availability zone in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | cloud.image.id                        | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | cloud.instance.id                     | Instance ID of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | cloud.instance.name                   | Instance name of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | cloud.machine.type                    | Machine type of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | cloud.project.id                      | The cloud project identifier. Examples: Google Cloud Project id, Azure Project id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | cloud.provider                        | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | cloud.region                          | Region in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | container.id                          | Unique container id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | container.image.name                  | Name of the image the container was built on.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | container.labels                      | Image labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | object           |
  | container.name                        | Container name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | data_stream.dataset                   | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                                                                                                                                                                                                                                                                                                                                                                            | constant_keyword |
  | data_stream.namespace                 | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                                                                                                                                                                                                                                                                                                                                                                                                           | constant_keyword |
  | data_stream.type                      | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | constant_keyword |
  | destination.address                   | Some event destination addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | destination.as.number                 | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | long             |
  | destination.as.organization.name      | Organization name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | destination.as.organization.name.text | Multi-field of `destination.as.organization.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | match_only_text  |
  | destination.geo.city_name             | City name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | destination.geo.continent_name        | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | destination.geo.country_iso_code      | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | destination.geo.country_name          | Country name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | destination.geo.location              | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | geo_point        |
  | destination.geo.name                  | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | destination.geo.region_iso_code       | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | destination.geo.region_name           | Region name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | destination.ip                        | IP address of the destination (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | destination.port                      | Port of the destination.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | long             |
  | dns.answers                           | An array containing an object for each answer section returned by the server. The main keys that should be present in these objects are defined by ECS. Records that have more information may contain more keys than what ECS defines. Not all DNS data sources give all details about DNS answers. At minimum, answer objects must contain the `data` key. If more information is available, map as much of it to ECS as possible, and add any additional fields to the answer objects as custom fields.                                                                                                                                                                                                                                                                                                                                                                                                              | group            |
  | dns.answers.class                     | The class of DNS data contained in this resource record.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | dns.answers.data                      | The data describing the resource. The meaning of this data depends on the type and class of the resource record.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | dns.answers.name                      | The domain name to which this resource record pertains. If a chain of CNAME is being resolved, each answer's `name` should be the one that corresponds with the answer's `data`. It should not simply be the original `question.name` repeated.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | dns.answers.ttl                       | The time interval in seconds that this resource record may be cached before it should be discarded. Zero values mean that the data should not be cached.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | long             |
  | dns.answers.type                      | The type of data contained in this resource record.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | dns.header_flags                      | Array of 2 letter DNS header flags.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | dns.id                                | The DNS packet identifier assigned by the program that generated the query. The identifier is copied to the response.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | dns.question.class                    | The class of records being queried.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | dns.question.name                     | The name being queried. If the name field contains non-printable characters (below 32 or above 126), those characters should be represented as escaped base 10 integers (\DDD). Back slashes and quotes should be escaped. Tabs, carriage returns, and line feeds should be converted to \t, \r, and \n respectively.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | dns.question.registered_domain        | The highest registered domain, stripped of the subdomain. For example, the registered domain for "foo.example.com" is "example.com". This value can be determined precisely with a list like the public suffix list (). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk".                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | dns.question.subdomain                | The subdomain is all of the labels under the registered_domain. If the domain has multiple levels of subdomain, such as "sub2.sub1.example.com", the subdomain field should contain "sub2.sub1", with no trailing period.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | dns.question.top_level_domain         | The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for example.com is "com". This value can be determined precisely with a list like the public suffix list (). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk".                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | dns.question.type                     | The type of record being queried.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | dns.resolved_ip                       | Array containing all IPs seen in `answers.data`. The `answers` array can be difficult to use, because of the variety of data formats it can contain. Extracting all IP addresses seen in there to `dns.resolved_ip` makes it possible to index them as IP addresses, and makes them easier to visualize and query for.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | ip               |
  | dns.response_code                     | The DNS response code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | dns.type                              | The type of DNS event captured, query or answer. If your source of DNS events only gives you DNS queries, you should only create dns events of type `dns.type:query`. If your source of DNS events gives you answers as well, you should create one event per query (optionally as soon as the query is seen). And a second event containing all query details as well as an array of answers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | ecs.version                           | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | error.message                         | Error message.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | match_only_text  |
  | event.category                        | This is one of four ECS Categorization Fields, and indicates the second level in the ECS category hierarchy. `event.category` represents the "big buckets" of ECS categories. For example, filtering on `event.category:process` yields all events relating to process activity. This field is closely related to `event.type`, which is used as a subcategory. This field is an array. This will allow proper categorization of some events that fall in multiple categories.                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | event.created                         | `event.created` contains the date/time when the event was first read by an agent, or by your pipeline. This field is distinct from `@timestamp` in that `@timestamp` typically contain the time extracted from the original event. In most situations, these two timestamps will be slightly different. The difference can be used to calculate the delay between your source generating an event, and the time when your agent first processed it. This can be used to monitor your agent's or pipeline's ability to keep up with your event source. In case the two timestamps are identical, `@timestamp` should be used.                                                                                                                                                                                                                                                                                            | date             |
  | event.dataset                         | Event dataset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | constant_keyword |
  | event.duration                        | Duration of the event in nanoseconds. If `event.start` and `event.end` are known this value should be the difference between the end and start time.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | long             |
  | event.id                              | Unique ID to describe the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | event.ingested                        | Timestamp when an event arrived in the central data store. This is different from `@timestamp`, which is when the event originally occurred.  It's also different from `event.created`, which is meant to capture the first time an agent saw the event. In normal conditions, assuming no tampering, the timestamps should chronologically look like this: `@timestamp` < `event.created` < `event.ingested`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | date             |
  | event.kind                            | This is one of four ECS Categorization Fields, and indicates the highest level in the ECS category hierarchy. `event.kind` gives high-level information about what type of information the event contains, without being specific to the contents of the event. For example, values of this field distinguish alert events from metric events. The value of this field can be used to inform how these kinds of events should be handled. They may warrant different retention, different access control, it may also help understand whether the data is coming in at a regular interval or not.                                                                                                                                                                                                                                                                                                                       | keyword          |
  | event.module                          | Event module                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | constant_keyword |
  | event.original                        | Raw text message of entire event. Used to demonstrate log integrity or where the full log message (before splitting it up in multiple parts) may be required, e.g. for reindex. This field is not indexed and doc_values are disabled. It cannot be searched, but it can be retrieved from `_source`. If users wish to override this and index this field, please see `Field data types` in the `Elasticsearch Reference`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | event.outcome                         | This is one of four ECS Categorization Fields, and indicates the lowest level in the ECS category hierarchy. `event.outcome` simply denotes whether the event represents a success or a failure from the perspective of the entity that produced the event. Note that when a single transaction is described in multiple events, each event may populate different values of `event.outcome`, according to their perspective. Also note that in the case of a compound event (a single event that contains multiple logical events), this field should be populated with the value that best captures the overall success or failure from the perspective of the event producer. Further note that not all events will have an associated outcome. For example, this field is generally not populated for metric events, events with `event.type:info`, or any events for which an outcome does not make logical sense. | keyword          |
  | event.type                            | This is one of four ECS Categorization Fields, and indicates the third level in the ECS category hierarchy. `event.type` represents a categorization "sub-bucket" that, when used along with the `event.category` field values, enables filtering events down to a level appropriate for single visualization. This field is an array. This will allow proper categorization of some events that fall in multiple event types.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | host.architecture                     | Operating system architecture.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | host.containerized                    | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | boolean          |
  | host.domain                           | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | host.hostname                         | Hostname of the host. It normally contains what the `hostname` command returns on the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | host.id                               | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.ip                               | Host ip addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | ip               |
  | host.mac                              | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | host.name                             | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | host.os.build                         | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | host.os.codename                      | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.os.family                        | OS family (such as redhat, debian, freebsd, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | host.os.kernel                        | Operating system kernel version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.name                          | Operating system name, without the version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.os.name.text                     | Multi-field of `host.os.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | match_only_text  |
  | host.os.platform                      | Operating system platform (such centos, ubuntu, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | host.os.version                       | Operating system version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | host.type                             | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | input.type                            | Type of Filebeat input.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | log.file.path                         | Full path to the log file this event came from, including the file name. It should include the drive letter, when appropriate. If the event wasn't read from a log file, do not populate this field.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | log.flags                             | Flags for the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | log.offset                            | Offset of the entry in the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | long             |
  | network.community_id                  | A hash of source and destination IPs and ports, as well as the protocol used in a communication. This is a tool-agnostic standard to identify flows. Learn more at .                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | network.protocol                      | In the OSI Model this would be the Application Layer protocol. For example, `http`, `dns`, or `ssh`. The field value must be normalized to lowercase for querying.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | network.transport                     | Same as network.iana_number, but instead using the Keyword name of the transport layer (udp, tcp, ipv6-icmp, etc.) The field value must be normalized to lowercase for querying.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | related.ip                            | All of the IPs seen on your event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | ip               |
  | source.address                        | Some event source addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | source.as.number                      | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | long             |
  | source.as.organization.name           | Organization name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | source.as.organization.name.text      | Multi-field of `source.as.organization.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | match_only_text  |
  | source.geo.city_name                  | City name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | source.geo.continent_name             | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | source.geo.country_iso_code           | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | source.geo.country_name               | Country name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | source.geo.location                   | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | geo_point        |
  | source.geo.name                       | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | source.geo.region_iso_code            | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | source.geo.region_name                | Region name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | source.ip                             | IP address of the source (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | ip               |
  | source.port                           | Port of the source.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | long             |
  | tags                                  | List of keywords used to tag each event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | zeek.dns.AA                           | The Authoritative Answer bit for response messages specifies that the responding name server is an authority for the domain name in the question section.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | boolean          |
  | zeek.dns.RA                           | The Recursion Available bit in a response message indicates that the name server supports recursive queries.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | boolean          |
  | zeek.dns.RD                           | The Recursion Desired bit in a request message indicates that the client wants recursive service for this query.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | boolean          |
  | zeek.dns.TC                           | The Truncation bit specifies that the message was truncated.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | boolean          |
  | zeek.dns.TTLs                         | The caching intervals of the associated RRs described by the answers field.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | double           |
  | zeek.dns.answers                      | The set of resource descriptions in the query answer.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | zeek.dns.qclass                       | The QCLASS value specifying the class of the query.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | long             |
  | zeek.dns.qclass_name                  | A descriptive name for the class of the query.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | zeek.dns.qtype                        | A QTYPE value specifying the type of the query.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | zeek.dns.qtype_name                   | A descriptive name for the type of the query.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | zeek.dns.query                        | The domain name that is the subject of the DNS query.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | zeek.dns.rcode                        | The response code value in DNS response messages.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | long             |
  | zeek.dns.rcode_name                   | A descriptive name for the response code value.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | zeek.dns.rejected                     | Indicates whether the DNS query was rejected by the server.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | boolean          |
  | zeek.dns.rtt                          | Round trip time for the query and response.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | double           |
  | zeek.dns.saw_query                    | Whether the full DNS query has been seen.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | boolean          |
  | zeek.dns.saw_reply                    | Whether the full DNS reply has been seen.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | boolean          |
  | zeek.dns.total_answers                | The total number of resource records in the reply.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | integer          |
  | zeek.dns.total_replies                | The total number of resource records in the reply message.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | integer          |
  | zeek.dns.trans_id                     | DNS transaction identifier.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | zeek.session_id                       | A unique identifier of the session                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
</dropdown>


### dpd

The `dpd` dataset collects the Zeek dpd.log, which contains dynamic
protocol detection failures.
<dropdown title="Exported fields">
  | Field                                 | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |---------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                            | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                                                                                                                            | date             |
  | cloud.account.id                      | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.availability_zone               | Availability zone in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | cloud.image.id                        | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.instance.id                     | Instance ID of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.instance.name                   | Instance name of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.machine.type                    | Machine type of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | cloud.project.id                      | The cloud project identifier. Examples: Google Cloud Project id, Azure Project id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.provider                        | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.region                          | Region in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | container.id                          | Unique container id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | container.image.name                  | Name of the image the container was built on.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | container.labels                      | Image labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | object           |
  | container.name                        | Container name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | data_stream.dataset                   | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                                                                                 | constant_keyword |
  | data_stream.namespace                 | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                                                                                                                | constant_keyword |
  | data_stream.type                      | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | destination.address                   | Some event destination addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | destination.as.number                 | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | long             |
  | destination.as.organization.name      | Organization name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | destination.as.organization.name.text | Multi-field of `destination.as.organization.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | match_only_text  |
  | destination.geo.city_name             | City name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | destination.geo.continent_name        | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | destination.geo.country_iso_code      | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | destination.geo.country_name          | Country name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | destination.geo.location              | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | geo_point        |
  | destination.geo.name                  | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | destination.geo.region_iso_code       | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | destination.geo.region_name           | Region name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | destination.ip                        | IP address of the destination (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | ip               |
  | destination.port                      | Port of the destination.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | long             |
  | ecs.version                           | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | error.message                         | Error message.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |
  | event.category                        | This is one of four ECS Categorization Fields, and indicates the second level in the ECS category hierarchy. `event.category` represents the "big buckets" of ECS categories. For example, filtering on `event.category:process` yields all events relating to process activity. This field is closely related to `event.type`, which is used as a subcategory. This field is an array. This will allow proper categorization of some events that fall in multiple categories.                                                                                                                                               | keyword          |
  | event.created                         | `event.created` contains the date/time when the event was first read by an agent, or by your pipeline. This field is distinct from `@timestamp` in that `@timestamp` typically contain the time extracted from the original event. In most situations, these two timestamps will be slightly different. The difference can be used to calculate the delay between your source generating an event, and the time when your agent first processed it. This can be used to monitor your agent's or pipeline's ability to keep up with your event source. In case the two timestamps are identical, `@timestamp` should be used. | date             |
  | event.dataset                         | Event dataset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | constant_keyword |
  | event.id                              | Unique ID to describe the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | event.ingested                        | Timestamp when an event arrived in the central data store. This is different from `@timestamp`, which is when the event originally occurred.  It's also different from `event.created`, which is meant to capture the first time an agent saw the event. In normal conditions, assuming no tampering, the timestamps should chronologically look like this: `@timestamp` < `event.created` < `event.ingested`.                                                                                                                                                                                                               | date             |
  | event.kind                            | This is one of four ECS Categorization Fields, and indicates the highest level in the ECS category hierarchy. `event.kind` gives high-level information about what type of information the event contains, without being specific to the contents of the event. For example, values of this field distinguish alert events from metric events. The value of this field can be used to inform how these kinds of events should be handled. They may warrant different retention, different access control, it may also help understand whether the data is coming in at a regular interval or not.                            | keyword          |
  | event.module                          | Event module                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | constant_keyword |
  | event.type                            | This is one of four ECS Categorization Fields, and indicates the third level in the ECS category hierarchy. `event.type` represents a categorization "sub-bucket" that, when used along with the `event.category` field values, enables filtering events down to a level appropriate for single visualization. This field is an array. This will allow proper categorization of some events that fall in multiple event types.                                                                                                                                                                                               | keyword          |
  | host.architecture                     | Operating system architecture.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | host.containerized                    | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |
  | host.domain                           | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | host.hostname                         | Hostname of the host. It normally contains what the `hostname` command returns on the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | host.id                               | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.ip                               | Host ip addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | host.mac                              | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | host.name                             | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host.                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.os.build                         | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.codename                      | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | host.os.family                        | OS family (such as redhat, debian, freebsd, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.kernel                        | Operating system kernel version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.os.name                          | Operating system name, without the version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | host.os.name.text                     | Multi-field of `host.os.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |
  | host.os.platform                      | Operating system platform (such centos, ubuntu, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.os.version                       | Operating system version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.type                             | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | input.type                            | Type of Filebeat input.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | log.file.path                         | Full path to the log file this event came from, including the file name. It should include the drive letter, when appropriate. If the event wasn't read from a log file, do not populate this field.                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | log.flags                             | Flags for the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | log.offset                            | Offset of the entry in the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | network.community_id                  | A hash of source and destination IPs and ports, as well as the protocol used in a communication. This is a tool-agnostic standard to identify flows. Learn more at .                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | network.transport                     | Same as network.iana_number, but instead using the Keyword name of the transport layer (udp, tcp, ipv6-icmp, etc.) The field value must be normalized to lowercase for querying.                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | related.ip                            | All of the IPs seen on your event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | source.address                        | Some event source addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | source.as.number                      | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | long             |
  | source.as.organization.name           | Organization name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | source.as.organization.name.text      | Multi-field of `source.as.organization.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | match_only_text  |
  | source.geo.city_name                  | City name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | source.geo.continent_name             | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | source.geo.country_iso_code           | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | source.geo.country_name               | Country name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | source.geo.location                   | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | geo_point        |
  | source.geo.name                       | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | source.geo.region_iso_code            | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | source.geo.region_name                | Region name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | source.ip                             | IP address of the source (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | ip               |
  | source.port                           | Port of the source.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | long             |
  | tags                                  | List of keywords used to tag each event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | zeek.dpd.analyzer                     | The analyzer that generated the violation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | zeek.dpd.failure_reason               | The textual reason for the analysis failure.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | zeek.dpd.packet_segment               | (present if policy/frameworks/dpd/packet-segment-logging.bro is loaded) A chunk of the payload that most likely resulted in the protocol violation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | zeek.session_id                       | A unique identifier of the session                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
</dropdown>


### files

The `files` dataset collects the Zeek files.log file, which contains
file analysis results.
<dropdown title="Exported fields">
  | Field                       | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |-----------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                  | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                                                                                                                            | date             |
  | client.ip                   | IP address of the client (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | ip               |
  | cloud.account.id            | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.availability_zone     | Availability zone in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | cloud.image.id              | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.instance.id           | Instance ID of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.instance.name         | Instance name of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.machine.type          | Machine type of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | cloud.project.id            | The cloud project identifier. Examples: Google Cloud Project id, Azure Project id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.provider              | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.region                | Region in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | container.id                | Unique container id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | container.image.name        | Name of the image the container was built on.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | container.labels            | Image labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | object           |
  | container.name              | Container name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | data_stream.dataset         | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                                                                                 | constant_keyword |
  | data_stream.namespace       | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                                                                                                                | constant_keyword |
  | data_stream.type            | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | ecs.version                 | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | error.message               | Error message.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |
  | event.category              | This is one of four ECS Categorization Fields, and indicates the second level in the ECS category hierarchy. `event.category` represents the "big buckets" of ECS categories. For example, filtering on `event.category:process` yields all events relating to process activity. This field is closely related to `event.type`, which is used as a subcategory. This field is an array. This will allow proper categorization of some events that fall in multiple categories.                                                                                                                                               | keyword          |
  | event.created               | `event.created` contains the date/time when the event was first read by an agent, or by your pipeline. This field is distinct from `@timestamp` in that `@timestamp` typically contain the time extracted from the original event. In most situations, these two timestamps will be slightly different. The difference can be used to calculate the delay between your source generating an event, and the time when your agent first processed it. This can be used to monitor your agent's or pipeline's ability to keep up with your event source. In case the two timestamps are identical, `@timestamp` should be used. | date             |
  | event.dataset               | Event dataset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | constant_keyword |
  | event.id                    | Unique ID to describe the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | event.ingested              | Timestamp when an event arrived in the central data store. This is different from `@timestamp`, which is when the event originally occurred.  It's also different from `event.created`, which is meant to capture the first time an agent saw the event. In normal conditions, assuming no tampering, the timestamps should chronologically look like this: `@timestamp` < `event.created` < `event.ingested`.                                                                                                                                                                                                               | date             |
  | event.kind                  | This is one of four ECS Categorization Fields, and indicates the highest level in the ECS category hierarchy. `event.kind` gives high-level information about what type of information the event contains, without being specific to the contents of the event. For example, values of this field distinguish alert events from metric events. The value of this field can be used to inform how these kinds of events should be handled. They may warrant different retention, different access control, it may also help understand whether the data is coming in at a regular interval or not.                            | keyword          |
  | event.module                | Event module                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | constant_keyword |
  | event.type                  | This is one of four ECS Categorization Fields, and indicates the third level in the ECS category hierarchy. `event.type` represents a categorization "sub-bucket" that, when used along with the `event.category` field values, enables filtering events down to a level appropriate for single visualization. This field is an array. This will allow proper categorization of some events that fall in multiple event types.                                                                                                                                                                                               | keyword          |
  | file.hash.md5               | MD5 hash.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | file.hash.sha1              | SHA1 hash.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | file.hash.sha256            | SHA256 hash.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | file.mime_type              | MIME type should identify the format of the file or stream of bytes using  official types], where possible. When more than one type is applicable, the most specific type should be used.                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | file.name                   | Name of the file including the extension, without the directory.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | file.size                   | File size in bytes. Only relevant when `file.type` is "file".                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | long             |
  | host.architecture           | Operating system architecture.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | host.containerized          | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |
  | host.domain                 | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | host.hostname               | Hostname of the host. It normally contains what the `hostname` command returns on the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | host.id                     | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.ip                     | Host ip addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | host.mac                    | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | host.name                   | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host.                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.os.build               | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.codename            | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | host.os.family              | OS family (such as redhat, debian, freebsd, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.kernel              | Operating system kernel version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.os.name                | Operating system name, without the version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | host.os.name.text           | Multi-field of `host.os.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |
  | host.os.platform            | Operating system platform (such centos, ubuntu, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.os.version             | Operating system version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.type                   | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | input.type                  | Type of Filebeat input.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | log.file.path               | Full path to the log file this event came from, including the file name. It should include the drive letter, when appropriate. If the event wasn't read from a log file, do not populate this field.                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | log.flags                   | Flags for the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | log.offset                  | Offset of the entry in the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | related.hash                | All the hashes seen on your event. Populating this field, then using it to search for hashes can help in situations where you're unsure what the hash algorithm is (and therefore which key name to search).                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | related.ip                  | All of the IPs seen on your event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | server.ip                   | IP address of the server (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | ip               |
  | tags                        | List of keywords used to tag each event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | zeek.files.analyzers        | A set of analysis types done during the file analysis.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | zeek.files.depth            | A value to represent the depth of this file in relation to its source. In SMTP, it is the depth of the MIME attachment on the message. In HTTP, it is the depth of the request within the TCP connection.                                                                                                                                                                                                                                                                                                                                                                                                                    | long             |
  | zeek.files.duration         | The duration the file was analyzed for. Not the duration of the session.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | double           |
  | zeek.files.entropy          | The information density of the contents of the file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | double           |
  | zeek.files.extracted        | Local filename of extracted file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | zeek.files.extracted_cutoff | Indicate whether the file being extracted was cut off hence not extracted completely.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | boolean          |
  | zeek.files.extracted_size   | The number of bytes extracted to disk.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | long             |
  | zeek.files.filename         | Name of the file if available.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | zeek.files.fuid             | A file unique identifier.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | zeek.files.is_orig          | If the source of this file is a network connection, this field indicates if the file is being sent by the originator of the connection or the responder.                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | boolean          |
  | zeek.files.local_orig       | If the source of this file is a network connection, this field indicates if the data originated from the local network or not.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | boolean          |
  | zeek.files.md5              | An MD5 digest of the file contents.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | zeek.files.mime_type        | Mime type of the file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | zeek.files.missing_bytes    | The number of bytes in the file stream that were completely missed during the process of analysis.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | long             |
  | zeek.files.overflow_bytes   | The number of bytes in the file stream that were not delivered to stream file analyzers. This could be overlapping bytes or bytes that couldn't be reassembled.                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | zeek.files.parent_fuid      | Identifier associated with a container file from which this one was extracted as part of the file analysis.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | zeek.files.rx_host          | The host that received the file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | ip               |
  | zeek.files.seen_bytes       | Number of bytes provided to the file analysis engine for the file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | long             |
  | zeek.files.session_ids      | The sessions that have this file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | zeek.files.sha1             | A SHA1 digest of the file contents.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | zeek.files.sha256           | A SHA256 digest of the file contents.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | zeek.files.source           | An identification of the source of the file data. E.g. it may be a network protocol over which it was transferred, or a local file path which was read, or some other input source.                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | zeek.files.timedout         | Whether the file analysis timed out at least once for the file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | boolean          |
  | zeek.files.total_bytes      | Total number of bytes that are supposed to comprise the full file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | long             |
  | zeek.files.tx_host          | The host that transferred the file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | ip               |
  | zeek.session_id             | A unique identifier of the session                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
</dropdown>


### ftp

The `ftp` dataset collects the Zeek ftp.log file, which contains FTP
activity.
<dropdown title="Exported fields">
  | Field                                  | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |----------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                             | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                                                                                                                            | date             |
  | cloud.account.id                       | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.availability_zone                | Availability zone in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | cloud.image.id                         | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.instance.id                      | Instance ID of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.instance.name                    | Instance name of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.machine.type                     | Machine type of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | cloud.project.id                       | The cloud project identifier. Examples: Google Cloud Project id, Azure Project id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.provider                         | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.region                           | Region in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | container.id                           | Unique container id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | container.image.name                   | Name of the image the container was built on.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | container.labels                       | Image labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | object           |
  | container.name                         | Container name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | data_stream.dataset                    | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                                                                                 | constant_keyword |
  | data_stream.namespace                  | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                                                                                                                | constant_keyword |
  | data_stream.type                       | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | destination.address                    | Some event destination addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | destination.as.number                  | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | long             |
  | destination.as.organization.name       | Organization name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | destination.as.organization.name.text  | Multi-field of `destination.as.organization.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | match_only_text  |
  | destination.geo.city_name              | City name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | destination.geo.continent_name         | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | destination.geo.country_iso_code       | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | destination.geo.country_name           | Country name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | destination.geo.location               | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | geo_point        |
  | destination.geo.name                   | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | destination.geo.region_iso_code        | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | destination.geo.region_name            | Region name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | destination.ip                         | IP address of the destination (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | ip               |
  | destination.port                       | Port of the destination.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | long             |
  | ecs.version                            | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | error.message                          | Error message.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |
  | event.action                           | The action captured by the event. This describes the information in the event. It is more specific than `event.category`. Examples are `group-add`, `process-started`, `file-created`. The value is normally defined by the implementer.                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | event.category                         | This is one of four ECS Categorization Fields, and indicates the second level in the ECS category hierarchy. `event.category` represents the "big buckets" of ECS categories. For example, filtering on `event.category:process` yields all events relating to process activity. This field is closely related to `event.type`, which is used as a subcategory. This field is an array. This will allow proper categorization of some events that fall in multiple categories.                                                                                                                                               | keyword          |
  | event.created                          | `event.created` contains the date/time when the event was first read by an agent, or by your pipeline. This field is distinct from `@timestamp` in that `@timestamp` typically contain the time extracted from the original event. In most situations, these two timestamps will be slightly different. The difference can be used to calculate the delay between your source generating an event, and the time when your agent first processed it. This can be used to monitor your agent's or pipeline's ability to keep up with your event source. In case the two timestamps are identical, `@timestamp` should be used. | date             |
  | event.dataset                          | Event dataset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | constant_keyword |
  | event.id                               | Unique ID to describe the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | event.ingested                         | Timestamp when an event arrived in the central data store. This is different from `@timestamp`, which is when the event originally occurred.  It's also different from `event.created`, which is meant to capture the first time an agent saw the event. In normal conditions, assuming no tampering, the timestamps should chronologically look like this: `@timestamp` < `event.created` < `event.ingested`.                                                                                                                                                                                                               | date             |
  | event.kind                             | This is one of four ECS Categorization Fields, and indicates the highest level in the ECS category hierarchy. `event.kind` gives high-level information about what type of information the event contains, without being specific to the contents of the event. For example, values of this field distinguish alert events from metric events. The value of this field can be used to inform how these kinds of events should be handled. They may warrant different retention, different access control, it may also help understand whether the data is coming in at a regular interval or not.                            | keyword          |
  | event.module                           | Event module                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | constant_keyword |
  | event.type                             | This is one of four ECS Categorization Fields, and indicates the third level in the ECS category hierarchy. `event.type` represents a categorization "sub-bucket" that, when used along with the `event.category` field values, enables filtering events down to a level appropriate for single visualization. This field is an array. This will allow proper categorization of some events that fall in multiple event types.                                                                                                                                                                                               | keyword          |
  | file.mime_type                         | MIME type should identify the format of the file or stream of bytes using  official types], where possible. When more than one type is applicable, the most specific type should be used.                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | file.size                              | File size in bytes. Only relevant when `file.type` is "file".                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | long             |
  | host.architecture                      | Operating system architecture.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | host.containerized                     | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |
  | host.domain                            | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | host.hostname                          | Hostname of the host. It normally contains what the `hostname` command returns on the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | host.id                                | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.ip                                | Host ip addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | host.mac                               | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | host.name                              | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host.                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.os.build                          | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.codename                       | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | host.os.family                         | OS family (such as redhat, debian, freebsd, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.kernel                         | Operating system kernel version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.os.name                           | Operating system name, without the version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | host.os.name.text                      | Multi-field of `host.os.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |
  | host.os.platform                       | Operating system platform (such centos, ubuntu, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.os.version                        | Operating system version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.type                              | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | input.type                             | Type of Filebeat input.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | log.file.path                          | Full path to the log file this event came from, including the file name. It should include the drive letter, when appropriate. If the event wasn't read from a log file, do not populate this field.                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | log.flags                              | Flags for the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | log.offset                             | Offset of the entry in the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | network.community_id                   | A hash of source and destination IPs and ports, as well as the protocol used in a communication. This is a tool-agnostic standard to identify flows. Learn more at .                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | network.protocol                       | In the OSI Model this would be the Application Layer protocol. For example, `http`, `dns`, or `ssh`. The field value must be normalized to lowercase for querying.                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | network.transport                      | Same as network.iana_number, but instead using the Keyword name of the transport layer (udp, tcp, ipv6-icmp, etc.) The field value must be normalized to lowercase for querying.                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | related.ip                             | All of the IPs seen on your event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | related.user                           | All the user names or other user identifiers seen on the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | source.address                         | Some event source addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | source.as.number                       | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | long             |
  | source.as.organization.name            | Organization name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | source.as.organization.name.text       | Multi-field of `source.as.organization.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | match_only_text  |
  | source.geo.city_name                   | City name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | source.geo.continent_name              | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | source.geo.country_iso_code            | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | source.geo.country_name                | Country name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | source.geo.location                    | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | geo_point        |
  | source.geo.name                        | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | source.geo.region_iso_code             | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | source.geo.region_name                 | Region name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | source.ip                              | IP address of the source (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | ip               |
  | source.port                            | Port of the source.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | long             |
  | tags                                   | List of keywords used to tag each event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | user.name                              | Short name or login of the user.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | user.name.text                         | Multi-field of `user.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | match_only_text  |
  | zeek.ftp.arg                           | Argument for the command if one is given.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | zeek.ftp.capture_password              | Determines if the password will be captured for this request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | boolean          |
  | zeek.ftp.cmdarg.arg                    | Argument for the command if one was given.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | zeek.ftp.cmdarg.cmd                    | Command.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | zeek.ftp.cmdarg.seq                    | Counter to track how many commands have been executed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | integer          |
  | zeek.ftp.command                       | Command given by the client.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | zeek.ftp.cwd                           | Current working directory that this session is in. By making the default value '.', we can indicate that unless something more concrete is discovered that the existing but unknown directory is ok to use.                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | zeek.ftp.data_channel.originating_host | The host that will be initiating the data connection.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | ip               |
  | zeek.ftp.data_channel.passive          | Whether PASV mode is toggled for control channel.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | boolean          |
  | zeek.ftp.data_channel.response_host    | The host that will be accepting the data connection.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | ip               |
  | zeek.ftp.data_channel.response_port    | The port at which the acceptor is listening for the data connection.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | integer          |
  | zeek.ftp.file.fuid                     | (present if base/protocols/ftp/files.bro is loaded) File unique ID.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | zeek.ftp.file.mime_type                | Sniffed mime type of file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | zeek.ftp.file.size                     | Size of the file if the command indicates a file transfer.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | long             |
  | zeek.ftp.last_auth_requested           | present if base/protocols/ftp/gridftp.bro is loaded. Last authentication/security mechanism that was used.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | zeek.ftp.passive                       | Indicates if the session is in active or passive mode.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | boolean          |
  | zeek.ftp.password                      | Password for the current FTP session if captured.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | zeek.ftp.pending_commands              | Queue for commands that have been sent but not yet responded to are tracked here.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | integer          |
  | zeek.ftp.reply.code                    | Reply code from the server in response to the command.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | integer          |
  | zeek.ftp.reply.msg                     | Reply message from the server in response to the command.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | zeek.ftp.user                          | User name for the current FTP session.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | zeek.session_id                        | A unique identifier of the session                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
</dropdown>


### http

The `http` dataset collects the Zeek http.log file, which contains
HTTP requests and replies.
<dropdown title="Exported fields">
  | Field                                 | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | Type             |
  |---------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                            | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | date             |
  | cloud.account.id                      | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | cloud.availability_zone               | Availability zone in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | cloud.image.id                        | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | cloud.instance.id                     | Instance ID of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | cloud.instance.name                   | Instance name of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | cloud.machine.type                    | Machine type of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | cloud.project.id                      | The cloud project identifier. Examples: Google Cloud Project id, Azure Project id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | cloud.provider                        | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | cloud.region                          | Region in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | container.id                          | Unique container id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | container.image.name                  | Name of the image the container was built on.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | container.labels                      | Image labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | object           |
  | container.name                        | Container name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | data_stream.dataset                   | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                                                                                                                                                                                                                                                                                                                                                                            | constant_keyword |
  | data_stream.namespace                 | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                                                                                                                                                                                                                                                                                                                                                                                                           | constant_keyword |
  | data_stream.type                      | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | constant_keyword |
  | destination.address                   | Some event destination addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | destination.as.number                 | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | long             |
  | destination.as.organization.name      | Organization name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | destination.as.organization.name.text | Multi-field of `destination.as.organization.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | match_only_text  |
  | destination.geo.city_name             | City name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | destination.geo.continent_name        | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | destination.geo.country_iso_code      | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | destination.geo.country_name          | Country name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | destination.geo.location              | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | geo_point        |
  | destination.geo.name                  | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | destination.geo.region_iso_code       | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | destination.geo.region_name           | Region name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | destination.ip                        | IP address of the destination (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | destination.port                      | Port of the destination.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | long             |
  | ecs.version                           | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | error.message                         | Error message.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | match_only_text  |
  | event.action                          | The action captured by the event. This describes the information in the event. It is more specific than `event.category`. Examples are `group-add`, `process-started`, `file-created`. The value is normally defined by the implementer.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | event.category                        | This is one of four ECS Categorization Fields, and indicates the second level in the ECS category hierarchy. `event.category` represents the "big buckets" of ECS categories. For example, filtering on `event.category:process` yields all events relating to process activity. This field is closely related to `event.type`, which is used as a subcategory. This field is an array. This will allow proper categorization of some events that fall in multiple categories.                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | event.created                         | `event.created` contains the date/time when the event was first read by an agent, or by your pipeline. This field is distinct from `@timestamp` in that `@timestamp` typically contain the time extracted from the original event. In most situations, these two timestamps will be slightly different. The difference can be used to calculate the delay between your source generating an event, and the time when your agent first processed it. This can be used to monitor your agent's or pipeline's ability to keep up with your event source. In case the two timestamps are identical, `@timestamp` should be used.                                                                                                                                                                                                                                                                                            | date             |
  | event.dataset                         | Event dataset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | constant_keyword |
  | event.id                              | Unique ID to describe the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | event.ingested                        | Timestamp when an event arrived in the central data store. This is different from `@timestamp`, which is when the event originally occurred.  It's also different from `event.created`, which is meant to capture the first time an agent saw the event. In normal conditions, assuming no tampering, the timestamps should chronologically look like this: `@timestamp` < `event.created` < `event.ingested`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | date             |
  | event.kind                            | This is one of four ECS Categorization Fields, and indicates the highest level in the ECS category hierarchy. `event.kind` gives high-level information about what type of information the event contains, without being specific to the contents of the event. For example, values of this field distinguish alert events from metric events. The value of this field can be used to inform how these kinds of events should be handled. They may warrant different retention, different access control, it may also help understand whether the data is coming in at a regular interval or not.                                                                                                                                                                                                                                                                                                                       | keyword          |
  | event.module                          | Event module                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | constant_keyword |
  | event.outcome                         | This is one of four ECS Categorization Fields, and indicates the lowest level in the ECS category hierarchy. `event.outcome` simply denotes whether the event represents a success or a failure from the perspective of the entity that produced the event. Note that when a single transaction is described in multiple events, each event may populate different values of `event.outcome`, according to their perspective. Also note that in the case of a compound event (a single event that contains multiple logical events), this field should be populated with the value that best captures the overall success or failure from the perspective of the event producer. Further note that not all events will have an associated outcome. For example, this field is generally not populated for metric events, events with `event.type:info`, or any events for which an outcome does not make logical sense. | keyword          |
  | event.type                            | This is one of four ECS Categorization Fields, and indicates the third level in the ECS category hierarchy. `event.type` represents a categorization "sub-bucket" that, when used along with the `event.category` field values, enables filtering events down to a level appropriate for single visualization. This field is an array. This will allow proper categorization of some events that fall in multiple event types.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | host.architecture                     | Operating system architecture.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | host.containerized                    | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | boolean          |
  | host.domain                           | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | host.hostname                         | Hostname of the host. It normally contains what the `hostname` command returns on the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | host.id                               | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.ip                               | Host ip addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | ip               |
  | host.mac                              | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | host.name                             | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | host.os.build                         | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | host.os.codename                      | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.os.family                        | OS family (such as redhat, debian, freebsd, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | host.os.kernel                        | Operating system kernel version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.name                          | Operating system name, without the version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.os.name.text                     | Multi-field of `host.os.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | match_only_text  |
  | host.os.platform                      | Operating system platform (such centos, ubuntu, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | host.os.version                       | Operating system version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | host.type                             | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | http.request.body.bytes               | Size in bytes of the request body.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | long             |
  | http.request.method                   | HTTP request method. The value should retain its casing from the original event. For example, `GET`, `get`, and `GeT` are all considered valid values for this field.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | http.request.referrer                 | Referrer for this HTTP request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | http.response.body.bytes              | Size in bytes of the response body.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | long             |
  | http.response.status_code             | HTTP response status code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | long             |
  | http.version                          | HTTP version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | input.type                            | Type of Filebeat input.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | log.file.path                         | Full path to the log file this event came from, including the file name. It should include the drive letter, when appropriate. If the event wasn't read from a log file, do not populate this field.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | log.flags                             | Flags for the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | log.offset                            | Offset of the entry in the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | long             |
  | network.community_id                  | A hash of source and destination IPs and ports, as well as the protocol used in a communication. This is a tool-agnostic standard to identify flows. Learn more at .                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | network.transport                     | Same as network.iana_number, but instead using the Keyword name of the transport layer (udp, tcp, ipv6-icmp, etc.) The field value must be normalized to lowercase for querying.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | related.ip                            | All of the IPs seen on your event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | ip               |
  | related.user                          | All the user names or other user identifiers seen on the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | source.address                        | Some event source addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | source.as.number                      | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | long             |
  | source.as.organization.name           | Organization name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | source.as.organization.name.text      | Multi-field of `source.as.organization.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | match_only_text  |
  | source.geo.city_name                  | City name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | source.geo.continent_name             | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | source.geo.country_iso_code           | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | source.geo.country_name               | Country name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | source.geo.location                   | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | geo_point        |
  | source.geo.name                       | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | source.geo.region_iso_code            | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | source.geo.region_name                | Region name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | source.ip                             | IP address of the source (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | ip               |
  | source.port                           | Port of the source.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | long             |
  | tags                                  | List of keywords used to tag each event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | url.domain                            | Domain of the url, such as "[www.elastic.co](http://www.elastic.co)". In some cases a URL may refer to an IP and/or port directly, without a domain name. In this case, the IP address would go to the `domain` field. If the URL contains a literal IPv6 address enclosed by `[` and `]` (IETF RFC 2732), the `[` and `]` characters should also be captured in the `domain` field.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | url.original                          | Unmodified original url as seen in the event source. Note that in network monitoring, the observed URL may be a full URL, whereas in access logs, the URL is often just represented as a path. This field is meant to represent the URL as it was observed, complete or not.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | wildcard         |
  | url.original.text                     | Multi-field of `url.original`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | match_only_text  |
  | url.password                          | Password of the request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | url.path                              | Path of the request, such as "/search".                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | wildcard         |
  | url.port                              | Port of the request, such as 443.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | long             |
  | url.scheme                            | Scheme of the request, such as "https". Note: The `:` is not part of the scheme.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | url.username                          | Username of the request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | user.name                             | Short name or login of the user.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | user.name.text                        | Multi-field of `user.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | match_only_text  |
  | user_agent.device.name                | Name of the device.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | user_agent.name                       | Name of the user agent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | user_agent.original                   | Unparsed user_agent string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | user_agent.original.text              | Multi-field of `user_agent.original`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | match_only_text  |
  | user_agent.os.family                  | OS family (such as redhat, debian, freebsd, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | user_agent.os.full                    | Operating system name, including the version or code name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | user_agent.os.full.text               | Multi-field of `user_agent.os.full`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | match_only_text  |
  | user_agent.os.kernel                  | Operating system kernel version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | user_agent.os.name                    | Operating system name, without the version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | user_agent.os.name.text               | Multi-field of `user_agent.os.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | match_only_text  |
  | user_agent.os.platform                | Operating system platform (such centos, ubuntu, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | user_agent.os.version                 | Operating system version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | user_agent.version                    | Version of the user agent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | zeek.http.captured_password           | Determines if the password will be captured for this request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | boolean          |
  | zeek.http.client_header_names         | The vector of HTTP header names sent by the client. No header values are included here, just the header names.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | zeek.http.host                        | The Zeek host if it differs from the domain extracted from the Zeek URI.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | zeek.http.info_code                   | Last seen 1xx informational reply code returned by the server.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | integer          |
  | zeek.http.info_msg                    | Last seen 1xx informational reply message returned by the server.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | zeek.http.orig_filenames              | An ordered vector of filenames from the originator.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | zeek.http.orig_fuids                  | An ordered vector of file unique IDs from the originator.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | zeek.http.orig_mime_depth             | Current number of MIME entities in the HTTP request message body.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | integer          |
  | zeek.http.orig_mime_types             | An ordered vector of mime types from the originator.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | zeek.http.password                    | Password if basic-auth is performed for the request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | zeek.http.proxied                     | All of the headers that may indicate if the HTTP request was proxied.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | zeek.http.range_request               | Indicates if this request can assume 206 partial content in response.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | boolean          |
  | zeek.http.resp_filenames              | An ordered vector of filenames from the responder.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | zeek.http.resp_fuids                  | An ordered vector of file unique IDs from the responder.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | zeek.http.resp_mime_depth             | Current number of MIME entities in the HTTP response message body.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | integer          |
  | zeek.http.resp_mime_types             | An ordered vector of mime types from the responder.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | zeek.http.server_header_names         | The vector of HTTP header names sent by the server. No header values are included here, just the header names.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | zeek.http.status_msg                  | Status message returned by the server.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | zeek.http.tags                        | A set of indicators of various attributes discovered and related to a particular request/response pair.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | zeek.http.trans_depth                 | Represents the pipelined depth into the connection of this request/response transaction.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | integer          |
  | zeek.session_id                       | A unique identifier of the session                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
</dropdown>


### intel

The `intel` dataset collects the Zeek intel.log file, which contains
intelligence data matches.
<dropdown title="Exported fields">
  | Field                                      | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |--------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                 | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                                                                                                                            | date             |
  | cloud.account.id                           | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.availability_zone                    | Availability zone in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | cloud.image.id                             | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.instance.id                          | Instance ID of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.instance.name                        | Instance name of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.machine.type                         | Machine type of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | cloud.project.id                           | The cloud project identifier. Examples: Google Cloud Project id, Azure Project id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.provider                             | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.region                               | Region in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | container.id                               | Unique container id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | container.image.name                       | Name of the image the container was built on.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | container.labels                           | Image labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | object           |
  | container.name                             | Container name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | data_stream.dataset                        | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                                                                                 | constant_keyword |
  | data_stream.namespace                      | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                                                                                                                | constant_keyword |
  | data_stream.type                           | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | destination.address                        | Some event destination addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | destination.as.number                      | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | long             |
  | destination.as.organization.name           | Organization name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | destination.as.organization.name.text      | Multi-field of `destination.as.organization.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | match_only_text  |
  | destination.geo.city_name                  | City name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | destination.geo.continent_name             | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | destination.geo.country_iso_code           | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | destination.geo.country_name               | Country name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | destination.geo.location                   | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | geo_point        |
  | destination.geo.name                       | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | destination.geo.region_iso_code            | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | destination.geo.region_name                | Region name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | destination.ip                             | IP address of the destination (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | ip               |
  | destination.port                           | Port of the destination.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | long             |
  | ecs.version                                | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | error.message                              | Error message.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |
  | event.created                              | `event.created` contains the date/time when the event was first read by an agent, or by your pipeline. This field is distinct from `@timestamp` in that `@timestamp` typically contain the time extracted from the original event. In most situations, these two timestamps will be slightly different. The difference can be used to calculate the delay between your source generating an event, and the time when your agent first processed it. This can be used to monitor your agent's or pipeline's ability to keep up with your event source. In case the two timestamps are identical, `@timestamp` should be used. | date             |
  | event.dataset                              | Event dataset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | constant_keyword |
  | event.ingested                             | Timestamp when an event arrived in the central data store. This is different from `@timestamp`, which is when the event originally occurred.  It's also different from `event.created`, which is meant to capture the first time an agent saw the event. In normal conditions, assuming no tampering, the timestamps should chronologically look like this: `@timestamp` < `event.created` < `event.ingested`.                                                                                                                                                                                                               | date             |
  | event.kind                                 | This is one of four ECS Categorization Fields, and indicates the highest level in the ECS category hierarchy. `event.kind` gives high-level information about what type of information the event contains, without being specific to the contents of the event. For example, values of this field distinguish alert events from metric events. The value of this field can be used to inform how these kinds of events should be handled. They may warrant different retention, different access control, it may also help understand whether the data is coming in at a regular interval or not.                            | keyword          |
  | event.module                               | Event module                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | constant_keyword |
  | event.original                             | Raw text message of entire event. Used to demonstrate log integrity or where the full log message (before splitting it up in multiple parts) may be required, e.g. for reindex. This field is not indexed and doc_values are disabled. It cannot be searched, but it can be retrieved from `_source`. If users wish to override this and index this field, please see `Field data types` in the `Elasticsearch Reference`.                                                                                                                                                                                                   | keyword          |
  | event.type                                 | This is one of four ECS Categorization Fields, and indicates the third level in the ECS category hierarchy. `event.type` represents a categorization "sub-bucket" that, when used along with the `event.category` field values, enables filtering events down to a level appropriate for single visualization. This field is an array. This will allow proper categorization of some events that fall in multiple event types.                                                                                                                                                                                               | keyword          |
  | host.architecture                          | Operating system architecture.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | host.containerized                         | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |
  | host.domain                                | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | host.hostname                              | Hostname of the host. It normally contains what the `hostname` command returns on the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | host.id                                    | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.ip                                    | Host ip addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | host.mac                                   | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | host.name                                  | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host.                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.os.build                              | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.codename                           | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | host.os.family                             | OS family (such as redhat, debian, freebsd, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.kernel                             | Operating system kernel version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.os.name                               | Operating system name, without the version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | host.os.name.text                          | Multi-field of `host.os.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |
  | host.os.platform                           | Operating system platform (such centos, ubuntu, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.os.version                            | Operating system version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.type                                  | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | input.type                                 | Type of Filebeat input.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | log.file.path                              | Full path to the log file this event came from, including the file name. It should include the drive letter, when appropriate. If the event wasn't read from a log file, do not populate this field.                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | log.flags                                  | Flags for the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | log.offset                                 | Offset of the entry in the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | network.community_id                       | A hash of source and destination IPs and ports, as well as the protocol used in a communication. This is a tool-agnostic standard to identify flows. Learn more at .                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | related.ip                                 | All of the IPs seen on your event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | source.address                             | Some event source addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | source.as.number                           | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | long             |
  | source.as.organization.name                | Organization name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | source.as.organization.name.text           | Multi-field of `source.as.organization.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | match_only_text  |
  | source.geo.city_name                       | City name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | source.geo.continent_name                  | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | source.geo.country_iso_code                | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | source.geo.country_name                    | Country name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | source.geo.location                        | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | geo_point        |
  | source.geo.name                            | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | source.geo.region_iso_code                 | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | source.geo.region_name                     | Region name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | source.ip                                  | IP address of the source (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | ip               |
  | source.port                                | Port of the source.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | long             |
  | tags                                       | List of keywords used to tag each event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | threat.enrichments                         | A list of associated indicators objects enriching the event, and the context of that association/enrichment.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | nested           |
  | threat.indicator.as.number                 | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | long             |
  | threat.indicator.as.organization.name      | Organization name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | threat.indicator.as.organization.name.text | Multi-field of `threat.indicator.as.organization.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | match_only_text  |
  | threat.indicator.email.address             | Identifies a threat indicator as an email address (irrespective of direction).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | threat.indicator.file.name                 | Name of the file including the extension, without the directory.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | threat.indicator.geo.city_name             | City name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | threat.indicator.geo.continent_name        | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | threat.indicator.geo.country_iso_code      | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | threat.indicator.geo.country_name          | Country name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | threat.indicator.geo.location              | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | geo_point        |
  | threat.indicator.geo.region_iso_code       | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | threat.indicator.geo.region_name           | Region name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | threat.indicator.geo.timezone              | The time zone of the location, such as IANA time zone name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | threat.indicator.ip                        | Identifies a threat indicator as an IP address (irrespective of direction).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | ip               |
  | threat.indicator.type                      | Type of indicator as represented by Cyber Observable in STIX 2.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | threat.indicator.url.domain                | Domain of the url, such as "[www.elastic.co](http://www.elastic.co)". In some cases a URL may refer to an IP and/or port directly, without a domain name. In this case, the IP address would go to the `domain` field. If the URL contains a literal IPv6 address enclosed by `[` and `]` (IETF RFC 2732), the `[` and `]` characters should also be captured in the `domain` field.                                                                                                                                                                                                                                         | keyword          |
  | threat.indicator.url.extension             | The field contains the file extension from the original request url, excluding the leading dot. The file extension is only set if it exists, as not every url has a file extension. The leading period must not be included. For example, the value must be "png", not ".png". Note that when the file name has multiple extensions (example.tar.gz), only the last one should be captured ("gz", not "tar.gz").                                                                                                                                                                                                             | keyword          |
  | threat.indicator.url.fragment              | Portion of the url after the `#`, such as "top". The `#` is not part of the fragment.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | threat.indicator.url.full                  | If full URLs are important to your use case, they should be stored in `url.full`, whether this field is reconstructed or present in the event source.                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | wildcard         |
  | threat.indicator.url.full.text             | Multi-field of `threat.indicator.url.full`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | match_only_text  |
  | threat.indicator.url.original              | Unmodified original url as seen in the event source. Note that in network monitoring, the observed URL may be a full URL, whereas in access logs, the URL is often just represented as a path. This field is meant to represent the URL as it was observed, complete or not.                                                                                                                                                                                                                                                                                                                                                 | wildcard         |
  | threat.indicator.url.original.text         | Multi-field of `threat.indicator.url.original`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | match_only_text  |
  | threat.indicator.url.password              | Password of the request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | threat.indicator.url.path                  | Path of the request, such as "/search".                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | wildcard         |
  | threat.indicator.url.port                  | Port of the request, such as 443.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | long             |
  | threat.indicator.url.query                 | The query field describes the query string of the request, such as "q=elasticsearch". The `?` is excluded from the query string. If a URL contains no `?`, there is no query field. If there is a `?` but no query, the query field exists with an empty string. The `exists` query can be used to differentiate between the two cases.                                                                                                                                                                                                                                                                                      | keyword          |
  | threat.indicator.url.registered_domain     | The highest registered url domain, stripped of the subdomain. For example, the registered domain for "foo.example.com" is "example.com". This value can be determined precisely with a list like the public suffix list (). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk".                                                                                                                                                                                                                                                                                     | keyword          |
  | threat.indicator.url.scheme                | Scheme of the request, such as "https". Note: The `:` is not part of the scheme.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | threat.indicator.url.subdomain             | The subdomain portion of a fully qualified domain name includes all of the names except the host name under the registered_domain.  In a partially qualified domain, or if the the qualification level of the full name cannot be determined, subdomain contains all of the names below the registered domain. For example the subdomain portion of "[www.east.example.com](http://www.east.example.com)" is "east". If the domain has multiple levels of subdomain, such as "sub2.sub1.example.com", the subdomain field should contain "sub2.sub1", with no trailing period.                                               | keyword          |
  | threat.indicator.url.top_level_domain      | The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for example.com is "com". This value can be determined precisely with a list like the public suffix list (). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk".                                                                                                                                                                                                                                                | keyword          |
  | threat.indicator.url.username              | Username of the request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | zeek.intel.file_desc                       | Frequently files can be described to give a bit more context. If the $f field is provided this field will be automatically filled out.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | zeek.intel.file_mime_type                  | A mime type if the intelligence hit is related to a file. If the $f field is provided this will be automatically filled out.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | zeek.intel.fuid                            | If a file was associated with this intelligence hit, this is the uid for the file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | zeek.intel.matched                         | Event to represent a match in the intelligence data from data that was seen.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | zeek.intel.seen.conn                       | If the data was discovered within a connection, the connection record should go here to give context to the data.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | zeek.intel.seen.f.*                        | If the data was discovered within a file, the file record should go here to provide context to the data.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | object           |
  | zeek.intel.seen.fuid                       | If the data was discovered within a file, the file uid should go here to provide context to the data. If the file record f is provided, this will be automatically filled out.                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | zeek.intel.seen.host                       | If the indicator type was Intel::ADDR, then this field will be present.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | zeek.intel.seen.indicator                  | The intelligence indicator.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | zeek.intel.seen.indicator_type             | The type of data the indicator represents.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | zeek.intel.seen.node                       | The name of the node where the match was discovered.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | zeek.intel.seen.uid                        | If the data was discovered within a connection, the connection uid should go here to give context to the data. If the conn field is provided, this will be automatically filled out.                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | zeek.intel.seen.where                      | Where the data was discovered.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | zeek.intel.sources                         | Sources which supplied data for this match.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | zeek.session_id                            | A unique identifier of the session                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
</dropdown>


### irc

The `irc` dataset collects the Zeek irc.log file, which contains IRC
commands and responses.
<dropdown title="Exported fields">
  | Field                                 | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Type             |
  |---------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                            | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                                                                                                                            | date             |
  | cloud.account.id                      | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.availability_zone               | Availability zone in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | cloud.image.id                        | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.instance.id                     | Instance ID of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.instance.name                   | Instance name of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.machine.type                    | Machine type of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | cloud.project.id                      | The cloud project identifier. Examples: Google Cloud Project id, Azure Project id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | cloud.provider                        | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | cloud.region                          | Region in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | container.id                          | Unique container id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | container.image.name                  | Name of the image the container was built on.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | container.labels                      | Image labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | object           |
  | container.name                        | Container name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | data_stream.dataset                   | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                                                                                 | constant_keyword |
  | data_stream.namespace                 | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                                                                                                                | constant_keyword |
  | data_stream.type                      | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                                                                                                                              | constant_keyword |
  | destination.address                   | Some event destination addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | destination.as.number                 | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | long             |
  | destination.as.organization.name      | Organization name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | destination.as.organization.name.text | Multi-field of `destination.as.organization.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | match_only_text  |
  | destination.geo.city_name             | City name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | destination.geo.continent_name        | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | destination.geo.country_iso_code      | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | destination.geo.country_name          | Country name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | destination.geo.location              | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | geo_point        |
  | destination.geo.name                  | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | destination.geo.region_iso_code       | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | destination.geo.region_name           | Region name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | destination.ip                        | IP address of the destination (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | ip               |
  | destination.port                      | Port of the destination.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | long             |
  | ecs.version                           | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | error.message                         | Error message.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |
  | event.action                          | The action captured by the event. This describes the information in the event. It is more specific than `event.category`. Examples are `group-add`, `process-started`, `file-created`. The value is normally defined by the implementer.                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | event.category                        | This is one of four ECS Categorization Fields, and indicates the second level in the ECS category hierarchy. `event.category` represents the "big buckets" of ECS categories. For example, filtering on `event.category:process` yields all events relating to process activity. This field is closely related to `event.type`, which is used as a subcategory. This field is an array. This will allow proper categorization of some events that fall in multiple categories.                                                                                                                                               | keyword          |
  | event.created                         | `event.created` contains the date/time when the event was first read by an agent, or by your pipeline. This field is distinct from `@timestamp` in that `@timestamp` typically contain the time extracted from the original event. In most situations, these two timestamps will be slightly different. The difference can be used to calculate the delay between your source generating an event, and the time when your agent first processed it. This can be used to monitor your agent's or pipeline's ability to keep up with your event source. In case the two timestamps are identical, `@timestamp` should be used. | date             |
  | event.dataset                         | Event dataset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | constant_keyword |
  | event.id                              | Unique ID to describe the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | event.ingested                        | Timestamp when an event arrived in the central data store. This is different from `@timestamp`, which is when the event originally occurred.  It's also different from `event.created`, which is meant to capture the first time an agent saw the event. In normal conditions, assuming no tampering, the timestamps should chronologically look like this: `@timestamp` < `event.created` < `event.ingested`.                                                                                                                                                                                                               | date             |
  | event.kind                            | This is one of four ECS Categorization Fields, and indicates the highest level in the ECS category hierarchy. `event.kind` gives high-level information about what type of information the event contains, without being specific to the contents of the event. For example, values of this field distinguish alert events from metric events. The value of this field can be used to inform how these kinds of events should be handled. They may warrant different retention, different access control, it may also help understand whether the data is coming in at a regular interval or not.                            | keyword          |
  | event.module                          | Event module                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | constant_keyword |
  | event.type                            | This is one of four ECS Categorization Fields, and indicates the third level in the ECS category hierarchy. `event.type` represents a categorization "sub-bucket" that, when used along with the `event.category` field values, enables filtering events down to a level appropriate for single visualization. This field is an array. This will allow proper categorization of some events that fall in multiple event types.                                                                                                                                                                                               | keyword          |
  | file.mime_type                        | MIME type should identify the format of the file or stream of bytes using  official types], where possible. When more than one type is applicable, the most specific type should be used.                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | file.name                             | Name of the file including the extension, without the directory.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | file.size                             | File size in bytes. Only relevant when `file.type` is "file".                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | long             |
  | host.architecture                     | Operating system architecture.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | host.containerized                    | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | boolean          |
  | host.domain                           | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | host.hostname                         | Hostname of the host. It normally contains what the `hostname` command returns on the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | host.id                               | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.ip                               | Host ip addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | host.mac                              | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | host.name                             | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host.                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.os.build                         | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.codename                      | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | host.os.family                        | OS family (such as redhat, debian, freebsd, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.kernel                        | Operating system kernel version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.os.name                          | Operating system name, without the version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | host.os.name.text                     | Multi-field of `host.os.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | match_only_text  |
  | host.os.platform                      | Operating system platform (such centos, ubuntu, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.os.version                       | Operating system version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.type                             | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | input.type                            | Type of Filebeat input.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | log.file.path                         | Full path to the log file this event came from, including the file name. It should include the drive letter, when appropriate. If the event wasn't read from a log file, do not populate this field.                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | log.flags                             | Flags for the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | log.offset                            | Offset of the entry in the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | long             |
  | network.community_id                  | A hash of source and destination IPs and ports, as well as the protocol used in a communication. This is a tool-agnostic standard to identify flows. Learn more at .                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | network.protocol                      | In the OSI Model this would be the Application Layer protocol. For example, `http`, `dns`, or `ssh`. The field value must be normalized to lowercase for querying.                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | network.transport                     | Same as network.iana_number, but instead using the Keyword name of the transport layer (udp, tcp, ipv6-icmp, etc.) The field value must be normalized to lowercase for querying.                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | related.ip                            | All of the IPs seen on your event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | related.user                          | All the user names or other user identifiers seen on the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | source.address                        | Some event source addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | source.as.number                      | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | long             |
  | source.as.organization.name           | Organization name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | source.as.organization.name.text      | Multi-field of `source.as.organization.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | match_only_text  |
  | source.geo.city_name                  | City name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | source.geo.continent_name             | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | source.geo.country_iso_code           | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | source.geo.country_name               | Country name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | source.geo.location                   | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | geo_point        |
  | source.geo.name                       | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | source.geo.region_iso_code            | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | source.geo.region_name                | Region name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | source.ip                             | IP address of the source (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | ip               |
  | source.port                           | Port of the source.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | long             |
  | tags                                  | List of keywords used to tag each event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | user.name                             | Short name or login of the user.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | user.name.text                        | Multi-field of `user.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | match_only_text  |
  | zeek.irc.addl                         | Any additional data for the command.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | zeek.irc.command                      | Command given by the client.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | zeek.irc.dcc.file.name                | Present if base/protocols/irc/dcc-send.bro is loaded. DCC filename requested.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | zeek.irc.dcc.file.size                | Present if base/protocols/irc/dcc-send.bro is loaded. Size of the DCC transfer as indicated by the sender.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | long             |
  | zeek.irc.dcc.mime_type                | present if base/protocols/irc/dcc-send.bro is loaded. Sniffed mime type of the file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | zeek.irc.fuid                         | present if base/protocols/irc/files.bro is loaded. File unique ID.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | zeek.irc.nick                         | Nickname given for the connection.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | zeek.irc.user                         | Username given for the connection.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | zeek.irc.value                        | Value for the command given by the client.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | zeek.session_id                       | A unique identifier of the session                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
</dropdown>


### kerberos

The `kerberos` dataset collects the Zeek kerberos.log file, which
contains kerberos data.
<dropdown title="Exported fields">
  | Field                                       | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | Type             |
  |---------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                  | Date/time when the event originated. This is the date/time extracted from the event, typically representing when the event was generated by the source. If the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline. Required field for all events.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | date             |
  | client.address                              | Some event client addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | cloud.account.id                            | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | cloud.availability_zone                     | Availability zone in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | cloud.image.id                              | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | cloud.instance.id                           | Instance ID of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | cloud.instance.name                         | Instance name of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | cloud.machine.type                          | Machine type of the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | cloud.project.id                            | The cloud project identifier. Examples: Google Cloud Project id, Azure Project id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | cloud.provider                              | Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | cloud.region                                | Region in which this host, resource, or service is located.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | container.id                                | Unique container id.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | container.image.name                        | Name of the image the container was built on.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | container.labels                            | Image labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | object           |
  | container.name                              | Container name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | data_stream.dataset                         | The field can contain anything that makes sense to signify the source of the data. Examples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`. Beyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                                                                                                                                                                                                                                                                                                                                                                            | constant_keyword |
  | data_stream.namespace                       | A user defined namespace. Namespaces are useful to allow grouping of data. Many users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`. Beyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:   * Must not contain `-`   * No longer than 100 characters                                                                                                                                                                                                                                                                                                                                                                                                                           | constant_keyword |
  | data_stream.type                            | An overarching type for the data stream. Currently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | constant_keyword |
  | destination.address                         | Some event destination addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | destination.as.number                       | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | long             |
  | destination.as.organization.name            | Organization name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | destination.as.organization.name.text       | Multi-field of `destination.as.organization.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | match_only_text  |
  | destination.geo.city_name                   | City name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | destination.geo.continent_name              | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | destination.geo.country_iso_code            | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | destination.geo.country_name                | Country name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | destination.geo.location                    | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | geo_point        |
  | destination.geo.name                        | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | destination.geo.region_iso_code             | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | destination.geo.region_name                 | Region name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | destination.ip                              | IP address of the destination (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | ip               |
  | destination.port                            | Port of the destination.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | long             |
  | ecs.version                                 | ECS version this event conforms to. `ecs.version` is a required field and must exist in all events. When querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | error.message                               | Error message.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | match_only_text  |
  | event.action                                | The action captured by the event. This describes the information in the event. It is more specific than `event.category`. Examples are `group-add`, `process-started`, `file-created`. The value is normally defined by the implementer.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | event.category                              | This is one of four ECS Categorization Fields, and indicates the second level in the ECS category hierarchy. `event.category` represents the "big buckets" of ECS categories. For example, filtering on `event.category:process` yields all events relating to process activity. This field is closely related to `event.type`, which is used as a subcategory. This field is an array. This will allow proper categorization of some events that fall in multiple categories.                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | event.created                               | `event.created` contains the date/time when the event was first read by an agent, or by your pipeline. This field is distinct from `@timestamp` in that `@timestamp` typically contain the time extracted from the original event. In most situations, these two timestamps will be slightly different. The difference can be used to calculate the delay between your source generating an event, and the time when your agent first processed it. This can be used to monitor your agent's or pipeline's ability to keep up with your event source. In case the two timestamps are identical, `@timestamp` should be used.                                                                                                                                                                                                                                                                                            | date             |
  | event.dataset                               | Event dataset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | constant_keyword |
  | event.id                                    | Unique ID to describe the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | event.ingested                              | Timestamp when an event arrived in the central data store. This is different from `@timestamp`, which is when the event originally occurred.  It's also different from `event.created`, which is meant to capture the first time an agent saw the event. In normal conditions, assuming no tampering, the timestamps should chronologically look like this: `@timestamp` < `event.created` < `event.ingested`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | date             |
  | event.kind                                  | This is one of four ECS Categorization Fields, and indicates the highest level in the ECS category hierarchy. `event.kind` gives high-level information about what type of information the event contains, without being specific to the contents of the event. For example, values of this field distinguish alert events from metric events. The value of this field can be used to inform how these kinds of events should be handled. They may warrant different retention, different access control, it may also help understand whether the data is coming in at a regular interval or not.                                                                                                                                                                                                                                                                                                                       | keyword          |
  | event.module                                | Event module                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | constant_keyword |
  | event.outcome                               | This is one of four ECS Categorization Fields, and indicates the lowest level in the ECS category hierarchy. `event.outcome` simply denotes whether the event represents a success or a failure from the perspective of the entity that produced the event. Note that when a single transaction is described in multiple events, each event may populate different values of `event.outcome`, according to their perspective. Also note that in the case of a compound event (a single event that contains multiple logical events), this field should be populated with the value that best captures the overall success or failure from the perspective of the event producer. Further note that not all events will have an associated outcome. For example, this field is generally not populated for metric events, events with `event.type:info`, or any events for which an outcome does not make logical sense. | keyword          |
  | event.type                                  | This is one of four ECS Categorization Fields, and indicates the third level in the ECS category hierarchy. `event.type` represents a categorization "sub-bucket" that, when used along with the `event.category` field values, enables filtering events down to a level appropriate for single visualization. This field is an array. This will allow proper categorization of some events that fall in multiple event types.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | host.architecture                           | Operating system architecture.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | host.containerized                          | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | boolean          |
  | host.domain                                 | Name of the domain of which the host is a member. For example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | host.hostname                               | Hostname of the host. It normally contains what the `hostname` command returns on the host machine.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | host.id                                     | Unique host id. As hostname is not always unique, use values that are meaningful in your environment. Example: The current usage of `beat.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.ip                                     | Host ip addresses.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | ip               |
  | host.mac                                    | Host MAC addresses. The notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | host.name                                   | Name of the host. It can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | host.os.build                               | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | host.os.codename                            | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | host.os.family                              | OS family (such as redhat, debian, freebsd, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | host.os.kernel                              | Operating system kernel version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | host.os.name                                | Operating system name, without the version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.os.name.text                           | Multi-field of `host.os.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | match_only_text  |
  | host.os.platform                            | Operating system platform (such centos, ubuntu, windows).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | host.os.version                             | Operating system version as a raw string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | keyword          |
  | host.type                                   | Type of host. For Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | input.type                                  | Type of Filebeat input.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | log.file.path                               | Full path to the log file this event came from, including the file name. It should include the drive letter, when appropriate. If the event wasn't read from a log file, do not populate this field.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | log.flags                                   | Flags for the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | log.offset                                  | Offset of the entry in the log file.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | long             |
  | network.community_id                        | A hash of source and destination IPs and ports, as well as the protocol used in a communication. This is a tool-agnostic standard to identify flows. Learn more at .                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | network.protocol                            | In the OSI Model this would be the Application Layer protocol. For example, `http`, `dns`, or `ssh`. The field value must be normalized to lowercase for querying.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | network.transport                           | Same as network.iana_number, but instead using the Keyword name of the transport layer (udp, tcp, ipv6-icmp, etc.) The field value must be normalized to lowercase for querying.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | related.ip                                  | All of the IPs seen on your event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | ip               |
  | related.user                                | All the user names or other user identifiers seen on the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | keyword          |
  | server.address                              | Some event server addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | source.address                              | Some event source addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field. Then it should be duplicated to `.ip` or `.domain`, depending on which one it is.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | source.as.number                            | Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | long             |
  | source.as.organization.name                 | Organization name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | source.as.organization.name.text            | Multi-field of `source.as.organization.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | match_only_text  |
  | source.geo.city_name                        | City name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | source.geo.continent_name                   | Name of the continent.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | keyword          |
  | source.geo.country_iso_code                 | Country ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | source.geo.country_name                     | Country name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | source.geo.location                         | Longitude and latitude.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | geo_point        |
  | source.geo.name                             | User-defined description of a location, at the level of granularity they care about. Could be the name of their data centers, the floor number, if this describes a local physical entity, city names. Not typically used in automated geolocation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | source.geo.region_iso_code                  | Region ISO code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | source.geo.region_name                      | Region name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | source.ip                                   | IP address of the source (IPv4 or IPv6).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | ip               |
  | source.port                                 | Port of the source.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | long             |
  | tags                                        | List of keywords used to tag each event.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | tls.client.x509.subject.common_name         | List of common names (CN) of subject.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | tls.client.x509.subject.country             | List of country (C) code                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | tls.client.x509.subject.locality            | List of locality names (L)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | tls.client.x509.subject.organization        | List of organizations (O) of subject.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | tls.client.x509.subject.organizational_unit | List of organizational units (OU) of subject.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | tls.client.x509.subject.state_or_province   | List of state or province names (ST, S, or P)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | tls.server.x509.subject.common_name         | List of common names (CN) of subject.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | tls.server.x509.subject.country             | List of country (C) code                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | tls.server.x509.subject.locality            | List of locality names (L)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | tls.server.x509.subject.organization        | List of organizations (O) of subject.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | tls.server.x509.subject.organizational_unit | List of organizational units (OU) of subject.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | tls.server.x509.subject.state_or_province   | List of state or province names (ST, S, or P)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | user.domain                                 | Name of the directory the user is a member of. For example, an LDAP or Active Directory domain name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | keyword          |
  | user.name                                   | Short name or login of the user.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | user.name.text                              | Multi-field of `user.name`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | match_only_text  |
  | zeek.kerberos.cert.client.fuid              | File unique ID of client cert.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | zeek.kerberos.cert.client.subject           | Subject of client certificate.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | zeek.kerberos.cert.client.value             | Client certificate.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | zeek.kerberos.cert.server.fuid              | File unique ID of server certificate.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | keyword          |
  | zeek.kerberos.cert.server.subject           | Subject of server certificate.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | zeek.kerberos.cert.server.value             | Server certificate.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | zeek.kerberos.cipher                        | Ticket encryption type.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | zeek.kerberos.client                        | Client name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | zeek.kerberos.error.code                    | Error code.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | integer          |
  | zeek.kerberos.error.msg                     | Error message.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | keyword          |
  | zeek.kerberos.forwardable                   | Forwardable ticket requested.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | boolean          |
  | zeek.kerberos.renewable                     | Renewable ticket requested.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | boolean          |
  | zeek.kerberos.request_type                  | Request type - Authentication Service (AS) or Ticket Granting Service (TGS).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | zeek.kerberos.service                       | Service name.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | zeek.kerberos.success                       | Request result.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | boolean          |
  | zeek.kerberos.ticket.auth                   | Hash of ticket used to authorize request/transaction.                                                 