﻿---
title: Custom Windows event log package
description: The custom Windows event log package allows you to ingest events from any Windows event log channel. You can get a list of available event log channels...
url: https://www.elastic.co/docs/reference/integrations/winlog
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Custom Windows event log package
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 2.4.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                        |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.10.1                    |

The custom Windows event log package allows you to ingest events from any [Windows event log](https://docs.microsoft.com/en-us/windows/win32/wes/windows-event-log) channel.
You can get a list of available event log channels by running [`Get-WinEvent -ListLog * | Format-List -Property LogName`](https://learn.microsoft.com/en-us/powershell/module/microsoft.powershell.diagnostics/get-winevent) in PowerShell on Windows Vista or newer.
If `Get-WinEvent` is not available, [`Get-EventLog *`](https://learn.microsoft.com/en-us/powershell/module/microsoft.powershell.management/get-eventlog) may be used.
Custom ingest pipelines may be added by setting one up in *Ingest Node Pipelines* (use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects) to search for "ingest pipelines").

## Configuration


### Windows Event ID clause limit

If you specify more than 22 query conditions (event IDs or event ID ranges), some
versions of Windows will prevent the integration from reading the event log due to
limits in the query system. If this occurs, a similar warning as shown below:
```
The specified query is invalid.
```

In some cases, the limit may be lower than 22 conditions. For instance, using a
mixture of ranges and single event IDs, along with an additional parameter such
as `ignore older`, results in a limit of 21 conditions.
If you have more than 22 conditions, you can work around this Windows limitation
by using a drop_event processor to do the filtering after filebeat has received
the events from Windows. The filter shown below is equivalent to
`event_id: 903, 1024, 2000-2004, 4624` but can be expanded beyond 22 event IDs.
```yaml
- drop_event.when.not.or:
  - equals.winlog.event_id: "903"
  - equals.winlog.event_id: "1024"
  - equals.winlog.event_id: "4624"
  - range:
      winlog.event_id.gte: 2000
      winlog.event_id.lte: 2004
```


## Fields Mapping

In addition to the fields specified below, this integration includes the ECS Dynamic Template. Any field that follow the ECS Schema will get assigned the correct index field mapping and does not need to be added manually.
<dropdown title="Exported fields">
  | Field                                             | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | Type             |
  |---------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                        | Event timestamp.                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | date             |
  | cloud.image.id                                    | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | cloud.project.id                                  | Name of the project in Google Cloud.                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | data_stream.dataset                               | Data stream dataset.                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | constant_keyword |
  | data_stream.namespace                             | Data stream namespace.                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | constant_keyword |
  | data_stream.type                                  | Data stream type.                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | constant_keyword |
  | host.containerized                                | If the host is a container.                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | boolean          |
  | host.os.build                                     | OS build information.                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | keyword          |
  | host.os.codename                                  | OS codename, if any.                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | winlog.activity_id                                | A globally unique identifier that identifies the current activity. The events that are published with this identifier are part of the same activity.                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | winlog.api                                        | The event log API type used to read the record. The possible values are "wineventlog" for the Windows Event Log API or "eventlogging" for the Event Logging API. The Event Logging API was designed for Windows Server 2003 or Windows 2000 operating systems. In Windows Vista, the event logging infrastructure was redesigned. On Windows Vista or later operating systems, the Windows Event Log API is used. Winlogbeat automatically detects which API to use for reading event logs. | keyword          |
  | winlog.channel                                    | The name of the channel from which this record was read. This value is one of the names from the `event_logs` collection in the configuration.                                                                                                                                                                                                                                                                                                                                              | keyword          |
  | winlog.computerObject.domain                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.computerObject.id                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.computerObject.name                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.computer_name                              | The name of the computer that generated the record. When using Windows event forwarding, this name can differ from `agent.hostname`.                                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | winlog.event_data                                 | The event-specific data. This field is mutually exclusive with `user_data`. If you are capturing event data on versions prior to Windows Vista, the parameters in `event_data` are named `param1`, `param2`, and so on, because event log parameters are unnamed in earlier versions of Windows.                                                                                                                                                                                            | object           |
  | winlog.event_data.AccessGranted                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.AccessRemoved                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.AccountDomain                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.AccountExpires                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.AccountName                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.AllowedToDelegateTo             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.AuditPolicyChanges              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.AuditPolicyChangesDescription   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.AuditSourceName                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.AuthenticationPackageName       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.Binary                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.BitlockerUserInputTime          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.BootMode                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.BootType                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.BuildVersion                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.CallerProcessId                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.CallerProcessName               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.Category                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.CategoryId                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.ClientAddress                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.ClientName                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.CommandLine                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.Company                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.CorruptionActionState           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.CrashOnAuditFailValue           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.CreationUtcTime                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.Description                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.Detail                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.DeviceName                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.DeviceNameLength                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.DeviceTime                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.DeviceVersionMajor              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.DeviceVersionMinor              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.DisplayName                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.DomainBehaviorVersion           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.DomainName                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.DomainPolicyChanged             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.DomainSid                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.DriveName                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.DriverName                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.DriverNameLength                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.Dummy                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.DwordVal                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.EntryCount                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.EventSourceId                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.ExtraInfo                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.FailureName                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.FailureNameLength               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.FailureReason                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.FileVersion                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.FinalStatus                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.Group                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.GroupTypeChange                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.HandleId                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.HomeDirectory                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.HomePath                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.IdleImplementation              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.IdleStateCount                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.ImpersonationLevel              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.IntegrityLevel                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.IpAddress                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.IpPort                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.KerberosPolicyChange            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.KeyLength                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.LastBootGood                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.LastShutdownGood                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.LmPackageName                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.LogonGuid                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.LogonHours                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.LogonID                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.LogonId                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.LogonProcessName                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.LogonType                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.MachineAccountQuota             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.MajorVersion                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.MandatoryLabel                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.MaximumPerformancePercent       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.MemberName                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.MemberSid                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.MinimumPerformancePercent       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.MinimumThrottlePercent          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.MinorVersion                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.MixedDomainMode                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.NewProcessId                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.NewProcessName                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.NewSchemeGuid                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.NewSd                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.NewSdDacl0                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.NewSdDacl1                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.NewSdDacl2                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.NewSdSacl0                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.NewSdSacl1                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.NewSdSacl2                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.NewTargetUserName               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.NewTime                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.NewUACList                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.NewUacValue                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.NominalFrequency                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.Number                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.ObjectName                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.ObjectServer                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.ObjectType                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.OemInformation                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.OldSchemeGuid                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.OldSd                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.OldSdDacl0                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.OldSdDacl1                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.OldSdDacl2                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.OldSdSacl0                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.OldSdSacl1                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.OldSdSacl2                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.OldTargetUserName               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.OldTime                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.OldUacValue                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.OriginalFileName                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.PackageName                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.ParentProcessName               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.PasswordHistoryLength           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.PasswordLastSet                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.Path                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.PerformanceImplementation       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.PreAuthType                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.PreviousCreationUtcTime         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.PreviousTime                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.PrimaryGroupId                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.PrivilegeList                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.ProcessId                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.ProcessName                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.ProcessPath                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.ProcessPid                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.Product                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.ProfilePath                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.PuaCount                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.PuaPolicyId                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.QfeVersion                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.Reason                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.SamAccountName                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.SchemaVersion                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.ScriptBlockText                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.ScriptPath                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.Service                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.ServiceAccount                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.ServiceFileName                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.ServiceName                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.ServiceSid                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.ServiceStartType                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.ServiceType                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.ServiceVersion                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.SessionName                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.ShutdownActionType              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.ShutdownEventCode               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.ShutdownReason                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.SidFilteringEnabled             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.SidHistory                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.Signature                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.SignatureStatus                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.Signed                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.StartTime                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.State                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.Status                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.StatusDescription               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.StopTime                        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.SubCategory                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.SubCategoryGuid                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.SubCategoryId                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.SubStatus                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.SubcategoryGuid                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.SubcategoryId                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.SubjectDomainName               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.SubjectLogonId                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.SubjectUserName                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.SubjectUserSid                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.TSId                            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.TargetDomainName                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.TargetInfo                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.TargetLogonGuid                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.TargetLogonId                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.TargetServerName                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.TargetSid                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.TargetUserName                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.TargetUserSid                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.TdoAttributes                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.TdoDirection                    |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.TdoType                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.TerminalSessionId               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.TicketEncryptionType            |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.TicketEncryptionTypeDescription |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.TicketOptions                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.TicketOptionsDescription        |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.TokenElevationType              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.TransmittedServices             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.UserAccountControl              |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.UserParameters                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.UserPrincipalName               |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.UserSid                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.UserWorkstations                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.Version                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.Workstation                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.WorkstationName                 |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.param1                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.param2                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.param3                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.param4                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.param5                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.param6                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.param7                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_data.param8                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.event_id                                   | The event identifier. The value is specific to the source of the event.                                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | winlog.keywords                                   | The keywords are used to classify an event.                                                                                                                                                                                                                                                                                                                                                                                                                                                 | keyword          |
  | winlog.level                                      | The event severity.  Levels are Critical, Error, Warning and Information, Verbose                                                                                                                                                                                                                                                                                                                                                                                                           | keyword          |
  | winlog.opcode                                     | The opcode defined in the event. Task and opcode are typically used to identify the location in the application from where the event was logged.                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | winlog.outcome                                    | Success or Failure of the event.                                                                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | winlog.process.pid                                | The process_id of the Client Server Runtime Process.                                                                                                                                                                                                                                                                                                                                                                                                                                        | long             |
  | winlog.process.thread.id                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | long             |
  | winlog.provider_guid                              | A globally unique identifier that identifies the provider that logged the event.                                                                                                                                                                                                                                                                                                                                                                                                            | keyword          |
  | winlog.provider_name                              | The source of the event log record (the application or service that logged the record).                                                                                                                                                                                                                                                                                                                                                                                                     | keyword          |
  | winlog.record_id                                  | The record ID of the event log record. The first record written to an event log is record number 1, and other records are numbered sequentially. If the record number reaches the maximum value (2^32^ for the Event Logging API and 2^64^ for the Windows Event Log API), the next record number will be 0.                                                                                                                                                                                | keyword          |
  | winlog.related_activity_id                        | A globally unique identifier that identifies the activity to which control was transferred to. The related events would then have this identifier as their `activity_id` identifier.                                                                                                                                                                                                                                                                                                        | keyword          |
  | winlog.task                                       | The task defined in the event. Task and opcode are typically used to identify the location in the application from where the event was logged. The category used by the Event Logging API (on pre Windows Vista operating systems) is written to this field.                                                                                                                                                                                                                                | keyword          |
  | winlog.time_created                               | Time event was created                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | date             |
  | winlog.trustAttribute                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.trustDirection                             |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.trustType                                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.user.domain                                | The domain that the account associated with this event is a member of.                                                                                                                                                                                                                                                                                                                                                                                                                      | keyword          |
  | winlog.user.identifier                            | The Windows security identifier (SID) of the account associated with this event. If Winlogbeat cannot resolve the SID to a name, then the `user.name`, `user.domain`, and `user.type` fields will be omitted from the event. If you discover Winlogbeat not resolving SIDs, review the log for clues as to what the problem may be.                                                                                                                                                         | keyword          |
  | winlog.user.name                                  | Name of the user associated with this event.                                                                                                                                                                                                                                                                                                                                                                                                                                                | keyword          |
  | winlog.user.type                                  | The type of account associated with this event.                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.user_data                                  | The event specific data. This field is mutually exclusive with `event_data`.                                                                                                                                                                                                                                                                                                                                                                                                                | object           |
  | winlog.user_data.BackupPath                       |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.user_data.Channel                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.user_data.SubjectDomainName                |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.user_data.SubjectLogonId                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.user_data.SubjectUserName                  |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.user_data.SubjectUserSid                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.user_data.xml_name                         |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | keyword          |
  | winlog.version                                    | The version number of the event's definition.                                                                                                                                                                                                                                                                                                                                                                                                                                               | long             |
</dropdown>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                                                                                                                                                                              | Minimum Kibana version |
  |------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **2.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12938))Add `xml_query` and `level` options.                                                                                                                                                                                                                                                                                        | 9.0.08.10.1            |
  | **2.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12636))ECS version updated to 8.17.0.                                                                                                                                                                                                                                                                                              | 9.0.08.10.1            |
  | **2.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12381))Add 9.0.0 constraint.                                                                                                                                                                                                                                                                                                       | 9.0.08.10.1            |
  | **2.1.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10198))Add missing preserve_original_event tag when toggled on for Winlog                                                                                                                                                                                                                                                          | 8.10.1                 |
  | **2.1.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                                                                                                                                                                               | 8.10.1                 |
  | **2.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8436))ECS version updated to 8.11.0.                                                                                                                                                                                                                                                                                               | 8.10.1                 |
  | **2.0.0**  | **Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/8010))Convert to an input package.                                                                                                                                                                                                                                                                                             | 8.10.1                 |
  | **1.20.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7920))ECS version updated to 8.10.0.                                                                                                                                                                                                                                                                                               | 8.7.1                  |
  | **1.19.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7883))The format_version in the package manifest changed from 2.11.0 to 3.0.0. Removed dotted YAML keys from package manifest. Added 'owner.type: elastic' to package manifest.                                                                                                                                                    | 8.7.1                  |
  | **1.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.                                                                                                                                                                         | 8.7.1                  |
  | **1.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7111))Update package to ECS 8.9.0.                                                                                                                                                                                                                                                                                                 | 8.7.1                  |
  | **1.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6328))Update package to ECS 8.8.0.                                                                                                                                                                                                                                                                                                 | 8.7.1                  |
  | **1.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6299))Update package-spec version to 2.7.0.                                                                                                                                                                                                                                                                                        | 8.7.1                  |
  | **1.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6115))Add a new flag to enable request tracing                                                                                                                                                                                                                                                                                     | 8.7.1                  |
  | **1.13.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5838))Document 21 Event ID clause limit under certain situations.                                                                                                                                                                                                                                                                  | 8.0.07.16.0            |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                                                                                                                                                                                                 | 8.0.07.16.0            |
  | **1.12.4** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5689))Improve documentation for listing event log channels.                                                                                                                                                                                                                                                                        | 8.0.07.16.0            |
  | **1.12.3** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                                                                                                                                                                       | 8.0.07.16.0            |
  | **1.12.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/5350))Fix mapping for winlog.time_created by setting to date instead of keyword                                                                                                                                                                                                                                                        | 8.0.07.16.0            |
  | **1.12.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5239))Fix event.dataset to allow for custom datasets and conform to ECS.                                                                                                                                                                                                                                                           | 8.0.07.16.0            |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5273))Add ecs error fields                                                                                                                                                                                                                                                                                                         | 8.0.07.16.0            |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5135))Add agent fields                                                                                                                                                                                                                                                                                                             | 8.0.07.16.0            |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                                                                                                                                                                                                 | 8.0.07.16.0            |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4553))Allow users to configure providers list.                                                                                                                                                                                                                                                                                     | 8.0.07.16.0            |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                                                                                                                                                                                                 | 8.0.07.16.0            |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3871))Update package to ECS 8.4.0                                                                                                                                                                                                                                                                                                  | 8.0.07.16.0            |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3353))Update package to ECS 8.3.0.                                                                                                                                                                                                                                                                                                 | 8.0.07.16.0            |
  | **1.5.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3579))Add correct field mapping for event.created                                                                                                                                                                                                                                                                                      | 8.0.07.16.0            |
  | **1.5.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3177))update readme added link to Microsoft documentation and reworded a link                                                                                                                                                                                                                                                      | 8.0.07.16.0            |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2781))Update to ECS 8.2 (documentation reference only)                                                                                                                                                                                                                                                                             | 8.0.07.16.0            |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2542))Expose winlog input ignore_older option.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2542))Fix preserve original event option**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2542))Make order of options consistent with other winlog based integrations. | 8.0.07.16.0            |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2344))Expose winlog input language option.                                                                                                                                                                                                                                                                                         | 8.0.07.16.0            |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2268))Add 8.0.0 version constraint                                                                                                                                                                                                                                                                                                 | 8.0.07.16.0            |
  | **1.1.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2079))Uniform with guidelines                                                                                                                                                                                                                                                                                                      | 7.16.0                 |
  | **1.1.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2067))Update Splunk input description                                                                                                                                                                                                                                                                                              |                        |
  | **1.1.0**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2008))Consistently map message field in Windows integrations.                                                                                                                                                                                                                                                                          | 7.16.0                 |
  | **1.0.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1991))Update Title and Description.                                                                                                                                                                                                                                                                                                | 7.16.0                 |
  | **1.0.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1860))Fix logic that checks for the 'forwarded' tag                                                                                                                                                                                                                                                                                    |                        |
  | **1.0.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/1755))Fix drop_event processor example by using event ID string values in conditions.                                                                                                                                                                                                                                                  |                        |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1716))make GA                                                                                                                                                                                                                                                                                                                      |                        |
  | **0.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1364))Update integration description                                                                                                                                                                                                                                                                                               |                        |
  | **0.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1277))Set "event.module" and "event.dataset"                                                                                                                                                                                                                                                                                       |                        |
  | **0.2.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1147))Add support for Splunk authorization tokens                                                                                                                                                                                                                                                                                  |                        |
  | **0.2.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/922))Change Splunk input to use the decode_xml_wineventlog processor.                                                                                                                                                                                                                                                              |                        |
  | **0.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/884))Add Splunk httpjson input                                                                                                                                                                                                                                                                                                     |                        |
  | **0.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/794))initial release                                                                                                                                                                                                                                                                                                               |                        |
</dropdown>