﻿---
title: Custom macOS Unified Logs
description: The unified logging system provides a comprehensive and performant API to capture telemetry across all levels of the system. This system centralizes the...
url: https://www.elastic.co/docs/reference/integrations/unifiedlogs
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Custom macOS Unified Logs
|                                                                                                 |                                                                |
|-------------------------------------------------------------------------------------------------|----------------------------------------------------------------|
| **Version**                                                                                     | 0.4.0 <applies-to>: Beta</applies-to> ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                                                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                                                        |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.18.0                                                    |

<admonition title="The Custom macOS Unified Logs integration v0.4.0 is in beta">
  To use beta integrations, go to the **Integrations** page in Kibana, scroll down, and toggle on the _Display beta integrations_ option.
</admonition>

The unified logging system provides a comprehensive and performant API to capture
telemetry across all levels of the system. This system centralizes the storage of
log data in memory and on disk, rather than writing that data to a text-based log file.
This package interacts with the `log` command-line tool to provide access to these events.
It starts streaming events from the current point in time unless a start date or
the backfill options are set. When restarted it will continue where it left off.
Alternatively, it can also do one off operations, such as:
- Stream events contained in a `.logarchive` file.
- Stream events contained in a `.tracev3` file.
- Stream events in a specific time span, by providing a specific end date.

After this one off operations complete, the package input will stop.
Other configuration options can be specified to filter what events to process.
<note>
  This package can cause some duplicated events when backfilling and/or
  restarting. This is caused by how the underlying fetching method works and
  should be taken into account when using the input.
</note>


## Fields Mapping

In addition to the fields specified below, this integration includes the ECS Dynamic Template. Any field that follow the ECS Schema will get assigned the correct index field mapping and does not need to be added manually.
<dropdown title="Exported fields">
  | Field                 | Description                          | Type             |
  |-----------------------|--------------------------------------|------------------|
  | @timestamp            | Event timestamp.                     | date             |
  | cloud.image.id        | Image ID for the cloud instance.     | keyword          |
  | cloud.project.id      | Name of the project in Google Cloud. | keyword          |
  | data_stream.dataset   | Data stream dataset.                 | constant_keyword |
  | data_stream.namespace | Data stream namespace.               | constant_keyword |
  | data_stream.type      | Data stream type.                    | constant_keyword |
  | host.containerized    | If the host is a container.          | boolean          |
  | host.os.build         | OS build information.                | keyword          |
  | host.os.codename      | OS codename, if any.                 | keyword          |
</dropdown>


## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                 | Minimum Kibana version |
  |-----------|-------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **0.4.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13448))Downgrade package spec version |                        |
  | **0.3.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12636))ECS version updated to 8.17.0. |                        |
  | **0.2.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12381))Add 9.0.0 constraint.          |                        |
  | **0.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12096))initial release                |                        |
</dropdown>