﻿---
title: Threat Intelligence Utilities
description: The threat intelligence utilities package contains a dashboard that provides a high-level overview of data from all connected TI feeds. To add the dashboard,...
url: https://www.elastic.co/docs/reference/integrations/ti_util
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Threat Intelligence Utilities
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 1.7.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                        |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.13.0                    |

The threat intelligence utilities package contains a dashboard that provides a high-level overview of data from all connected [TI feeds](https://www.elastic.co/guide/en/security/current/es-threat-intel-integrations.html).
To add the dashboard, click **Settings** > **Install Threat Intelligence Utilities assets**.

## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![threat intelligence overview](https://epr.elastic.co/package/ti_util/1.7.0/img/threat-intel-overview.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                                                                                                                                                           | Minimum Kibana version |
  |-----------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.7.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                                               | 9.0.08.13.0            |
  | **1.6.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Update the kibana constraint to ^8.13.0.                                                                                                                                 | 8.13.0                 |
  | **1.5.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9404))Update manifest format version to v3.0.3.                                                                                                                                 | 8.5.0                  |
  | **1.4.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                            | 8.5.0                  |
  | **1.4.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7883))The format_version in the package manifest changed from 2.11.0 to 3.0.0. Removed dotted YAML keys from package manifest. Added 'owner.type: elastic' to package manifest. | 8.5.0                  |
  | **1.3.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.                      | 8.5.0                  |
  | **1.2.3** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7731))Fix the query type for matching 'event.dataset'.                                                                                                                              | 8.5.0                  |
  | **1.2.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6942))Update to use new Threat Indicator Match rule names.                                                                                                                          | 8.5.0                  |
  | **1.2.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6793))Update to use security-solution-default.                                                                                                                                      | 8.4.0                  |
  | **1.2.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6299))Update package-spec version to 2.7.0.                                                                                                                                     | 8.4.0                  |
  | **1.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4179))Include ti_util in threat_intel category.                                                                                                                                 | 8.4.0                  |
  | **1.0.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4106))Correcting index-pattern references in dashboard                                                                                                                              | 8.4.0                  |
  | **1.0.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4090))Initial draft of the package                                                                                                                                              | 8.4.0                  |
</dropdown>