﻿---
title: Mandiant Advantage
description: The Mandiant Advantage integration allows users to retrieve IOCs (Indicators of Compromise) from the Threat Intelligence Advantage Module. These indicators...
url: https://www.elastic.co/docs/reference/integrations/ti_mandiant_advantage
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.1
---

# Mandiant Advantage
|                                                                                                 |                                 |
|-------------------------------------------------------------------------------------------------|---------------------------------|
| **Version**                                                                                     | 1.10.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                           |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Partner                         |
| **Ingestion method(s)**                                                                         | API                             |
| **Minimum Kibana version(s)**                                                                   | 9.1.49.0.78.19.4                |


## Overview

The [Mandiant Advantage](https://www.mandiant.com/advantage) integration allows users to retrieve IOCs (Indicators of Compromise) from the Threat Intelligence Advantage Module.
These indicators can be used for correlation in Elastic Security to help discover potential threats. Mandiant Threat Intelligence gives security practitioners unparalleled visibility and expertise into threats that matter to their business right now.
Our threat intelligence is compiled by over 500 threat intelligence analysts across 30 countries, researching actors via undercover adversarial pursuits, incident forensics, malicious infrastructure reconstructions and actor identification processes that comprise the deep knowledge embedded in the Mandiant Intel Grid.

## Data streams

The Mandiant Advantage integration collects one type of data stream: `threat_intelligence`

### **Threat Intelligence**

IOCs are retrieved via the Mandiant Threat Intelligence API.

## Compatibility

- This integration has been tested against the Threat Intelligence API v4.


## Requirements

You need Elasticsearch for storing and searching your data and Kibana for visualizing and managing it.
You can use our hosted Elasticsearch Service on Elastic Cloud, which is recommended, or self-manage the Elastic Stack on your own hardware.

## Setup

For step-by-step instructions on how to set up an integration, see the
[Getting started](https://www.elastic.co/guide/en/starting-with-the-elasticsearch-platform-and-its-solutions/current/getting-started-observability.html) guide.
For instructions on how to get Threat Intelligence API v4 credentials, see the [Mandiant Documentation Portal.](https://docs.mandiant.com/home/mati-threat-intelligence-api-v4#tag/Getting-Started)

### Filtering IOCs

The integration allows you to filter the amount of IOCs that are ingested, by using the following configuration parameters:
- **Initial interval**
  - The time in the past to start the collection of Indicator data from, based on an indicators last_update date.
- Supported units for this parameter are h/m/s. The default value is 720h (i.e 30 days)
- You may reduce this interval if you do not want as much historical data to be ingested when the integration first runs.
- **Minimum IC-Score**
  - Indicators that have an IC-Score greater than or equal to the given value will be collected.
- Indicators with any IC-Score will be collected if a value is set to 0.
- You might set this to a different value such as 80, to ensure that only high confidence indicators are ingested.


## Logs reference


### Threat Intelligence

Retrieves IOCs using the Mandiant Threat Intelligence API over time.
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2023-01-26T08:19:05.976Z",
      "agent": {
          "ephemeral_id": "2c6878dd-7b92-473f-ad99-47aadb8df5ad",
          "id": "f96577f5-6103-4829-8392-ba893ed24e94",
          "name": "elastic-agent-91830",
          "type": "filebeat",
          "version": "8.19.4"
      },
      "data_stream": {
          "dataset": "ti_mandiant_advantage.threat_intelligence",
          "namespace": "23612",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "f96577f5-6103-4829-8392-ba893ed24e94",
          "snapshot": false,
          "version": "8.19.4"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "threat"
          ],
          "created": "2025-12-16T03:01:16.608Z",
          "dataset": "ti_mandiant_advantage.threat_intelligence",
          "ingested": "2025-12-16T03:01:17Z",
          "kind": "enrichment",
          "module": "ti_mandiant_advantage_threat_intelligence",
          "original": "{\"campaigns\":[{\"id\":\"campaign--bff76355-4d90-5f1f-b402-565a8fb2ac61\",\"name\":\"GLOBAL.21.005\",\"title\":\"Exploitation of CVE-2021-44228 (aka \\\"Log4Shell\\\") in Various Products\"}],\"first_seen\":\"2021-06-19T23:34:03.000Z\",\"id\":\"ipv4--55ba8198-79a1-5f13-b537-632c8bad942f\",\"is_publishable\":true,\"last_seen\":\"2022-12-26T23:34:03.000Z\",\"last_updated\":\"2023-01-26T08:19:05.976Z\",\"misp\":{\"akamai\":false,\"alexa\":false,\"alexa_1M\":false,\"amazon-aws\":false,\"apple\":false,\"automated-malware-analysis\":false,\"bank-website\":false,\"cisco_1M\":false,\"cisco_top1000\":false,\"cisco_top10k\":false,\"cisco_top20k\":false,\"cisco_top5k\":false,\"cloudflare\":false,\"common-contact-emails\":false,\"common-ioc-false-positive\":false,\"covid\":false,\"covid-19-cyber-threat-coalition-whitelist\":false,\"covid-19-krassi-whitelist\":false,\"crl-hostname\":false,\"crl-ip\":false,\"dax30\":false,\"disposable-email\":false,\"dynamic-dns\":false,\"eicar.com\":false,\"empty-hashes\":false,\"fastly\":false,\"google\":false,\"google-chrome-crux-1million\":false,\"google-gcp\":false,\"google-gmail-sending-ips\":false,\"googlebot\":false,\"ipv6-linklocal\":false,\"majestic_million\":false,\"majestic_million_1M\":false,\"microsoft\":false,\"microsoft-attack-simulator\":false,\"microsoft-azure\":false,\"microsoft-azure-appid\":false,\"microsoft-azure-china\":false,\"microsoft-azure-germany\":false,\"microsoft-azure-us-gov\":false,\"microsoft-office365\":false,\"microsoft-office365-cn\":false,\"microsoft-office365-ip\":false,\"microsoft-win10-connection-endpoints\":false,\"moz-top500\":false,\"mozilla-CA\":false,\"mozilla-IntermediateCA\":false,\"multicast\":false,\"nioc-filehash\":false,\"ovh-cluster\":false,\"parking-domain\":false,\"parking-domain-ns\":false,\"phone_numbers\":false,\"public-dns-hostname\":false,\"public-dns-v4\":false,\"public-dns-v6\":false,\"public-ipfs-gateways\":false,\"rfc1918\":false,\"rfc3849\":false,\"rfc5735\":false,\"rfc6598\":false,\"rfc6761\":false,\"second-level-tlds\":false,\"security-provider-blogpost\":false,\"sinkholes\":false,\"smtp-receiving-ips\":false,\"smtp-sending-ips\":false,\"stackpath\":false,\"tenable-cloud-ipv4\":false,\"tenable-cloud-ipv6\":false,\"ti-falsepositives\":false,\"tlds\":false,\"tranco\":false,\"tranco10k\":false,\"university_domains\":false,\"url-shortener\":false,\"vpn-ipv4\":false,\"vpn-ipv6\":false,\"whats-my-ip\":false,\"wikimedia\":false},\"mscore\":58,\"reports\":[{\"audience\":[\"cyber espionage\",\"fusion\"],\"id\":\"report--2781217d-3b75-5e22-b3f7-8db3e09d2b70\",\"published_date\":\"2022-05-11T19:53:16.583Z\",\"report_id\":\"22-00011950\",\"title\":\"APT29 Targets European Diplomatic Entities with ROOTSAW Dropper and New BEATDROP Variants Using Dropbox and Slack for C\\u0026C\",\"type\":\"Event Coverage/Implication\"}],\"sources\":[{\"category\":[],\"first_seen\":\"2022-02-23T10:10:01.828+0000\",\"last_seen\":\"2022-02-23T10:10:01.828+0000\",\"osint\":true,\"source_name\":\"blocklist_de\"},{\"category\":[\"exploit/vuln-scanning\",\"exploit\"],\"first_seen\":\"2021-06-19T23:34:03.810+0000\",\"last_seen\":\"2022-12-26T23:34:03.998+0000\",\"osint\":true,\"source_name\":\"blocklist_net_ua\"},{\"category\":[],\"first_seen\":\"2022-06-03T23:39:01.621+0000\",\"last_seen\":\"2022-06-03T23:39:01.621+0000\",\"osint\":false,\"source_name\":\"Mandiant\"},{\"category\":[],\"first_seen\":\"2022-06-20T20:20:01.549+0000\",\"last_seen\":\"2022-06-20T20:20:01.549+0000\",\"osint\":true,\"source_name\":\"the_haleys_ssh_dict_attack\"}],\"type\":\"ipv4\",\"value\":\"1.128.3.4\"}",
          "risk_score": 58,
          "type": [
              "indicator"
          ]
      },
      "input": {
          "type": "httpjson"
      },
      "mandiant": {
          "threat_intelligence": {
              "ioc": {
                  "campaigns": [
                      {
                          "id": "campaign--bff76355-4d90-5f1f-b402-565a8fb2ac61",
                          "name": "GLOBAL.21.005",
                          "title": "Exploitation of CVE-2021-44228 (aka \"Log4Shell\") in Various Products"
                      }
                  ],
                  "categories": [
                      "exploit/vuln-scanning",
                      "exploit"
                  ],
                  "first_seen": "2021-06-19T23:34:03.000Z",
                  "id": "ipv4--55ba8198-79a1-5f13-b537-632c8bad942f",
                  "is_publishable": true,
                  "last_seen": "2022-12-26T23:34:03.000Z",
                  "last_update_date": "2023-01-26T08:19:05.976Z",
                  "misp_warning_list_misses": [
                      "akamai",
                      "alexa",
                      "alexa_1M",
                      "amazon-aws",
                      "apple",
                      "automated-malware-analysis",
                      "bank-website",
                      "cisco_1M",
                      "cisco_top1000",
                      "cisco_top10k",
                      "cisco_top20k",
                      "cisco_top5k",
                      "cloudflare",
                      "common-contact-emails",
                      "common-ioc-false-positive",
                      "covid",
                      "covid-19-cyber-threat-coalition-whitelist",
                      "covid-19-krassi-whitelist",
                      "crl-hostname",
                      "crl-ip",
                      "dax30",
                      "disposable-email",
                      "dynamic-dns",
                      "eicar.com",
                      "empty-hashes",
                      "fastly",
                      "google",
                      "google-chrome-crux-1million",
                      "google-gcp",
                      "google-gmail-sending-ips",
                      "googlebot",
                      "ipv6-linklocal",
                      "majestic_million",
                      "majestic_million_1M",
                      "microsoft",
                      "microsoft-attack-simulator",
                      "microsoft-azure",
                      "microsoft-azure-appid",
                      "microsoft-azure-china",
                      "microsoft-azure-germany",
                      "microsoft-azure-us-gov",
                      "microsoft-office365",
                      "microsoft-office365-cn",
                      "microsoft-office365-ip",
                      "microsoft-win10-connection-endpoints",
                      "moz-top500",
                      "mozilla-CA",
                      "mozilla-IntermediateCA",
                      "multicast",
                      "nioc-filehash",
                      "ovh-cluster",
                      "parking-domain",
                      "parking-domain-ns",
                      "phone_numbers",
                      "public-dns-hostname",
                      "public-dns-v4",
                      "public-dns-v6",
                      "public-ipfs-gateways",
                      "rfc1918",
                      "rfc3849",
                      "rfc5735",
                      "rfc6598",
                      "rfc6761",
                      "second-level-tlds",
                      "security-provider-blogpost",
                      "sinkholes",
                      "smtp-receiving-ips",
                      "smtp-sending-ips",
                      "stackpath",
                      "tenable-cloud-ipv4",
                      "tenable-cloud-ipv6",
                      "ti-falsepositives",
                      "tlds",
                      "tranco",
                      "tranco10k",
                      "university_domains",
                      "url-shortener",
                      "vpn-ipv4",
                      "vpn-ipv6",
                      "whats-my-ip",
                      "wikimedia"
                  ],
                  "mscore": 58,
                  "reports": [
                      {
                          "audience": [
                              "cyber espionage",
                              "fusion"
                          ],
                          "id": "report--2781217d-3b75-5e22-b3f7-8db3e09d2b70",
                          "published_date": "2022-05-11T19:53:16.583Z",
                          "report_id": "22-00011950",
                          "title": "APT29 Targets European Diplomatic Entities with ROOTSAW Dropper and New BEATDROP Variants Using Dropbox and Slack for C&C",
                          "type": "Event Coverage/Implication"
                      }
                  ],
                  "sources": [
                      {
                          "first_seen": "2022-02-23T10:10:01.828+0000",
                          "last_seen": "2022-02-23T10:10:01.828+0000",
                          "osint": true,
                          "source_name": "blocklist_de"
                      },
                      {
                          "category": [
                              "exploit/vuln-scanning",
                              "exploit"
                          ],
                          "first_seen": "2021-06-19T23:34:03.810+0000",
                          "last_seen": "2022-12-26T23:34:03.998+0000",
                          "osint": true,
                          "source_name": "blocklist_net_ua"
                      },
                      {
                          "first_seen": "2022-06-03T23:39:01.621+0000",
                          "last_seen": "2022-06-03T23:39:01.621+0000",
                          "osint": false,
                          "source_name": "Mandiant"
                      },
                      {
                          "first_seen": "2022-06-20T20:20:01.549+0000",
                          "last_seen": "2022-06-20T20:20:01.549+0000",
                          "osint": true,
                          "source_name": "the_haleys_ssh_dict_attack"
                      }
                  ],
                  "type": "ipv4",
                  "value": "1.128.3.4"
              }
          }
      },
      "related": {
          "ip": [
              "1.128.3.4"
          ]
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "mandiant-threat-intelligence-indicator"
      ],
      "threat": {
          "feed": {
              "name": "Mandiant Threat Intelligence"
          },
          "indicator": {
              "as": {
                  "number": 1221,
                  "organization": {
                      "name": "Telstra Pty Ltd"
                  }
              },
              "confidence": "Medium",
              "first_seen": "2021-06-19T23:34:03.000Z",
              "ip": "1.128.3.4",
              "last_seen": "2022-12-26T23:34:03.000Z",
              "marking": {
                  "tlp": "RED",
                  "tlp_version": "2.0"
              },
              "modified_at": "2023-01-26T08:19:05.976Z",
              "provider": [
                  "blocklist_de",
                  "blocklist_net_ua",
                  "Mandiant",
                  "the_haleys_ssh_dict_attack"
              ],
              "type": "ipv4-addr"
          }
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                                     | Description                                                                                                                                                                        | Type             |
  |-----------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                                | Event timestamp.                                                                                                                                                                   | date             |
  | cloud.account.id                                          | The cloud account or organization id used to identify different entities in a multi-tenant environment. Examples: AWS account id, Google Cloud ORG Id, or other unique identifier. | keyword          |
  | cloud.image.id                                            | Image ID for the cloud instance.                                                                                                                                                   | keyword          |
  | data_stream.dataset                                       | Data stream dataset.                                                                                                                                                               | constant_keyword |
  | data_stream.namespace                                     | Data stream namespace.                                                                                                                                                             | constant_keyword |
  | data_stream.type                                          | Data stream type.                                                                                                                                                                  | constant_keyword |
  | event.dataset                                             | Event dataset                                                                                                                                                                      | constant_keyword |
  | host.os.build                                             | OS build information.                                                                                                                                                              | keyword          |
  | host.os.codename                                          | OS codename, if any.                                                                                                                                                               | keyword          |
  | input.type                                                | Input type                                                                                                                                                                         | keyword          |
  | log.offset                                                | Log offset                                                                                                                                                                         | long             |
  | mandiant.threat_intelligence.ioc.associated_hashes        | List of associated hashes and their types.                                                                                                                                         | object           |
  | mandiant.threat_intelligence.ioc.attributed_associations  | List of attributed associations that this indicator has to other Malware families or Actors.                                                                                       | object           |
  | mandiant.threat_intelligence.ioc.campaigns                | List of related campaigns.                                                                                                                                                         | object           |
  | mandiant.threat_intelligence.ioc.categories               | Categories associated with this indicator.                                                                                                                                         | keyword          |
  | mandiant.threat_intelligence.ioc.first_seen               | IOC first seen date.                                                                                                                                                               | date             |
  | mandiant.threat_intelligence.ioc.id                       | IOC internal ID.                                                                                                                                                                   | keyword          |
  | mandiant.threat_intelligence.ioc.is_exclusive             | Whether the indicator is exclusive to Mandiant or not.                                                                                                                             | boolean          |
  | mandiant.threat_intelligence.ioc.is_publishable           | Whether the indicator is publishable or not.                                                                                                                                       | boolean          |
  | mandiant.threat_intelligence.ioc.last_seen                | IOC last seen date.                                                                                                                                                                | date             |
  | mandiant.threat_intelligence.ioc.last_update_date         | IOC last update date.                                                                                                                                                              | date             |
  | mandiant.threat_intelligence.ioc.misp_warning_list_hits   | Which MISP warning lists the indicator was found in.                                                                                                                               | keyword          |
  | mandiant.threat_intelligence.ioc.misp_warning_list_misses | Which MISP warning lists the indicator was not found in.                                                                                                                           | keyword          |
  | mandiant.threat_intelligence.ioc.mscore                   | M-Score (IC-Score) between 0 - 100.                                                                                                                                                | integer          |
  | mandiant.threat_intelligence.ioc.reports                  | List of related reports.                                                                                                                                                           | object           |
  | mandiant.threat_intelligence.ioc.sources.*                |                                                                                                                                                                                    | keyword          |
  | mandiant.threat_intelligence.ioc.sources.osint            |                                                                                                                                                                                    | boolean          |
  | mandiant.threat_intelligence.ioc.type                     | IOC type.                                                                                                                                                                          | keyword          |
  | mandiant.threat_intelligence.ioc.value                    | IOC value.                                                                                                                                                                         | keyword          |
  | threat.indicator.first_seen                               | The date and time when intelligence source first reported sighting this indicator.                                                                                                 | date             |
  | threat.indicator.last_seen                                | The date and time when intelligence source last reported sighting this indicator.                                                                                                  | date             |
  | threat.indicator.modified_at                              | The date and time when intelligence source last modified information for this indicator.                                                                                           | date             |
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Threat Intelligence Overview Dashboard](https://epr.elastic.co/package/ti_mandiant_advantage/1.10.0/img/ti_mandiant_dashboard.png)

  ![Threat Intelligence Indicators built-in dashboard](https://epr.elastic.co/package/ti_mandiant_advantage/1.10.0/img/ti_mandiant_indicators.png)

  ![Sample Alert being enriched with Indicator data](https://epr.elastic.co/package/ti_mandiant_advantage/1.10.0/img/ti_mandiant_alert.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                                     | Minimum Kibana version |
  |------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16570))Prevent updating fleet health status to degraded when pagination completes.                                                                                                        | 9.1.49.0.78.19.4       |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                                                         | 9.0.08.13.0            |
  | **1.8.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12145))Update links to getting started docs                                                                                                                                                   | 8.13.0                 |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12109))Add "preserve_original_event" tag to documents with `event.kind` manually set to "pipeline_error".                                                                                 | 8.13.0                 |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12108))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                                                          | 8.13.0                 |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11993))Add support for proxy configuration.                                                                                                                                               | 8.13.0                 |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11913))Add processor definition possibility.                                                                                                                                              | 8.13.0                 |
  | **1.4.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11325))Use the full event to construct a document `_id` to prevent duplicate indicators from being indexed.                                                                                   | 8.13.0                 |
  | **1.4.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11008))Add missing fields in transform.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11008))Fix mapping of sources subfields.                                 | 8.13.0                 |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10957))Add optional extra fields.                                                                                                                                                         | 8.13.0                 |
  | **1.3.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10674))Fix ECS date mapping on threat fields.                                                                                                                                                 | 8.13.0                 |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))ECS version updated to 8.11.0. Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template. | 8.13.0                 |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9974))Improve handling of empty responses.                                                                                                                                                | 8.12.0                 |
  | **1.1.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/9309))Remove invalid field definition.                                                                                                                                                        | 8.12.0                 |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9129))Set sensitive values as secret.                                                                                                                                                     | 8.12.0                 |
  | **1.0.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                                      | 8.6.2                  |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8833))Release package as GA.                                                                                                                                                              | 8.6.2                  |
  | **0.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8390))Initial release of Mandiant Advantage Elastic Integration.                                                                                                                          |                        |
</dropdown>