﻿---
title: Maltiverse Integration
description: Maltiverse is a threat intelligence platform. It works as a broker for Threat intelligence sources that are aggregated from more than a hundred different...
url: https://www.elastic.co/docs/reference/integrations/ti_maltiverse
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Maltiverse Integration
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 1.6.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Partner                        |
| **Ingestion method(s)**                                                                         | API                            |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.13.0                    |

[Maltiverse](https://maltiverse.com) is a threat intelligence platform. It works as a broker for Threat intelligence sources that are aggregated from more than a hundred different Public, Private and Community sources. Once the data is ingested, the IoC Scoring Algorithm applies a qualitative classification to the IoC that changes. Finally this data can be queried in a Threat Intelligence feed that can be delivered to your Firewalls, SOAR, SIEM, EDR or any other technology.
This integration fetches Maltiverse Threat Intelligence feeds and add them into Elastic Threat Intelligence. It supports `hostname`, `hash`, `ipv4` and `url` indicators.
In order to download feed you need to [register](https://maltiverse.com/auth/register) and generate an API key on you profile page.

## IoCs Expiration

Since we want to retain only valuable information and avoid duplicated data, the Maltiverse Elastic integration forces the indicators to rotate into a custom index called: `logs-ti_maltiverse_latest.indicator`.
**Please, refer to this index in order to set alerts and so on.**

### How it works

This is possible thanks to a transform rule installed along with the integration. The transform rule parses the data_stream content that is pulled from Maltiverse and only adds new indicators.
Both, the data_stream and the *latest index have applied expiration through ILM and a retention policy in the transform respectively.*

## Logs


### Indicator

<dropdown title="Exported fields">
  | Field                                                 | Description                                                                                    | Type             |
  |-------------------------------------------------------|------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                            | Event timestamp.                                                                               | date             |
  | data_stream.dataset                                   | Data stream dataset.                                                                           | constant_keyword |
  | data_stream.namespace                                 | Data stream namespace.                                                                         | constant_keyword |
  | data_stream.type                                      | Data stream type.                                                                              | constant_keyword |
  | event.dataset                                         | Event dataset                                                                                  | constant_keyword |
  | event.module                                          | Event module                                                                                   | constant_keyword |
  | input.type                                            | Input type.                                                                                    | keyword          |
  | labels.is_ioc_transform_source                        | Indicates whether an IOC is in the raw source data stream, or the in latest destination index. | constant_keyword |
  | maltiverse.address                                    | registered address                                                                             | keyword          |
  | maltiverse.address.address                            | Multi-field of `maltiverse.address`.                                                           | match_only_text  |
  | maltiverse.as_name                                    | AS registered name                                                                             | keyword          |
  | maltiverse.as_name.as_name                            | Multi-field of `maltiverse.as_name`.                                                           | match_only_text  |
  | maltiverse.asn_cidr                                   | CIDR associated                                                                                | keyword          |
  | maltiverse.asn_country_code                           | Country code asociated with ASN                                                                | keyword          |
  | maltiverse.asn_date                                   | date when asn registered                                                                       | date             |
  | maltiverse.asn_registry                               | ASN registry                                                                                   | keyword          |
  | maltiverse.blacklist.count                            | number of reports for the indicator                                                            | long             |
  | maltiverse.blacklist.description                      | what we saw                                                                                    | keyword          |
  | maltiverse.blacklist.description.description          | Multi-field of `maltiverse.blacklist.description`.                                             | match_only_text  |
  | maltiverse.blacklist.external_references              |                                                                                                | flattened        |
  | maltiverse.blacklist.first_seen                       | first sighting                                                                                 | date             |
  | maltiverse.blacklist.labels                           |                                                                                                | keyword          |
  | maltiverse.blacklist.last_seen                        | last sighting                                                                                  | date             |
  | maltiverse.blacklist.source                           | reporter of the activity                                                                       | keyword          |
  | maltiverse.cidr                                       | CIDR associated                                                                                | keyword          |
  | maltiverse.city                                       | City                                                                                           | keyword          |
  | maltiverse.classification                             | Classification of the threat                                                                   | keyword          |
  | maltiverse.country_code                               | Country code of the threat                                                                     | keyword          |
  | maltiverse.creation_time                              | creation date                                                                                  | date             |
  | maltiverse.domain_consonants                          |                                                                                                | long             |
  | maltiverse.domain_length                              |                                                                                                | long             |
  | maltiverse.email                                      | email address                                                                                  | keyword          |
  | maltiverse.entropy                                    |                                                                                                | double           |
  | maltiverse.feed                                       | Origin of the IoC                                                                              | keyword          |
  | maltiverse.hostname                                   |                                                                                                | keyword          |
  | maltiverse.ip_addr                                    | IP address                                                                                     | ip               |
  | maltiverse.is_alive                                   |                                                                                                | boolean          |
  | maltiverse.is_cdn                                     | boolean description tag                                                                        | boolean          |
  | maltiverse.is_cnc                                     | boolean description tag                                                                        | boolean          |
  | maltiverse.is_distributing_malware                    | boolean description tag                                                                        | boolean          |
  | maltiverse.is_hosting                                 | boolean description tag                                                                        | boolean          |
  | maltiverse.is_iot_threat                              | boolean description tag                                                                        | boolean          |
  | maltiverse.is_known_attacker                          | boolean description tag                                                                        | boolean          |
  | maltiverse.is_known_scanner                           | boolean description tag                                                                        | boolean          |
  | maltiverse.is_mining_pool                             | boolean description tag                                                                        | boolean          |
  | maltiverse.is_open_proxy                              | boolean description tag                                                                        | boolean          |
  | maltiverse.is_phishing                                |                                                                                                | boolean          |
  | maltiverse.is_sinkhole                                | boolean description tag                                                                        | boolean          |
  | maltiverse.is_storing_phishing                        |                                                                                                | boolean          |
  | maltiverse.is_tor_node                                | boolean description tag                                                                        | boolean          |
  | maltiverse.is_vpn_node                                | boolean description tag                                                                        | boolean          |
  | maltiverse.last_online_time                           |                                                                                                | keyword          |
  | maltiverse.location                                   | Longitude and latitude.                                                                        | geo_point        |
  | maltiverse.modification_time                          | Last modification date                                                                         | date             |
  | maltiverse.number_of_blacklisted_domains_resolving    | Blacklisted domains resolving associated                                                       | long             |
  | maltiverse.number_of_domains_resolving                | Domains resolving associated                                                                   | long             |
  | maltiverse.number_of_offline_malicious_urls_allocated | URLs allocated                                                                                 | long             |
  | maltiverse.number_of_online_malicious_urls_allocated  | URLs allocated                                                                                 | long             |
  | maltiverse.number_of_whitelisted_domains_resolving    | Whitelisted domains resolving associated                                                       | long             |
  | maltiverse.postal_code                                |                                                                                                | keyword          |
  | maltiverse.registrant_name                            | Registrant name                                                                                | keyword          |
  | maltiverse.registrant_name.registrant_name            | Multi-field of `maltiverse.registrant_name`.                                                   | match_only_text  |
  | maltiverse.resolved_ip                                |                                                                                                | flattened        |
  | maltiverse.tag                                        | Tags of the threat                                                                             | keyword          |
  | maltiverse.type                                       | Type of the threat                                                                             | keyword          |
  | maltiverse.urlchecksum                                |                                                                                                | keyword          |
  | threat.indicator.first_seen                           | The date and time when intelligence source first reported sighting this indicator.             | date             |
  | threat.indicator.last_seen                            | The date and time when intelligence source last reported sighting this indicator.              | date             |
  | threat.indicator.modified_at                          | The date and time when intelligence source last modified information for this indicator.       | date             |
</dropdown>

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2022-11-05T05:37:57.000Z",
      "agent": {
          "ephemeral_id": "c371b9d1-ae14-4272-9d73-3ef7bf7e46f9",
          "id": "8299ae35-ee0e-4107-9acb-1b6acfdda1fb",
          "name": "docker-fleet-agent",
          "type": "filebeat",
          "version": "8.13.0"
      },
      "data_stream": {
          "dataset": "ti_maltiverse.indicator",
          "namespace": "34244",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "8299ae35-ee0e-4107-9acb-1b6acfdda1fb",
          "snapshot": false,
          "version": "8.13.0"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "threat"
          ],
          "created": "2024-08-02T05:34:15.473Z",
          "dataset": "ti_maltiverse.indicator",
          "id": "NsHdp9tZZtzo6Kzlv6Z1TmPP47U=",
          "ingested": "2024-08-02T05:34:27Z",
          "kind": "enrichment",
          "original": "{\"blacklist\":{\"count\":1,\"description\":\"QakBot\",\"first_seen\":\"2022-11-03 06:23:53\",\"labels\":[\"malicious-activity\"],\"last_seen\":\"2022-11-05 05:37:57\",\"source\":\"ThreatFox Abuse.ch\"},\"classification\":\"malicious\",\"creation_time\":\"2022-11-03 06:23:53\",\"domain\":\"autooutletllc.com\",\"hostname\":\"autooutletllc.com\",\"is_alive\":false,\"is_cnc\":true,\"is_distributing_malware\":false,\"is_iot_threat\":false,\"is_phishing\":false,\"last_online_time\":\"2022-11-05 05:37:57\",\"modification_time\":\"2022-11-05 05:37:57\",\"tag\":[\"bb05\",\"iso\",\"qakbot\",\"qbot\",\"quakbot\",\"tr\",\"w19\",\"zip\",\"oakboat\",\"pinkslipbot\"],\"tld\":\"com\",\"type\":\"url\",\"url\":\"https://autooutletllc.com/spares.php\",\"urlchecksum\":\"4aa7a29969dc1dffa5cad5af6cb343b9a9b40ea9646fed619d4c8d6472629128\"}",
          "severity": 9,
          "type": [
              "indicator"
          ]
      },
      "input": {
          "type": "httpjson"
      },
      "maltiverse": {
          "blacklist": {
              "labels": [
                  "malicious-activity"
              ]
          },
          "classification": "malicious",
          "creation_time": "2022-11-03T06:23:53.000Z",
          "feed": "test",
          "hostname": "autooutletllc.com",
          "is_alive": false,
          "is_cnc": true,
          "is_distributing_malware": false,
          "is_iot_threat": false,
          "is_phishing": false,
          "last_online_time": "2022-11-05T05:37:57.000Z",
          "modification_time": "2022-11-05T05:37:57.000Z",
          "type": "url",
          "urlchecksum": "4aa7a29969dc1dffa5cad5af6cb343b9a9b40ea9646fed619d4c8d6472629128"
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "ti_maltiverse-indicator",
          "bb05",
          "iso",
          "qakbot",
          "qbot",
          "quakbot",
          "tr",
          "w19",
          "zip",
          "oakboat",
          "pinkslipbot"
      ],
      "threat": {
          "feed": {
              "reference": "https://maltiverse.com/feed/test"
          },
          "indicator": {
              "confidence": "High",
              "description": "QakBot",
              "first_seen": "2022-11-03T06:23:53.000Z",
              "last_seen": "2022-11-05T05:37:57.000Z",
              "marking": {
                  "tlp": "WHITE"
              },
              "provider": "ThreatFox Abuse.ch",
              "reference": "https://maltiverse.com/url/4aa7a29969dc1dffa5cad5af6cb343b9a9b40ea9646fed619d4c8d6472629128",
              "sightings": 1,
              "type": "url",
              "url": {
                  "full": "https://autooutletllc.com/spares.php",
                  "registered_domain": "autooutletllc.com",
                  "top_level_domain": "com"
              }
          }
      }
  }
  ```
</dropdown>


## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                                                                                                                                                                                                                                                                                                                | Minimum Kibana version |
  |-----------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.6.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16535))Allow transforms to run in unattended mode.                                                                                                                                                                                                                                                                                   | 9.0.08.13.0            |
  | **1.5.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                                                                                                                                                                                                    | 9.0.08.13.0            |
  | **1.4.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12076))Do not remove `event.original` in main ingest pipeline.                                                                                                                                                                                                                                                                       | 8.13.0                 |
  | **1.3.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                                                                                                                                                                                                     | 8.13.0                 |
  | **1.2.5** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11314))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                                                                                                                                                                                              | 8.13.0                 |
  | **1.2.4** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11284))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                                                                                                                                                                                              | 8.13.0                 |
  | **1.2.3** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11231))Fix labels.is_ioc_transform_source values                                                                                                                                                                                                                                                                                         | 8.13.0                 |
  | **1.2.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11008))Add missing fields in transform                                                                                                                                                                                                                                                                                                   | 8.13.0                 |
  | **1.2.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10674))Fix ECS date mapping on threat fields.                                                                                                                                                                                                                                                                                            | 8.13.0                 |
  | **1.2.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                                                                                                                                                                           | 8.13.0                 |
  | **1.1.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10062))Add missing fields for detection rules.                                                                                                                                                                                                                                                                                           | 8.12.0                 |
  | **1.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9129))Set sensitive values as secret.                                                                                                                                                                                                                                                                                                | 8.12.0                 |
  | **1.0.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                                                                                                                                                                                 | 8.8.0                  |
  | **1.0.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8833))Release package as GA.                                                                                                                                                                                                                                                                                                         | 8.8.0                  |
  | **0.8.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8489))Limit request tracer log count to five.                                                                                                                                                                                                                                                                                        |                        |
  | **0.7.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8436))ECS version updated to 8.11.0.                                                                                                                                                                                                                                                                                                 |                        |
  | **0.6.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8269))Improve 'event.original' check to avoid errors if set.                                                                                                                                                                                                                                                                         |                        |
  | **0.5.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8035))Set 'partner' owner type.                                                                                                                                                                                                                                                                                                      |                        |
  | **0.4.0** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7909))Move non-ECS fields out of root.                                                                                                                                                                                                                                                                                                   |                        |
  | **0.3.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7851))Add DLM policy. Add owner.type to package manifest. Update format_version to 3.0.0**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI. |                        |
  | **0.2.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7804))Remove dotted YAML keys.                                                                                                                                                                                                                                                                                                           |                        |
  | **0.2.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7340))Add support for HTTP request trace logging.                                                                                                                                                                                                                                                                                    |                        |
  | **0.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6741))initial implementation                                                                                                                                                                                                                                                                                                         |                        |
</dropdown>