﻿---
title: Anomali Integration
description: The Anomali integration can fetch indicators from Anomali ThreatStream, a commercial Threat Intelligence service. It has the following data streams: intelligence...
url: https://www.elastic.co/docs/reference/integrations/ti_anomali
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Anomali Integration
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 2.3.1 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                        |
| **Ingestion method(s)**                                                                         | API, Webhook                   |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.18.0                    |

The Anomali integration can fetch indicators from [Anomali ThreatStream](https://www.anomali.com/products/threatstream), a commercial Threat Intelligence service.
It has the following data streams:
- **`intelligence`** Indicators retrieved from the Anomali ThreatStream API's intelligence endpoint.
- **`threatstream`** Indicators received from the Anomali ThreatStream Elastic Extension, which is additional software. This is deprecated.


## Requirements


### Agentless enabled integration

Agentless integrations allow you to collect data without having to manage Elastic Agent in your cloud. They make manual agent deployment unnecessary, so you can focus on your data instead of the agent that collects it. For more information, refer to [Agentless integrations](https://www.elastic.co/guide/en/serverless/current/security-agentless-integrations.html) and the [Agentless integrations FAQ](https://www.elastic.co/guide/en/serverless/current/agentless-integration-troubleshooting.html).
Agentless deployments are only supported in Elastic Serverless and Elastic Cloud environments. This functionality is in beta and is subject to change. Beta features are not subject to the support SLA of official GA features.

### Agent based installation

Elastic Agent must be installed. For more details, check the Elastic Agent [installation instructions](https://www.elastic.co/docs/reference/fleet/install-elastic-agents).
You can install only one Elastic Agent per host.
Elastic Agent is required to stream data from the REST API or webhook and ship the data to Elastic, where the events will then be processed via the integration's ingest pipelines.

## Logs


### Expiration of Indicators of Compromise (IOCs)

An [Elastic Transform](https://www.elastic.co/guide/en/elasticsearch/reference/current/transforms.html) is created to provide a view of active indicators for end users. The transform creates destination indices that are accessible via the alias of the form `logs-ti_anomali_latest.<datastreamname>`. When querying for active indicators or setting up indicator match rules, use the alias to avoid false positives from expired indicators. The dashboards show only the latest indicators.

#### Handling Orphaned IOCs

Indicator data from Anomali can contain information about deletion or expiry times. However, some Anomali IOCs may never expire and will continue to stay in the latest destination index. To avoid any false positives from such orphaned IOCs, users are allowed to configure an "IOC Expiration Duration" or "IOC Duration Before Deletion" parameter while setting up a policy. The value set there will limit the time that indicators are retained before deletion, but indicators may be removed earlier based on information from Anomali.

### Destination index versioning and deleting older versions

The destination indices created by the transform are versioned with an integer suffix such as `-1`, `-2`, for example, `logs-ti_anomali_latest.intelligence-1`.
Due to schema changes in the destination index, its version number may be incremented.
When this happens, the transform does not have the functionality to auto-delete the old index, so users must delete this old index manually. This is to ensure that duplicates are not present when using wildcard queries such as `logs-ti_anomali_latest.intelligence-*`. To delete an old index, follow the steps below (either for `intelligence` as below, or for the older `threatstream` equivalents):
1. After upgrading the integration to the latest version, check the current transform's destination index version by navigating to: `Stack Management -> Transforms -> logs-ti_anomali.latest_intelligence-default -> Details`. Check the `destination_index` value.
2. Run `GET _cat/indices?v` and check if any older versions exist. Such as `logs-ti_anomali_latest.intelligence-1`
3. Run `DELETE logs-ti_anomali_latest.intelligence-<OLDVERSION>` to delete the old index.


### ILM Policies

To prevent unbounded growth of the source data streams `logs-ti_opencti.<datastreamname>-*`, index lifecycle management (ILM) policies will deletes records 5 days after ingestion.

### Anomali ThreatStream API

The Anomali ThreatStream API's intelligence endpoint is the preferred source of indicators. This data will be be accessible using the alias `logs-ti_anomali_latest.intelligence`.
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2025-05-15T05:41:39.529550940Z",
      "agent": {
          "ephemeral_id": "c4e3038f-6797-46c3-b082-cbd123c7cbe3",
          "id": "1c061faa-0b6d-43fe-b1d8-93ca2ddea2de",
          "name": "elastic-agent-51370",
          "type": "filebeat",
          "version": "8.13.0"
      },
      "anomali": {
          "threatstream": {
              "can_add_public_tags": true,
              "confidence": 60,
              "deletion_scheduled_at": "2025-05-22T05:41:39.52955094Z",
              "expiration_ts": "9999-12-31T00:00:00.000Z",
              "feed_id": 0,
              "id": "232020126",
              "is_anonymous": false,
              "is_editable": false,
              "is_public": true,
              "itype": "apt_domain",
              "meta": {
                  "severity": "very-high"
              },
              "owner_organization_id": 67,
              "retina_confidence": -1,
              "source_reported_confidence": 60,
              "status": "active",
              "threat_type": "apt",
              "type": "domain",
              "update_id": "100000001",
              "uuid": "0921be47-9cc2-4265-b896-c62a7cb91042",
              "value": "gen1xyz.com"
          }
      },
      "data_stream": {
          "dataset": "ti_anomali.intelligence",
          "namespace": "27115",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "1c061faa-0b6d-43fe-b1d8-93ca2ddea2de",
          "snapshot": false,
          "version": "8.13.0"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "threat"
          ],
          "created": "2021-04-06T09:56:22.915Z",
          "dataset": "ti_anomali.intelligence",
          "ingested": "2025-05-15T05:41:39Z",
          "kind": "enrichment",
          "original": "{\"asn\":\"\",\"can_add_public_tags\":true,\"confidence\":60,\"created_by\":null,\"created_ts\":\"2021-04-06T09:56:22.915Z\",\"description\":null,\"expiration_ts\":\"9999-12-31T00:00:00.000Z\",\"feed_id\":0,\"id\":232020126,\"is_anonymous\":false,\"is_editable\":false,\"is_public\":true,\"itype\":\"apt_domain\",\"locations\":[],\"meta\":{\"detail2\":\"imported by user 136\",\"severity\":\"very-high\"},\"modified_ts\":\"2021-04-06T09:56:22.915Z\",\"org\":\"\",\"owner_organization_id\":67,\"rdns\":null,\"resource_uri\":\"/api/v2/intelligence/232020126/\",\"retina_confidence\":-1,\"sort\":[455403032],\"source\":\"Analyst\",\"source_locations\":[],\"source_reported_confidence\":60,\"status\":\"active\",\"subtype\":null,\"tags\":null,\"target_industry\":[],\"threat_type\":\"apt\",\"threatscore\":54,\"tlp\":null,\"trusted_circle_ids\":null,\"type\":\"domain\",\"update_id\":100000001,\"uuid\":\"0921be47-9cc2-4265-b896-c62a7cb91042\",\"value\":\"gen1xyz.com\",\"workgroups\":[]}",
          "severity": 9,
          "type": [
              "indicator"
          ]
      },
      "input": {
          "type": "cel"
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "anomali-intelligence"
      ],
      "threat": {
          "indicator": {
              "confidence": "Medium",
              "marking": {
                  "tlp": "WHITE"
              },
              "modified_at": "2021-04-06T09:56:22.915Z",
              "provider": "Analyst",
              "type": "domain-name",
              "url": {
                  "domain": "gen1xyz.com"
              }
          }
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                           | Description                                                                                                                                                                                                                | Type             |
  |-------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                      | Event timestamp.                                                                                                                                                                                                           | date             |
  | anomali.threatstream.can_add_public_tags        | Indicates whether a user can add public tags to a Threat Model entity.                                                                                                                                                     | boolean          |
  | anomali.threatstream.confidence                 | Level of certainty that an observable is of the reported indicator type. Confidence scores range from 0-100, in increasing order of confidence, and is assigned by ThreatStream based on several factors.                  | long             |
  | anomali.threatstream.deletion_scheduled_at      | At this time the IOC will be deleted by the transform.                                                                                                                                                                     | date             |
  | anomali.threatstream.expiration_ts              | Time stamp of when intelligence will expire on ThreatStream, in UTC time. Note: expiration_ts can only be specified in an advanced search query.                                                                           | date             |
  | anomali.threatstream.feed_id                    | Numeric ID of the threat feed that generated the indicator. feed_id = 0 for user-created indicators.                                                                                                                       | long             |
  | anomali.threatstream.id                         | Unique ID for the indicator. This identifier is assigned to the indicator when it is first created on ThreatStream. Unlike update_id, this identifier never changes as long as the indicator is available on ThreatStream. | keyword          |
  | anomali.threatstream.import_session_id          | ID of import session in which the indicator was imported. import_session_id=0 if the indicator came in through a threat feed.                                                                                              | keyword          |
  | anomali.threatstream.is_anonymous               | Whether the organization and user information is anonymized when the observable is accessed by users outside of the owner organization.                                                                                    | boolean          |
  | anomali.threatstream.is_editable                | Indicates whether the imported entity can be updated by an intelligence source. This attribute is reserved for intelligence source providers and can be ignored.                                                           | boolean          |
  | anomali.threatstream.is_public                  | Visibility of the indicator—public or private. 0/False—if the indicator is private or belongs to a Trusted Circle 1/True—if the indicator is public Default: 0/False                                                       | boolean          |
  | anomali.threatstream.itype                      | Indicator type.                                                                                                                                                                                                            | keyword          |
  | anomali.threatstream.meta.maltype               | Tag that specifies the malware associated with an indicator.                                                                                                                                                               | keyword          |
  | anomali.threatstream.meta.registrant.address    | Indicator domain WHOIS registrant address.                                                                                                                                                                                 | keyword          |
  | anomali.threatstream.meta.registrant.email      | Indicator domain WHOIS registrant email.                                                                                                                                                                                   | keyword          |
  | anomali.threatstream.meta.registrant.name       | Indicator domain WHOIS registrant name.                                                                                                                                                                                    | keyword          |
  | anomali.threatstream.meta.registrant.org        | Indicator domain WHOIS registrant org.                                                                                                                                                                                     | keyword          |
  | anomali.threatstream.meta.registrant.phone      | Indicator domain WHOIS registrant phone.                                                                                                                                                                                   | keyword          |
  | anomali.threatstream.meta.registration_created  | Registration created.                                                                                                                                                                                                      | date             |
  | anomali.threatstream.meta.registration_updated  | Registration updated.                                                                                                                                                                                                      | date             |
  | anomali.threatstream.meta.severity              | Severity assigned to the indicator through machine-learning algorithms ThreatStream deploys. Possible values: low, medium, high, very-high                                                                                 | keyword          |
  | anomali.threatstream.owner_organization_id      | ID of the (ThreatStream) organization that brought in the indicator, either through a threat feed or through the import process.                                                                                           | long             |
  | anomali.threatstream.rdns                       | Domain name (obtained through reverse domain name lookup) associated with the IP address that is associated with the indicator.                                                                                            | keyword          |
  | anomali.threatstream.retina_confidence          | Confidence score assigned to the observable by Anomali machine learning algorithms.                                                                                                                                        | long             |
  | anomali.threatstream.source_created             | Time stamp of when the entity was created by its original source.                                                                                                                                                          | date             |
  | anomali.threatstream.source_modified            | Time stamp of when the entity was last updated by its original source.                                                                                                                                                     | date             |
  | anomali.threatstream.source_reported_confidence | A risk score from 0 to 100, provided by the source of the indicator.                                                                                                                                                       | long             |
  | anomali.threatstream.status                     | Status assigned to the indicator. For example, active, inactive, falsepos.                                                                                                                                                 | keyword          |
  | anomali.threatstream.threat_type                | Summarized threat type of the indicator. For example, malware, compromised, apt, c2, and so on.                                                                                                                            | keyword          |
  | anomali.threatstream.threatscore                | Deprecated.                                                                                                                                                                                                                | keyword          |
  | anomali.threatstream.trusted_circle_ids         | IDs of the trusted circles with which the indicator is shared.                                                                                                                                                             | keyword          |
  | anomali.threatstream.type                       | Type of indicator—domain, email, ip, md5, string, url.                                                                                                                                                                     | keyword          |
  | anomali.threatstream.update_id                  | An incrementing numeric identifier associated with each update to intelligence on ThreatStream.                                                                                                                            | keyword          |
  | anomali.threatstream.uuid                       | UUID (universally unique identifier) assigned to the observable for STIX compliance.                                                                                                                                       | keyword          |
  | anomali.threatstream.value                      | Value of the observable. For example, 192.168.0.10 or .                                                                                                                                                                    | keyword          |
  | cloud.image.id                                  | Image ID for the cloud instance.                                                                                                                                                                                           | keyword          |
  | data_stream.dataset                             | Data stream dataset name.                                                                                                                                                                                                  | constant_keyword |
  | data_stream.namespace                           | Data stream namespace.                                                                                                                                                                                                     | constant_keyword |
  | data_stream.type                                | Data stream type.                                                                                                                                                                                                          | constant_keyword |
  | event.dataset                                   | Event dataset                                                                                                                                                                                                              | constant_keyword |
  | event.module                                    | Event module                                                                                                                                                                                                               | constant_keyword |
  | host.containerized                              | If the host is a container.                                                                                                                                                                                                | boolean          |
  | host.os.build                                   | OS build information.                                                                                                                                                                                                      | keyword          |
  | host.os.codename                                | OS codename, if any.                                                                                                                                                                                                       | keyword          |
  | input.type                                      | Type of Filebeat input.                                                                                                                                                                                                    | keyword          |
  | labels.is_ioc_transform_source                  | Indicates whether an IOC is in the raw source data stream, or the in latest destination index.                                                                                                                             | constant_keyword |
  | threat.feed.dashboard_id                        | Dashboard ID used for Kibana CTI UI                                                                                                                                                                                        | constant_keyword |
  | threat.feed.name                                | Display friendly feed name                                                                                                                                                                                                 | constant_keyword |
  | threat.indicator.modified_at                    | The date and time when intelligence source last modified information for this indicator.                                                                                                                                   | date             |
</dropdown>


### Anomali ThreatStream via the Elastic Extension

This source of indicators is deprecated. New users should instead use the API source above. This source requires additional software, the *Elastic* *Extension,* to connect Anomali ThreatStream to this integration. It's available on the [ThreatStream download page](https://ui.threatstream.com/downloads).
Please refer to the documentation included with the extension for a detailed explanation on how to configure Anomali ThreatStream to send indicators to this integration.
Indicators ingested in this way will become accessible using the alias `logs-ti_anomali_latest.threatstream`.
<dropdown title="Example">
  ```json
  {
      "@timestamp": "2020-10-08T12:22:11.000Z",
      "agent": {
          "ephemeral_id": "5b173eb1-b99b-41b7-8bd8-aee3a5e52c58",
          "id": "574058b5-688b-43f0-ac43-68a85476b2fa",
          "name": "elastic-agent-42471",
          "type": "filebeat",
          "version": "8.13.0"
      },
      "anomali": {
          "threatstream": {
              "added_at": "2020-10-08T12:22:11.000Z",
              "classification": "public",
              "confidence": 20,
              "deleted_at": "2020-10-13T12:22:11.000Z",
              "detail2": "imported by user 184",
              "id": "3135167627",
              "import_session_id": "1400",
              "itype": "mal_domain",
              "resource_uri": "/api/v1/intelligence/P46279656657/",
              "severity": "high",
              "source_feed_id": "3143",
              "state": "active",
              "trusted_circle_ids": [
                  "122"
              ],
              "update_id": "3786618776",
              "value_type": "domain"
          }
      },
      "data_stream": {
          "dataset": "ti_anomali.threatstream",
          "namespace": "11488",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "574058b5-688b-43f0-ac43-68a85476b2fa",
          "snapshot": false,
          "version": "8.13.0"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "threat"
          ],
          "dataset": "ti_anomali.threatstream",
          "ingested": "2025-05-14T08:28:29Z",
          "kind": "enrichment",
          "original": "{\"added_at\":\"2020-10-08T12:22:11\",\"classification\":\"public\",\"confidence\":20,\"country\":\"FR\",\"date_first\":\"2020-10-08T12:21:50\",\"date_last\":\"2020-10-08T12:24:42\",\"detail2\":\"imported by user 184\",\"domain\":\"d4xgfj.example.net\",\"id\":3135167627,\"import_session_id\":1400,\"itype\":\"mal_domain\",\"lat\":-49.1,\"lon\":94.4,\"org\":\"OVH Hosting\",\"resource_uri\":\"/api/v1/intelligence/P46279656657/\",\"severity\":\"high\",\"source\":\"Default Organization\",\"source_feed_id\":3143,\"srcip\":\"89.160.20.156\",\"state\":\"active\",\"trusted_circle_ids\":\"122\",\"update_id\":3786618776,\"value_type\":\"domain\"}",
          "severity": 7,
          "type": [
              "indicator"
          ]
      },
      "input": {
          "type": "http_endpoint"
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "anomali-threatstream"
      ],
      "threat": {
          "indicator": {
              "as": {
                  "organization": {
                      "name": "OVH Hosting"
                  }
              },
              "confidence": "Low",
              "first_seen": "2020-10-08T12:21:50.000Z",
              "geo": {
                  "country_iso_code": "FR",
                  "location": {
                      "lat": -49.1,
                      "lon": 94.4
                  }
              },
              "ip": "89.160.20.156",
              "last_seen": "2020-10-08T12:24:42.000Z",
              "marking": {
                  "tlp": [
                      "WHITE"
                  ]
              },
              "provider": "Default Organization",
              "type": "domain-name",
              "url": {
                  "domain": "d4xgfj.example.net"
              }
          }
      }
  }
  ```
</dropdown>

<dropdown title="Exported fields">
  | Field                                   | Description                                                                                                                                                                                                                                                                                                                                       | Type             |
  |-----------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                              | Event timestamp.                                                                                                                                                                                                                                                                                                                                  | date             |
  | anomali.threatstream.added_at           | Date when IOC was added.                                                                                                                                                                                                                                                                                                                          | date             |
  | anomali.threatstream.classification     | Indicates whether an indicator is private or from a public feed and available publicly. Possible values: private, public.                                                                                                                                                                                                                         | keyword          |
  | anomali.threatstream.confidence         | The measure of the accuracy (from 0 to 100) assigned by ThreatStream's predictive analytics technology to indicators.                                                                                                                                                                                                                             | long             |
  | anomali.threatstream.deleted_at         | Date when IOC was deleted/expired.                                                                                                                                                                                                                                                                                                                | date             |
  | anomali.threatstream.detail2            | Detail text for indicator.                                                                                                                                                                                                                                                                                                                        | text             |
  | anomali.threatstream.id                 | The ID of the indicator.                                                                                                                                                                                                                                                                                                                          | keyword          |
  | anomali.threatstream.import_session_id  | ID of the import session that created the indicator on ThreatStream.                                                                                                                                                                                                                                                                              | keyword          |
  | anomali.threatstream.itype              | Indicator type. Possible values: "apt_domain", "apt_email", "apt_ip", "apt_url", "bot_ip", "c2_domain", "c2_ip", "c2_url", "i2p_ip", "mal_domain", "mal_email", "mal_ip", "mal_md5", "mal_url", "parked_ip", "phish_email", "phish_ip", "phish_url", "scan_ip", "spam_domain", "ssh_ip", "suspicious_domain", "tor_ip" and "torrent_tracker_url". | keyword          |
  | anomali.threatstream.maltype            | Information regarding a malware family, a CVE ID, or another attack or threat, associated with the indicator.                                                                                                                                                                                                                                     | wildcard         |
  | anomali.threatstream.md5                | Hash for the indicator.                                                                                                                                                                                                                                                                                                                           | keyword          |
  | anomali.threatstream.resource_uri       | Relative URI for the indicator details.                                                                                                                                                                                                                                                                                                           | keyword          |
  | anomali.threatstream.severity           | Criticality associated with the threat feed that supplied the indicator. Possible values: low, medium, high, very-high.                                                                                                                                                                                                                           | keyword          |
  | anomali.threatstream.source             | Source for the indicator.                                                                                                                                                                                                                                                                                                                         | keyword          |
  | anomali.threatstream.source_feed_id     | ID for the integrator source.                                                                                                                                                                                                                                                                                                                     | keyword          |
  | anomali.threatstream.state              | State for this indicator.                                                                                                                                                                                                                                                                                                                         | keyword          |
  | anomali.threatstream.trusted_circle_ids | ID of the trusted circle that imported the indicator.                                                                                                                                                                                                                                                                                             | keyword          |
  | anomali.threatstream.update_id          | Update ID.                                                                                                                                                                                                                                                                                                                                        | keyword          |
  | anomali.threatstream.url                | URL for the indicator.                                                                                                                                                                                                                                                                                                                            | keyword          |
  | anomali.threatstream.value_type         | Data type of the indicator. Possible values: ip, domain, url, email, md5.                                                                                                                                                                                                                                                                         | keyword          |
  | cloud.image.id                          | Image ID for the cloud instance.                                                                                                                                                                                                                                                                                                                  | keyword          |
  | data_stream.dataset                     | Data stream dataset name.                                                                                                                                                                                                                                                                                                                         | constant_keyword |
  | data_stream.namespace                   | Data stream namespace.                                                                                                                                                                                                                                                                                                                            | constant_keyword |
  | data_stream.type                        | Data stream type.                                                                                                                                                                                                                                                                                                                                 | constant_keyword |
  | event.dataset                           | Event dataset                                                                                                                                                                                                                                                                                                                                     | constant_keyword |
  | event.module                            | Event module                                                                                                                                                                                                                                                                                                                                      | constant_keyword |
  | host.containerized                      | If the host is a container.                                                                                                                                                                                                                                                                                                                       | boolean          |
  | host.os.build                           | OS build information.                                                                                                                                                                                                                                                                                                                             | keyword          |
  | host.os.codename                        | OS codename, if any.                                                                                                                                                                                                                                                                                                                              | keyword          |
  | input.type                              | Type of Filebeat input.                                                                                                                                                                                                                                                                                                                           | keyword          |
  | labels.is_ioc_transform_source          | Indicates whether an IOC is in the raw source data stream, or the in latest destination index.                                                                                                                                                                                                                                                    | constant_keyword |
  | log.flags                               | Flags for the log file.                                                                                                                                                                                                                                                                                                                           | keyword          |
  | log.offset                              | Offset of the entry in the log file.                                                                                                                                                                                                                                                                                                              | long             |
  | threat.feed.dashboard_id                | Dashboard ID used for Kibana CTI UI                                                                                                                                                                                                                                                                                                               | constant_keyword |
  | threat.feed.name                        | Display friendly feed name                                                                                                                                                                                                                                                                                                                        | constant_keyword |
  | threat.indicator.first_seen             | The date and time when intelligence source first reported sighting this indicator.                                                                                                                                                                                                                                                                | date             |
  | threat.indicator.last_seen              | The date and time when intelligence source last reported sighting this indicator.                                                                                                                                                                                                                                                                 | date             |
  | threat.indicator.modified_at            | The date and time when intelligence source last modified information for this indicator.                                                                                                                                                                                                                                                          | date             |
</dropdown>


## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![Dashboard: Anomali Overview](https://epr.elastic.co/package/ti_anomali/2.3.1/img/screenshot1.png)

  ![Dashboard: Anomali Files](https://epr.elastic.co/package/ti_anomali/2.3.1/img/screenshot2.png)

  ![Dashboard: Anomali URL](https://epr.elastic.co/package/ti_anomali/2.3.1/img/screenshot3.png)

  ![Dashboard: Anomali Other Indicators](https://epr.elastic.co/package/ti_anomali/2.3.1/img/screenshot4.png)

  ![Add Anomali integration](https://epr.elastic.co/package/ti_anomali/2.3.1/img/screenshot5.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | Minimum Kibana version |
  |------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **2.3.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/17253))Remove `is_default` from agentless deployment mode to ensure agent-based deployment is the default.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/17253))Remove organization field in ingest pipeline.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/17253))Downgrade the `format_version` to the minimum version that supports all the necessary features for the package.**Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/17253))Update Kibana constraint to 8.18.0 support agentless deployment. | 9.0.08.18.0            |
  | **2.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16535))Allow transforms to run in unattended mode.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.0.08.13.0            |
  | **2.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14547))Added Agentless deployment mode.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 9.0.08.13.0            |
  | **2.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14779))Allow setting an advanced search query.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 9.0.08.13.0            |
  | **2.0.0**  | **Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/13909))Modify field type to eliminate field conflicts within the data streams.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 9.0.08.13.0            |
  | **1.27.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14082))Add `event.ingested` ECS field definition in transform.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 9.0.08.13.0            |
  | **1.27.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13826))Add support for proxy URL and SSL configuration parameters in intelligence data stream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 9.0.08.13.0            |
  | **1.26.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/113426))Add initial_interval parameter to API ingestion.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 9.0.08.13.0            |
  | **1.26.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13238))Fix lower bound query parameter in Threatstream API.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 9.0.08.13.0            |
  | **1.26.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13119))Update Kibana constraint to support 9.0.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 9.0.08.13.0            |
  | **1.25.2** | **Bug fix** ([View pull request](http://github.com/elastic/integrations/pull/12624))Add missing ECS field in intelligence datastream.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.13.0                 |
  | **1.25.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12697))Updated SSL description to be uniform and to include links to documentation.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.13.0                 |
  | **1.25.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12076))Do not remove `event.original` in main ingest pipeline.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | 8.13.0                 |
  | **1.24.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.13.0                 |
  | **1.23.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/11309))Support the ThreatStream API                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.13.0                 |
  | **1.22.3** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11231))Fix labels.is_ioc_transform_source values                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | 8.13.0                 |
  | **1.22.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11008))Add missing fields in transform                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.13.0                 |
  | **1.22.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10674))Fix ECS date mapping on threat fields.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | 8.13.0                 |
  | **1.22.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.13.0                 |
  | **1.21.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9618))Add destination index alias and fix docs.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | 8.12.0                 |
  | **1.20.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9129))Set sensitive values as secret.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | 8.12.0                 |
  | **1.19.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.8.0                  |
  | **1.19.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/8786))Fix IOC expiration duration character casting.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.8.0                  |
  | **1.19.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8436))ECS version updated to 8.11.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.8.0                  |
  | **1.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7920))ECS version updated to 8.10.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.8.0                  |
  | **1.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7849))Add DLM policy. Add owner.type to package manifest. Update format_version to 3.0.0**Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.                                                                                                                                                                                                                                                              | 8.8.0                  |
  | **1.16.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7803))Remove dotted YAML keys.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |                        |
  | **1.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7613))Update package-spec to 2.10.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.8.0                  |
  | **1.15.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/issues/6514))Fix destination fields mapping. Note - Since transform's destination index version is changed, users must manually delete the old index. See [https://docs.elastic.co/integrations/ti_anomali#logs](https://docs.elastic.co/integrations/ti_anomali#logs) for details on destination index versioning.                                                                                                                                                                                                                                                                                        | 8.8.0                  |
  | **1.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7111))Update package to ECS 8.9.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.8.0                  |
  | **1.14.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7000))Change sort order field in latest transform                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.8.0                  |
  | **1.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6630))Ensure event.kind is correctly set for pipeline errors.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | 8.8.0                  |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6328))Update package to ECS 8.8.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.8.0                  |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/issues/6344))Add IOC field to transform source to easily filter destination indices with unexpired indicators                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.8.0                  |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5581))Support for IoC Expiration                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | 8.8.0                  |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.0.0                  |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.0.0                  |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.0.0                  |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4220))Deprecate EOL Limo datastream. See [https://www.anomali.com/resources/limo](https://www.anomali.com/resources/limo).                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.0.0                  |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3920))Update package to ECS 8.4.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.0.0                  |
  | **1.5.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3881))Fix proxy URL documentation rendering.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.0.0                  |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3689))Update categories to include `threat_intel`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.0.0                  |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3353))Update package to ECS 8.3.0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.0.0                  |
  | **1.3.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3167))added links to Anomoli documentation in readme                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.0.0                  |
  | **1.3.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3437))Fix threatstream                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | 8.0.0                  |
  | **1.3.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3398))Update package descriptions                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.0.0                  |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2781))Update to ECS 8.2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.0.0                  |
  | **1.2.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3042))Add mapping for event.created                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | 8.0.0                  |
  | **1.2.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | 8.0.0                  |
  | **1.2.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2677))Adding first interval to Anomali Limo policy UI                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | 8.0.0                  |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2446))Update to ECS 8.0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | 8.0.0                  |
  | **1.1.3**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2339))Regenerate test files using the new GeoIP database                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | 8.0.0                  |
  | **1.1.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2327))Change test public IPs to the supported subset                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |                        |
  | **1.1.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2330))Fixing typo in base-fields.yml                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |                        |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2292))Adding dashboards and threat.feed ECS fields                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |                        |
  | **1.0.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2063))Bump minimum version                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | 8.0.0                  |
  | **1.0.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1997))Update title and description.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |                        |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1911))Initial release                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |                        |
</dropdown>