﻿---
title: abuse.ch integration for Elastic
description: The abuse.ch integration for Elastic allows you to collect logs from abuse.ch, which provides actionable, community-driven threat intelligence data and...
url: https://www.elastic.co/docs/reference/integrations/ti_abusech
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.1
---

# abuse.ch integration for Elastic
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 3.5.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                        |
| **Ingestion method(s)**                                                                         | API                            |
| **Minimum Kibana version(s)**                                                                   | 9.1.08.19.0                    |


## Overview

The abuse.ch integration for Elastic allows you to collect logs from [abuse.ch](https://abuse.ch/), which provides actionable, community-driven threat intelligence data and helps identify, track, and mitigate malware and botnet-related cyber threats. With this integration, threat intelligence indicators can be ingested into Elastic for enhanced threat detection and event enrichment.

### Compatibility

The abuse.ch integration is compatible with `v1` version of abuse.ch URLhaus, MalwareBazaar, ThreatFox, and SSLBL APIs.

### How it works

This integration periodically queries the abuse.ch APIs to retrieve threat intelligence indicators.

## What data does this integration collect?

This integration collects threat intelligence indicators into the following datasets:
- `ja3_fingerprints`: Collects JA3 fingerprint based threat indicators identified by SSLBL via [SSLBL API endpoint](https://sslbl.abuse.ch/blacklist/ja3_fingerprints.csv).
- `malware`: Collects malware payloads from URLs tracked by URLhaus via [URLhaus Bulk API](https://urlhaus-api.abuse.ch/#payloads-recent).
- `malwarebazaar`: Collects malware payloads from MalwareBazaar via [MalwareBazaar API](https://bazaar.abuse.ch/api/#latest_additions).
- `sslblacklist`: Collects SSL certificate based threat indicators blacklisted on SSLBL via [SSLBL API endpoint](https://sslbl.abuse.ch/blacklist/sslblacklist.csv).
- `threatfox`: Collects threat indicators from ThreatFox via [ThreatFox API](https://threatfox.abuse.ch/api/#recent-iocs).
- `url`: Collects malware URL based threat indicators from URLhaus via [URLhaus API](https://urlhaus.abuse.ch/api/#csv).


### Supported use cases

The abuse.ch integration brings threat intel into Elastic Security, enabling detection alerts when Indicators of Compromise (IoCs) like malicious [IPs](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/threat_intel/threat_intel_indicator_match_address), [domains](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/threat_intel/threat_intel_indicator_match_url), or [hashes](https://www.elastic.co/docs/reference/security/prebuilt-rules/rules/threat_intel/threat_intel_indicator_match_hash) match your event or alert data. This data can also support threat hunting, enrich alerts with threat context, and power dashboards to track known threats in your environment.

## What do I need to use this integration?


### From Elastic

This integration installs [Elastic latest transforms](https://www.elastic.co/docs/explore-analyze/transforms/transform-overview#latest-transform-overview). For more details, check the [Transform](https://www.elastic.co/docs/explore-analyze/transforms/transform-setup) setup and requirements.

### From abuse.ch

abuse.ch requires an `Auth Key` (API key) for request authentication. Any requests made without this key will be rejected by the abuse.ch APIs.

#### Obtain `Auth Key`

1. Sign up for a new account, or login into the [abuse.ch authentication portal](https://auth.abuse.ch).
2. Connect with at least one authentication provider: Google, Github, X, or LinkedIn.
3. Select **Save profile**.
4. In the **Optional** section, click the **Generate Key** button to generate **Auth Key**.
5. Copy the generated **Auth Key**.

For more details, check the abuse.ch [Community First - New Authentication](https://abuse.ch/blog/community-first/) blog.

## How do I deploy this integration?

This integration supports both Elastic Agentless-based and Agent-based installations.

#### Agentless-based installation

Agentless integrations allow you to collect data without having to manage Elastic Agent in your cloud. They make manual agent deployment unnecessary, so you can focus on your data instead of the agent that collects it. For more information, refer to [Agentless integrations](https://www.elastic.co/guide/en/serverless/current/security-agentless-integrations.html) and the [Agentless integrations FAQ](https://www.elastic.co/guide/en/serverless/current/agentless-integration-troubleshooting.html).
Agentless deployments are only supported in Elastic Serverless and Elastic Cloud environments. This functionality is in beta and is subject to change. Beta features are not subject to the support SLA of official GA features.

#### Agent-based installation

Elastic Agent must be installed. For more details, check the Elastic Agent [installation instructions](https://www.elastic.co/docs/reference/fleet/install-elastic-agents). You can install only one Elastic Agent per host.

### Setup

1. In the top search bar in Kibana, search for **Integrations**.
2. In the search bar, type **abuse.ch**.
3. Select the **abuse.ch** integration from the search results.
4. Select **Add abuse.ch** to add the integration.
5. Enable and configure only the collection methods which you will use.
   - To **Collect abuse.ch logs via API**, you'll need to:
  - Configure **Auth Key**.
- Enable/Disable the required datasets.
- For each dataset, adjust the integration configuration parameters if required, including the URL, Interval, etc. to enable data collection.
6. Select **Save and continue** to save the integration.


### Validation


#### Dashboards populated

1. In Kibana, navigate to **Dashboards**.
2. In the search bar, type **abuse.ch**.
3. Select a dashboard for the dataset you are collecting, and verify the dashboard information is populated.


#### Transforms healthy

1. In Kibana, navigate to **Management** > **Stack Management**.
2. Under **Data**, select **Transforms**.
3. In the search bar, type **abuse.ch**.
4. All transforms from the search results should indicate **Healthy** under the **Health** column.


## Troubleshooting

- When creating the **Auth Key** inside the [abuse.ch authentication](https://auth.abuse.ch/) portal, make sure you connect at least one additional authentication provider to ensure seemless access to the abuse.ch platform.
- Check for captured ingestion errors inside Kibana. Ingestion errors, including API errors, are captured into `error.message` field.
  1. Navigate to **Analytics** > **Discover**.
2. In **Search field names**, search and add fields `error.message` and `data_stream.dataset` into the **Discover** view. For more details on adding fields inside **Discover**, check [Discover getting started](https://www.elastic.co/docs/explore-analyze/discover/discover-get-started).
3. Search for the dataset(s) that are enabled by this integration. For example, in the KQL query bar, use the KQL query `data_stream.dataset: ti_abusech.url` to search on specific dataset or KQL query `data_stream.dataset: ti_abusech.*` to search on all datasets.
4. Search for errors that are captured into `error.message` field using KQL query `error.message: *`. You can combine queries using [KQL boolean expressions](https://www.elastic.co/docs/explore-analyze/query-filter/languages/kql#_combining_multiple_queries), such as `AND`. For example, to search for errors inside `url` dataset, you can use KQL query: `data_stream.dataset: ti_abusech.url AND error.message: *`.
- Common API errors:
  All the abusec.ch API errors are captured inside the `error` fields.
  1. abuse.ch APIs return HTTP status `403 Forbidden` when the Auth Key is invalid. In such case, the `error.message` field is populated with message `query_status: unknown_auth_key` and `error.id` with `403 Forbidden`. To fix this, you need to regenerate the Auth Key in the [abuse.ch authentication portal](https://auth.abuse.ch/) and update the integration policy with newly generated Auth Key.
2. abuse.ch APIs return HTTP status `500 Internal Server Error` when experiencing problem on the abuse.ch service. In such case, `error.message` field is populated with message `POST:500 Internal Server Error (500)` and `error.id` with `500 Internal Server Error`. This is likely a one-off scenario and the ingestion should resume normally in the subsequent request.
- Since this integration supports the expiration of Indicators of Compromise (IoCs) using Elastic latest transform, the threat indicators are present in both source and destination indices. While this may appear to be duplicate ingestion, it is an implementation detail necessary for properly expiring threat indicators.
- Because the latest copy of threat indicators is now indexed in two places, that is, in both source and destination indices, users must anticipate storage requirements accordingly. The ILM policies on source indices can be tuned to manage their data retention period.
- For help with Elastic ingest tools, check [Common problems](https://www.elastic.co/docs/troubleshoot/ingest/fleet/common-problems).


## Scaling

For more information on architectures that can be used for scaling this integration, check the [Ingest Architectures](https://www.elastic.co/docs/manage-data/ingest/ingest-reference-architectures) documentation.

## Reference


### ECS field reference


#### JA3 Fingerprint Blacklist

<dropdown title="Exported fields">
  | Field                                      | Description                                                                                             | Type             |
  |--------------------------------------------|---------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                 | Event timestamp.                                                                                        | date             |
  | abusech.ja3_fingerprints.deleted_at        | The timestamp when the indicator is (will be) deleted.                                                  | date             |
  | abusech.ja3_fingerprints.urlhaus_reference | Link to URLhaus entry.                                                                                  | keyword          |
  | cloud.image.id                             | Image ID for the cloud instance.                                                                        | keyword          |
  | data_stream.dataset                        | Data stream dataset name.                                                                               | constant_keyword |
  | data_stream.namespace                      | Data stream namespace.                                                                                  | constant_keyword |
  | data_stream.type                           | Data stream type.                                                                                       | constant_keyword |
  | event.dataset                              | Event dataset                                                                                           | constant_keyword |
  | event.module                               | Event module                                                                                            | constant_keyword |
  | host.containerized                         | If the host is a container.                                                                             | boolean          |
  | host.os.build                              | OS build information.                                                                                   | keyword          |
  | host.os.codename                           | OS codename, if any.                                                                                    | keyword          |
  | input.type                                 | Type of Filebeat input.                                                                                 | keyword          |
  | labels.interval                            | User-configured value for `Interval` setting. This is used in calculation of indicator expiration time. | keyword          |
  | labels.is_ioc_transform_source             | Indicates whether an IOC is in the raw source data stream, or the in latest destination index.          | constant_keyword |
  | log.flags                                  | Flags for the log file.                                                                                 | keyword          |
  | log.offset                                 | Offset of the entry in the log file.                                                                    | long             |
  | threat.feed.dashboard_id                   | Dashboard ID used for Kibana CTI UI                                                                     | constant_keyword |
  | threat.feed.name                           | Display friendly feed name                                                                              | constant_keyword |
  | threat.indicator.first_seen                | The date and time when intelligence source first reported sighting this indicator.                      | date             |
  | threat.indicator.last_seen                 | The date and time when intelligence source last reported sighting this indicator.                       | date             |
  | threat.indicator.modified_at               | The date and time when intelligence source last modified information for this indicator.                | date             |
</dropdown>


#### Malware

<dropdown title="Exported fields">
  | Field                                   | Description                                                                                    | Type             |
  |-----------------------------------------|------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                              | Event timestamp.                                                                               | date             |
  | abusech.malware.deleted_at              | The indicator expiration timestamp.                                                            | date             |
  | abusech.malware.ioc_expiration_duration | The configured expiration duration.                                                            | keyword          |
  | abusech.malware.signature               | Malware family.                                                                                | keyword          |
  | abusech.malware.virustotal.link         | Link to the Virustotal report.                                                                 | keyword          |
  | abusech.malware.virustotal.percent      | AV detection in percent.                                                                       | float            |
  | abusech.malware.virustotal.result       | AV detection ratio.                                                                            | keyword          |
  | cloud.image.id                          | Image ID for the cloud instance.                                                               | keyword          |
  | data_stream.dataset                     | Data stream dataset name.                                                                      | constant_keyword |
  | data_stream.namespace                   | Data stream namespace.                                                                         | constant_keyword |
  | data_stream.type                        | Data stream type.                                                                              | constant_keyword |
  | event.dataset                           | Event dataset                                                                                  | constant_keyword |
  | event.module                            | Event module                                                                                   | constant_keyword |
  | host.containerized                      | If the host is a container.                                                                    | boolean          |
  | host.os.build                           | OS build information.                                                                          | keyword          |
  | host.os.codename                        | OS codename, if any.                                                                           | keyword          |
  | input.type                              | Type of Filebeat input.                                                                        | keyword          |
  | labels.is_ioc_transform_source          | Indicates whether an IOC is in the raw source data stream, or the in latest destination index. | constant_keyword |
  | log.flags                               | Flags for the log file.                                                                        | keyword          |
  | log.offset                              | Offset of the entry in the log file.                                                           | long             |
  | threat.feed.dashboard_id                | Dashboard ID used for Kibana CTI UI                                                            | constant_keyword |
  | threat.feed.name                        | Display friendly feed name                                                                     | constant_keyword |
  | threat.indicator.first_seen             | The date and time when intelligence source first reported sighting this indicator.             | date             |
  | threat.indicator.last_seen              | The date and time when intelligence source last reported sighting this indicator.              | date             |
  | threat.indicator.modified_at            | The date and time when intelligence source last modified information for this indicator.       | date             |
</dropdown>


#### MalwareBazaar

<dropdown title="Exported fields">
  | Field                                                | Description                                                                                    | Type             |
  |------------------------------------------------------|------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                           | Event timestamp.                                                                               | date             |
  | abusech.malwarebazaar.anonymous                      | Identifies if the sample was submitted anonymously.                                            | long             |
  | abusech.malwarebazaar.code_sign.algorithm            | Algorithm used to generate the public key.                                                     | keyword          |
  | abusech.malwarebazaar.code_sign.cscb_listed          | Whether the certificate is present on the Code Signing Certificate Blocklist (CSCB).           | boolean          |
  | abusech.malwarebazaar.code_sign.cscb_reason          | Why the certificate is present on the Code Signing Certificate Blocklist (CSCB).               | keyword          |
  | abusech.malwarebazaar.code_sign.issuer_cn            | Common name (CN) of issuing certificate authority.                                             | keyword          |
  | abusech.malwarebazaar.code_sign.serial_number        | Unique serial number issued by the certificate authority.                                      | keyword          |
  | abusech.malwarebazaar.code_sign.subject_cn           | Common name (CN) of subject.                                                                   | keyword          |
  | abusech.malwarebazaar.code_sign.thumbprint           | Hash of certificate.                                                                           | keyword          |
  | abusech.malwarebazaar.code_sign.thumbprint_algorithm | Algorithm used to create thumbprint.                                                           | keyword          |
  | abusech.malwarebazaar.code_sign.valid_from           | Time at which the certificate is first considered valid.                                       | date             |
  | abusech.malwarebazaar.code_sign.valid_to             | Time at which the certificate is no longer considered valid.                                   | keyword          |
  | abusech.malwarebazaar.deleted_at                     | The indicator expiration timestamp.                                                            | date             |
  | abusech.malwarebazaar.dhash_icon                     | In case the file is a PE executable: dhash of the samples icon.                                | keyword          |
  | abusech.malwarebazaar.intelligence.downloads         | Number of downloads from MalwareBazaar.                                                        | long             |
  | abusech.malwarebazaar.intelligence.mail.Generic      | Malware seen in generic spam traffic.                                                          | keyword          |
  | abusech.malwarebazaar.intelligence.mail.IT           | Malware seen in IT spam traffic.                                                               | keyword          |
  | abusech.malwarebazaar.intelligence.uploads           | Number of uploads from MalwareBazaar.                                                          | long             |
  | abusech.malwarebazaar.ioc_expiration_duration        | The configured expiration duration.                                                            | keyword          |
  | cloud.image.id                                       | Image ID for the cloud instance.                                                               | keyword          |
  | data_stream.dataset                                  | Data stream dataset name.                                                                      | constant_keyword |
  | data_stream.namespace                                | Data stream namespace.                                                                         | constant_keyword |
  | data_stream.type                                     | Data stream type.                                                                              | constant_keyword |
  | event.dataset                                        | Event dataset                                                                                  | constant_keyword |
  | event.module                                         | Event module                                                                                   | constant_keyword |
  | host.containerized                                   | If the host is a container.                                                                    | boolean          |
  | host.os.build                                        | OS build information.                                                                          | keyword          |
  | host.os.codename                                     | OS codename, if any.                                                                           | keyword          |
  | input.type                                           | Type of Filebeat input.                                                                        | keyword          |
  | labels.is_ioc_transform_source                       | Indicates whether an IOC is in the raw source data stream, or the in latest destination index. | constant_keyword |
  | log.flags                                            | Flags for the log file.                                                                        | keyword          |
  | log.offset                                           | Offset of the entry in the log file.                                                           | long             |
  | threat.feed.dashboard_id                             | Dashboard ID used for Kibana CTI UI                                                            | constant_keyword |
  | threat.feed.name                                     | Display friendly feed name                                                                     | constant_keyword |
  | threat.indicator.first_seen                          | The date and time when intelligence source first reported sighting this indicator.             | date             |
  | threat.indicator.last_seen                           | The date and time when intelligence source last reported sighting this indicator.              | date             |
  | threat.indicator.modified_at                         | The date and time when intelligence source last modified information for this indicator.       | date             |
</dropdown>


#### SSL Certificate Blacklist

<dropdown title="Exported fields">
  | Field                           | Description                                                                                             | Type             |
  |---------------------------------|---------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                      | Event timestamp.                                                                                        | date             |
  | abusech.sslblacklist.deleted_at | The timestamp when the indicator is (will be) deleted.                                                  | date             |
  | cloud.image.id                  | Image ID for the cloud instance.                                                                        | keyword          |
  | data_stream.dataset             | Data stream dataset name.                                                                               | constant_keyword |
  | data_stream.namespace           | Data stream namespace.                                                                                  | constant_keyword |
  | data_stream.type                | Data stream type.                                                                                       | constant_keyword |
  | event.dataset                   | Event dataset                                                                                           | constant_keyword |
  | event.module                    | Event module                                                                                            | constant_keyword |
  | host.containerized              | If the host is a container.                                                                             | boolean          |
  | host.os.build                   | OS build information.                                                                                   | keyword          |
  | host.os.codename                | OS codename, if any.                                                                                    | keyword          |
  | input.type                      | Type of Filebeat input.                                                                                 | keyword          |
  | labels.interval                 | User-configured value for `Interval` setting. This is used in calculation of indicator expiration time. | keyword          |
  | labels.is_ioc_transform_source  | Indicates whether an IOC is in the raw source data stream, or the in latest destination index.          | constant_keyword |
  | log.flags                       | Flags for the log file.                                                                                 | keyword          |
  | log.offset                      | Offset of the entry in the log file.                                                                    | long             |
  | threat.feed.dashboard_id        | Dashboard ID used for Kibana CTI UI                                                                     | constant_keyword |
  | threat.feed.name                | Display friendly feed name                                                                              | constant_keyword |
  | threat.indicator.first_seen     | The date and time when intelligence source first reported sighting this indicator.                      | date             |
  | threat.indicator.last_seen      | The date and time when intelligence source last reported sighting this indicator.                       | date             |
  | threat.indicator.modified_at    | The date and time when intelligence source last modified information for this indicator.                | date             |
</dropdown>


#### ThreatFox

<dropdown title="Exported fields">
  | Field                                     | Description                                                                                    | Type             |
  |-------------------------------------------|------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                                | Event timestamp.                                                                               | date             |
  | abusech.threatfox.confidence_level        | Confidence level between 0-100.                                                                | long             |
  | abusech.threatfox.deleted_at              | The indicator expiration timestamp.                                                            | date             |
  | abusech.threatfox.ioc_expiration_duration | The configured expiration duration.                                                            | keyword          |
  | abusech.threatfox.malware                 | The malware associated with the IOC.                                                           | keyword          |
  | abusech.threatfox.tags                    | A list of tags associated with the queried malware sample.                                     | keyword          |
  | abusech.threatfox.threat_type             | The type of threat.                                                                            | keyword          |
  | abusech.threatfox.threat_type_desc        | The threat descsription.                                                                       | keyword          |
  | cloud.image.id                            | Image ID for the cloud instance.                                                               | keyword          |
  | data_stream.dataset                       | Data stream dataset name.                                                                      | constant_keyword |
  | data_stream.namespace                     | Data stream namespace.                                                                         | constant_keyword |
  | data_stream.type                          | Data stream type.                                                                              | constant_keyword |
  | event.dataset                             | Event dataset                                                                                  | constant_keyword |
  | event.module                              | Event module                                                                                   | constant_keyword |
  | host.containerized                        | If the host is a container.                                                                    | boolean          |
  | host.os.build                             | OS build information.                                                                          | keyword          |
  | host.os.codename                          | OS codename, if any.                                                                           | keyword          |
  | input.type                                | Type of Filebeat input.                                                                        | keyword          |
  | labels.is_ioc_transform_source            | Indicates whether an IOC is in the raw source data stream, or the in latest destination index. | constant_keyword |
  | log.flags                                 | Flags for the log file.                                                                        | keyword          |
  | log.offset                                | Offset of the entry in the log file.                                                           | long             |
  | threat.feed.dashboard_id                  | Dashboard ID used for Kibana CTI UI                                                            | constant_keyword |
  | threat.feed.name                          | Display friendly feed name                                                                     | constant_keyword |
  | threat.indicator.first_seen               | The date and time when intelligence source first reported sighting this indicator.             | date             |
  | threat.indicator.last_seen                | The date and time when intelligence source last reported sighting this indicator.              | date             |
  | threat.indicator.modified_at              | The date and time when intelligence source last modified information for this indicator.       | date             |
</dropdown>


#### URL

<dropdown title="Exported fields">
  | Field                               | Description                                                                                             | Type             |
  |-------------------------------------|---------------------------------------------------------------------------------------------------------|------------------|
  | @timestamp                          | Event timestamp.                                                                                        | date             |
  | abusech.url.blacklists.spamhaus_dbl | If the indicator is listed on the spamhaus blacklist.                                                   | keyword          |
  | abusech.url.blacklists.surbl        | If the indicator is listed on the surbl blacklist.                                                      | keyword          |
  | abusech.url.deleted_at              | The timestamp when the indicator is (will be) deleted.                                                  | date             |
  | abusech.url.id                      | The ID of the indicator.                                                                                | keyword          |
  | abusech.url.larted                  | Indicates whether the malware URL has been reported to the hosting provider (true or false).            | boolean          |
  | abusech.url.last_online             | Last timestamp when the URL has been serving malware.                                                   | date             |
  | abusech.url.reporter                | The Twitter handle of the reporter that has reported this malware URL (or anonymous).                   | keyword          |
  | abusech.url.tags                    | A list of tags associated with the queried malware URL.                                                 | keyword          |
  | abusech.url.threat                  | The threat corresponding to this malware URL.                                                           | keyword          |
  | abusech.url.url_status              | The current status of the URL. Possible values are: online, offline and unknown.                        | keyword          |
  | abusech.url.urlhaus_reference       | Link to URLhaus entry.                                                                                  | keyword          |
  | cloud.image.id                      | Image ID for the cloud instance.                                                                        | keyword          |
  | data_stream.dataset                 | Data stream dataset name.                                                                               | constant_keyword |
  | data_stream.namespace               | Data stream namespace.                                                                                  | constant_keyword |
  | data_stream.type                    | Data stream type.                                                                                       | constant_keyword |
  | event.dataset                       | Event dataset                                                                                           | constant_keyword |
  | event.module                        | Event module                                                                                            | constant_keyword |
  | host.containerized                  | If the host is a container.                                                                             | boolean          |
  | host.os.build                       | OS build information.                                                                                   | keyword          |
  | host.os.codename                    | OS codename, if any.                                                                                    | keyword          |
  | input.type                          | Type of Filebeat input.                                                                                 | keyword          |
  | labels.interval                     | User-configured value for `Interval` setting. This is used in calculation of indicator expiration time. | keyword          |
  | labels.is_ioc_transform_source      | Indicates whether an IOC is in the raw source data stream, or the in latest destination index.          | constant_keyword |
  | log.flags                           | Flags for the log file.                                                                                 | keyword          |
  | log.offset                          | Offset of the entry in the log file.                                                                    | long             |
  | threat.feed.dashboard_id            | Dashboard ID used for Kibana CTI UI                                                                     | constant_keyword |
  | threat.feed.name                    | Display friendly feed name                                                                              | constant_keyword |
  | threat.indicator.first_seen         | The date and time when intelligence source first reported sighting this indicator.                      | date             |
  | threat.indicator.last_seen          | The date and time when intelligence source last reported sighting this indicator.                       | date             |
  | threat.indicator.modified_at        | The date and time when intelligence source last modified information for this indicator.                | date             |
</dropdown>


### Example event


#### JA3 Fingerprint Blacklist

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2025-07-31T05:12:01.523Z",
      "abusech": {
          "ja3_fingerprints": {
              "deleted_at": "2025-07-31T06:10:34.470Z"
          }
      },
      "agent": {
          "ephemeral_id": "9a4132fc-38d5-43ec-a459-0ef108d28187",
          "id": "28fe4213-ba33-434e-8815-6bbc80c646d0",
          "name": "elastic-agent-82406",
          "type": "filebeat",
          "version": "8.19.0"
      },
      "data_stream": {
          "dataset": "ti_abusech.ja3_fingerprints",
          "namespace": "86925",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "28fe4213-ba33-434e-8815-6bbc80c646d0",
          "snapshot": false,
          "version": "8.19.0"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "threat"
          ],
          "dataset": "ti_abusech.ja3_fingerprints",
          "ingested": "2025-07-31T05:12:04Z",
          "kind": "enrichment",
          "original": "{\"first_ts\":\"2017-07-14T18:08:15Z\",\"ja3\":\"b386946a5a44d1ddcc843bc75336dfce\",\"last_ts\":\"2019-07-27T20:42:54Z\",\"reason\":\"Dridex\"}",
          "type": [
              "indicator"
          ]
      },
      "input": {
          "type": "cel"
      },
      "labels": {
          "interval": "1h"
      },
      "related": {
          "hash": [
              "b386946a5a44d1ddcc843bc75336dfce"
          ]
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "abusech-ja3_fingerprints"
      ],
      "threat": {
          "indicator": {
              "description": "Dridex",
              "first_seen": "2017-07-14T18:08:15.000Z",
              "last_seen": "2019-07-27T20:42:54.000Z",
              "name": "b386946a5a44d1ddcc843bc75336dfce",
              "type": "software"
          }
      }
  }
  ```
</dropdown>


#### Malware

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2025-07-16T06:30:10.517Z",
      "abusech": {
          "malware": {
              "deleted_at": "2021-10-10T04:17:02.000Z",
              "ioc_expiration_duration": "5d"
          }
      },
      "agent": {
          "ephemeral_id": "c478eac0-6769-456a-8a26-d5d6cc86318d",
          "id": "5d0ab6a2-0351-4c94-8bfb-e268dee367e4",
          "name": "elastic-agent-40763",
          "type": "filebeat",
          "version": "8.18.0"
      },
      "data_stream": {
          "dataset": "ti_abusech.malware",
          "namespace": "70630",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "5d0ab6a2-0351-4c94-8bfb-e268dee367e4",
          "snapshot": true,
          "version": "8.18.0"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "threat"
          ],
          "dataset": "ti_abusech.malware",
          "ingested": "2025-07-16T06:30:13Z",
          "kind": "enrichment",
          "original": "{\"file_size\":\"1563\",\"file_type\":\"unknown\",\"firstseen\":\"2021-10-05 04:17:02\",\"imphash\":null,\"md5_hash\":\"9cd5a4f0231a47823c4adba7c8ef370f\",\"sha256_hash\":\"7c0852d514df7faf8fdbfa4f358cc235dd1b1a2d843cc65495d03b502e4099f2\",\"signature\":null,\"ssdeep\":\"48:yazkS7neW+mfe4CJjNXcq5Co4Fr1PpsHn:yrmGNt5mbP2n\",\"tlsh\":\"T109314C5E7822CA70B91AD69300C22D8C2F53EAF229E6686C3BDD4C86FA1344208CF1\",\"urlhaus_download\":\"https://urlhaus-api.abuse.ch/v1/download/7c0852d514df7faf8fdbfa4f358cc235dd1b1a2d843cc65495d03b502e4099f2/\",\"virustotal\":null}",
          "type": [
              "indicator"
          ]
      },
      "input": {
          "type": "cel"
      },
      "related": {
          "hash": [
              "9cd5a4f0231a47823c4adba7c8ef370f",
              "7c0852d514df7faf8fdbfa4f358cc235dd1b1a2d843cc65495d03b502e4099f2",
              "48:yazkS7neW+mfe4CJjNXcq5Co4Fr1PpsHn:yrmGNt5mbP2n",
              "T109314C5E7822CA70B91AD69300C22D8C2F53EAF229E6686C3BDD4C86FA1344208CF1"
          ]
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "abusech-malware"
      ],
      "threat": {
          "indicator": {
              "confidence": "Not Specified",
              "file": {
                  "hash": {
                      "md5": "9cd5a4f0231a47823c4adba7c8ef370f",
                      "sha256": "7c0852d514df7faf8fdbfa4f358cc235dd1b1a2d843cc65495d03b502e4099f2",
                      "ssdeep": "48:yazkS7neW+mfe4CJjNXcq5Co4Fr1PpsHn:yrmGNt5mbP2n",
                      "tlsh": "T109314C5E7822CA70B91AD69300C22D8C2F53EAF229E6686C3BDD4C86FA1344208CF1"
                  },
                  "size": 1563,
                  "type": "unknown"
              },
              "first_seen": "2021-10-05T04:17:02.000Z",
              "name": "7c0852d514df7faf8fdbfa4f358cc235dd1b1a2d843cc65495d03b502e4099f2",
              "type": "file"
          }
      }
  }
  ```
</dropdown>


#### MalwareBazaar

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2025-07-16T06:30:59.281Z",
      "abusech": {
          "malwarebazaar": {
              "anonymous": 0,
              "deleted_at": "2021-10-10T14:02:45.000Z",
              "intelligence": {
                  "downloads": 11,
                  "uploads": 1
              },
              "ioc_expiration_duration": "5d"
          }
      },
      "agent": {
          "ephemeral_id": "f5b70b3f-5d2b-4d55-96b0-dc8e46e10b9a",
          "id": "372b884d-d232-4e1e-806c-d08ae525f868",
          "name": "elastic-agent-37187",
          "type": "filebeat",
          "version": "8.18.0"
      },
      "data_stream": {
          "dataset": "ti_abusech.malwarebazaar",
          "namespace": "64456",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "372b884d-d232-4e1e-806c-d08ae525f868",
          "snapshot": true,
          "version": "8.18.0"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "threat"
          ],
          "dataset": "ti_abusech.malwarebazaar",
          "ingested": "2025-07-16T06:31:02Z",
          "kind": "enrichment",
          "original": "{\"anonymous\":0,\"code_sign\":[],\"dhash_icon\":null,\"file_name\":\"7a6c03013a2f2ab8b9e8e7e5d226ea89e75da72c1519e.exe\",\"file_size\":432640,\"file_type\":\"exe\",\"file_type_mime\":\"application/x-dosexec\",\"first_seen\":\"2021-10-05 14:02:45\",\"imphash\":\"f34d5f2d4577ed6d9ceec516c1f5a744\",\"intelligence\":{\"clamav\":null,\"downloads\":\"11\",\"mail\":null,\"uploads\":\"1\"},\"last_seen\":null,\"md5_hash\":\"1fc1c2997c8f55ac10496b88e23f5320\",\"origin_country\":\"FR\",\"reporter\":\"abuse_ch\",\"sha1_hash\":\"42c7153680d7402e56fe022d1024aab49a9901a0\",\"sha256_hash\":\"7a6c03013a2f2ab8b9e8e7e5d226ea89e75da72c1519e78fd28b2253ea755c28\",\"sha3_384_hash\":\"d63e73b68973bc73ab559549aeee2141a48b8a3724aabc0d81fb14603c163a098a5a10be9f6d33b888602906c0d89955\",\"signature\":\"RedLineStealer\",\"ssdeep\":\"12288:jhhl1Eo+iEXvpb1C7drqAd1uUaJvzXGyO2F5V3bS1jsTacr:7lL\",\"tags\":[\"exe\",\"RedLineStealer\"],\"telfhash\":null,\"tlsh\":\"T13794242864BFC05994E3EEA12DDCA8FBD99A55E3640C743301B4633B8B52B84DE4F479\"}",
          "type": [
              "indicator"
          ]
      },
      "input": {
          "type": "cel"
      },
      "related": {
          "hash": [
              "42c7153680d7402e56fe022d1024aab49a9901a0",
              "d63e73b68973bc73ab559549aeee2141a48b8a3724aabc0d81fb14603c163a098a5a10be9f6d33b888602906c0d89955",
              "7a6c03013a2f2ab8b9e8e7e5d226ea89e75da72c1519e78fd28b2253ea755c28",
              "T13794242864BFC05994E3EEA12DDCA8FBD99A55E3640C743301B4633B8B52B84DE4F479",
              "12288:jhhl1Eo+iEXvpb1C7drqAd1uUaJvzXGyO2F5V3bS1jsTacr:7lL",
              "1fc1c2997c8f55ac10496b88e23f5320",
              "f34d5f2d4577ed6d9ceec516c1f5a744"
          ]
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "abusech-malwarebazaar",
          "exe",
          "RedLineStealer"
      ],
      "threat": {
          "indicator": {
              "file": {
                  "extension": "exe",
                  "hash": {
                      "md5": "1fc1c2997c8f55ac10496b88e23f5320",
                      "sha1": "42c7153680d7402e56fe022d1024aab49a9901a0",
                      "sha256": "7a6c03013a2f2ab8b9e8e7e5d226ea89e75da72c1519e78fd28b2253ea755c28",
                      "sha384": "d63e73b68973bc73ab559549aeee2141a48b8a3724aabc0d81fb14603c163a098a5a10be9f6d33b888602906c0d89955",
                      "ssdeep": "12288:jhhl1Eo+iEXvpb1C7drqAd1uUaJvzXGyO2F5V3bS1jsTacr:7lL",
                      "tlsh": "T13794242864BFC05994E3EEA12DDCA8FBD99A55E3640C743301B4633B8B52B84DE4F479"
                  },
                  "mime_type": "application/x-dosexec",
                  "name": "7a6c03013a2f2ab8b9e8e7e5d226ea89e75da72c1519e.exe",
                  "pe": {
                      "imphash": "f34d5f2d4577ed6d9ceec516c1f5a744"
                  },
                  "size": 432640
              },
              "first_seen": "2021-10-05T14:02:45.000Z",
              "geo": {
                  "country_iso_code": "FR"
              },
              "marking": {
                  "tlp": "CLEAR"
              },
              "name": "7a6c03013a2f2ab8b9e8e7e5d226ea89e75da72c1519e78fd28b2253ea755c28",
              "provider": "abuse_ch",
              "type": "file"
          },
          "software": {
              "alias": [
                  "RedLineStealer"
              ]
          }
      }
  }
  ```
</dropdown>


#### SSL Certificate Blacklist

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2025-07-31T05:15:00.672Z",
      "abusech": {
          "sslblacklist": {
              "deleted_at": "2025-07-31T06:13:33.669Z"
          }
      },
      "agent": {
          "ephemeral_id": "80e31fdd-70e8-4156-9a0d-ad6d0d853888",
          "id": "01f51d20-e150-4b4e-a036-1746eb0c7285",
          "name": "elastic-agent-47845",
          "type": "filebeat",
          "version": "8.19.0"
      },
      "data_stream": {
          "dataset": "ti_abusech.sslblacklist",
          "namespace": "19255",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "01f51d20-e150-4b4e-a036-1746eb0c7285",
          "snapshot": false,
          "version": "8.19.0"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "threat"
          ],
          "dataset": "ti_abusech.sslblacklist",
          "ingested": "2025-07-31T05:15:03Z",
          "kind": "enrichment",
          "original": "{\"reason\":\"HijackLoader C\\u0026C\",\"sha1\":\"029c128ec7f6c5a62ea19f5ad525cd1487971ce4\",\"ts\":\"2025-06-25T06:50:28Z\"}",
          "type": [
              "indicator"
          ]
      },
      "input": {
          "type": "cel"
      },
      "labels": {
          "interval": "1h"
      },
      "related": {
          "hash": [
              "029c128ec7f6c5a62ea19f5ad525cd1487971ce4"
          ]
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "abusech-sslblacklist"
      ],
      "threat": {
          "indicator": {
              "description": "HijackLoader C&C",
              "first_seen": "2025-06-25T06:50:28.000Z",
              "name": "029c128ec7f6c5a62ea19f5ad525cd1487971ce4",
              "type": "x509-certificate"
          }
      }
  }
  ```
</dropdown>


#### ThreatFox

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2025-07-16T06:31:50.732Z",
      "abusech": {
          "threatfox": {
              "confidence_level": 100,
              "deleted_at": "2022-08-10T19:43:08.000Z",
              "ioc_expiration_duration": "5d",
              "malware": "win.asyncrat",
              "threat_type": "botnet_cc",
              "threat_type_desc": "Indicator that identifies a botnet command&control server (C&C)"
          }
      },
      "agent": {
          "ephemeral_id": "49a54718-d50a-45cf-8da6-597e14572d1b",
          "id": "07477042-3fd0-44e5-83e1-d33c53a1b34d",
          "name": "elastic-agent-57963",
          "type": "filebeat",
          "version": "8.18.0"
      },
      "data_stream": {
          "dataset": "ti_abusech.threatfox",
          "namespace": "90202",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "07477042-3fd0-44e5-83e1-d33c53a1b34d",
          "snapshot": true,
          "version": "8.18.0"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "threat"
          ],
          "dataset": "ti_abusech.threatfox",
          "id": "841537",
          "ingested": "2025-07-16T06:31:53Z",
          "kind": "enrichment",
          "original": "{\"confidence_level\":100,\"first_seen\":\"2022-08-05 19:43:08 UTC\",\"id\":\"841537\",\"ioc\":\"wizzy.hopto.org\",\"ioc_type\":\"domain\",\"ioc_type_desc\":\"Domain that is used for botnet Command\\u0026control (C\\u0026C)\",\"last_seen\":null,\"malware\":\"win.asyncrat\",\"malware_alias\":null,\"malware_malpedia\":\"https://malpedia.caad.fkie.fraunhofer.de/details/win.asyncrat\",\"malware_printable\":\"AsyncRAT\",\"reference\":\"https://tria.ge/220805-w57pxsgae2\",\"reporter\":\"AndreGironda\",\"tags\":[\"asyncrat\"],\"threat_type\":\"botnet_cc\",\"threat_type_desc\":\"Indicator that identifies a botnet command\\u0026control server (C\\u0026C)\"}",
          "type": [
              "indicator"
          ]
      },
      "input": {
          "type": "cel"
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "abusech-threatfox",
          "asyncrat"
      ],
      "threat": {
          "indicator": {
              "confidence": "High",
              "description": "Domain that is used for botnet Command&control (C&C)",
              "first_seen": "2022-08-05T19:43:08.000Z",
              "marking": {
                  "tlp": "WHITE"
              },
              "name": "wizzy.hopto.org",
              "provider": "AndreGironda",
              "reference": "https://tria.ge/220805-w57pxsgae2",
              "type": "domain-name",
              "url": {
                  "domain": "wizzy.hopto.org"
              }
          },
          "software": {
              "name": "AsyncRAT",
              "reference": "https://malpedia.caad.fkie.fraunhofer.de/details/win.asyncrat"
          }
      }
  }
  ```
</dropdown>


#### URL

<dropdown title="Example">
  ```json
  {
      "@timestamp": "2025-07-16T06:32:41.644Z",
      "abusech": {
          "url": {
              "deleted_at": "2025-07-16T07:31:14.625Z",
              "id": "2786904",
              "threat": "malware_download",
              "url_status": "online"
          }
      },
      "agent": {
          "ephemeral_id": "8039c627-ea96-4027-8751-2ff7db77251b",
          "id": "9106f11b-d54d-46d0-8ace-39e4fff1157b",
          "name": "elastic-agent-41888",
          "type": "filebeat",
          "version": "8.18.0"
      },
      "data_stream": {
          "dataset": "ti_abusech.url",
          "namespace": "49664",
          "type": "logs"
      },
      "ecs": {
          "version": "8.11.0"
      },
      "elastic_agent": {
          "id": "9106f11b-d54d-46d0-8ace-39e4fff1157b",
          "snapshot": true,
          "version": "8.18.0"
      },
      "event": {
          "agent_id_status": "verified",
          "category": [
              "threat"
          ],
          "dataset": "ti_abusech.url",
          "ingested": "2025-07-16T06:32:44Z",
          "kind": "enrichment",
          "original": "{\"dateadded\":\"2024-03-19 11:34:09 UTC\",\"id\":\"2786904\",\"last_online\":\"2024-03-19 11:34:09 UTC\",\"reporter\":\"lrz_urlhaus\",\"tags\":[\"elf\",\"Mozi\"],\"threat\":\"malware_download\",\"url\":\"http://115.55.244.160:41619/Mozi.m\",\"url_status\":\"online\",\"urlhaus_link\":\"https://urlhaus.abuse.ch/url/2786904/\"}",
          "type": [
              "indicator"
          ]
      },
      "input": {
          "type": "cel"
      },
      "labels": {
          "interval": "1h"
      },
      "tags": [
          "preserve_original_event",
          "forwarded",
          "abusech-url",
          "elf",
          "Mozi"
      ],
      "threat": {
          "indicator": {
              "first_seen": "2024-03-19T11:34:09.000Z",
              "last_seen": "2024-03-19T11:34:09.000Z",
              "name": "http://115.55.244.160:41619/Mozi.m",
              "provider": "lrz_urlhaus",
              "reference": "https://urlhaus.abuse.ch/url/2786904/",
              "type": "url",
              "url": {
                  "domain": "115.55.244.160",
                  "extension": "m",
                  "full": "http://115.55.244.160:41619/Mozi.m",
                  "original": "http://115.55.244.160:41619/Mozi.m",
                  "path": "/Mozi.m",
                  "port": 41619,
                  "scheme": "http"
              }
          }
      }
  }
  ```
</dropdown>


### Inputs used

These inputs can be used in this integration:
- [cel](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-cel)


### API usage

This integration datasets use the following APIs:
- `ja3_fingerprints`: [SSLBL API](https://sslbl.abuse.ch/blacklist/ja3_fingerprints.csv).
- `malware`: [URLhaus Bulk API](https://urlhaus-api.abuse.ch/#payloads-recent).
- `malwarebazaar`: [MalwareBazaar API](https://bazaar.abuse.ch/api/#latest_additions).
- `sslblacklist`: [SSLBL API](https://sslbl.abuse.ch/blacklist/sslblacklist.csv).
- `threatfox`: [ThreatFox API](https://threatfox.abuse.ch/api/#recent-iocs).
- `url`: [URLhaus API](https://urlhaus.abuse.ch/api/#csv).


### Expiration of Indicators of Compromise (IOCs)

All abuse.ch datasets now support indicator expiration. For the `URL` dataset, a full list of active threat indicators are ingested at every interval. For other datasets, namely `Malware`, `MalwareBazaar`, and `ThreatFox`, the threat indicators are expired after the duration `IOC Expiration Duration` is configured in the integration setting. An [Elastic Transform](https://www.elastic.co/guide/en/elasticsearch/reference/current/transforms.html) is created for every source index to make sure only active threat indicators are available to the end users. Each transform creates a destination index named `logs-ti_abusech_latest.dest_*` which only contains active and unexpired threat indicators. The indicator match rules and dashboards are updated to list only active threat indicators.
Destinations indices are aliased to `logs-ti_abusech_latest.<data_stream_name>`.

| Source Data stream                | Destination Index Pattern                     | Destination Alias                      |
|-----------------------------------|-----------------------------------------------|----------------------------------------|
| `logs-ti_abusech.url-*`           | `logs-ti_abusech_latest.dest_url-*`           | `logs-ti_abusech_latest.url`           |
| `logs-ti_abusech.malware-*`       | `logs-ti_abusech_latest.dest_malware-*`       | `logs-ti_abusech_latest.malware`       |
| `logs-ti_abusech.malwarebazaar-*` | `logs-ti_abusech_latest.dest_malwarebazaar-*` | `logs-ti_abusech_latest.malwarebazaar` |
| `logs-ti_abusech.threatfox-*`     | `logs-ti_abusech_latest.dest_threatfox-*`     | `logs-ti_abusech_latest.threatfox`     |


#### ILM Policy

To facilitate IoC expiration, source data stream-backed indices `.ds-logs-ti_abusech.<data_stream_name>-*` are allowed to contain duplicates from each polling interval. ILM policy `logs-ti_abusech.<data_stream_name>-default_policy` is added to these source indices, so it doesn't lead to unbounded growth. This means that in these source indices data will be deleted after `5 days` from ingested date.

## Screenshots

This integration includes one or more Kibana dashboards that visualizes the data collected by the integration. The screenshots below illustrate how the ingested data is displayed.
<carousel>
  ![abuse.ch Overview Dashboard Screenshot](https://epr.elastic.co/package/ti_abusech/3.5.0/img/abusech-overview.png)

  ![abuse.ch Files Dashboard Screenshot](https://epr.elastic.co/package/ti_abusech/3.5.0/img/abusech-files.png)

  ![abuse.ch URLs Dashboard Screenshot](https://epr.elastic.co/package/ti_abusech/3.5.0/img/abusech-urls.png)

  ![abuse.ch Softwares and x509 Certificates Dashboard Screenshot](https://epr.elastic.co/package/ti_abusech/3.5.0/img/abusech-softwares.png)

  ![abuse.ch Domains and IP Addresses Dashboard Screenshot](https://epr.elastic.co/package/ti_abusech/3.5.0/img/abusech-domains.png)
</carousel>


## Changelog

<dropdown title="Changelog">
  | Version    | Details                                                                                                                                                                                                                                                                                                                                                                                                  | Minimum Kibana version |
  |------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **3.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/16535))Allow transforms to run in unattended mode.                                                                                                                                                                                                                                                                     | 9.1.08.19.0            |
  | **3.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15344))Add support for the 'Domain and IP Addresses' and 'Software and x509 Certificates' dashboards.Update deprecated visualization charts and implemented best practices in the existing Overview, Files, and URLs dashboards.                                                                                       | 9.1.08.19.0            |
  | **3.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14774))Update documentation.                                                                                                                                                                                                                                                                                           | 9.1.08.19.0            |
  | **3.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14703))Add `ja3_fingerprints` and `sslblacklist` data streams.                                                                                                                                                                                                                                                         | 9.1.08.19.0            |
  | **3.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14586))Add terminate processor in ingest pipelines to filter out events containing CEL errors. Add `threat.indicator.marking.tlp` ECS field mapping in `threatfox` and `malwarebazaar` data streams. Add `threat.indicator.confidence` ECS field mapping in `malware` data stream. Improve system tests configuration. | 9.0.08.18.0            |
  | **3.0.0**  | **Breaking change** ([View pull request](https://github.com/elastic/integrations/pull/14335))Auth Key (API Key) is now required for all AbuseCH API requests. Requests without authentication will be denied.See the official announcement: [https://abuse.ch/blog/community-first/](https://abuse.ch/blog/community-first/)                                                                             | 9.0.08.18.0            |
  | **2.10.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14172))Add temporary processor to remove the fields added by the Agentless policy.                                                                                                                                                                                                                                         | 9.0.08.18.0            |
  | **2.10.0** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13760))Increase memory for agentless deployment.                                                                                                                                                                                                                                                                           | 9.0.08.18.0            |
  | **2.9.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13712))Fix default request trace enabled behavior.                                                                                                                                                                                                                                                                         | 9.0.08.18.0            |
  | **2.9.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13708))Properly handle CEL errors.                                                                                                                                                                                                                                                                                         | 9.0.08.18.0            |
  | **2.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13452))Enable request trace log removal.                                                                                                                                                                                                                                                                               | 9.0.08.18.0            |
  | **2.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13261))Add support for 'Auth-Key' in request header for all data streams.                                                                                                                                                                                                                                              | 9.0.08.18.0            |
  | **2.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/13173))Enable Agentless deployment.                                                                                                                                                                                                                                                                                    | 9.0.08.18.0            |
  | **2.6.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/13317))Add support for 'Auth-Key' in request header for all data streams.                                                                                                                                                                                                                                                  | 9.0.08.13.0            |
  | **2.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12919))Update Kibana constraint to support 9.0.0.                                                                                                                                                                                                                                                                      | 9.0.08.13.0            |
  | **2.5.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/12697))Updated SSL description to be uniform and to include links to documentation.                                                                                                                                                                                                                                        | 8.13.0                 |
  | **2.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12076))Do not remove `event.original` in main ingest pipeline.                                                                                                                                                                                                                                                         | 8.13.0                 |
  | **2.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12046))Add "preserve_original_event" tag to documents with `event.kind` set to "pipeline_error".                                                                                                                                                                                                                       | 8.13.0                 |
  | **2.3.5**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11314))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                                                                                                                                                                                | 8.13.0                 |
  | **2.3.4**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11284))Use triple-brace Mustache templating when referencing variables in ingest pipelines.                                                                                                                                                                                                                                | 8.13.0                 |
  | **2.3.3**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11231))Fix labels.is_ioc_transform_source values                                                                                                                                                                                                                                                                           | 8.13.0                 |
  | **2.3.2**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/11008))Add missing fields in transform                                                                                                                                                                                                                                                                                     | 8.13.0                 |
  | **2.3.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10637))Fix ECS date mapping on threat fields.                                                                                                                                                                                                                                                                              | 8.13.0                 |
  | **2.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10346))Improve error reporting for API request failures.                                                                                                                                                                                                                                                               | 8.13.0                 |
  | **2.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10135))Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template.                                                                                                                                                             | 8.13.0                 |
  | **2.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10156))Improve error handling and reporting in malwarebazaar data stream.                                                                                                                                                                                                                                              | 8.12.0                 |
  | **2.0.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/10049))Adjust field mappings for transform destination index.                                                                                                                                                                                                                                                              | 8.12.0                 |
  | **2.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7793))Support IoC expiration                                                                                                                                                                                                                                                                                           | 8.12.0                 |
  | **1.25.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9404))Update manifest format version to v3.0.3.                                                                                                                                                                                                                                                                        | 8.7.1                  |
  | **1.24.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8943))Changed owners                                                                                                                                                                                                                                                                                                   | 8.7.1                  |
  | **1.24.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8489))Limit request tracer log count to five.                                                                                                                                                                                                                                                                          | 8.7.1                  |
  | **1.23.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8436))ECS version updated to 8.11.0.                                                                                                                                                                                                                                                                                   | 8.7.1                  |
  | **1.22.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/8269))Improve 'event.original' check to avoid errors if set.                                                                                                                                                                                                                                                           | 8.7.1                  |
  | **1.21.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7920))ECS version updated to 8.10.0.                                                                                                                                                                                                                                                                                   | 8.7.1                  |
  | **1.20.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7883))The format_version in the package manifest changed from 2.11.0 to 3.0.0. Removed dotted YAML keys from package manifest. Added 'owner.type: elastic' to package manifest.                                                                                                                                        | 8.7.1                  |
  | **1.19.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7789))Add tags.yml file so that integration's dashboards and saved searches are tagged with "Security Solution" and displayed in the Security Solution UI.                                                                                                                                                             | 8.7.1                  |
  | **1.18.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7315))Update package-spec to 2.9.0.                                                                                                                                                                                                                                                                                    | 8.7.1                  |
  | **1.17.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/7111))Update package to ECS 8.9.0.                                                                                                                                                                                                                                                                                     | 8.7.1                  |
  | **1.16.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6992))Document duration units.                                                                                                                                                                                                                                                                                         | 8.7.1                  |
  | **1.15.2** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7143))Change ThreatFox initial interval to integer and note valid values 1-7                                                                                                                                                                                                                                               | 8.7.1                  |
  | **1.15.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/7103))Remove fields with empty string values                                                                                                                                                                                                                                                                               | 8.7.1                  |
  | **1.15.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6924))Convert visualizations to lens.                                                                                                                                                                                                                                                                                  | 8.7.1                  |
  | **1.14.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6706))Document valid duration units.                                                                                                                                                                                                                                                                                   | 8.7.1                  |
  | **1.13.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6629))Ensure event.kind is correctly set for pipeline errors.                                                                                                                                                                                                                                                          | 8.7.1                  |
  | **1.12.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6328))Update package to ECS 8.8.0.                                                                                                                                                                                                                                                                                     | 8.7.1                  |
  | **1.11.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6115))Add a new flag to enable request tracing                                                                                                                                                                                                                                                                         | 8.7.1                  |
  | **1.10.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5765))Update package to ECS 8.7.0.                                                                                                                                                                                                                                                                                     | 8.0.0                  |
  | **1.9.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4576))Update package to ECS 8.6.0.                                                                                                                                                                                                                                                                                     | 8.0.0                  |
  | **1.8.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4285))Update package to ECS 8.5.0.                                                                                                                                                                                                                                                                                     | 8.0.0                  |
  | **1.7.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/4102))Change abusech.malwarebazaar.code_sign to Nested field                                                                                                                                                                                                                                                               | 8.0.0                  |
  | **1.7.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3962))Add Threat Fox datastream                                                                                                                                                                                                                                                                                        | 8.0.0                  |
  | **1.6.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3871))Update package to ECS 8.4.0                                                                                                                                                                                                                                                                                      | 8.0.0                  |
  | **1.5.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/3881))Fix proxy URL documentation rendering.                                                                                                                                                                                                                                                                               | 8.0.0                  |
  | **1.5.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3689))Update categories to include `threat_intel`.                                                                                                                                                                                                                                                                     | 8.0.0                  |
  | **1.4.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3353))Update package to ECS 8.3.0.                                                                                                                                                                                                                                                                                     | 8.0.0                  |
  | **1.3.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3166))Added link to AbuseCH documentation in readme                                                                                                                                                                                                                                                                    | 8.0.0                  |
  | **1.3.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3398))Update package descriptions                                                                                                                                                                                                                                                                                      | 8.0.0                  |
  | **1.3.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2781))Update to ECS 8.2                                                                                                                                                                                                                                                                                                | 8.0.0                  |
  | **1.2.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/3042))Add mapping for event.created                                                                                                                                                                                                                                                                                    | 8.0.0                  |
  | **1.2.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2916))Add documentation for multi-fields                                                                                                                                                                                                                                                                               | 8.0.0                  |
  | **1.2.1**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2893))Fix field mapping conflicts in `threat.indicator.file.x509.not_before/not_after`                                                                                                                                                                                                                                     |                        |
  | **1.2.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2445))Update to ECS 8.0                                                                                                                                                                                                                                                                                                | 8.0.0                  |
  | **1.1.5**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2544))Removes extra tag from dashboards                                                                                                                                                                                                                                                                                    | 8.0.0                  |
  | **1.1.4**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2339))Regenerate test files using the new GeoIP database                                                                                                                                                                                                                                                                   | 8.0.0                  |
  | **1.1.3**  | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/2327))Change test public IPs to the supported subset                                                                                                                                                                                                                                                                       |                        |
  | **1.1.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2331))Fixing typo in base-fields.yml                                                                                                                                                                                                                                                                                   |                        |
  | **1.1.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2293))Update ECS fields for threat.feed.name                                                                                                                                                                                                                                                                           |                        |
  | **1.1.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2072))Adding dashboards and adding minor tweaks to pipeline                                                                                                                                                                                                                                                            | 8.0.0                  |
  | **1.0.4**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2072))Bump minimum version in manifest                                                                                                                                                                                                                                                                                 | 8.0.0                  |
  | **1.0.3**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/2063))Bump minimum version                                                                                                                                                                                                                                                                                             |                        |
  | **1.0.2**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1997))Update title and description.                                                                                                                                                                                                                                                                                    |                        |
  | **1.0.1**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1939))Fix invisible package icon                                                                                                                                                                                                                                                                                       |                        |
  | **1.0.0**  | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/1866))Initial Release                                                                                                                                                                                                                                                                                                  |                        |
</dropdown>