﻿---
title: StatsD input
description: The statsd input package spawns a UDP server and listens for metrics in StatsD compatible format. This input can be used to collect metrics from services...
url: https://www.elastic.co/docs/reference/integrations/statsd_input
products:
  - Elastic integrations
applies_to:
  - Serverless Observability projects: Generally available
  - Serverless Security projects: Generally available
  - Elastic Stack: Generally available since 9.0
---

# StatsD input
|                                                                                                 |                                |
|-------------------------------------------------------------------------------------------------|--------------------------------|
| **Version**                                                                                     | 1.0.0 ([View all](#changelog)) |
| **Subscription level**[What's this?](https://www.elastic.co/subscriptions)                      | Basic                          |
| **Developed by**[What's this?](https://www.elastic.co/docs/reference/integrations/developed-by) | Elastic                        |
| **Minimum Kibana version(s)**                                                                   | 9.0.08.13.0                    |


## Overview

The `statsd input package` spawns a UDP server and listens for metrics in StatsD compatible format.
This input can be used to collect metrics from services that send data over the StatsD protocol. To tailor the data you can provide custom mappings and ingest pipelines through Kibana.

### Compatibility


#### Metric types

The input supports the following types of metrics:
<definitions>
  <definition term="Counter (c)">
    Measurement which accumulates over period of time until flushed (value set to 0).
  </definition>
  <definition term="Gauge (g)">
    Measurement which can increase, decrease or be set to a value.
  </definition>
  <definition term="Timer (ms)">
    Time measurement (in milliseconds) of an event.
  </definition>
  <definition term="Histogram (h)">
    Time measurement, alias for timer.
  </definition>
  <definition term="Set (s)">
    Measurement which counts unique occurrences until flushed (value set to 0).
  </definition>
</definitions>


#### Supported tag extensions

Example of tag styles supported by the `statsd` input:
[DogStatsD](https://docs.datadoghq.com/developers/dogstatsd/datagram_shell/?tab=metrics#the-dogstatsd-protocol)
`<metric name>:<value>|<type>|@samplerate|#<k>:<v>,<k>:<v>`
[InfluxDB](https://github.com/influxdata/telegraf/blob/master/plugins/inputs/statsd/README.md#influx-statsd)
`<metric name>,<k>=<v>,<k>=<v>:<value>|<type>|@samplerate`
[Graphite_1.1.x](https://graphite.readthedocs.io/en/latest/tags.html#graphite-tag-support)
`<metric name>;<k>=<v>;<k>=<v>:<value>|<type>|@samplerate`

## What data does this integration collect?

The StatsD input integration collects one type of data streams: metrics.

## What do I need to use this integration?

You need Elasticsearch for storing and searching your data and Kibana for visualizing and managing it.
You can use our hosted Elasticsearch Service on Elastic Cloud, which is recommended, or self-manage the Elastic Stack on your own hardware.

## How do I deploy this integration?

For step-by-step instructions on how to set up an integration, check the
[Getting started](https://www.elastic.co/guide/en/starting-with-the-elasticsearch-platform-and-its-solutions/current/getting-started-observability.html) guide.

### Configuration options

The `statsd` input has these additional configuration options:
<definitions>
  <definition term="Listen Address and Listen Port">
    Bind address and port for the UDP server to listen on.
  </definition>
  <definition term="TTL">
    It defines how long a metric will be reported after it was last recorded. Metrics are always reported at least once, regardless of the specified TTL. A TTL of zero indicates that the metrics never expire.
  </definition>
  <definition term="StatsD metric mappings (Optional)">
    It defines how metrics will be mapped from the original metric label to the event JSON. Here’s an example configuration:
  </definition>
</definitions>

```yaml
- metric: 'ti_failures' 
  value:
    field: task_failures 
- metric: '<job_name>_start' 
  labels:
    - attr: job_name 
      field: job_name 
  value:
    field: started 
```

**Important**:
- If the `statsd.mappings` is provided, only the metrics mentioned in it will remain.
- If the `statsd.mappings` is provided, then flattening (replacing dots `.` with underscores `_` in metric names) is not applied.
- If the `statsd.mappings` is NOT provided (default), then flattening is applied, e.g. `python.gauge.foo:10|g` becomes `python_gauge_foo:10|g`.


## Troubleshooting

General troubleshooting checklist (detailed steps depend on the environment):
- Make sure Elastic Agent is running.
- Check that the Elastic Agent is listening on the specified UDP port.
- Inspect network connectivity and check firewall rules.
- Examine Elastic Agent logs.
- Make sure that the application or service sending metrics is correctly configured to point to the right UDP endpoint.

If the `nc` is available in the environment, a sample UDP packet with StatsD payload may be sent using `nc` to check if the configuration is correct and the document appears in Kibana:
```bash
# Replace "localhost" and "8125" with your values
echo "sample:1|g"  | nc -u -w0 localhost 8125
```


## Metrics reference


### Example document

Provided that the elastic-agent with StatsD input integration is listening on `localhost:8125`, it is possible to send a UDP packet with the following bash one-liner:
`echo "python_gauge_foo:10|g"  | nc -u -w0 localhost 8125`
The resulting event will look like this:
```json
{
    "@timestamp": "2024-06-19T06:26:36.664Z",
    "agent": {
        "ephemeral_id": "f9a3bc3e-14ed-4245-a140-38032ec3e459",
        "id": "b138c66d-6261-4eac-a652-7f30ea89bcfc",
        "name": "docker-fleet-agent",
        "type": "metricbeat",
        "version": "8.13.0"
    },
    "data_stream": {
        "dataset": "statsd_input.statsd",
        "namespace": "ep",
        "type": "metrics"
    },
    "ecs": {
        "version": "8.17.0"
    },
    "elastic_agent": {
        "id": "b138c66d-6261-4eac-a652-7f30ea89bcfc",
        "snapshot": false,
        "version": "8.13.0"
    },
    "event": {
        "agent_id_status": "verified",
        "dataset": "statsd_input.statsd",
        "ingested": "2024-06-19T06:26:46Z",
        "module": "statsd"
    },
    "host": {
        "architecture": "x86_64",
        "containerized": true,
        "hostname": "docker-fleet-agent",
        "id": "8259e024976a406e8a54cdbffeb84fec",
        "ip": [
            "192.168.253.7"
        ],
        "mac": [
            "02-42-C0-A8-FD-07"
        ],
        "name": "docker-fleet-agent",
        "os": {
            "codename": "focal",
            "family": "debian",
            "kernel": "3.10.0-1160.102.1.el7.x86_64",
            "name": "Ubuntu",
            "platform": "ubuntu",
            "type": "linux",
            "version": "20.04.6 LTS (Focal Fossa)"
        }
    },
    "labels": {},
    "metricset": {
        "name": "server"
    },
    "service": {
        "type": "statsd"
    },
    "statsd": {
        "python_gauge_foo": {
            "value": 10
        }
    }
}
```


## Changelog

<dropdown title="Changelog">
  | Version   | Details                                                                                                                                                                                                                                                                     | Minimum Kibana version |
  |-----------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------------------------|
  | **1.0.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/15125))Make StatsD input package GA.                                                                                                                                                      | 9.0.08.13.0            |
  | **0.6.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/14577))Update format_version to 3.4.0.                                                                                                                                                    |                        |
  | **0.5.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/14462))Update format_version to make the package visible in Kibana ^9.0.0.                                                                                                                    |                        |
  | **0.5.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12468))Add support for Kibana `9.0.0`.                                                                                                                                                    |                        |
  | **0.4.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/12223))Add missing category.                                                                                                                                                              |                        |
  | **0.4.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/10171))ECS version updated to 8.11.0. Update the kibana constraint to ^8.13.0. Modified the field definitions to remove ECS fields made redundant by the ecs@mappings component template. |                        |
  | **0.3.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/9596))Update to Kibana 8.11 to support enhanced statsd implementation, and fix system test cases.                                                                                         |                        |
  | **0.2.3** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6580))Improve documentation for the package.                                                                                                                                              |                        |
  | **0.2.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6594))Add system tests for the package.                                                                                                                                                   |                        |
  | **0.2.1** | **Bug fix** ([View pull request](https://github.com/elastic/integrations/pull/6592))Fix config to take `host` instead of `hosts`                                                                                                                                            |                        |
  | **0.2.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6451))Update Kibana version to 8.8.0                                                                                                                                                      |                        |
  | **0.1.0** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6298))Rename ownership from obs-service-integrations to obs-infraobs-integrations                                                                                                         |                        |
  | **0.0.3** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/6212))Add base fields mappings                                                                                                                                                            |                        |
  | **0.0.2** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/5123))Added categories and/or subcategories.                                                                                                                                              |                        |
  | **0.0.1** | **Enhancement** ([View pull request](https://github.com/elastic/integrations/pull/4935))Initial draft of the Statsd Input                                                                                                                                                   |                        |
</dropdown>